<?php
/* 
Plugin Name: PrivateContent - User Data Add-on 
Plugin URI: https://lcweb.it/privatecontent/user-data-add-on
Description: Manage PrivateContent user data by creating new fields to add to the registration form or just create new forms and use them in your website. Finally, export completely the user data. 
Author: Luca Montanari (LCweb)
Version: 3.4.5
Author URI: https://lcweb.it
*/  


/////////////////////////////////////////////
/////// MAIN DEFINES ////////////////////////
/////////////////////////////////////////////

// plugin path
$wp_plugin_dir = substr(plugin_dir_path(__FILE__), 0, -1);
define('PCUD_DIR', $wp_plugin_dir );

// plugin url
$wp_plugin_url = substr(plugin_dir_url(__FILE__), 0, -1);
define('PCUD_URL', $wp_plugin_url );


// add-on version
define('PCUD_VER', '3.4.5');

// multilanguage id
define('PCUD_ML', 'pcud_ml');






///////////////////////////////////////////////
/////// CHECK IF PRIVATECONTENT IS ACTIVE /////
///////////////////////////////////////////////

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if(!is_plugin_active('private-content/private_content.php') && !defined('PC_VERS')) {
	
	function pcud_no_plugin_warning() {
		echo '
		<div class="error">
		   <p>'. __('Please activate PrivateContent plugin to use the "User Data" add-on', PCUD_ML) .'</p>
		</div>';
	}
	add_action('admin_notices', 'pcud_no_plugin_warning');
}


else {
	/////////////////////////////////////////////
	/////// MULTILANGUAGE SUPPORT ///////////////
	/////////////////////////////////////////////
	
	function pcud_multilanguage() {
	  $param_array = explode('/', PCUD_DIR);
	  $folder_name = end($param_array);

	  load_plugin_textdomain( PCUD_ML, false, $folder_name . '/languages');  
	}
	add_action('init', 'pcud_multilanguage', 1);
	
	

	
	// SCRIPTS AND CSS ENQUEUING
	function pcud_global_scripts() { 
		$is_admin = is_admin();

		if(!$is_admin || isset($GLOBALS['lc_guten_scripts'])) {
			wp_enqueue_script('pcud_fontend_js', PCUD_URL . '/js/private-content-ud.min.js', array('jquery', 'pc_frontend'), PCUD_VER, true);	
            
            // dynamic JS vars 
            $array = array( 
                'dd_def_placeh' => __('Select options', PCUD_ML), // default placeholder value for dropdown fields (used in combo-dd context)
                'combo_opts'    => array(), // storing involved opts
                'form_cond'     => array(), // store form conditions
                'user_data'     => pcud_static::all_user_data_vals(), // store current user data for all possible form fields (used by conditions)
            );
            wp_localize_script('pcud_fontend_js', 'pcud_vars', $array);  
		}
        
        if($is_admin) {
            global $current_screen;
            
            wp_enqueue_script('jquery-ui-core');
            wp_enqueue_script('jquery-ui-sortable');
            
            wp_enqueue_style('pcud_admin', PCUD_URL .'/css/admin.css', 999, PCUD_VER);	   
            

            // fields builder page scripts
            if(is_object($current_screen) && $current_screen->base == 'pvtcont-add-ons_page_pcud_fields_builder') {
                $baseurl = PC_URL .'/js';
                wp_enqueue_style('pc_settings', PC_URL .'/settings/settings_style.css', 999, PC_VERS);	
            }
        }
        
        // be sure lightbox is enqueued for forced psw reset
        if(!is_admin() && get_option('pcud_fpr_legend')) {
            wp_enqueue_style('pc_lightbox');	
            wp_enqueue_script('pc_lightbox');	
        }
	}
	add_action('wp_enqueue_scripts', 'pcud_global_scripts');
	add_action('admin_enqueue_scripts', 'pcud_global_scripts');
	add_action('lc_guten_scripts', 'pcud_global_scripts');
	
	
	
	////////////////////////////////////////////////////////
	
    
	
    // STATIC HELPER METHODS
    include_once(PCUD_DIR . '/classes/pcud_static.php');
	
    // STATIC METHODS RELATED TO FIELDS MANAGEMENT
    include_once(PCUD_DIR . '/classes/pcud_fields_static.php');
    
    // STATIC METHODS RELATED TO FORMS MANAGEMENT
    include_once(PCUD_DIR . '/classes/pcud_forms_static.php');
    
    
    
	// CPT 'N' CT
	include_once(PCUD_DIR . '/cpt_and_ct.php');
    
    // ADMIN MENU
	include_once(PCUD_DIR . '/admin_menu.php');
    
	// SETTINGS
	include_once(PCUD_DIR . '/settings.php');
	
    // STYLING
	include_once(PCUD_DIR . '/styling.php');
    
	// ADMIN INTEGRATIONS
	include_once(PCUD_DIR . '/admin_integrations.php');
	
    // FRONT INTEGRATIONS
	include_once(PCUD_DIR . '/front_integrations.php');
    
	// FORCED PSW RESET CLASS
	include_once(PCUD_DIR . '/classes/forced_psw_reset.php');
	
	// TINYMCE - PVTCONTENT SHORCODE WIZARD INTEGRATION
	include_once(PCUD_DIR . '/tinymce_integration.php');
	
	// ADMIN AJAX
	include_once(PCUD_DIR . '/admin_ajax.php');
	
	// SHORTCODE
	include_once(PCUD_DIR . '/shortcodes.php');
	
	// DATA_UPDATE FORMS HANDLE
	include_once(PCUD_DIR . '/cust_forms_handle.php');
    
    // USER ACTIVIGTIES ADD-ON INTEGRATION
	include_once(PCUD_DIR . '/pcua_integration.php');
	
	
	
    
    // gutenberg integration - not for WP 5.8 widgets.. for now
    if($_SERVER["REQUEST_URI"] != '/wp-admin/widgets.php') {
	   include_once(PCUD_DIR . '/builders_integration/gutenberg.php');
    }
	
	// visual composer integration
	include_once(PCUD_DIR . '/builders_integration/visual_composer.php');
	
	// cornerstone integration
	include_once(PCUD_DIR . '/builders_integration/cornerstone.php');

	// Elementor integration
	include_once(PCUD_DIR . '/builders_integration/elementor.php');
	
	// divi integration
    include_once(PCUD_DIR . '/builders_integration/divi.php');
	
    
	
    
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    
	
    
    ////////////
    // DIKE WP DASHBOARD

    $pcud_dike_slug = (isset($GLOBALS['is_pc_bundle'])) ? 'pcbp' : 'pcud';
    define('PCUD_DIKE_SLUG', $pcud_dike_slug);
    
    function pcud_dike_updater_data($data) {
        $data['pcud'] = array(
            'callback' => 'pcud_on_activation',
            'no_files_del' => false,
        );
        return $data;
    }
    add_filter('dike_lcweb_updater', 'pcud_dike_updater_data');

    function pcud_dike_plc_sc($sc) {
        if(!isset($sc[PCUD_DIKE_SLUG])) {
            $sc[PCUD_DIKE_SLUG] = array();    
        }

        $sc[PCUD_DIKE_SLUG] = array_merge($sc[PCUD_DIKE_SLUG], array('pcud-form', 'pcud-user-data', 'pcud-cond-block'));
        return $sc;
    }
    add_filter('dike_lcweb_sc', 'pcud_dike_plc_sc');
    
    ////////////
    


    


	//////////////////////////////////////////////////
	// ACTIONS ON ADD-ON ACTIVATION //////////////////
	//////////////////////////////////////////////////
	
	function pcud_on_activation() {
		$db_version = (float)get_option('pcud_db_version', 0);
		
		if($db_version < 2.01 || isset($_GET['pcud_db_update'])) {
			global $pc_users, $pc_meta;
			
			
			// if previous to v1.4 - serialize saved fields
			$custom_fields = get_option('pcud_custom_fields');
			if(!empty($custom_fields) && is_array($custom_fields)) { 
				update_option('pcud_custom_fields', serialize($custom_fields));
			}
			
			// pass user custom data into new meta management
			if($db_version < 2.01) {
				$users = $pc_users->get_users(array(
					'limit'		=> -1,
					'to_get' 	=> 'id'
				));
				
				foreach($users as $ud) {
					$old_stored = maybe_unserialize(get_option('pcud_user_'. $ud['id'] .'_custom_data', ''));
					if(empty($old_stored)) {continue;}
					
					foreach( (array)$old_stored as $field => $val) {
						if(!empty($field)) {
							$pc_meta->add_meta($ud['id'], sanitize_title($field), $val);
						}
					}	
				}
			}

			// move custom fields into a custom taxonomy
			if(!empty($custom_fields) && $db_version < 2.0) {
				pcud_cpt_n_ct();
				if(!is_array($custom_fields)) {$custom_fields = unserialize($custom_fields);}
				
				foreach($custom_fields as $field_id => $data) {
					$label = $data['label'];
					unset($data['label']);
					
					$result = wp_insert_term($label, 'pcud_fields', array(
						'slug' 			=> $field_id,
						'description' 	=> base64_encode(serialize($data))
					));		
				}
			}
		}
        
        
        
        // v3 - move dropdown options to the new format
        if($db_version < 3.0 || isset($_GET['pcud_v3_opts_upgrade'])) {
            include_once('classes/pcud_fields_static.php');
            
            include_once('cpt_and_ct.php');
            pcud_cpt_n_ct();
            
            foreach(pcud_fields_static::get_fields() as $term) {
                $val = $term->pcud_opts;   
                // TODO - in future, delete $val['opt'] array index
                
                
                if(in_array($val['type'], array('select', 'checkbox')) && !empty($val['opt'])) {
                    $raw_opts_arr = explode(',', $val['opt']);    
                    $opts = array();
                    foreach($raw_opts_arr as $ro) {
                        if(trim($ro)) {
                            $opts[ trim($ro) ] = trim($ro);    
                        }
                    } 
                    
                    update_term_meta($term->term_id, 'pcud_fow_opts_type', 'simple');
                    update_term_meta($term->term_id, 'pcud_fow_opts_comp', 'manual');
                    update_term_meta($term->term_id, 'pcud_fow_opts_sort', 'custom');
                    update_term_meta($term->term_id, 'pcud_fow_opts', $opts);
                    
                    pcud_fields_static::multilang_field_opts_sync($opts);
                }
            }
            
            
            
            // v3.3 - new fields arrangement systems with sections
            if($db_version < 3.3 || isset($_GET['pcud_v3.3_opts_upgrade'])) {
                
                $old_arrang = (array)get_option('pcud_user_dashboard_fields_arrang', array());
                if(!empty($old_arrang)){
                    
                    update_option('pcud_fields_arrang', $old_arrang);
                    
                    $ud_fields_order = array();
                    foreach($arrang as $sect_title => $a_field_ids) {
                        $ud_fields_order = array_merge($ud_fields_order, (array)$a_field_ids);        
                    }
                    
                    update_option('pcud_user_dashboard_fields_order', $ud_fields_order);
                    delete_option('pcud_user_dashboard_fields_arrang');
                }
            }
            
            

            // delete old fields sorting system
            delete_option('pcud_custom_fields_order');
            delete_option('pcud_fields_in_users_list');   
            
            update_option('pcud_db_version', 3.3);
        }
        
        
        // inject styles
        if(class_exists('pc_static') && method_exists('pc_static', 'create_custom_style')) {
            pc_static::create_custom_style();
        }
	}
	register_activation_hook(__FILE__, 'pcud_on_activation');

	if(isset($_GET['pcud_db_update'])) {
		add_action('admin_init', 'pcud_on_activation');
    }
}



// REQUIRE LATEST PC
function pcud_requirements_check() {
    $req_v = '8.8.0';
    
    if(!defined('PC_VERS') || version_compare(PC_VERS, $req_v, '<')) {
		deactivate_plugins( plugin_basename( __FILE__ ) );
        
        $btn = '<br/><a href="'. esc_attr(network_admin_url('plugins.php')) .'">'. esc_html__('Return to plugins page', PCUD_ML) .'</a>';
		wp_die('User Data add-on '. __('requires at least', PCUD_ML) .' PrivateContent v'. $req_v .' '. __('installed', PCUD_ML) .'!'. $btn);
    }
}
register_activation_hook(__FILE__, 'pcud_requirements_check');
add_action('admin_init', 'pcud_requirements_check', 1);
