<?php
// PRIVATECONTENT USER ACTIVITIES ADD-ON INTEGRATION



// ACTIVITY TYPES
function pcud_pcua_act_types($at) {
    $ml_key = PCUD_ML;
    
    // user updated its data
    $at['pcud_user_data_updated'] = array(
        'name'  => __('User data update', $ml_key),
        'helper'=> __('Reporting whenever a user update its data through a User Data add-on form', $ml_key),
        'group' => 'core',
        'metas' => array(
            'form_id' => array(
                'name'      => __('Form ID', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => '',
            ),
            'form_name' => array(
                'name'      => __('Form name', $ml_key),
                'data_type' => 'mixed',
                'num_unit'  => '',
                'helper'    => '',
            ),
        ),
    );
    
    return $at;
}
add_filter('pcua_act_types', 'pcud_pcua_act_types');








// ACTIVITY TRIGGERS
/*
array(
    'trigger_slug' => array(
        'act_type' => activity_slug,
        'trig_type' => wp_hook || js_event
        'helper' =>,
        'js_event' => array(
            'selector' =>,
            'event' =>,
            'is_jquery' => 1|0,
            'once_per_page' => 1|0,
        ),
        'wp_hook' => array(
            'type' => action || filter,
            'name' => ,
        ),
        'meta_assoc'=> array(
            'type_meta_slug'   => JS code returning a value (if js_event)
            'type_meta_slug'   => e.attr_name (if js_event > e is event object)
            'type_meta_slug'   => (int) jquery custom param num (if jquery js_event)

            'type_meta_slug'   => (int) hook param num (if wp_hook)
            'type_meta_slug'   => (string) PHP function name (if wp_hook)
        )
    )
) 
*/
function pcud_pcua_act_triggers($atrig) {
    $ml_key = PCUD_ML;
    
    // user registration
    $atrig['pcud_user_data_updated_js'] = array(
        'act_type'  => 'pcud_user_data_updated',
        'trig_type' => 'js_event',
        'helper'    => __('Official way to track user data update through User Data add-on forms', $ml_key),
        
        'js_event' => array(
            'selector'      => 'window',
            'event'         => 'pcud_data_upd_form_saved',
            'is_jquery'     => 1,
            'once_per_page' => 0,
        ),
        'meta_assoc'=> array(
            'form_id'   => 2,
            'form_name' => 2,
        )
    );
    
    return $atrig;
}
add_filter('pcua_act_triggers', 'pcud_pcua_act_triggers');






// set form name for pcud_user_data_updated activity
function pcud_set_form_name_meta($metas, $act_slug, $params) {
    if($act_slug != 'pcud_user_data_updated') {
        return $metas;    
    }
    
    $term = get_term_by('id', $metas['form_id'], 'pcud_forms');
    $metas['form_name'] = $term->name;
    return $metas;
}
add_filter('pcua_add_act_metas', 'pcud_set_form_name_meta', 10, 3);
