<?php
// ADD-ON SETTINGS - INTEGRATED IN PVTCONTENT AND MAIL ACTION ONES


/////////////////////////////////////////////////
// ADD PSW FORCED RESET text into settings //////
/////////////////////////////////////////////////

function pcud_cf_fpr_legend($structure) {
    include_once(PC_DIR .'/settings/settings_engine.php');
    
	$to_edit = $structure['main_opts'];
	$ml_key = PCUD_ML;
	
	
	// PCMA - force reset on password retrieval
	if(defined('PCMA_VER') && PCMA_VER >= 1.7) {
		$pcma_f = array(
			'pcud_fpr_on_pcma_recovery' => array(
				'label' => __('Force on Mail Actions add-on password recovery?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('If checked, forces password reset when user logs in through password recovery system', $ml_key),
			),
		);	
	} else {
		$pcma_f = array();	
	}
	
	$to_add = array(
		'pcud_fpr_legend_wrap' => array(
			'sect_name'	=>  'User Data add-on - '. __('Forced Password Reset', $ml_key),
			'fields' 	=> array(
			
				'pcud_fpr_legend' => array(
					'label'	 	=> __('Password reset legend', $ml_key),
					'type'		=> 'textarea',
					'def'		=> __('Due to security reasons, you must change your password.
Please insert a new password, different from the past one.', $ml_key),
					'fullwidth' => true,
					'required'	=> true,
					'note'		=> __('This text will be used in the form, above password fields. Is mandatory and supports HTML.', $ml_key)
				),
			) + $pcma_f,
		),
	);
	
	$structure['main_opts'] = pc_settings_engine::inject_array_elem($to_add, $to_edit, 'analytics');
	return $structure;
}
add_filter('pc_settings_structure', 'pcud_cf_fpr_legend', 1);





//////////////////////////////////////////////////////
// ADD DATA-UPDATE FORM BUTTON'S ICON into settings //
//////////////////////////////////////////////////////

function pcud_cf_btn_icon_field($field_id, $field, $value, $all_vals) {
	$icon = get_option($field_id);
	?>
    <tr class="pc_<?php echo $field_id ?>_tr">
		<td class="lcwp_sf_label">
        	<label>User Data add-on - <?php _e("Data-update form button's icon", PCUD_ML) ?></label>
        </td>
		<td class="lcwp_sf_field">
			
            <div class="pc_field_icon_trigger">
            	<i class="<?php echo esc_attr( pc_static::fontawesome_v4_retrocomp($icon)) ?>" title="<?php esc_attr_e('set icon', PCUD_ML) ?>"></i>
                <input type="hidden" name="<?php echo esc_attr($field_id) ?>" value="<?php echo esc_attr( pc_static::fontawesome_v4_retrocomp($icon)) ?>" /> 
            </div>
		</td>
	</tr>
    <?php
}
function pcud_cf_btn_opt($structure) {
	$structure['styling']['button_icons']['fields']['pcud_cf_btn_icon'] = array(
		'type'		=> 'custom',
		'callback'	=> 'pcud_cf_btn_icon_field',
		'validation'=> array(
			array('index' => 'pcud_cf_btn_icon', 'label' => "User Data add-on - Data-update Form button's icon"),
		)
	);
	return $structure;
}
add_filter('pc_settings_structure', 'pcud_cf_btn_opt');





///////////////////////////////////////////////////////////////////////////
// REMOVE PC REGISTRATION FORM BLOCK IN SETTINGS AND MOVE TO PCUD WIZARD //
///////////////////////////////////////////////////////////////////////////

function pcud_move_to_pcud_form_wizard($structure) {
    $structure['registration']['rf_builder']['fields'] = array(
        'move_to_pcud_mess' => array(
            'type'		=> 'message',
            'content'	=> __('Forms are now manageable through User Data add-on interface', PCUD_ML) .'. &nbsp; <strong><a href="'. admin_url() .'admin.php?page=pcud_forms_builder">'. __('Go to the form builder', PCUD_ML).' &raquo;</a></strong>'
        )
	);
	return $structure;
}
add_filter('pc_settings_structure', 'pcud_move_to_pcud_form_wizard', 9999);





/////////////////////////////////////////////////////////////////





// MAIL ACTIONS INTEGRATIONS 


// pcma settings - add tab	
function pcud_pcma_tabs($tabs) {
	$tabs['pcud_data_update'] = 'User Data add-on';
	return $tabs;	
}
add_filter('pcma_settings_tabs', 'pcud_pcma_tabs');	
	


// receivers - custom field
// Admin notifier - receiver email address
function pcud_sfan_receivers_field($field_id, $field, $value, $all_vals) {
	?>
    <tr class="pcma_<?php echo $field_id ?>">
		<td class="lcwp_sf_label"><label><?php _e("Receiver's e-mail address", PCUD_ML) ?></label></td>
		<td class="lcwp_sf_field" colspan="2">
			
            <?php $val = (is_array($value)) ? implode(',', $value) : $value; ?>
            <input type="text" name="<?php echo $field_id ?>" value="<?php echo $val ?>" autocomplete="off" />
			
            <p class="lcwp_sf_note"><?php _e('E-mail receiving the notification - multiple addresses supported, <strong>comma split</strong>', PCUD_ML) ?></p> 
		</td>
	</tr>
    <?php
}

	
// pcma settings - add tab contents	
function pcud_pcma_tab_content($structure) {
	
	$def_subj 	= __("User's data updated", PCUD_ML);
	$def_txt	= __('Hello, 
%USERNAME% has just updated its data through data-update form.', PCUD_ML);
	
	$structure['pcud_data_update'] = array(
		'pcud_du_enable' => array(
			'sect_name'	=>  __('Data-update Forms Submission Notifier', PCUD_ML),
			'fields' 	=> array(
				
				'pcud_sf_admin_notif' => array(
					'label' => __('E-mail admins on data-update form submission?', PCUD_ML),
					'type'	=> 'checkbox',
                    'def'   => 0,
					'note'	=> __("If checked, notifies admins when a data-update form is submitted by a user", PCUD_ML),
				),
				'pcud_sfan_receivers' => array(
					'type'		=> 'custom',
					'callback'	=> 'pcud_sfan_receivers_field',
					'validation'=> array(
						array('index' => 'pcud_sfan_receivers', 'label' => __("User Data add-on - receiver's e-mail address", PCUD_ML))
					)
				),
			),
		),
		
		'pcud_du_mail_builder' => array(
			'sect_name'	=>  __('E-mail builder', 'pcma_ml'),
			'fields' 	=> array(
				
				'pcud_sfan_legend' => pcma_phs_legend(
					array(
						'%SITE-TITLE%'	=> __('Website title specified in WP settings', PCUD_ML),
						'%NAME%'		=> __("User's name", PCUD_ML),
						'%SURNAME%'		=> __("User's surame", PCUD_ML),
						'%USERNAME%'	=> __("User's userame", PCUD_ML),
						'%MAIL%'		=> __("User's e-mail", PCUD_ML),
						'%TEL%'			=> __("User's telephone", PCUD_ML),
						'%CAT%'			=> __("User categories", PCUD_ML),
					)
				),
				'pcud_sfan_title' => array(
					'label' 	=> __('E-mail title', PCUD_ML),
					'type'		=> 'text',
					'def' 		=> $def_subj,
					'fullwidth' => true,
				),
				'pcud_sfan_txt' => array(
					'label' => __("E-mail text", PCUD_ML),
					'type'	=> 'wp_editor',
					'def' 	=> $def_txt,
					'rows' 	=> 13,
				), 
			),
		),
	);
	
	return $structure;
}
add_action('pcma_settings_structure', 'pcud_pcma_tab_content');		
 
  	

// pcma settings - custom validation
function pcud_pcma_setting_errors($errors, $fdata) {
	
	if(!empty($fdata['pcud_sf_admin_notif'])) {
		if(empty($fdata['pcud_sfan_receivers']) || empty($fdata['pcud_sfan_title']) || empty($fdata['pcud_sfan_txt'])) {
			$errors[ esc_html__('User Data add-on', PCUD_ML) ] = __('All fields must be filled to enable it', PCUD_ML); // better readability by customers
		}
	}
			
	return $errors;	
}
add_filter('pcma_setting_errors', 'pcud_pcma_setting_errors', 10, 2);	


