<?php
////////// SHORCODES LIST


// [pcud-form] 
//// print data-update form
function pcud_form_shortcode($atts, $content = null) {
	require_once(PC_DIR .'/classes/pc_form_framework.php');
	$f_fw = new pc_form;
	
	extract( shortcode_atts( array(
		'form' 		=> '',
        'pcud_form' => '', // gutenberg-proof index
        
		'layout' 	=> '',
		'align' 	=> 'center'
	), $atts ) );
	
    
    if($pcud_form && !$form) {
        $form = $pcud_form;    
    }
    
	$term = get_term_by('id', (int)$form, 'pcud_forms');
	if(empty($term)) {
        return __('Data-update form found', PCUD_ML);
    }
    
    $f_fw->form_term_id = (int)$form;
	
	
	// execute only if pvtContent or WP user is logged 
	$pc_logged = pc_user_logged(false);
	if(!$pc_logged && !pc_wpuc_static::current_wp_user_bypass_restrictions()) {
        return false;
    }
	
	$user_id = ($pc_logged) ? $GLOBALS['pc_user_id'] : 0;	

	// form structure
	$term = get_term_by('id', (int)$form, 'pcud_forms');
	if(empty($term)) {
        return false;
    }
	
	if(empty($term->description)) {
		// retrocompatibility
		$form_fields = (array)get_option('pcud_form_'. (int)$form, array());	
	} else {
		$form_fields = unserialize(base64_decode($term->description));	
	}
	
	// layout
	if(empty($layout) || !in_array($layout, array('one_col', 'fluid'))) {
		$layout_class = 'pc_'. get_option('pg_reg_layout', 'one_col') .'_form';
	} else {
		$layout_class = 'pc_'. $layout .'_form';	
	}
    
    
    // PCUD-ACTION - before data-update form code composition - passes form ID and form fields
    do_action('pcud_pre_data_upd_form_code', (int)$form, pcud_fields_static::v2_field_names_sanitize($form_fields));
    
		
	$form = '
	<form class="pvtcont_form pc_custom_form pc_custom_form_'.$form.' '.$layout_class.'" data-form-pag="1" data-form-id="'. pc_static::encrypt_number($term->term_id) .'">';
    
		$form .= $f_fw->form_code( pcud_fields_static::v2_field_names_sanitize($form_fields), false, $user_id);
	
		$form .= '<div class="pc_form_response pc_custom_form_message"></div>';
	
		// has pages?
		if($f_fw->form_pages > 1) {
			$pag_btns = '
			<input type="button" value="'. esc_attr__('Previous', PC_ML) .'" class="pc_pag_btn pc_pag_prev pc_pag_btn_hidden" />
			<input type="button" value="'. esc_attr__('Next', PC_ML) .'" class="pc_pag_btn pc_pag_next" />';
			
			$pag_submit_class 	= 'pc_pag_submit';	
			$pag_submit_vis		= 'pc_displaynone';	
		}
		else {
			$pag_btns = '';
			$pag_submit_class 	= '';
			$pag_submit_vis		= '';	
		}
		
		// button's icon
		$icon = (get_option('pcud_cf_btn_icon')) ? '<i class="'. esc_attr( pc_static::fontawesome_v4_retrocomp(get_option('pcud_cf_btn_icon')) ) .'"></i>' : '';
		
		$form .= '
		<button class="pc_custom_form_btn '.$pag_submit_class.' '.$pag_submit_vis.'" type="submit">
            <span class="pc_inner_btn">'. $icon . __('Submit', PCUD_ML) .'</span>
        </button>
		'. $pag_btns .'
	</form>';
	
    
    // fluid form columnization
    if($layout == 'fluid') {
        $form .= '
        <script type="text/javascript">
        (function() { 
            "use strict";  
            
            const intval = setInterval(() => {
                if(typeof(jQuery) == "undefined" || typeof(pc_fluid_form_columnizer) == "undefined") {
                    return true;
                }
                else {
                    clearTimeout(intval);
                    pc_fluid_form_columnizer();
                }
            }, 50);
        })();
        </script>';
    }
    
	
	// minify respecting textarea line breaks
	$code = pc_static::form_align($form, $align);
	preg_match_all('#<\s*?textarea\b[^>]*>(.*?)</textarea\b[^>]*>#s', $form, $matches, PREG_SET_ORDER);
	
	foreach($matches as $m) {
		$to_replace = str_replace(array("\r\n"), '%BR%', $m[1]);	
		$code = str_replace($m[1], $to_replace, $code);	
	}
	 
	$minified = str_replace(array("\r", "\n", "\t", "\v"), '', $code);
	return str_replace('%BR%', '
', $minified);
}
add_shortcode('pcud-form', 'pcud_form_shortcode');






// [pcud-user-data] 
//// print a specific user data
function pcud_data_shortcode( $atts, $content = null ) {
	global $pc_users;
	if(!isset($GLOBALS['pc_user_id'])) {
        return '';
    }
	
	extract( shortcode_atts( array(
		'f' => ''
	), $atts ) );
	
	$index = sanitize_title($f);
	$result = $pc_users->get_user($GLOBALS['pc_user_id'], array('to_get' => $index));

	return $pc_users->data_to_human($index, $result[$index]);
}
add_shortcode('pcud-user-data', 'pcud_data_shortcode');






// [pcud-cond-block] 
// hide shortcode content if user data satisfy the condition
function pcud_cond_block_sc( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'f' 	=> '',
		'cond'	=> '=',
		'val'	=> ''
	), $atts ) );
	
	// logged user data
	$ud = pc_user_logged( sanitize_title($f) );
	
	if(!isset($GLOBALS['pc_user_id'])) {
        return ''; // check logged user
    } 
	else {		
	
		// turn field to array to use a cycle
		$arr = (is_array($ud)) ? $ud : array($ud);
		
		foreach($arr as $ud_val) {
			switch($cond) {
				case '=' :
					$to_return = ($ud_val == $val) ? do_shortcode($content) : false;
					break;
						
				case '!=' :
					$to_return = ($ud_val != $val) ? do_shortcode($content) : false;
					break;
					
				case 'big' :
					$to_return = ((float)$ud_val > (float)$val) ? do_shortcode($content) : false;
					break;
					
				case 'small' :
					$to_return = ((float)$ud_val < (float)$val) ? do_shortcode($content) : false;
					break;
					
				case 'like' : // value contains string
					$to_return = (strpos((string)$ud_val, (string)$val) !== false) ? do_shortcode($content) : false;
					break;
				
					
				default : return ''; break; // if wrong condition - return nothing					
			}
			
			if($to_return !== false) {
				return $to_return;
				break;
			}
		}
	}
}
add_shortcode('pcud-cond-block', 'pcud_cond_block_sc');

