<?php
// PRIVATECONTENT INTEGRATIONS - SHOTRCODES


add_filter('pc_tinymce_tabs', 'pcud_tinymce_tabs');

function pcud_tinymce_tabs($tabs) {
	include_once(PC_DIR .'/classes/pc_form_framework.php');
	$f_fw = new pc_form;
	
	// get forms
	$forms = get_terms('pcud_forms', 'hide_empty=0');
	$form_fields = $f_fw->fields;	
	
	$grouped_fields = $f_fw->get_fields_grouped();
	
    $fields_to_ignore = pcud_static::wizards_ignore_fields(true);
    $username_key = array_search('username', $fields_to_ignore);
    if($username_key !== false) {unset($fields_to_ignore[$username_key]);}
    
    
	/* User data shortcode */
	$contents = '
	<ul>
		<li class="pc_scw_field pc_scw_field">
			<label>'. __('User data to display', PCUD_ML) .'</label>
	
			<select name="pcud_fields_list" id="pcud_fields_list" class="pc_lc_select f_type" data-placeholder="'. esc_html__('Select field', PCUD_ML) .' .." autocomplete="off">';
    
                foreach($grouped_fields as $group_name => $fields) {
                    $contents .= '
                    <optgroup label="'. esc_attr($group_name) .'">';

                        foreach($fields as $field => $data) {
                            if(!in_array($field, $fields_to_ignore)) {
                                $contents .= '<option value="'. $field .'" '. selected('username', $field, false) .'>'.$data['label'].'</option>';
                            }
                        }

                    $contents .= '
                    </optgroup>';
                }	
	
    $contents .= '		  
    		</select>
		</li>
		<li class="pc_scw_field pc_scw_field">
			<input type="button" id="pcud-user-data-submit" class="button-primary" value="'. esc_attr__('Insert', PCUD_ML) .'" name="submit" />
		</li>
	';
	$tabs['pcud_user_data'] = array(
		'name' 		=> 'PCUD - '. __("User's Data", PCUD_ML),
		'contents'	=> $contents .'</ul>'
	);
	



	/* data-update form */
	$contents = '
	<ul>
		<li class="pc_scw_field pc_scw_field">
			<label>'. __('Form to display', PCUD_ML) .'</label>
	
			<select name="pcud_form_list" id="pcud_forms_list" class="pc_lc_select f_type" data-placeholder="'. __('Select form', PCUD_ML) .' .." autocomplete="off">';
			
			  foreach ($forms as $form) {
				  $contents .= '<option value="'.$form->term_id.'">'.$form->name.'</option>';
			  }
	
    $contents .= '		  
    		</select>
		</li>
		<li class="pc_scw_field pc_scw_field">
			<label>'. __('Layout', PCUD_ML) .'</label>
	
			<select name="pcud_form_layout" id="pcud_forms_layout" class="pc_lc_select f_type" data-placeholder="'. esc_attr__('Select an option', PCUD_ML) .' .." autocomplete="off">
				<option value="" selected="selected">'. __('Default one', PCUD_ML) .'</option>
				<option value="one_col">'. __('Single column', PCUD_ML) .'</option>
				<option value="fluid">'. __('Fluid (multi column)', PCUD_ML) .'</option>
			</select>
		</li>
		<li class="pc_scw_field pc_scw_field">
			<label>'. __('Form alignment', PCUD_ML) .'</label>
			<select name="pcud_forms_align" id="pcud_forms_align" class="pc_lc_select" data-placeholder="'. esc_attr__('Select an option', PCUD_ML) .' .." autocomplete="off">
				<option value="center" selected="selected">'. esc_html__('Center', PC_ML) .'</option>
				<option value="left">'. esc_html__('Left', PC_ML) .'</option>
				<option value="right">'. esc_html__('Right', PC_ML) .'</option>
			</select>
		</li>	
		<li class="pc_scw_field pc_scw_field">
			<input type="button" id="pcud-form-submit" class="button-primary" value="'. esc_attr__('Insert Form', PCUD_ML) .'" name="submit" />
		</li>
	';
	$tabs['pcud_cust_form'] = array(
		'name' 		=> 'PCUD - '. __("Data-update Form", PCUD_ML),
		'contents'	=> $contents .'</ul>'
	);




	/* Conditional block */
	$contents = '
	<ul>
		<li class="pc_scw_field pc_scw_field">
			<label>'. __('Show content when', PCUD_ML) .'</label>
	
			<select name="pcud_cb_field" id="pcud_cb_field" class="pc_lc_select f_type" data-placeholder="'. esc_attr__('Select field', PCUD_ML) .' .." autocomplete="off">';
			
			foreach($form_fields as $field_id => $data) {
				if(!in_array($field_id, pcud_static::wizards_ignore_fields())) {
					$contents .= '<option value="'. $field_id .'">'. esc_html($data['label']) .'</option>';
				}
			}
	
    $contents .= '		  
    		</select>
		</li>
		<li class="pc_scw_field pc_scw_field">
			<select name="pcud_cb_condition" id="pcud_cb_condition" autocomplete="off">
				<option value="=" >'. esc_html__('is equal to', PCUD_ML) .'</option>
				<option value="!=" >'. esc_html__('is different from', PCUD_ML) .'</option>	
				<option value="big" >'. esc_html__('is greater than', PCUD_ML) .'</option>	
				<option value="small" >'. esc_html__('is lower than', PCUD_ML) .'</option>
				<option value="like">'. esc_html__('contains', PCUD_ML) .'</option>		
			</select>
			
            <input type="text" name="pcud_cb_val" id="pcud_cb_val" value="" autocomplete="off" />
		</li>	
		<li class="pc_scw_field pc_scw_field">
			<input type="button" id="pcud_cb_submit" class="button-primary" value="'. esc_attr__('Insert Block', PCUD_ML) .'" name="submit" />
		</li>
	';
	$tabs['pcud_cond_block'] = array(
		'name' 		=> 'PCUD - '. __("Conditional Block", PCUD_ML),
		'contents'	=> $contents .'</ul>'
	);


	$GLOBALS['pcud_print_tinymce_js'] = true;
	return $tabs;
}




// add javascript code in footer
function pcud_tinymce_js() {
	if(!isset($GLOBALS['pcud_print_tinymce_js'])) {
        return true;    
    }
	?>
	<script type="text/javascript">
    (function($) { 
        "use strict";  
		
		// [pcud-user-data] 
		$(document).on('click', "#pcud-user-data-submit", function() {
			var fid = $("#pcud_fields_list").val();
			
			if(fid != "") {
				var shortcode = '[pcud-user-data f="'+fid+'"]';
				tinyMCE.activeEditor.execCommand("mceInsertContent", 0, shortcode);
				$.magnificPopup.close();
			}
		});
		
		// [pcud-form] 
		$(document).on('click', "#pcud-form-submit", function() {
			var fid = $("#pcud_forms_list").val();
			
			if(fid) {
				var sc = '[pcud-form form="'+fid+'"';
				
				// layout
				if($('#pcud_forms_layout').val()) {
					sc += ' layout="'+ $('#pcud_forms_layout').val() +'"';	
				}
				
				// alignment
				if($('#pcud_forms_align').val() != 'center') {
					sc += ' align="'+ $('#pcud_forms_align').val() +'"';	
				}
				
				var shortcode = sc +']';
				tinyMCE.activeEditor.execCommand("mceInsertContent", 0, shortcode);
				$.magnificPopup.close();	
			}
		});
		
		// [pcud-cond-block] 
		$(document).on('click', "#pcud_cb_submit", function() {
			var fid = $("#pcud_cb_field").val();
			var cond = $("#pcud_cb_condition").val();
			var val = $("#pcud_cb_val").val(); 
			val = val.replace(/"/g, '&quot;');
			
			if(fid) {
				var shortcode = '[pcud-cond-block f="'+ fid +'" cond="'+ cond +'" val="'+ val +'"][/pcud-cond-block]';
				tinyMCE.activeEditor.execCommand("mceInsertContent", 0, shortcode);
				$.magnificPopup.close();	
			}
		});
        
	})(jQuery);
	</script>
    <?php
}
add_action('admin_footer', 'pcud_tinymce_js', 100);  // PC is triggered at 1

