<?php
	if (!defined('ABSPATH')) {
		exit;
	}
	/**
		* The Admin Panel and related tasks are handled in this file.
	*/
	if (!class_exists('WP_iv_membership_Admin')) {
		class WP_iv_membership_Admin {
			static $pages = array();
			public function __construct() {
				add_action('admin_menu', array($this, 'admin_menu'));
				add_action('admin_print_scripts', array($this, 'load_scripts'));
				add_action('admin_print_styles', array($this, 'load_styles'));	
				add_action('wp_ajax_iv_membership_save_package', array($this, 'iv_membership_save_package'));
				add_action('wp_ajax_iv_membership_update_package', array($this, 'iv_membership_update_package'));
				add_action('wp_ajax_iv_membership_update_form_registration', array($this, 'iv_membership_update_form_registration'));
				add_action('wp_ajax_iv_membership_update_form_payment', array($this, 'iv_membership_update_form_payment'));
				add_action('wp_ajax_iv_membership_update_paypal_settings', array($this, 'iv_membership_update_paypal_settings'));
				add_action('wp_ajax_iv_membership_update_stripe_settings', array($this, 'iv_membership_update_stripe_settings'));
				add_action('wp_ajax_iv_membership_create_coupon', array($this, 'iv_membership_create_coupon'));
				add_action('wp_ajax_iv_membership_update_coupon', array($this, 'iv_membership_update_coupon'));
				add_action('wp_ajax_iv_membership_update_profile_template', array($this, 'iv_membership_update_profile_template'));
				add_action('wp_ajax_iv_membership_update_signup_template', array($this, 'iv_membership_update_signup_template'));
				add_action('wp_ajax_iv_membership_update_payment_setting', array($this, 'iv_membership_update_payment_setting'));
				add_action('wp_ajax_iv_membership_update_page_setting', array($this, 'iv_membership_update_page_setting'));
				add_action('wp_ajax_iv_membership_update_email_setting', array($this, 'iv_membership_update_email_setting'));
				add_action('wp_ajax_iv_membership_update_mailchamp_setting', array($this, 'iv_membership_update_mailchamp_setting'));
				add_action('wp_ajax_iv_membership_update_package_status', array($this, 'iv_membership_update_package_status'));
				add_action('wp_ajax_iv_membership_gateway_settings_update', array($this, 'iv_membership_gateway_settings_update'));
				add_action('wp_ajax_iv_membership_update_account_setting', array($this, 'iv_membership_update_account_setting'));
				add_action('wp_ajax_iv_membership_update_post_setting', array($this, 'iv_membership_update_post_setting'));
				add_action('wp_ajax_iv_update_protected_page_setting', array($this, 'iv_update_protected_page_setting'));
				add_action('wp_ajax_iv_membership_update_tax_setting', array($this, 'iv_membership_update_tax_setting'));
				add_action('wp_ajax_iv_membership_update_profile_public_template', array($this, 'iv_membership_update_profile_public_template'));
				add_action('wp_ajax_iv_membership_update_user_directory', array($this, 'iv_membership_update_user_directory'));
				add_action('wp_ajax_iv_membership_update_user_settings', array($this, 'iv_membership_update_user_settings'));
				add_action('wp_ajax_iv_membership_update_price_table_template', array($this, 'iv_membership_update_price_table_template'));
				add_action('wp_ajax_iv_membership_settings_save', array($this, 'iv_membership_settings_save'));
				add_action('wp_ajax_iv_membership_email_admin_template_change', array($this, 'iv_membership_email_admin_template_change'));
				add_action('wp_ajax_iv_membership_email_client_template_change', array($this, 'iv_membership_email_client_template_change'));
				add_action('wp_ajax_iv_membership_save_package_table', array($this, 'iv_membership_save_package_table'));
				add_action('wp_ajax_iv_membership_update_profile_fields', array($this, 'iv_membership_update_profile_fields'));
				add_action( 'init', array(&$this, 'iv_membership_payment_post_type') );
				add_filter( 'manage_edit-iv_payment_columns', array($this, 'set_custom_edit_iv_payment_columns')  );
				add_action( 'manage_iv_payment_posts_custom_column' ,  array($this, 'custom_iv_payment_column')  , 10, 2 );
				$this->action_hook();
				wp_admin_notifications::load();
			}
			public function iv_membership_payment_post_type() {
				$args = array(
				'description' => 'iv_membership Payment Post Type',
				'show_ui' => true,
				'exclude_from_search' => true,
				'labels' => array(
				'name'=> 'Payment History',
				'singular_name' => 'iv_payment',
				'edit' => 'Edit Payment History',
				'edit_item' => 'Edit Payment History',
				'view' => 'View Payment History',
				'view_item' => 'View Payment History',
				'search_items' => 'Search ',
				'not_found' => 'No  Found',
				'not_found_in_trash' => 'No Found in Trash',
				),
				'public' => true,
				'publicly_queryable' => false,
				'exclude_from_search' => true,
				'show_ui' => true,
				'show_in_menu' => 'flase',
				'hiearchical' => false,
				'capability_type' => 'post',
				'hierarchical' => false,
				'rewrite' => true,
				'supports' => array('title', 'editor', 'thumbnail','excerpt','custom-fields'),
				);
				register_post_type( 'iv_payment', $args );
			}
			public function set_custom_edit_iv_payment_columns($columns) {
				$columns['title']='Package Name';
				$columns['User'] = 'User Name';
				$columns['Member'] = 'User ID';
				$columns['Amount'] ='Amount';
				return $columns;
			}
			public function custom_iv_payment_column( $column, $post_id ) {
				global $post;
				switch ( $column ) {
					case 'User' :
					if(isset($post->post_author) ){
						$user_info = get_userdata( $post->post_author);
						if($user_info!='' ){
							echo  esc_html($user_info->user_login) ;
						}
					}
					break;
					case 'Member' :
					echo esc_html($post->post_author);
					break;
					case 'Amount' :
					echo esc_html($post->post_content);
					break;
				}
			}
			/**
				* Menus in the wp-admin sidebar
			*/
			public function admin_menu() {
				add_menu_page('WP iv_membership', 'WP Membership', 'manage_options', 'wp-iv_membership', array(&$this, 'menu_hook'));
				self::$pages['wp-iv_membership-package-all'] = add_submenu_page('wp-iv_membership', 'Package', 'Package', 'manage_options', 'wp-iv_membership-package-all', array(&$this, 'menu_hook'));
				self::$pages['wp-iv_membership-form_wizard'] = add_submenu_page('wp-iv_membership', 'WP iv_membership Form Wizard', 'Signup Wizard', 'manage_options', 'wp-iv_membership-form_wizard', array(&$this, 'menu_hook'));
				self::$pages['wp-iv_membership-profile-fields'] = add_submenu_page('wp-iv_membership', 'WP iv_membership profile-fields', 'Registration Fields', 'manage_options', 'wp-iv_membership-profile-fields', array(&$this, 'profile_fields_setting'));
				self::$pages['wp-iv_membership-profile-public'] = add_submenu_page('wp-iv_membership', 'WP iv_membership Profile public', 'Public Profile', 'manage_options', 'wp-iv_membership-profile-public', array(&$this, 'menu_hook'));
				self::$pages['wp-iv_membership-coupons-form'] = add_submenu_page('wp-iv_membership', 'WP iv_membership Create', 'Coupons', 'manage_options', 'wp-iv_membership-coupons-form', array(&$this, 'menu_hook'));
				self::$pages['wp-iv_membership-user-directory'] = add_submenu_page('wp-iv_membership', 'WP iv_membership Directory', 'User Directory', 'manage_options', 'wp-iv_membership-user-directory', array(&$this, 'menu_hook'));
				self::$pages['wp-iv_membership-payment-setting'] = add_submenu_page('wp-iv_membership', 'WP iv_membership Settings', 'Payment Gateways', 'manage_options', 'wp-iv_membership-payment-settings', array(&$this, 'menu_hook'));
				add_submenu_page('wp-iv_membership', 'WP iv_membership', 'Payment  History', 'manage_options',  'edit.php?post_type=iv_payment');
				self::$pages['wp-iv_user-directory-admin'] = add_submenu_page('wp-iv_membership', 'WP iv_membership directory-admin', 'User Setting', 'manage_options', 'wp-iv_user-directory-admin', array(&$this, 'menu_hook'));
				self::$pages['wp-iv_membership-settings'] = add_submenu_page('wp-iv_membership', 'WP iv_membership Settings', 'Settings', 'manage_options', 'wp-iv_membership-settings', array(&$this, 'menu_hook'));
				self::$pages['wp-iv_membership-report'] = add_submenu_page('wp-iv_membership', 'WP iv_membership Report', 'Report', 'manage_options', 'wp-iv_membership-report', array(&$this, 'menu_hook'));
				self::$pages['wp-iv_membership-package-create'] = add_submenu_page('', 'WP iv_membership package', '', 'manage_options', 'wp-iv_membership-package-create', array(&$this, 'package_create_page'));
				self::$pages['wp-iv_membership-package-update'] = add_submenu_page('', 'WP iv_membership package', '', 'manage_options', 'wp-iv_membership-package-update', array(&$this, 'package_update_page'));
				self::$pages['wp-iv_membership-coupon-create'] = add_submenu_page('', 'WP iv_membership coupon', '', 'manage_options', 'wp-iv_membership-coupon-create', array(&$this, 'coupon_create_page'));
				self::$pages['wp-iv_membership-coupon-update'] = add_submenu_page('', 'WP iv_membership coupon', '', 'manage_options', 'wp-iv_membership-coupon-update', array(&$this, 'coupon_update_page'));
				self::$pages['wp-iv_membership-payment-paypal'] = add_submenu_page('', 'WP iv_membership Payment setting', '', 'manage_options', 'wp-iv_membership-payment-paypal', array(&$this, 'paypal_update_page'));
				self::$pages['wp-iv_membership-payment-authorize'] = add_submenu_page('', 'WP iv_membership Payment setting', '', 'manage_options', 'wp-iv_membership-payment-authorize', array(&$this, 'authorize_update_page'));
				self::$pages['wp-iv_membership-payment-stripe'] = add_submenu_page('', 'WP iv_membership Payment setting', '', 'manage_options', 'wp-iv_membership-payment-stripe', array(&$this, 'stripe_update_page'));
				self::$pages['wp-iv_membership-user_update'] = add_submenu_page('', 'WP iv_membership user_update', '', 'manage_options', 'wp-iv_membership-user_update', array(&$this, 'user_update_page'));
			}
			/**
				* Menu Page Router
			*/
			public function menu_hook() {
				$screen = get_current_screen();
				switch ($screen->id) {
					default:
					require_once ('pages/package_all.php');
					break;
					case self::$pages['wp-iv_membership-coupons-form']:
					require_once ('pages/all_coupons.php');
					break;
					case self::$pages['wp-iv_membership-settings']:
					require_once ('pages/settings.php');
					break;
					case self::$pages['wp-iv_membership-form_wizard']:
					require_once ('pages/membership-form-wizard.php');
					break;
					case self::$pages['wp-iv_membership-profile-public']:
					require_once ('pages/membership-profile-wizard-public.php');
					break;
					case self::$pages['wp-iv_membership-package-all']:
					require_once ('pages/package_all.php');
					break;
					case self::$pages['wp-iv_membership-payment-setting']:
					require_once ('pages/payment-settings.php');
					break;
					case self::$pages['wp-iv_membership-report']:
					require_once ('pages/report.php');
					break;
					case self::$pages['wp-iv_membership-user-directory']:
					require_once ('pages/user_directory_wizard.php');
					break;
					case self::$pages['wp-iv_user-directory-admin']:
					require_once ('pages/user_directory_admin.php');
					break;
				}
			}
			public function  profile_fields_setting (){
				require_once ('pages/profile-fields.php');
			}
			public function coupon_create_page(){
				require_once ('pages/coupon_create.php');
			}
			public function coupon_update_page(){
				require_once ('pages/coupon_update.php');
			}
			public function package_create_page(){
				require_once ('pages/package_create.php');
			}
			public function package_update_page(){
				require_once ('pages/package_update.php');
			}
			public function authorize_update_page(){
				require_once ('pages/authorize_update.php');
			}
			public function paypal_update_page(){
				require_once ('pages/paypal_update.php');
			}
			public function stripe_update_page(){
				require_once ('pages/stripe_update.php');
			}
			public function user_update_page(){
				require_once ('pages/user_update.php');
			}
			/**
				* Page based Script Loader
			*/
			public function load_scripts() {
				$screen = get_current_screen();
				if (in_array($screen->id, array_values(self::$pages))) {
					wp_enqueue_script('jquery-ui', WP_iv_membership_URLPATH . 'admin/files/js/jquery-ui.min.js');
					wp_enqueue_script('bootstrap', WP_iv_membership_URLPATH . 'admin/files/js/bootstrap.min.js');
					wp_enqueue_script('iv_membership-script-5', WP_iv_membership_URLPATH . 'admin/files/js/epadmin.js');
					wp_localize_script('iv_membership-script-5', 'ep_data', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ),
					'loading_image'		=> '<img src="'.WP_iv_membership_URLPATH.'admin/files/images/loader.gif">',
					'current_user_id'	=>get_current_user_id(),
					'redirecturl'	=>  WP_iv_membership_ADMINPATH.'admin.php?page=wp-iv_membership-coupons-form&form_submit=success',
					'login_message'		=> esc_html__('Please login to remove favorite','wpmembership'),
					'redirecturlcoupon'	=>  WP_iv_membership_ADMINPATH.'admin.php?page=wp-iv_membership-coupons-form&form_submit=success',
					'redirecturlpackage'	=>  WP_iv_membership_ADMINPATH.'admin.php?page=wp-iv_membership-package-all&form_submit=success',
					'adminnonce'=> wp_create_nonce("admin"),
					'userredirect'=>WP_iv_membership_ADMINPATH.'admin.php?page=wp-iv_user-directory-admin&message=success',
					) );
				}
			}
			/**
				* Page based Style Loader
			*/
			public function load_styles() {
				$screen = get_current_screen();			
				if (in_array($screen->id, array_values(self::$pages))) {
					wp_enqueue_style('wp-iv_membership-adminstyle-1', WP_iv_membership_URLPATH . 'admin/files/css/iv-bootstrap.css');
					wp_enqueue_style('wp-iv_membership-adminstyle-2', WP_iv_membership_URLPATH . 'admin/files/css/admin.css');
					wp_enqueue_style('jquery-ui', WP_iv_membership_URLPATH . 'admin/files/css/jquery-ui.css');
					wp_enqueue_style('admin_inline_css_here', WP_iv_membership_URLPATH . 'admin/files/css/inline_css_admin.css');				
				}
			}
			/**
				* This function declares the different forms, sections and fields.
			*/
			public function settings_form() {
				register_setting('WP_iv_membership_settings', 'WP_iv_membership_settings', array(&$this, 'validate'));
				// General Settings
				add_settings_section('general_section', 'General Settings', 'wp_admin_forms::section_description', 'WP_iv_membership_general_section');
				add_settings_field('text_field', 'Text Field', 'wp_admin_forms::textbox', 'WP_iv_membership_general_section', 'general_section', array('id' => 'text_field', 'text' => '', 'settings' => 'WP_iv_membership_settings'));
				add_settings_field('checkbox_field', 'Checkbox Field', 'wp_admin_forms::checkbox', 'WP_iv_membership_general_section', 'general_section', array('id' => 'checkbox_field', 'text' => '', 'settings' => 'WP_iv_membership_settings'));
				add_settings_field('textarea_field', 'Textbox Field', 'wp_admin_forms::textarea', 'WP_iv_membership_general_section', 'general_section', array('id' => 'textarea_field', 'settings' => 'WP_iv_membership_settings'));
			}
			public function validate($var) {
				return $var;
			}
			/**
				* Use this function to execute actions
			*/
			public function action_hook() {
				if (!isset($_GET['action'])) {
					return;
				}
				switch ($_GET['action']) {
				}
			}
			public function iv_membership_save_package() {
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				global $wpdb;
				$iv_membership_pack='iv_membership_pack';
				$last_post_id = $wpdb->get_var($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_type = '%s' ORDER BY `ID` DESC ", $iv_membership_pack));
				$form_number = $last_post_id + 1;
				$role_name='';
				if($form_data['package_name']==""){
					$post_name = 'Package' . $form_number;
					$role_name=$post_name;
					}else{
					$post_name = sanitize_text_field($form_data['package_name']) .'-'. $form_number;
					$role_name=sanitize_text_field($form_data['package_name']);
				}
				$post_title=sanitize_text_field($form_data['package_name']);
				$post_content= $form_data['package_feature'];
				$my_post_form = array('post_title' => wp_strip_all_tags($post_title), 'post_name' => wp_strip_all_tags($post_name), 'post_content' => $post_content, 'post_status' => 'draft', 'post_author' => get_current_user_id(),);
				$newpost_id = wp_insert_post($my_post_form);
				$post_type = 'iv_membership_pack';
				$query =$wpdb->prepare( "UPDATE {$wpdb->prefix}posts SET post_type='%s' WHERE id='%s' LIMIT 1",$post_type,$newpost_id );
				$wpdb->query($query);
				update_post_meta($newpost_id, 'iv_membership_package_cost', sanitize_text_field($form_data['package_cost']));
				update_post_meta($newpost_id, 'iv_membership_package_initial_expire_interval', sanitize_text_field($form_data['package_initial_expire_interval']));
				update_post_meta($newpost_id, 'iv_membership_package_initial_expire_type', sanitize_text_field($form_data['package_initial_expire_type']));
				if(isset($form_data['package_recurring'])){
					update_post_meta($newpost_id, 'iv_membership_package_recurring', sanitize_text_field($form_data['package_recurring']));
					}else{
					update_post_meta($newpost_id, 'iv_membership_package_recurring', '');
				}
				//Woocommerce_products
				if(isset($form_data['Woocommerce_product'])){
					update_post_meta($newpost_id, 'iv_membership_package_woocommerce_product', sanitize_text_field($form_data['Woocommerce_product']));
				}
				update_post_meta($newpost_id, 'iv_membership_package_recurring_cost_initial', sanitize_text_field($form_data['package_recurring_cost_initial']));
				update_post_meta($newpost_id, 'iv_membership_package_recurring_cycle_count', sanitize_text_field($form_data['package_recurring_cycle_count']));
				update_post_meta($newpost_id, 'iv_membership_package_recurring_cycle_type', sanitize_text_field($form_data['package_recurring_cycle_type']));
				update_post_meta($newpost_id, 'iv_membership_package_recurring_cycle_limit', sanitize_text_field($form_data['package_recurring_cycle_limit']));
				if(isset($form_data['package_enable_trial_period'])){
					update_post_meta($newpost_id, 'iv_membership_package_enable_trial_period', sanitize_text_field($form_data['package_enable_trial_period']));
					}else{
					update_post_meta($newpost_id, 'iv_membership_package_enable_trial_period', 'no');
				}
				update_post_meta($newpost_id, 'iv_membership_package_trial_amount', sanitize_text_field($form_data['package_trial_amount']));
				update_post_meta($newpost_id, 'iv_membership_package_trial_period_interval', sanitize_text_field($form_data['package_trial_period_interval']));
				update_post_meta($newpost_id, 'iv_membership_package_recurring_trial_type', sanitize_text_field($form_data['package_recurring_trial_type']));
				global $wp_roles;
				$contributor_roles = $wp_roles->get_role('contributor');
				$role_name_new= str_replace(' ', '_', $role_name);
				$wp_roles->remove_role( $role_name_new );
				$role_display_name = $role_name;
				$wp_roles->add_role($role_name_new, $role_display_name, array(
				'read' => true, 
				'edit_posts' => true,
				'delete_posts' => true,
				'upload_files' => true 
				));
				update_post_meta($newpost_id, 'iv_membership_package_user_role', $role_name_new);
				update_post_meta($newpost_id, 'iv_membership_package_max_post_no', sanitize_text_field($form_data['max_pst_no']));
				$cat_ids= '';
				if(isset($form_data['membershipcategory'])){
					$cat_ids= implode("|", $form_data['membershipcategory']);
				}
				update_post_meta($newpost_id, 'iv_membership_package_category_ids', $cat_ids);
				// End User Role
				// For Stripe Plan Create*****
				if(isset($form_data['package_recurring'])){
					$iv_gateway = get_option('iv_membership_payment_gateway');
					if($iv_gateway=='stripe'){
						require_once(WP_iv_membership_DIR . '/admin/files/init.php');
						$post_name2='iv_membership_stripe_setting';
						$row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_name = '%s' ",$post_name2 ));
						if(isset($row->ID)){
							$stripe_id= $row->ID;
						}
						$stripe_mode=get_post_meta( $stripe_id,'iv_membership_stripe_mode',true);
						if($stripe_mode=='test'){
							$stripe_api =get_post_meta($stripe_id, 'iv_membership_stripe_secret_test',true);
							}else{
							$stripe_api =get_post_meta($stripe_id, 'iv_membership_stripe_live_secret_key',true);
						}
						$interval_count= ($form_data['package_recurring_cycle_count']=="" ? '1':$form_data['package_recurring_cycle_count']);
						$stripe_currency =get_post_meta($stripe_id, 'iv_membership_stripe_api_currency',true);
						\Stripe\Stripe::setApiKey($stripe_api);
						$stripe_array=array();
						$post_package_one = get_post($newpost_id);
						$p_name = $post_package_one->post_name;
						$stripe_array['id']= $p_name;
						$stripe_array['amount']=$form_data['package_recurring_cost_initial'] * 100;
						$stripe_array['interval']=$form_data['package_recurring_cycle_type'];
						$stripe_array['interval_count']=$interval_count;
						$stripe_array['currency']=$stripe_currency;
						$stripe_array['product']=array('name' => $p_name);
						$trial=get_post_meta($newpost_id, 'iv_membership_package_enable_trial_period', true);
						if($trial=='yes'){
							$trial_type = get_post_meta( $newpost_id,'iv_membership_package_recurring_trial_type',true);
							$trial_cycle_count =get_post_meta($newpost_id, 'iv_membership_package_trial_period_interval', true);
							switch ($trial_type) {
								case 'year':
								$periodNum =  365 * 1;
								break;
								case 'month':
								$periodNum =  30 * $trial_cycle_count;
								break;
								case 'week':
								$periodNum = 7 * $trial_cycle_count;
								break;
								case 'day':
								$periodNum = 1 * $trial_cycle_count;
								break;
							}
							$stripe_array['trial_period_days']=$periodNum;
						}
						\Stripe\Plan::create($stripe_array);
					}
				}
				// End Stripe Plan Create*****
				echo json_encode(array('code' => 'success'));
				exit(0);
			}			
			public function iv_membership_save_package_table(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$package_html_content =	sanitize_text_field($_REQUEST['iv_membership_package_template']);
				$package_html_content = str_replace('container', 'container-fluid', $package_html_content);
				update_option('iv_membership_package_template', htmlentities(stripslashes($package_html_content)));
				echo json_encode(array('code' => 'success'));
				exit(0);
			}
			public function iv_membership_update_profile_fields(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$opt_array= array();
				$signup_array= array();
				$require_array= array();
				$max = sizeof($form_data['meta_name']);
				for($i = 0; $i < $max;$i++)
				{
					if($form_data['meta_name'][$i]!="" AND $form_data['meta_label'][$i]!=""){
						$opt_array[$form_data['meta_name'][$i]]=$form_data['meta_label'][$i];
						$default_signup='no';
						if(isset($form_data['signup'][$i])){
							$default_signup='yes';
							$signup_array[$form_data['signup'][$i]]=$default_signup;
						}
						$default_require='no';
						if(isset($form_data['srequire'][$i])){
							$default_require='yes';
							$require_array[$form_data['srequire'][$i]]=$default_require;
						}
					}
				}
				update_option('iv_membership_profile_fields', $opt_array );
				update_option('iv_membership_signup_fields', $signup_array );
				update_option('iv_membership_signup_require', $require_array );
				$opt_array= array();
				$max = sizeof($form_data['meta_name']);
				for($i = 0; $i < $max;$i++)
				{
					if($form_data['meta_name'][$i]!="" AND $form_data['meta_label'][$i]!=""){
						$opt_array[$form_data['meta_name'][$i]]=$form_data['meta_label'][$i];
					}
				}
				update_option('iv_membership_profile_fields', $opt_array );
				$opt_array2= array();
				$max = sizeof($form_data['menu_title']);
				for($i = 0; $i < $max;$i++)
				{
					if($form_data['menu_title'][$i]!="" AND $form_data['menu_link'][$i]!=""){
						$opt_array2[$form_data['menu_title'][$i]]=$form_data['menu_link'][$i];
					}
				}
				update_option('iv_membership_profile_menu', $opt_array2 );
				// remove menu******
				if(isset($form_data['mylevel'])){
					update_option( '_iv_membership_mylevel' ,$form_data['mylevel']);
					}else{
					update_option( '_iv_membership_mylevel' ,'no') ;
				}
				if(isset($form_data['menusetting'])){
					update_option( '_iv_membership_menusetting' ,$form_data['menusetting']);
					}else{
					update_option( '_iv_membership_menusetting' ,'no') ;
				}
				if(isset($form_data['menuallpost'])){
					update_option( '_iv_membership_menuallpost' ,$form_data['menuallpost']);
					}else{
					update_option( '_iv_membership_menuallpost' ,'no') ;
				}
				if(isset($form_data['menunewpost'])){
					update_option( '_iv_membership_menunewpost' ,$form_data['menunewpost']);
					}else{
					update_option( '_iv_membership_menunewpost' ,'no') ;
				}
				if(isset($form_data['menubilling'])){
					update_option( '_iv_membership_menubilling' ,$form_data['menubilling']);
					}else{
					update_option( '_iv_membership_menubilling' ,'no') ;
				}
				echo json_encode(array('code' => 'Update Successfully'));
				exit(0);
			}
			public function iv_membership_update_package() {
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$post_content="";
				global $wpdb;
				$post_title=sanitize_text_field($form_data['package_name']);
				$post_id=	sanitize_text_field($form_data['package_id']);
				$newpost_id=$post_id;
				$post_content= sanitize_textarea_field($form_data['package_feature']);
				$post_type = 'iv_membership_pack';
				$query = $wpdb->prepare("UPDATE {$wpdb->prefix}posts SET post_title='%s', post_content='%s'  WHERE id='%s' LIMIT 1",$post_title,$post_content ,$post_id );
				$wpdb->query($query);
				update_post_meta($newpost_id, 'iv_membership_package_cost', sanitize_text_field($form_data['package_cost']));
				update_post_meta($newpost_id, 'iv_membership_package_initial_expire_interval', sanitize_text_field($form_data['package_initial_expire_interval']));
				update_post_meta($newpost_id, 'iv_membership_package_initial_expire_type', sanitize_text_field($form_data['package_initial_expire_type']));
				//Woocommerce_products
				if(isset($form_data['Woocommerce_product'])){
					update_post_meta($newpost_id, 'iv_membership_package_woocommerce_product',sanitize_text_field( $form_data['Woocommerce_product']));
				}
				if(isset($form_data['package_recurring'])){
					update_post_meta($newpost_id, 'iv_membership_package_recurring', sanitize_text_field($form_data['package_recurring']));
					}else{
					update_post_meta($newpost_id, 'iv_membership_package_recurring', '');
				}
				if(isset($form_data['package_recurring'])){
					update_post_meta($newpost_id, 'iv_membership_package_recurring', sanitize_text_field($form_data['package_recurring']));
					update_post_meta($newpost_id, 'iv_membership_package_recurring_cost_initial', sanitize_text_field($form_data['package_recurring_cost_initial']));
					update_post_meta($newpost_id, 'iv_membership_package_recurring_cycle_count', sanitize_text_field($form_data['package_recurring_cycle_count']));
					update_post_meta($newpost_id, 'iv_membership_package_recurring_cycle_type', sanitize_text_field($form_data['package_recurring_cycle_type']));
					update_post_meta($newpost_id, 'iv_membership_package_recurring_cycle_limit', sanitize_text_field($form_data['package_recurring_cycle_limit']));
					if(isset($form_data['package_enable_trial_period'])){
						update_post_meta($newpost_id, 'iv_membership_package_enable_trial_period', sanitize_text_field($form_data['package_enable_trial_period']));
						}else{
						update_post_meta($newpost_id, 'iv_membership_package_enable_trial_period', 'no');
					}
					update_post_meta($newpost_id, 'iv_membership_package_trial_amount', sanitize_text_field($form_data['package_trial_amount']));
					update_post_meta($newpost_id, 'iv_membership_package_trial_period_interval', sanitize_text_field($form_data['package_trial_period_interval']));
					update_post_meta($newpost_id, 'iv_membership_package_recurring_trial_type', sanitize_text_field($form_data['package_recurring_trial_type']));
				}
				update_post_meta($newpost_id, 'iv_membership_package_max_post_no', sanitize_text_field($form_data['max_pst_no']));
				$cat_ids= '';
				if(isset($form_data['membershipcategory'])){
					$cat_ids= implode("|", $form_data['membershipcategory']);
				}
				
				// For Stripe*****
				// For Stripe Plan Edit*****
				if(isset($form_data['package_recurring'])){
					$iv_gateway = get_option('iv_membership_payment_gateway');
					if($iv_gateway=='stripe'){
						require_once(WP_iv_membership_DIR . '/admin/files/init.php');
						$post_name2='iv_membership_stripe_setting';
						$row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_name = '%s' " , $post_name2));
						if(isset($row->ID)){
							$stripe_id= $row->ID;
						}
						$stripe_mode=get_post_meta( $stripe_id,'iv_membership_stripe_mode',true);
						if($stripe_mode=='test'){
							$stripe_api =get_post_meta($stripe_id, 'iv_membership_stripe_secret_test',true);
							}else{
							$stripe_api =get_post_meta($stripe_id, 'iv_membership_stripe_live_secret_key',true);
						}
						$interval_count= ($form_data['package_recurring_cycle_count']=="" ? '1':$form_data['package_recurring_cycle_count']);
						$stripe_currency =get_post_meta($stripe_id, 'iv_membership_stripe_api_currency',true);
						\Stripe\Stripe::setApiKey($stripe_api);
						$stripe_array=array();
						$post_package_one = get_post($newpost_id);
						$p_name = $post_package_one->post_name;
						$stripe_array['id']= $p_name;
						$stripe_array['amount']=$form_data['package_recurring_cost_initial'] * 100;
						$stripe_array['interval']=$form_data['package_recurring_cycle_type'];
						$stripe_array['interval_count']=$interval_count;
						$stripe_array['currency']=$stripe_currency;
						$stripe_array['product']=array('name' => $p_name);
						$trial=get_post_meta($newpost_id, 'iv_membership_package_enable_trial_period', true);
						if($trial=='yes'){
							$trial_type = get_post_meta( $newpost_id,'iv_membership_package_recurring_trial_type',true);
							$trial_cycle_count =get_post_meta($newpost_id, 'iv_membership_package_trial_period_interval', true);
							switch ($trial_type) {
								case 'year':
								$periodNum =  365 * 1;
								break;
								case 'month':
								$periodNum =  30 * $trial_cycle_count;
								break;
								case 'week':
								$periodNum = 7 * $trial_cycle_count;
								break;
								case 'day':
								$periodNum = 1 * $trial_cycle_count;
								break;
							}
							$stripe_array['trial_period_days']=$periodNum;
						}
						try {
							$p = \Stripe\Plan::retrieve($p_name);							
						} catch (Exception $e) {
								$api_error = $e->getMessage();
						}
						if(empty($api_error)){
							$p->delete();
						}
						try {
							\Stripe\Plan::create($stripe_array);
						} catch (Exception $e) {
								print_r($e);
						}
					}
				}
				// End Stripe Plan Create*****
				update_post_meta($newpost_id, 'iv_membership_package_category_ids', $cat_ids);
				echo json_encode(array('code' => 'success'));
				exit(0);
			}
			public function iv_membership_update_paypal_settings() {
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$post_content="";
				global $wpdb;
				$post_name='iv_membership_paypal_setting';
				$post_type = 'iv_payment_setting';
				if (!get_page_by_title($post_name, OBJECT, 'iv_payment_setting')){
					$my_post_form = array('post_title' => wp_strip_all_tags($post_name), 'post_name' => wp_strip_all_tags($post_name), 'post_content' => 'Paypal Setting', 'post_status' => 'draft', 'post_author' => get_current_user_id(),'post_type'=>$post_type,);
					$newpost_id = wp_insert_post($my_post_form);
					}else{
					$row_data= get_page_by_title($post_name, OBJECT, 'iv_payment_setting');
					$newpost_id=$row_data->ID;
				}
				update_post_meta($newpost_id, 'iv_membership_paypal_mode', sanitize_text_field($form_data['paypal_mode']));
				update_post_meta($newpost_id, 'iv_membership_paypal_username', sanitize_text_field($form_data['paypal_username']));
				update_post_meta($newpost_id, 'iv_membership_paypal_api_password', sanitize_text_field($form_data['paypal_api_password']));
				update_post_meta($newpost_id, 'iv_membership_paypal_api_signature', sanitize_text_field($form_data['paypal_api_signature']));
				update_post_meta($newpost_id, 'iv_membership_paypal_api_currency', sanitize_text_field($form_data['paypal_api_currency']));
				update_option('_iv_membership_api_currency', sanitize_text_field($form_data['paypal_api_currency'] ));
				echo json_encode(array('code' => 'success'));
				exit(0);
			}
			public function iv_membership_update_tax_setting(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				if(isset($form_data['active_tax'])){
					$active_tax=sanitize_text_field($form_data['active_tax']);
					}else{
					$active_tax='no';
				}
				update_option('_iv_tax_type', sanitize_text_field($form_data['tax_type']));
				update_option('_iv_membership_active_tax', $active_tax );
				update_option('_iv_countries_tax', $form_data);
				update_option('_iv_comman_tax_value', sanitize_text_field($form_data['common_tax_input']));
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
			public function iv_membership_update_stripe_settings() {
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$post_content="";
				$post_name='iv_membership_stripe_setting';
				$post_type='iv_payment_setting';
				if (!get_page_by_title($post_name, OBJECT, 'iv_payment_setting')){
					$my_post_form = array('post_title' => wp_strip_all_tags($post_name), 'post_name' => wp_strip_all_tags($post_name), 'post_content' => 'stripe Setting', 'post_status' => 'draft', 'post_author' => get_current_user_id(),'post_type'=>$post_type,);
					$newpost_id = wp_insert_post($my_post_form);
					}else{
					$row_data= get_page_by_title($post_name, OBJECT, 'iv_payment_setting');
					$newpost_id=$row_data->ID;
				}
				update_post_meta($newpost_id, 'iv_membership_stripe_mode', sanitize_text_field($form_data['stripe_mode']));
				update_post_meta($newpost_id, 'iv_membership_stripe_live_secret_key', sanitize_text_field($form_data['secret_key']));
				update_post_meta($newpost_id, 'iv_membership_stripe_live_publishable_key', sanitize_text_field($form_data['publishable_key']));
				update_post_meta($newpost_id, 'iv_membership_stripe_secret_test', sanitize_text_field($form_data['secret_key_test']));
				update_post_meta($newpost_id, 'iv_membership_stripe_publishable_test', sanitize_text_field($form_data['stripe_publishable_test']));
				update_post_meta($newpost_id, 'iv_membership_stripe_api_currency', sanitize_text_field($form_data['stripe_api_currency']));
				update_option('_iv_membership_api_currency', sanitize_text_field($form_data['stripe_api_currency'] ));
				echo json_encode(array('code' => 'success'));
				exit(0);
			}
			public function iv_membership_create_coupon() {
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$post_content="";
				$post_name=sanitize_text_field($form_data['coupon_name']);
				$coupon_data = array('post_title' => wp_strip_all_tags($post_name), 'post_name' => wp_strip_all_tags($post_name), 'post_content' => $post_name, 'post_status' => 'draft', 'post_author' => get_current_user_id(), 'post_type' => 'iv_membership_coupon',);
				$newpost_id = wp_insert_post($coupon_data);
				if($form_data['coupon_count']==""){
					$coupon_limit='99999';
					}else{
					$coupon_limit=sanitize_text_field($form_data['coupon_count']);
				}
				$pac='';
				if(isset($_POST['form_pac_ids'])){$pac=$_POST['form_pac_ids'];}
				$pck_ids =implode(",",$pac);
				update_post_meta($newpost_id, 'iv_membership_coupon_pac_id', $pck_ids);
				update_post_meta($newpost_id, 'iv_membership_coupon_limit',$coupon_limit);
				update_post_meta($newpost_id, 'iv_membership_coupon_start_date', sanitize_text_field($form_data['start_date']));
				update_post_meta($newpost_id, 'iv_membership_coupon_end_date', sanitize_text_field($form_data['end_date']));
				update_post_meta($newpost_id, 'iv_membership_coupon_amount', sanitize_text_field($form_data['coupon_amount']));
				update_post_meta($newpost_id, 'iv_membership_coupon_type', sanitize_text_field($form_data['coupon_type']));
				echo json_encode(array('code' => 'success'));
				exit(0);
			}
			public function iv_membership_update_coupon() {
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$post_content="";
				global $wpdb;
				$post_title=sanitize_text_field($form_data['coupon_name']);
				$post_id=$form_data['coupon_id'];
				$newpost_id=$post_id;
				$post_data = array(
				'ID'           	=> $post_id,
				'post_title'   	=> $post_title,
				'post_type' 		=> 'iv_membership_coupon'
				);
				wp_update_post( $post_data );
				$pck_ids =implode(",",$_POST['form_pac_ids']);
				update_post_meta($newpost_id, 'iv_membership_coupon_pac_id', $pck_ids);
				update_post_meta($newpost_id, 'iv_membership_coupon_limit', sanitize_text_field($form_data['coupon_count']));
				update_post_meta($newpost_id, 'iv_membership_coupon_start_date', sanitize_text_field($form_data['start_date']));
				update_post_meta($newpost_id, 'iv_membership_coupon_end_date', sanitize_text_field($form_data['end_date']));
				update_post_meta($newpost_id, 'iv_membership_coupon_amount', sanitize_text_field($form_data['coupon_amount']));
				update_post_meta($newpost_id, 'iv_membership_coupon_type', sanitize_text_field($form_data['coupon_type']));
				echo json_encode(array('code' => 'success'));
				exit(0);
			}
			public function	iv_membership_update_profile_template(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$profile_style='';
				if(isset($_POST['profile-st'])){
					$profile_style=sanitize_text_field($_POST['profile-st']);
					update_option('iv_membership_profile-template', $profile_style);
				}
				echo json_encode(array('code' => 'Update successfully'));
				exit(0);
			}
			public function iv_membership_update_user_directory(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$dir_style='';
				if(isset($_POST['profile-st'])){
					$dir_style=sanitize_text_field($_POST['profile-st']);
					update_option('iv_membership_user_directory', $dir_style);
				}
				echo json_encode(array('code' => 'Update successfully'));
				exit(0);
			}
			public function iv_membership_update_profile_public_template(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$profile_style='';
				if(isset($_POST['profile-st'])){
					$profile_style=sanitize_text_field($_POST['profile-st']);
					update_option('iv_membership_profile-public', $profile_style);
				}
				echo json_encode(array('code' => 'Update successfully'));
				exit(0);
			}
			public function iv_membership_update_signup_template(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$signup_style='';
				if(isset($_POST['signup-st'])){
					$signup_style=sanitize_text_field($_POST['signup-st']);
					update_option('iv_membership_signup-template', $signup_style);
				}
				echo json_encode(array('code' => 'Update successfully'));
				exit(0);
			}
			public function	iv_membership_update_price_table_template(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$profile_style='';
				if(isset($_POST['price-tab-style'])){
					$profile_style=sanitize_text_field($_POST['price-tab-style']);
					update_option('iv_membership_price-table', $profile_style);
				}
				echo json_encode(array('code' => 'Update successfully'));
				exit(0);
			}
			public function  iv_membership_update_payment_setting(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$iv_terms='no';
				if(isset($form_data['iv_terms'])){
					$iv_terms=sanitize_textarea_field($form_data['iv_terms']);
				}
				$terms_detail=sanitize_textarea_field($form_data['terms_detail']);
				$iv_coupon='';
				if(isset($form_data['iv_coupon'])){
					$iv_coupon=sanitize_text_field($form_data['iv_coupon']);
				}
				update_option('iv_membership_payment_terms_text', $terms_detail );
				update_option('iv_membership_payment_terms', $iv_terms );
				update_option('_iv_membership_payment_coupon', $iv_coupon );
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
			public function iv_membership_update_account_setting(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$post_approved='no';
				if(isset($form_data['post_approved'])){
					$post_approved=$form_data['post_approved'];
				}
				$signup_redirect=sanitize_text_field($form_data['signup_redirect']);
				$private_profile_page  = sanitize_text_field($form_data['pri_profile_redirect']);
				$pub_profile_redirect=sanitize_text_field($form_data['profile_redirect']);
				if(isset($form_data['hide_admin_bar'])){
					$admin_bar=$form_data['hide_admin_bar'];
					}else{
					$admin_bar='no';
				}
				update_option('iv_membership_post_approved', $post_approved );
				update_option('iv_membership_signup_redirect', $signup_redirect );
				update_option('_iv_membership_profile_page', $private_profile_page );
				update_option('_iv_membership_profile_public_page', $pub_profile_redirect );
				update_option('_iv_membership_hide_admin_bar', $admin_bar );
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
			public function iv_update_protected_page_setting(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				update_option('_iv_membership_redirect_page','');
				update_option('_iv_membership_redirect_page',$form_data);
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
			public function iv_membership_update_post_setting(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				if(isset($form_data['client_post_type'])){
					$post_type=sanitize_text_field($form_data['client_post_type']);
					}else{
					$post_type='post';
				}
				update_option('_iv_membership_profile_post', $post_type );
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
			public function  iv_membership_update_page_setting(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				$iv_terms='no';
				if(isset($form_data['iv_terms'])){
					$iv_terms=sanitize_text_field($form_data['iv_terms']);
				}
				$pricing_page=sanitize_text_field($form_data['pricing_page']);
				$signup_page=sanitize_text_field($form_data['signup_page']);
				$profile_page=sanitize_text_field($form_data['profile_page']);
				$profile_public=sanitize_text_field($form_data['profile_public']);
				$thank_you=sanitize_text_field($form_data['thank_you_page']);
				$login=sanitize_text_field($form_data['login_page']);
				update_option('_iv_membership_price_table', $pricing_page);
				update_option('_iv_membership_registration', $signup_page);
				update_option('_iv_membership_profile_page', $profile_page);
				update_option('_iv_membership_profile_public',$profile_public);
				update_option('_iv_membership_thank_you_page',$thank_you);
				update_option('_iv_membership_login_page',$login);
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
			public function iv_membership_update_email_setting(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$allowed_html = wp_kses_allowed_html( 'post' );
				parse_str($_POST['form_data'], $form_data);
				$signup_form_id=$form_data['signup_form_id'];
				update_option( 'iv_membership_signup_email_subject',sanitize_text_field($form_data['iv_membership_signup_email_subject']));
				update_option( 'iv_membership_signup_email', wp_kses( $form_data['signup_email_template'], $allowed_html));
				update_option( 'iv_membership_forget_email_subject',sanitize_text_field($form_data['iv_membership_forget_email_subject']));
				update_option( 'iv_membership_forget_email',wp_kses($form_data['forget_email_template'], $allowed_html));
				update_option('admin_email_iv_membership', wp_kses($form_data['iv_membership_admin_email'], $allowed_html));
				update_option('iv_membership_order_client_email_sub', sanitize_text_field($form_data['iv_membership_order_email_subject']));
				update_option('iv_membership_order_client_email', wp_kses($form_data['order_client_email_template'], $allowed_html));
				update_option('iv_membership_order_admin_email_sub', sanitize_text_field($form_data['iv_membership_order_admin_email_subject']));
				update_option('iv_membership_order_admin_email', wp_kses($form_data['order_admin_email_template'], $allowed_html));
				update_option( 'iv_membership_reminder_email_subject',sanitize_text_field($form_data['iv_membership_reminder_email_subject']));
				update_option( 'iv_membership_reminder_email',wp_kses($form_data['reminder_email_template'], $allowed_html));
				update_option('iv_membership_reminder_day', sanitize_text_field($form_data['iv_membership_reminder_day']));
				update_option('iv_membership_cancellation_email_sub', sanitize_text_field($form_data['iv_membership_cancellation_email_sub']));
				update_option('iv_membership_cancellation_email', wp_kses($form_data['iv_membership_cancellation_email'], $allowed_html));
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
			public function iv_membership_update_mailchamp_setting (){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				parse_str($_POST['form_data'], $form_data);
				update_option('iv_membership_mailchimp_api_key', sanitize_text_field($form_data['iv_membership_mailchimp_api_key']));
				update_option('iv_membership_mailchimp_confirmation', sanitize_text_field($form_data['iv_membership_mailchimp_confirmation']));
				if(isset($form_data['iv_membership_mailchimp_list'])){
					update_option('iv_membership_mailchimp_list', $form_data['iv_membership_mailchimp_list']);
				}
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
			public function iv_membership_update_package_status (){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				global $wpdb;
				$package_id_update=trim($_POST['status_id']);
				$package_current_status=trim(sanitize_text_field($_POST['status_current']));			
				if($package_current_status=="pending"){
					$package_st='draft';
					$pac_msg='Active';
					}else{
					$package_st='pending';
					$pac_msg='Inactive';
				}
				$post_type = 'iv_membership_pack';
				$query = $wpdb->prepare("UPDATE {$wpdb->prefix}posts SET post_status='%s' WHERE ID='%s' LIMIT 1",$package_st,$package_id_update  );
				$wpdb->query($query);
				echo json_encode(array("code" => "success","msg"=>$pac_msg,"current_st"=>$package_st));
				exit(0);
			}
			public function iv_membership_email_admin_template_change() {
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$iv_membership_template = $_POST['iv_membership_template'];
				$settings = array('textarea_rows' => 20,);
				$content_admin = get_option('iv_membership_admin_email_'.$iv_membership_template );
				echo esc_html($content_admin);
				exit(0);
			}
			public function iv_membership_email_client_template_change() {
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$iv_membership_template = sanitize_textarea_field($_POST['iv_membership_template']);
				$settings = array('textarea_rows' => 20,);
				$content_admin = get_option('iv_membership_client_email_'.$iv_membership_template );
				echo esc_html($content_admin);
				exit(0);
			}
			public function iv_membership_gateway_settings_update(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$payment_gateway = $_POST['payment_gateway'];
				global $wpdb;
				update_option('iv_membership_payment_gateway', $payment_gateway);
				// For Stripe Plan Create*****
				$iv_gateway = get_option('iv_membership_payment_gateway');
				if($iv_gateway=='stripe'){
					$stripe_id='';
					$post_name2='iv_membership_stripe_setting';
					$row2 = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_name = '%s' ", $post_name2));
					if(isset($row2->ID )){
						$stripe_id= $row2->ID;
					}
					$iv_membership_pack='iv_membership_pack';
					$sql=$wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_type = '%s'" ,$iv_membership_pack);
					$membership_pack = $wpdb->get_results($sql);
					if(sizeof($membership_pack)>0){
						$i=0;
						require_once(WP_iv_membership_DIR . '/admin/files/init.php');
						$stripe_mode=get_post_meta( $stripe_id,'iv_membership_stripe_mode',true);
						if($stripe_mode=='test'){
							$stripe_api =get_post_meta($stripe_id, 'iv_membership_stripe_secret_test',true);
							}else{
							$stripe_api =get_post_meta($stripe_id, 'iv_membership_stripe_live_secret_key',true);
						}
						$stripe_currency =get_post_meta($stripe_id, 'iv_membership_stripe_api_currency',true);
						\Stripe\Stripe::setApiKey($stripe_api);
						foreach ( $membership_pack as $row )
						{		$package_recurring=get_post_meta( $row->ID,'iv_membership_package_recurring',true);
							if($package_recurring=='on'){
								$interval_count= get_post_meta( $row->ID,'iv_membership_package_recurring_cycle_count',true);
								$interval_count= ($interval_count=="" ? '1':$interval_count);
								$stripe_array=array();
								$p_name = $row->post_name;
								$stripe_array['id']= $p_name;
								$stripe_array['amount']=get_post_meta( $row->ID,'iv_membership_package_recurring_cost_initial',true) * 100;
								$stripe_array['interval']=get_post_meta( $row->ID,'iv_membership_package_recurring_cycle_type',true);
								$stripe_array['interval_count']=$interval_count;
								$stripe_array['currency']=$stripe_currency;
								$stripe_array['product']=array('name' => $p_name);
								$trial=get_post_meta($row->ID, 'iv_membership_package_enable_trial_period', true);
								if($trial=='yes'){
									$trial_type = get_post_meta( $row->ID,'iv_membership_package_recurring_trial_type',true);
									$trial_cycle_count =get_post_meta($row->ID, 'iv_membership_package_trial_period_interval', true);
									switch ($trial_type) {
										case 'year':
										$periodNum =  365 * 1;
										break;
										case 'month':
										$periodNum =  30 * $trial_cycle_count;
										break;
										case 'week':
										$periodNum = 7 * $trial_cycle_count;
										break;
										case 'day':
										$periodNum = 1 * $trial_cycle_count;
										break;
									}
									$stripe_array['trial_period_days']=$periodNum;
								}
								try {
									\Stripe\Plan::retrieve($p_name);
									} catch (Exception $e) {
									if($stripe_array['amount']>0){
										\Stripe\Plan::create($stripe_array);
									}
								}
							}
						}
					}
				}
				// End Stripe Plan Create*****
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully: Your current gateway is ', 'wpmembership' ).$payment_gateway));
				exit(0);
			}
			public function iv_membership_update_user_settings(){
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				global $wpdb;
				parse_str($_POST['form_data'], $form_data);
				$user_id=sanitize_text_field($form_data['user_id']);
				if($form_data['exp_date']!=''){
					$exp_d=date('Y-m-d', strtotime($form_data['exp_date']));
					update_user_meta($user_id, 'iv_membership_exprie_date',$exp_d);
				}
				update_user_meta($user_id, 'iv_membership_payment_status', sanitize_text_field($form_data['payment_status']));
				$package_title= str_replace('_', ' ', $form_data['user_role']);
				$row2 = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_title = '%s' ", $package_title));
				$package_id='';
				if(isset($row2->ID )){
					$package_id= $row2->ID;
				}
				$package_id=sanitize_text_field($form_data['package_sel2']);				
				update_user_meta($user_id, 'iv_membership_package_id',$package_id);
				$user = new WP_User( $user_id );
				if($form_data['user_role']!='administrator'){
					$user->set_role($form_data['user_role']);
				}
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
			public function iv_membership_settings_save() {
				if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'admin' ) ) {
					wp_die( 'Are you cheating:wpnonce?' );
				}
				if ( ! current_user_can( 'manage_options' ) ) {
					wp_die( 'Are you cheating:user Permission?' );
				}
				$sucess_message = $_POST['sucess_message'];
				$auto_reply = $_POST['auto_reply'];
				$fail_message = $_POST['fail_message'];
				$iv_membership_admin_email_subject = $_POST['iv_membership_admin_email_subject'];
				$iv_membership_auto_email_subject = $_POST['iv_membership_auto_email_subject'];
				update_option('iv_membership_success_message', $sucess_message);
				update_option('iv_membership_auto_reply', $auto_reply);
				update_option('iv_membership_fail_message', $fail_message);
				echo json_encode(array("code" => "success","msg"=>esc_html__( 'Updated Successfully ', 'wpmembership' )));
				exit(0);
			}
		}
	}
$WP_iv_membership_admin = new WP_iv_membership_Admin();