"use strict";
var ajaxurl = epsignup_data.ajaxurl;
var loader_image = epsignup_data.loading_image;
var select = jQuery(".card-expiry-year"),
	year = new Date().getFullYear();
	for (var i = 0; i < 12; i++) {
		select.append(jQuery("<option value='"+(i + year)+"' "+(i === 0 ? "selected" : "")+">"+(i + year)+"</option>"))
}
(function($) {
	var active_payment_gateway=epsignup_data.iv_gateway;
	jQuery(document).ready(function($) {
		jQuery.validate({
			form : '#iv_membership_registration',
			modules : 'security',
			onSuccess : function() {
				jQuery("#loading-3").show();
				jQuery("#loading").html(loader_image);
				if(active_payment_gateway=='stripe'){
					Stripe.createToken({
						number: jQuery('#card_number').val(),
						cvc: jQuery('#card_cvc').val(),
						exp_month: jQuery('#card_month').val(),
						exp_year: jQuery('#card_year').val(),
					}, stripeResponseHandler);
					return false;
					}else{ // Else for paypal
					return true; // false Will stop the submission of the form
				}
			},
		})
	})
	// this identifies your website in the createToken call below
		if(epsignup_data.iv_gateway=='stripe'){
			Stripe.setPublishableKey(epsignup_data.stripe_publishable);
		}
		function stripeResponseHandler(status, response) {
			if (response.error) {
				jQuery("#payment-errors").html('<div class="alert alert-info alert-dismissable"><a class="panel-close close" data-dismiss="alert">x</a>'+response.error.message +'.</div> ');
				jQuery("#loading-3").hide();
				} else {
				var form$ = jQuery("#iv_membership_registration");
				// token contains id, last4, and card type
				var token = response['id'];
				// insert the token into the form so it gets submitted to the server
				form$.append("<input type='hidden' name='stripeToken' value='" + token + "' />");
				// and submit
				form$.get(0).submit();
			}
		}

})(jQuery);
jQuery(document).ready(function() {
	jQuery('#coupon_name').on('keyup change', function() {	
		var search_params={
			"action"  				: "iv_membership_check_coupon",
			"coupon_code" 		:	jQuery("#coupon_name").val(),
			"package_id" 			:	jQuery("#package_id").val(),
			"package_amount" 	:	epsignup_data.package_amount,
			"api_currency" 		:	epsignup_data.api_currency,
			"form_data"				:	jQuery("#iv_membership_registration").serialize(),
			"_wpnonce"				: epsignup_data.signup,
			
		};
		jQuery('#coupon-result').html(epsignup_data.loader_image2);
		jQuery.ajax({
			url : ajaxurl,
			dataType : "json",
			type : "post",
			data : search_params,
			success : function(response){
				if(response.code=='success'){
					jQuery('#coupon-result').html(epsignup_data.right_icon);
					}else{
					jQuery('#coupon-result').html(epsignup_data.wrong_16x16);
				}
				jQuery('#total').html('<label class="control-label">'+response.gtotal +'</label>');
				jQuery('#discount').html('<label class="control-label">'+response.dis_amount +'</label>');
			}
		});
	});
});

jQuery('#country_select').on('change', function (e) {
	var optionSelected = jQuery("option:selected", this);
	var pack_id = jQuery("#package_id").val();
	var search_params={
		"action"  				: "iv_membership_check_package_amount",
		"coupon_code" 		:	jQuery("#coupon_name").val(),
		"package_id" 			: pack_id,
		"package_amount" 	:	epsignup_data.package_amount,
		"api_currency" 		:	epsignup_data.api_currency,
		"form_data"				:	jQuery("#iv_membership_registration").serialize(),
		"_wpnonce"				: epsignup_data.signup,
	};
	jQuery.ajax({
		url : ajaxurl,
		dataType : "json",
		type : "post",
		data : search_params,
		success : function(response){
			if(response.code=='success'){
				jQuery('#coupon-result').html(epsignup_data.right_icon);
				}else{
				jQuery('#coupon-result').html(epsignup_data.wrong_16x16);
			}
			jQuery('#p_amount').html('<label class="control-label">'+response.p_amount+'</label>');
			jQuery('#total').html('<label class="control-label">'+response.gtotal+'</label>');
			jQuery('#tax').html('<label class="control-label">'+response.tax_total+'</label>');
			jQuery('#discount').html('<label class="control-label">'+response.dis_amount+'</label>');
		}
	});
});
jQuery(function(){
	jQuery('#package_sel').on('change', function (e) {
		var optionSelected = jQuery("option:selected", this);
		var pack_id = this.value;
		jQuery("#package_id").val(pack_id);
	
		var search_params={
			"action"  				: "iv_membership_check_package_amount",
			"coupon_code" 		:	jQuery("#coupon_name").val(),
			"package_id" 			: pack_id,
			"package_amount" 	:	epsignup_data.package_amount ,
			"api_currency" 		:	epsignup_data.api_currency,
			"form_data"				:	jQuery("#iv_membership_registration").serialize(),
			"_wpnonce"				: epsignup_data.signup,
		};
		jQuery.ajax({
			url : ajaxurl,
			dataType : "json",
			type : "post",
			data : search_params,
			success : function(response){
				if(response.code=='success'){
					jQuery('#coupon-result').html(epsignup_data.wrong_16x16);
					}else{
					jQuery('#coupon-result').html(epsignup_data.right_icon);
				}
				jQuery('#p_amount').html('<label class="control-label">'+response.p_amount+'</label>');
				jQuery('#total').html('<label class="control-label">'+response.gtotal+'</label>');
				jQuery('#tax').html('<label class="control-label">'+response.tax_total+'</label>');
				jQuery('#discount').html('<label class="control-label">'+response.dis_amount+'</label>');
			}
		});
	});
});
function show_coupon(){
	jQuery("#coupon-div").show();
	jQuery("#show_hide_div").html('<label for="text" class="col-md-4 col-xs-4 col-sm-4 control-label"></label><div class="col-md-8 col-xs-8 col-sm-8 " ><button type="button" onclick="hide_coupon();"  class="btn btn-default center">Hide Coupon</button></div>');
}
function hide_coupon(){
	jQuery("#coupon-div").hide();
	jQuery("#show_hide_div").html('<label for="text" class="col-md-4 col-xs-4 col-sm-4 control-label"></label><div class="col-md-8 col-xs-8 col-sm-8 " ><button type="button" onclick="show_coupon();"  class="btn btn-default center">Have a coupon?</button></div>');
}