<?php
	if(isset($_REQUEST['delete_id']))  {
		$post_id=sanitize_text_field($_REQUEST['delete_id']);
		wp_delete_post($post_id);
		delete_post_meta($post_id,true);
		$message= esc_html__( 'Form Deleted Successfully','wpmembership');
	}
?>
<div class="bootstrap-wrapper">
	<div class="welcome-panel container-fluid">
		<?php
			if(!isset($_REQUEST['id']))  {
			?>
			<div class="row ">
				<div class="col-md-12" id="submit-button-holder">
					<div class="pull-right ">
						<a class="btn btn-info "  href="<?php echo WP_iv_membership_ADMINPATH; ?>admin.php?page=wp-iv_membership-coupon-create"><?php esc_html_e('Create A New Coupon','wpmembership');?> </a>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12 table-responsive">
					<h3  class="page-header"><?php esc_html_e('Coupon List','wpmembership');?>
						<small >
							<?php
								if (isset($_REQUEST['form_submit']) AND $_REQUEST['form_submit'] <> "") {
									echo  '<span class="spclr"> [ The Coupon Create Successfully ]</span>';
								}
								if (isset($message) AND $message <> "") {
									echo  '<span class="spclr"> [ '.esc_html($message).' ]</span>';
								}
							?>
						</small>
					</h3>
					<table class="table table-striped col-md-12">
						<thead >
							<tr>
								<th><?php esc_html_e('Coupon Code/ Name','wpmembership');?>  </th>
								<th><?php esc_html_e('Start Date','wpmembership');?></th>
								<th><?php esc_html_e('End Date','wpmembership');?></th>
								<th><?php esc_html_e('Uses Limit','wpmembership');?></th>
								<th><?php esc_html_e('Amount','wpmembership');?> </th>
								<th ><?php esc_html_e('Action','wpmembership');?></th>
							</tr>
						</thead>
						<tbody>
							<?php
								$args = array(
								'post_type' => 'iv_membership_coupon',
								'posts_per_page'=> '999',
								'orderby' => 'date',
								'order' => 'ASC',
								);
								$ep_query = new WP_Query( $args );
								if ( $ep_query->have_posts() ) :
								while ( $ep_query->have_posts() ) : $ep_query->the_post();
								$epid = get_the_ID();
								echo'<tr>';
								echo '<td>'. get_the_title().'</td>';
								echo '<td>'. esc_html(get_post_meta($epid, 'iv_membership_coupon_start_date', true)).'</td>';
								echo '<td>'. esc_html(get_post_meta($epid, 'iv_membership_coupon_end_date', true)).'</td>';
								echo '<td>'. esc_html(get_post_meta($epid, 'iv_membership_coupon_limit', true)).' / '.esc_html(get_post_meta($epid, 'iv_membership_coupon_used', true)).' </td>';
								echo '<td>'. esc_html(get_post_meta($epid, 'iv_membership_coupon_amount', true)).'</td>';
								echo '<td>  <a class="btn btn-primary btn-xs" href="?page=wp-iv_membership-coupon-update&id='.$epid.'"> '. esc_html__( 'Edit','wpmembership').'</a> ';
								echo '  <a href="?page=wp-iv_membership-coupons-form&delete_id='.esc_html($epid).'" class="btn btn-danger btn-xs" onclick="return confirm(\'Are you sure to delete this form?\');">'. esc_html__( 'Delete','wpmembership').'</a></td>';
								echo'</tr>';
								endwhile;
								endif;
							?>
						</tbody>
					</table>
					<div class=" col-md-12  bs-callout bs-callout-info">
						<?php esc_html_e('Note : Coupon will work on "One Time Payment" only. Coupon will not work on recurring payment ans 100% discount.','wpmembership');?>
					</div>
					.
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">
					<div class="">
						<a class="btn btn-info "  href="<?php echo WP_iv_membership_ADMINPATH; ?>admin.php?page=wp-iv_membership-coupon-create">
						<?php esc_html_e('Create A New Coupon','wpmembership');?> </a>
					</div>
				</div>
			</div>
			<div class="row">
				<br/>
			</div>
			<?php
			} 
		?>
	</div>
</div>