<?php
	global $wpdb;
	$package_id='';
	if(isset($_REQUEST['id'])){
		$package_id=sanitize_text_field($_REQUEST['id']);
	}
?>
<div class="bootstrap-wrapper">
	<div class="welcome-panel container-fluid">
		<div class="row">
			<div class="col-xs-12" id="submit-button-holder">
				<div class="pull-right"><button class="btn btn-info btn-lg" onclick="return update_the_package();">
					<?php esc_html_e('Update Package', 'wpmembership'); ?>
				</button></div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12"><h3 class="page-header"><?php esc_html_e('Update Package / Membership Level', 'wpmembership'); ?><br /><small> &nbsp;</small> </h3>
			</div>
		</div>
		<form id="package_form_iv" name="package_form_iv" class="form-horizontal" role="form" onsubmit="return false;">
			<input type="hidden"  name="package_id" value="<?php echo esc_html($package_id); ?>">
			<div class="form-group">
				<label for="text" class="col-md-2 control-label"><?php esc_html_e('Package Name', 'wpmembership'); ?></label>
				<div class="col-md-6">
					<input type="text" class="form-control" name="package_name" id="package_name" value="<?php echo get_the_title($package_id); ?>"placeholder="<?php esc_html_e('Enter Package Name', 'wpmembership'); ?>">
				</div>
			</div>
			<div class="form-group">
				<label for="text" class="col-md-2 control-label"><?php esc_html_e('Package Feature List', 'wpmembership'); ?></label>
				<div class="col-md-6">
					<textarea class="form-control" name="package_feature" id="package_feature" placeholder="<?php esc_html_e('Enter Feature List','wpmembership'); ?> " rows="5"><?php echo get_post_field('post_content', $package_id);  ?></textarea>
					<?php esc_html_e('It will display on price list table', 'wpmembership'); ?>
				</div>
			</div>
			<h3 class="page-header">
				<?php esc_html_e('Billing Details', 'wpmembership'); ?>
			</h3>
			<div class="form-group">
				<label for="inputEmail3" class="col-md-2 control-label"><?php esc_html_e('Initial Payment', 'wpmembership'); ?></label>
				<div class="col-md-6">
					<input type="text" class="form-control" id="package_cost" name="package_cost" value="<?php echo get_post_meta($package_id, 'iv_membership_package_cost', true); ?>"  placeholder="<?php esc_html_e('Enter Initial Payment', 'wpmembership'); ?>">
					<?php esc_html_e('The Initial Amount Collected at User Registration.', 'wpmembership'); ?>
				</div>
			</div>
			<div class="form-group">
				<label for="text" class="col-md-2 control-label"><?php esc_html_e('Package Expire After', 'wpmembership'); ?></label>
				<div class="col-md-2">
					<select id="package_initial_expire_interval" name="package_initial_expire_interval" class="ctrl-combobox form-control">
						<?php
							$package_initial_period_interval= get_post_meta($package_id, 'iv_membership_package_initial_expire_interval', true);
							echo '<option value="">None</option>';
							for($ii=1;$ii<31;$ii++){
								echo '<option value="'.$ii.'" '.($package_initial_period_interval == $ii ? 'selected' : '').'>'.$ii.'</option>';
							}
						?>
					</select>
				</div>
				<div class="col-md-4">
					<?php
						$package_initial_expire_type= get_post_meta($package_id, 'iv_membership_package_initial_expire_type', true);
					?>
					<select name="package_initial_expire_type" id ="package_initial_expire_type" class=" form-control">
						<option value="">
							<?php esc_html_e('None', 'wpmembership'); ?>
						</option>
						<option value="day" <?php echo ($package_initial_expire_type == 'day' ? 'selected' : '') ?>><?php esc_html_e('Day(s)', 'wpmembership'); ?></option>
						<option value="week" <?php echo ($package_initial_expire_type == 'week' ? 'selected' : '') ?>><?php esc_html_e('Week(s)', 'wpmembership'); ?></option>
						<option value="month" <?php echo ($package_initial_expire_type == 'month' ? 'selected' : '') ?>><?php esc_html_e('Month(s)', 'wpmembership'); ?></option>
						<option value="year" <?php echo ($package_initial_expire_type == 'year' ? 'selected' : '') ?>><?php esc_html_e('Year(s)', 'wpmembership'); ?></option>
					</select>
				</div>
				<div class='col-md-12'><label for="text" class="col-md-2 control-label"></label>
					<?php esc_html_e('If select none then user\'s package will expire after 19 years. Package Expire Option will not work on Recurring Subscription. "Billing Cycle Limit" will Work For Recurring Subscription.', 'wpmembership'); ?>
				</div>
			</div>
			<div class="form-group">
				<label for="text" class="col-md-2 control-label"><?php esc_html_e('Recurring Subscription', 'wpmembership'); ?></label>
				<div class="col-md-6 ">
					<label>
						<input type="checkbox"  <?php echo (get_post_meta($package_id, 'iv_membership_package_recurring', true)=='on'?'checked': ''); ?> name="package_recurring" id="package_recurring" value="on" > <?php esc_html_e('Enable Recurring Payment', 'wpmembership'); ?>
					</label>
				</div>
			</div>
			<div id="recurring_block" style="display:<?php echo (get_post_meta($package_id, 'iv_membership_package_recurring', true)=='on'?'': 'none'); ?>" >
				<div class="form-group">
					<label for="text" class="col-md-2 control-label"><?php esc_html_e('Billing Amount', 'wpmembership'); ?></label>
					<div class="col-md-2">
						<input type="text" class="form-control" value="<?php echo get_post_meta($package_id, 'iv_membership_package_recurring_cost_initial', true); ?>" name ="package_recurring_cost_initial" id="package_recurring_cost_initial" placeholder="<?php esc_html_e('Amount', 'wpmembership'); ?>">
					</div>
					<label for="text" class="col-md-1 control-label"><?php esc_html_e('Per', 'wpmembership'); ?></label>
					<div class="col-md-1">
						<input type="text" class="form-control" value="<?php echo get_post_meta($package_id, 'iv_membership_package_recurring_cycle_count', true); ?>" id="package_recurring_cycle_count" name="package_recurring_cycle_count" placeholder="<?php esc_html_e('Cycle #', 'wpmembership'); ?>">
					</div>
					<div class="col-md-2">
						<?php $package_recurring_cycle_type= get_post_meta($package_id, 'iv_membership_package_recurring_cycle_type', true); ?>
						<select name="package_recurring_cycle_type" id ="package_recurring_cycle_type" class="form-control">
							<option value="day" <?php echo ($package_recurring_cycle_type == 'day' ? 'selected' : '') ?>>
								<?php esc_html_e('Day(s)', 'wpmembership'); ?>
							</option>
							<option value="week" <?php echo ($package_recurring_cycle_type == 'week' ? 'selected' : '') ?>>
								<?php esc_html_e('Week(s)', 'wpmembership'); ?>
							</option>
							<option value="month" <?php echo ($package_recurring_cycle_type == 'month' ? 'selected' : '') ?>><?php esc_html_e('Month(s)', 'wpmembership'); ?></option>
							<option value="year" <?php echo ($package_recurring_cycle_type == 'year' ? 'selected' : '') ?>><?php esc_html_e('Year(s)', 'wpmembership'); ?></option>
						</select>
					</div>
					<div class='col-md-12'><label for="text" class="col-md-2 control-label"></label>
						<?php esc_html_e('The "Billing Amount" will Collect at User Registration.', 'wpmembership'); ?>
					</div>
				</div>
				<?php
					if(get_option('iv_membership_payment_gateway')!='woocommerce'){
					?>
					<div class="form-group">
						<label for="text" class="col-md-2 control-label"><?php esc_html_e('Billing Cycle Limit', 'wpmembership'); ?></label>
						<div class="col-md-2">
							<select name="package_recurring_cycle_limit" id ="package_recurring_cycle_limit" class="ctrl-combobox form-control">
								<option value=""><?php esc_html_e('Never', 'wpmembership'); ?></option>
								<?php
									$package_recurring_cycle_limit= get_post_meta($package_id, 'iv_membership_package_recurring_cycle_limit', true);
									for($ii=1;$ii<35;$ii++){
										echo '<option value="'.esc_html($ii).'" '.($package_recurring_cycle_limit == $ii ? 'selected' : '').'>'.esc_html($ii).'</option>';
									}
								?>
							</select>
						</div>
					</div>
					<div class="form-group">
						<label for="text" class="col-md-2 control-label"> <?php esc_html_e('Trial', 'wpmembership'); ?></label>
						<div class="col-md-6 ">
							<label>
								<input type="checkbox" <?php echo (get_post_meta($package_id, 'iv_membership_package_enable_trial_period', true)=='yes'? 'checked': ''); ?> name="package_enable_trial_period" id="package_enable_trial_period" value='yes'> <?php esc_html_e('Enable Trial Period', 'wpmembership'); ?>
							</label>
							<br/>
							<?php esc_html_e('"Billing Amount" will Collect After Trial Period.', 'wpmembership'); ?>
						</div>
					</div>
					<div id="trial_block" style="display:<?php echo (get_post_meta($package_id, 'iv_membership_package_enable_trial_period', true)=='yes'? '': 'none'); ?>" >
						<div class="form-group">
							<label for="inputEmail3" class="col-md-2 control-label"><?php esc_html_e('Trial Amount', 'wpmembership'); ?></label>
							<div class="col-md-6">
								<input type="text" class="form-control" value="<?php echo get_post_meta($package_id, 'iv_membership_package_trial_amount', true); ?>" id="package_trial_amount" name="package_trial_amount" placeholder="<?php esc_html_e('Enter Amount to Bill for The Trial Period', 'wpmembership'); ?>">
								<?php esc_html_e('Amount to Bill for The Trial Period. Free is 0.[Stripe will not support this option ]', 'wpmembership'); ?>
							</div>
						</div>
						<div class="form-group">
							<label for="text" class="col-md-2 control-label"><?php esc_html_e('Trial Period', 'wpmembership'); ?></label>
							<div class="col-md-2">
								<select id="package_trial_period_interval" name="package_trial_period_interval" class="ctrl-combobox form-control">
									<?php
										$package_trial_period_interval= get_post_meta($package_id, 'iv_membership_package_trial_period_interval', true);
										for($ii=1;$ii<31;$ii++){
											echo '<option value="'.$ii.'" '.($package_trial_period_interval == $ii ? 'selected' : '').'>'.$ii.'</option>';
										}
									?>
								</select>
							</div>
							<div class="col-md-4">
								<?php
									$package_recurring_trial_type= get_post_meta($package_id, 'iv_membership_package_recurring_trial_type', true);
								?>
								<select name="package_recurring_trial_type" id ="package_recurring_trial_type" class=" form-control">
									<option value="day" <?php echo ($package_recurring_trial_type == 'day' ? 'selected' : '') ?>><?php esc_html_e('Day(s)', 'wpmembership'); ?></option>
									<option value="week" <?php echo ($package_recurring_trial_type == 'week' ? 'selected' : '') ?>><?php esc_html_e('Week(s)', 'wpmembership'); ?></option>
									<option value="month" <?php echo ($package_recurring_trial_type == 'month' ? 'selected' : '') ?>><?php esc_html_e('Month(s)', 'wpmembership'); ?></option>
									<option value="year" <?php echo ($package_recurring_trial_type == 'year' ? 'selected' : '') ?>><?php esc_html_e('Year(s)', 'wpmembership'); ?></option>
								</select>
							</div>
							<div class='col-md-12'><label for="text" class="col-md-2 control-label"></label>
								<?php esc_html_e('After The Trial Period "Billing Amount"	Will Be Billed.', 'wpmembership'); ?>
							</div>
						</div>
					</div> <!-- Trial Block -->
					<?php
					}
				?>
			</div> <!-- Recurring Block -->
			<?php
				if(get_option('iv_membership_payment_gateway')=='woocommerce'){
					if ( class_exists( 'WooCommerce' ) ) {
						$woo_pro= get_post_meta($package_id, 'iv_membership_package_woocommerce_product', true);
					?>
					<div class="form-group">
						<label for="text" class="col-md-2 control-label"><?php esc_html_e('Woocommerce Product','epphotographer'); ?></label>
						<div class="col-md-3">
							<select  class="form-control" id="Woocommerce_product" name="Woocommerce_product">
								<?php
									$args = array(
									'post_type' => 'product',
									'posts_per_page'=> '999',
									'post_status' => 'publish',
									);
									$ep_query = new WP_Query( $args );
									if ( $ep_query->have_posts() ) :
									while ( $ep_query->have_posts() ) : $ep_query->the_post();
									$epid = get_the_ID();
									if($woo_pro==$epid){$selected=' selected';}
									echo '<option value="'.$epid.'"'.$selected.' >'.get_the_title($epid).' </option>';
									endwhile;
									endif;
								?>
							</select>
						</div>
					</div>
					<?php
					}
				}
			?>
			<h3 class="page-header">
				<?php esc_html_e('User Access Control', 'wpmembership'); ?>
			</h3>
			<div class="form-group">
				<label for="text" class="col-md-2  control-label"><?php esc_html_e('Maximum Post', 'wpmembership'); ?> </label>
				<div class="col-md-6">
					<input type="text" class="form-control" name="max_pst_no" id="max_pst_no" value="<?php echo get_post_meta($package_id, 'iv_membership_package_max_post_no', true); ?>" placeholder="<?php esc_html_e('Enter Max Number ', 'wpmembership'); ?>">
					<?php esc_html_e('Maximum # of post by this package. Blank is unlimited.', 'wpmembership'); ?>
				</div>
			</div>
			<div class="form-group">
				<label for="text" class="col-md-2  control-label"><?php esc_html_e('Categories', 'wpmembership'); ?>	 </label>
				<div class="col-md-6">
					<table class="form-table">
						<tbody>
							<tr>
								<td>
									<?php
										$user_cat=  array();
										$cat_meta=	get_post_meta($package_id, 'iv_membership_package_category_ids', true);
										if(trim($cat_meta)!=''){
											$user_cat= explode("|",get_post_meta($package_id, 'iv_membership_package_category_ids', true));
										}
										$categories = get_categories( array( 'hide_empty' => 0 ) );
										$checked =in_array( 'all', $user_cat) ? "checked='checked'" : '';
										echo "<ul>";
										echo "<li><input name='membershipcategory[]' type='checkbox' value='all' ".$checked." /> All</li>\n";
										foreach ( $categories as $cat )
										{
											$checked =in_array( $cat->term_id, $user_cat) ? "checked='checked'" : '';
											echo "<li><input name='membershipcategory[]' id='membershipcategory[]' type='checkbox' value='{$cat->term_id}' $checked /> {$cat->name}</li>\n";
										}
										echo "</ul>";
									?>
								</td>
							</tr>
							<tr><td>
								<?php esc_html_e(' Can Write on the Categories Only.', 'wpmembership'); ?>
							</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</form>
		<div class="row">
			<div class="col-xs-12">
				<div align="center">
					<div id="loading"></div>
				<button class="btn btn-info btn-lg" onclick="return update_the_package();"> <?php esc_html_e('Update Package', 'wpmembership'); ?></button></div>
				<p>&nbsp;</p>
			</div>
		</div>
	</div>
</div>
