<?php
	global $wpdb;
?>
<div class="bootstrap-wrapper">
	<div class="container-fluid">
		<br/>
		<div id="update_message"> </div>
		<div class="panel with-nav-tabs panel-info">
			<div class="panel-heading">
				<ul class="nav nav-tabs">
					<li class="active"><a href="#page" data-toggle="tab"><?php esc_html_e('Page Setting ','wpmembership'); ?></a></li>
					<li ><a href="#protected_page" data-toggle="tab"><?php esc_html_e('Blocked URL ','wpmembership'); ?></a></li>
					<li><a href="#payment" data-toggle="tab"><?php esc_html_e('Payment Page ','wpmembership'); ?></a></li>
					<li><a href="#email" data-toggle="tab"><?php esc_html_e('Email Setting','wpmembership'); ?></a></li>
					
					<li><a href="#mailchimp" data-toggle="tab"><?php esc_html_e('MailChimp Setting','wpmembership'); ?></a></li>
					<li ><a href="#user_reg" data-toggle="tab"><?php esc_html_e('Page Redirect','wpmembership'); ?></a></li>
					<li ><a href="#user_post" data-toggle="tab"><?php esc_html_e('Post Setting','wpmembership'); ?></a></li>
					<li ><a href="#tax" data-toggle="tab"><?php esc_html_e('Tax','wpmembership'); ?></a></li>
				</ul>
			</div>
			<div class="panel-body">
				<div class="tab-content">				
					<div class="tab-pane fade " id="protected_page">
						<?php
							require (WP_iv_membership_DIR .'/admin/pages/protected_page.php');
						?>
					</div>
					<div class="tab-pane fade " id="user_post">
						<form class="form-horizontal" role="form"  name='post_settings' id='post_settings'>
							<?php
								$args = array(
								'public'   => true,
								'_builtin' => false
								);
								$output = 'names'; 
								$operator = 'and'; 
								$post_types = get_post_types( $args, $output, $operator );
							?>
							<div class="form-group">
								<h3  class="col-md-12   page-header"><?php esc_html_e('My Account And Public Profile Post Type','wpmembership'); ?> </h3>
							</div>
							<div class="form-group">
								<label  class="col-md-3   control-label"><?php esc_html_e('Post type:','wpmembership'); ?> </label>
								<div class="checkbox col-md-3 ">
									<?php
										$iv_post = get_option( '_iv_membership_profile_post');
										echo "<select id='client_post_type' name='client_post_type' class='form-control'>";
										echo "<option value='post' ".($iv_post=='post'? 'selected':'').">Post</option>";
										foreach ( $post_types  as $post_type ) {
											if($post_type!='iv_payment'){
												echo "<option value='".esc_html($post_type)."' ".($iv_post==$post_type? 'selected':'').">".esc_html($post_type)."</option>";
											}
										}
										echo "</select>";
									?>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-3 control-label"> </label>
								<div class="col-md-8">
									<button type="button" onclick="return  iv_update_post_settings();" class="btn btn-success"><?php esc_html_e('Update','wpmembership'); ?></button>
								</div>
							</div>
						</form>
					</div>
					<div class="tab-pane fade " id="user_reg">
						<form class="form-horizontal" role="form"  name='account_settings' id='account_settings'>
							<br/>
							<?php
								$args = array(
								'child_of'     => 0,
								'sort_order'   => 'ASC',
								'sort_column'  => 'post_title',
								'hierarchical' => 1,
								'post_type' => 'page'
								);
							?>
							<div class="form-group">
								<label  class="col-md-3   control-label">
								<?php esc_html_e('User Registration Page Redirect:','wpmembership'); ?> </label>
								<div class="checkbox col-md-3 ">
									<?php
										$iv_redirect = get_option( 'iv_membership_signup_redirect');
										if ( $pages = get_pages( $args ) ){
											echo "<select id='signup_redirect' name='signup_redirect' class='form-control'>";
											echo "<option value='defult' ".($iv_redirect=='defult' ? 'selected':'').">Defult WP Action</option>";
											foreach ( $pages as $page ) {
												echo "<option value='".esc_html($page->ID)."' ".($iv_redirect==$page->ID ? 'selected':'').">".esc_html($page->post_title)."</option>";
											}
											echo "</select>";
										}
									?>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-3   control-label"><?php esc_html_e( 'User My Account Page Redirect', 'wpmembership' );?>: </label>
								<div class="checkbox col-md-3 ">
									<?php
										$iv_redirect = get_option( '_iv_membership_profile_page');
										if ( $pages = get_pages( $args ) ){
											echo "<select id='pri_profile_redirect' name='pri_profile_redirect' class='form-control'>";
											echo "<option value='defult' ".($iv_redirect=='defult' ? 'selected':'').">Defult WP Action</option>";
											foreach ( $pages as $page ) {
												echo "<option value='".esc_html($page->ID)."' ".($iv_redirect==$page->ID ? 'selected':'').">".esc_html($page->post_title)."</option>";
											}
											echo "</select>";
										}
									?>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-3   control-label"><?php esc_html_e( 'User Public Profile Page Redirect', 'wpmembership' );?>: </label>
								<div class="checkbox col-md-3 ">
									<?php
										$iv_redirect = get_option( '_iv_membership_profile_public_page');
										if ( $pages = get_pages( $args ) ){
											echo "<select id='profile_redirect' name='profile_redirect' class='form-control'>";
											echo "<option value='defult' ".($iv_redirect=='defult' ? 'selected':'').">Defult WP Action</option>";
											foreach ( $pages as $page ) {
												echo "<option value='".esc_html($page->ID)."' ".($iv_redirect==$page->ID ? 'selected':'').">".esc_html($page->post_title)."</option>";
											}
											echo "</select>";
										}
									?>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-3   control-label"><?php esc_html_e('Hide Admin Bar for All Users Except for Administrators:','wpmembership'); ?> </label>
								<div class=" col-md-3 ">
									<?php
										$hide_admin_bar='';
										if( get_option( '_iv_membership_hide_admin_bar' ) ) {
											$hide_admin_bar= get_option('_iv_membership_hide_admin_bar');
										}
										?><label>
										<input  class="" type="checkbox" name="hide_admin_bar" id="hide_admin_bar" value="yes" <?php echo ($hide_admin_bar=='yes'? 'checked':'' ); ?> >
										<?php esc_html_e('Hide','wpmembership'); ?>
									</label>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-3 control-label"> </label>
								<div class="col-md-8">
									<button type="button" onclick="return  iv_update_account_settings();" class="btn btn-success">
										<?php esc_html_e('Update','wpmembership'); ?>
									</button>
								</div>
							</div>
						</form>
					</div>
					<div class="tab-pane fade " id="payment">
						<!--Payment  -->
						<form class="form-horizontal" role="form"  name='payment_settings' id='payment_settings'>
							<div class="form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('Terms CheckBox :','wpmembership'); ?> </label>
								<div class="col-md-10 col-xs-10 col-sm-10">
									<div class="checkbox col-md-1 ">
										<label><?php
											$t_terms='';
											if( get_option( 'iv_membership_payment_terms' ) ) {
												$t_terms= get_option('iv_membership_payment_terms');
											}
										?>
										<input type="checkbox" name="iv_terms" id="iv_terms" value="yes" <?php echo ($t_terms=='yes'? 'checked':'' ); ?> > <?php esc_html_e('Dispaly','wpmembership'); ?>
										</label>
									</div>
									<div class=" col-md-6 col-xs-6 col-sm-6">
										<?php
											$t_text='I have read & accept the Terms & Conditions';
											if( get_option( 'iv_membership_payment_terms_text' ) ) {
												$t_text= get_option('iv_membership_payment_terms_text');
											}
										?>
										<textarea class="form-control" rows="3" name='terms_detail' id='terms_detail' >  <?php echo esc_html($t_text); ?></textarea>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label">
									<?php esc_html_e('Hide Coupon Buton :','wpmembership'); ?>
								</label>
								<div class="col-md-10 col-xs-10 col-sm-10">
									<div class="checkbox col-md-1 ">
										<label><?php
											$t_coupon='';
											if( get_option( '_iv_membership_payment_coupon' ) ) {
												$t_coupon= get_option('_iv_membership_payment_coupon');
											}
										?>
										<input type="checkbox" name="iv_coupon" id="iv_coupon" value="yes" <?php echo ($t_coupon=='yes'? 'checked':'' ); ?> > <?php esc_html_e('Hide','wpmembership'); ?>
										</label>
									</div>
								</div>
							</div>
							<div class="form-group  row">
								<label  class="col-md-3  control-label"> </label>
								<div class="col-md-4">
									<button type="button" onclick="return  iv_update_payment_settings();" class="btn btn-success"><?php esc_html_e('Update','wpmembership'); ?> </button>
								</div>
							</div>
						</form>
					</div>
					<div class="tab-pane fade in active" id="page">
						<form class="form-horizontal" role="form"  name='page_settings' id='page_settings'>
							<?php
								$price_table=get_option('_iv_membership_price_table');
								$registration=get_option('_iv_membership_registration');
								$profile_page=get_option('_iv_membership_profile_page');
								$profile_public=get_option('_iv_membership_profile_public_page');
								$login_page=get_option('_iv_membership_login_page');
								$thank_you=get_option('_iv_membership_thank_you_page');
								$args = array(
								'child_of'     => 0,
								'sort_order'   => 'ASC',
								'sort_column'  => 'post_title',
								'hierarchical' => 1,
								'post_type' => 'page'
								);
							?>
							<div class="form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('Price Listing:','wpmembership'); ?> </label>
								<div class="col-md-10 col-xs-10 col-sm-10">
									<div class="checkbox col-md-4 ">
										<?php
											if ( $pages = get_pages( $args ) ){
												echo "<select id='pricing_page' name='pricing_page' class='form-control'>";
												foreach ( $pages as $page ) {
													echo "<option value='".esc_html($page->ID)."' ".($price_table==$page->ID ? 'selected':'').">".esc_html($page->post_title)."</option>";
												}
												echo "</select>";
											}
										?>
									</div>
									<div class="checkbox col-md-1 ">
										<?php
											$reg_page= get_permalink( $price_table);
										?>
										<a class="btn btn-info " href="<?php  echo esc_url($reg_page); ?>"> <?php esc_html_e('View','wpmembership'); ?></a>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('User Sign Up:','wpmembership'); ?> </label>
								<div class="col-md-10 col-xs-10 col-sm-10">
									<div class="checkbox col-md-4 ">
										<?php
											if ( $pages = get_pages( $args ) ){
												echo "<select id='signup_page' name='signup_page' class='form-control'>";
												foreach ( $pages as $page ) {
													echo "<option value='".esc_html($page->ID)."' ".($registration==$page->ID ? 'selected':'').">".esc_html($page->post_title)."</option>";
												}
												echo "</select>";
											}
										?>
									</div>
									<div class="checkbox col-md-1 ">
										<?php
											$reg_page= get_permalink( $registration);
										?>
										<a class="btn btn-info " href="<?php  echo esc_url($reg_page); ?>"> <?php esc_html_e('View','wpmembership'); ?></a>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('Signup Thanks :','wpmembership'); ?> </label>
								<div class="col-md-10 col-xs-10 col-sm-10">
									<div class="checkbox col-md-4 ">
										<?php
											if ( $pages = get_pages( $args ) ){
												echo "<select id='thank_you_page'  name='thank_you_page'  class='form-control'>";
												foreach ( $pages as $page ) {
													echo "<option value='".esc_html($page->ID)."' ".($thank_you==$page->ID ? 'selected':'').">".esc_html($page->post_title)."</option>";
												}
												echo "</select>";
											}
										?>
									</div>
									<div class="checkbox col-md-1 ">
										<?php
											$reg_page= get_permalink( $thank_you);
										?>
										<a class="btn btn-info " href="<?php  echo esc_url($reg_page); ?>"> <?php esc_html_e('View','wpmembership'); ?> </a>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('Login Page:','wpmembership'); ?> </label>
								<div class="col-md-10 col-xs-10 col-sm-10">
									<div class="checkbox col-md-4 ">
										<?php
											if ( $pages = get_pages( $args ) ){
												echo "<select id='login_page'  name='login_page'  class='form-control'>";
												foreach ( $pages as $page ) {
													echo "<option value='".esc_html($page->ID)."' ".($login_page==$page->ID ? 'selected':'').">".esc_html($page->post_title)."</option>";
												}
												echo "</select>";
											}
										?>
									</div>
									<div class="checkbox col-md-1 ">
										<?php
											$reg_page= get_permalink( $login_page);
										?>
										<a class="btn btn-info " href="<?php  echo esc_url($reg_page); ?>"> <?php esc_html_e('View','wpmembership'); ?></a>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('User My Account :','wpmembership'); ?> </label>
								<div class="col-md-10 col-xs-10 col-sm-10">
									<div class="checkbox col-md-4 ">
										<?php
											if ( $pages = get_pages( $args ) ){
												echo "<select id='profile_page'  name='profile_page'  class='form-control'>";
												foreach ( $pages as $page ) {
													echo "<option value='".esc_html($page->ID)."' ".($profile_page==$page->ID ? 'selected':'').">".esc_html($page->post_title)."</option>";
												}
												echo "</select>";
											}
										?>
									</div>
									<div class="checkbox col-md-1 ">
										<?php
											$reg_page= get_permalink( $profile_page);
										?>
										<a class="btn btn-info " href="<?php  echo esc_url($reg_page); ?>"> <?php esc_html_e('View','wpmembership'); ?></a>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('User Public Profile:','wpmembership'); ?> </label>
								<div class="col-md-10 col-xs-10 col-sm-10">
									<div class="checkbox col-md-4 ">
										<?php
											if ( $pages = get_pages( $args ) ){
												echo "<select id='profile_public'  name='profile_public'  class='form-control'>";
												foreach ( $pages as $page ) {
													echo "<option value='".esc_html($page->ID)."' ".($profile_public==$page->ID ? 'selected':'').">".esc_html($page->post_title)."</option>";
												}
												echo "</select>";
											}
										?>
									</div>
									<div class="checkbox col-md-1 ">
										<?php
											$reg_page= get_permalink( $profile_public);
										?>
										<a class="btn btn-info " href="<?php  echo esc_url($reg_page); ?>"> <?php esc_html_e('View','wpmembership'); ?></a>
									</div>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> </label>
								<div class="col-md-10 col-xs-10 col-sm-10">
									<div class="checkbox col-md-4  ">
										<button type="button" onclick="return  iv_update_page_settings();" class="btn btn-success"><?php esc_html_e('Update','wpmembership'); ?></button>
									</div>
									<div class="checkbox col-md-1 ">
									</div>
								</div>
							</div>
						</form>
					</div>
					<div class="tab-pane fade" id="email">
						<div class="row pull-right">
							<div class="col-md-12 ">
							<button type="button" onclick="return  iv_update_email_settings();" class="btn btn-success"><?php esc_html_e('Update Email Setting','wpmembership'); ?></button>					</div>
						</div>
						<form class="form-horizontal" role="form"  name='email_settings' id='email_settings'>
							<div class="form-group">
								<label  class="col-md-2  control-label"> <?php esc_html_e('Email Sender :','wpmembership'); ?> </label>
								<div class="col-md-4 ">
									<?php
										$admin_email_setting='';
										if( get_option( 'admin_email_iv_membership' )==FALSE ) {
											$admin_email_setting = get_option('admin_email');
											}else{
											$admin_email_setting = get_option('admin_email_iv_membership');
										}
									?>
									<input type="text" class="form-control" id="iv_membership_admin_email" name="iv_membership_admin_email" value="<?php echo esc_html($admin_email_setting); ?>" placeholder="">
								</div>
							</div>
							<div class="form-group">
								<h3  class="col-md-12   page-header"><?php esc_html_e('Signup / Forget password Email','wpmembership'); ?> </h3>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('Email Subject :','wpmembership'); ?> </label>
								<div class="col-md-4 ">
									<?php
										$iv_membership_signup_email_subject = get_option( 'iv_membership_signup_email_subject');
									?>
									<input type="hidden" name="signup_form_id" value="<?php echo esc_html($form_id); ?>">
									<input type="text" class="form-control" id="iv_membership_signup_email_subject" name="iv_membership_signup_email_subject" value="<?php echo esc_html($iv_membership_signup_email_subject); ?>" placeholder="<?php esc_html_e('Enter signup email subject','wpmembership'); ?>">
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('Email Tempalte :','wpmembership'); ?> </label>
								<div class="col-md-10 ">
									<?php
										$settings_a = array(
										'textarea_rows' =>20,
										);
										$content_client = get_option( 'iv_membership_signup_email');
										$editor_id = 'signup_email_template';
									?>
									<textarea id="signup_email_template" name="signup_email_template" rows="20" class="col-md-12 "><?php echo esc_html($content_client); ?>
									</textarea>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('Forget Subject :','wpmembership'); ?> </label>
								<div class="col-md-4 ">
									<?php
										$iv_membership_forget_email_subject = get_option( 'iv_membership_forget_email_subject');
									?>
									<input type="hidden" name="forget_form_id" value="<?php echo esc_html($form_id); ?>">
									<input type="text" class="form-control" id="iv_membership_forget_email_subject" name="iv_membership_forget_email_subject" value="<?php echo esc_html($iv_membership_forget_email_subject); ?>" placeholder="<?php esc_html_e('Enter forget email subject','wpmembership'); ?>">
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('Forget Tempalte :','wpmembership'); ?>  </label>
								<div class="col-md-10 ">
									<?php
										$settings_forget = array(
										'textarea_rows' =>'20',
										'editor_class'  => 'form-control',
										);
										$content_client = get_option( 'iv_membership_forget_email');
										$editor_id = 'forget_email_template';
									?>
									<textarea id="forget_email_template" name="forget_email_template" rows="20" class="col-md-12 "><?php echo esc_html($content_client); ?>
									</textarea>
								</div>
							</div>
							<div class="form-group">
								<h3  class="col-md-12 col-xs-12 col-sm-12  page-header"><?php esc_html_e('Order Email','wpmembership'); ?> </h3>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('User Email Subject :','wpmembership'); ?> </label>
								<div class="col-md-4 ">
									<?php
										$iv_membership_order_email_subject = get_option( 'iv_membership_order_client_email_sub');
									?>
									<input type="text" class="form-control" id="iv_membership_order_email_subject" name="iv_membership_order_email_subject" value="<?php echo esc_html($iv_membership_order_email_subject); ?>" placeholder="<?php esc_html_e('Enter order email subject','wpmembership'); ?>">
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('User Email Tempalte :','wpmembership'); ?> </label>
								<div class="col-md-10 ">
									<?php
										$settings_a = array(
										'textarea_rows' =>20,
										);
										$content_client = get_option( 'iv_membership_order_client_email');
										$editor_id = 'order_client_email_template';
									?>
									<textarea id="order_client_email_template" name="order_client_email_template" rows="20" class="col-md-12 "><?php echo esc_html($content_client); ?></textarea>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('Admin Email Subject :','wpmembership'); ?> </label>
								<div class="col-md-4 ">
									<?php
										$iv_membership_order_admin_email_subject = get_option( 'iv_membership_order_admin_email_sub');
									?>
									<input type="text" class="form-control" id="iv_membership_order_admin_email_subject" name="iv_membership_order_admin_email_subject" value="<?php echo esc_html($iv_membership_order_admin_email_subject); ?>" placeholder="<?php esc_html_e('Enter order email subject','wpmembership'); ?>">
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('Admin Email Tempalte :','wpmembership'); ?> </label>
								<div class="col-md-10 ">
									<?php
										$settings_a = array(
										'textarea_rows' =>20,
										);
										$content_client = get_option( 'iv_membership_order_admin_email');
										$editor_id = 'order_admin_email_template';
									?>
									<textarea id="order_admin_email_template" name="order_admin_email_template" rows="20" class="col-md-12 "><?php echo esc_html($content_client); ?></textarea>
								</div>
							</div>
							<div class="form-group">
								<h3  class="col-md-12 col-xs-12 col-sm-12  page-header"><?php esc_html_e('Reminder Email','wpmembership'); ?> </h3>
							</div>
								<div class="form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('Reminder Email Subject : ','wpmembership'); ?></label>
								<div class="col-md-4 ">
									<?php
										$iv_membership_reminder_email_subject = get_option( 'iv_membership_reminder_email_subject');
									?> 
									<input type="text" class="form-control" id="iv_membership_reminder_email_subject" name="iv_membership_reminder_email_subject" value="<?php echo esc_html($iv_membership_reminder_email_subject); ?>" placeholder="<?php esc_html_e('Enter reminder email subject','wpmembership'); ?>">
								</div>
							</div>
								
							<div class="form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('Reminder Email Tempalte :','wpmembership'); ?> </label>
								<div class="col-md-10 ">
									<?php
										$settings_a = array(
										'textarea_rows' =>20,
										);
										$content_reminder = get_option( 'iv_membership_reminder_email');
										$editor_id = 'reminder_email_template';
									?>
									<textarea id="reminder_email_template" name="reminder_email_template" rows="20" class="col-md-12 ">
										<?php echo esc_html($content_reminder); ?>
									</textarea>
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('Send Email Before # Days :','wpmembership'); ?> </label>
								<div class="col-md-4 ">
									<?php
										$iv_membership_reminder_day = get_option( 'iv_membership_reminder_day');
									?>
									<input type="text" class="form-control" id="iv_membership_reminder_day" name="iv_membership_reminder_day" value="<?php echo esc_html($iv_membership_reminder_day); ?>" placeholder="<?php esc_html_e('Enter number of day', 'wpmembership'); ?>">
								</div>
							</div>
							<div class="row form-group">
								<label  class="col-md-2   control-label"><?php esc_html_e('Reminder  Cron Job URL:','wpmembership'); ?>
									<br/><?php esc_html_e('( Set the url on your web server cron job schedule for every day. )','wpmembership'); ?>
								</label>
								<div class="col-md-4 ">
									<?php
										$cron_page=get_option('_iv_membership_remainder_email_page');
										$cron_page= get_permalink( $cron_page);
									?>
									<a  href="<?php  echo esc_url($cron_page); ?>"> <?php echo  esc_url($cron_page); ?></a>
								</div>
							</div>
						
							<div class="form-group">
								<h3  class="col-md-12 col-xs-12 col-sm-12  page-header"><?php esc_html_e('Subscription Cancellation Email [Admin + User]','wpmembership'); ?> </h3>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('Cancellation Email Subject :','wpmembership'); ?> </label>
								<div class="col-md-4 ">
									<?php
										$cancellation_email = get_option( 'iv_membership_cancellation_email');
										if($cancellation_email==""){
											require_once (WP_iv_membership_DIR .'/install/install-cancellation-email.php');
										}
										$iv_membership_order_admin_email_subject = get_option( 'iv_membership_cancellation_email_sub');
									?>
									<input type="text" class="form-control" id="iv_membership_cancellation_email_sub" name="iv_membership_cancellation_email_sub" value="<?php echo esc_html($iv_membership_order_admin_email_subject); ?>" placeholder="<?php esc_html_e('Enter order email subject','wpmembership'); ?>">
								</div>
							</div>
							<div class="form-group">
								<label  class="col-md-2   control-label"> <?php esc_html_e('Cancellation Email Tempalte :','wpmembership'); ?> </label>
								<div class="col-md-10 ">
									<?php
										$settings_a = array(
										'textarea_rows' =>20,
										);
										$content_client = get_option( 'iv_membership_cancellation_email');
										$editor_id = 'cancellation_email_template';
									?>
									<textarea id="iv_membership_cancellation_email" name="iv_membership_cancellation_email" rows="20" class="col-md-12 "><?php echo esc_html($content_client); ?></textarea>
								</div>
							</div>
						</form>
						<div class="row pull-left">
							<div class="col-md-12 ">
							<button type="button" onclick="return  iv_update_email_settings();" class="btn btn-success"><?php esc_html_e('Update Email Setting','wpmembership'); ?></button>					</div>
						</div>
					</div>
					<div class="tab-pane fade" id="mailchimp">
						<form class="form-horizontal" role="form"  name='mailchimp_settings' id='mailchimp_settings'>
							<div class="form-group row">
								<label  class="col-md-3 col-xs-6 col-sm-6 control-label"> <?php esc_html_e('MailChimp API Key :','wpmembership'); ?> </label>
								<div class="col-md-4 col-xs-6 col-sm-6">
									<?php
										$iv_mailchimp_api_key='';
										if( get_option( 'iv_membership_mailchimp_api_key' )==FALSE ) {
											$iv_mailchimp_api_key = get_option('iv_membership_mailchimp_api_key');
											}else{
											$iv_mailchimp_api_key = get_option('iv_membership_mailchimp_api_key');
										}
									?>
									<input type="text" class="form-control" id="iv_membership_mailchimp_api_key" name="iv_membership_mailchimp_api_key" value="<?php echo esc_html($iv_mailchimp_api_key); ?>" placeholder="">
									<a href="http://admin.mailchimp.com/account/api" target="_blank"><?php esc_html_e('Get your API key here.','wpmembership'); ?></a>
								</div>
							</div>
							<div class="form-group row">
								<label  class="col-md-3 col-xs-6 col-sm-6  control-label"> </label>
							</div>
							<div class="form-group row">
								<label  class="col-md-3 col-xs-6 col-sm-6 control-label"><?php esc_html_e('Mailchimp List :','wpmembership'); ?> </label>
								<div class="col-md-4 col-xs-6 col-sm-6">
									<?php
										if( ! class_exists('MailChimp' ) ) {
											require_once(WP_iv_membership_DIR . '/inc/MailChimp.php');
										}
										$iv_mailchimp_api_key='';
										if( get_option( 'iv_membership_mailchimp_api_key' )==FALSE ) {
											$iv_mailchimp_api_key = get_option('iv_membership_mailchimp_api_key');
											}else{
											$iv_mailchimp_api_key = get_option('iv_membership_mailchimp_api_key');
										}
										echo '<select class="form-control" id="iv_membership_mailchimp_list" name="iv_membership_mailchimp_list">';
										if($iv_mailchimp_api_key!=''){
											$iv_form_membership_mailchimp_list=get_option( 'iv_membership_mailchimp_list');
											$api = new MailChimp($iv_mailchimp_api_key);
											$list_data = $api->get('lists');
											if($list_data){
												foreach($list_data['lists'] as $key => $list):
												$lists[$list['id']] = $list['name'];
												echo '<option value="'.$list['id'].'" '.($iv_form_membership_mailchimp_list==$list['id']? 'selected': '').'>'.$list['name'].' </option>';
												endforeach;
												}else{
												echo '<option value=" " > Not Available</option>';
											}
										}
										echo'</select>';
									?>
								</div>
							</div>
							<div class=" col-md-7  bs-callout bs-callout-info">
								<?php esc_html_e('Signup user email address will go to the mailchimp list.','wpmembership'); ?><br/>
								<?php esc_html_e('Please remove require fields :"First Name", "Last Name" from your mailchimp list setting.','wpmembership'); ?>
							</div>
							<div class="clearfix"></div>
						</form>
						<div class="form-group  row">
							<label  class="col-md-3  control-label"> </label>
							<div class="col-md-4">
								<button type="button" onclick="return  iv_update_mailchamp_settings();" class="btn btn-success"><?php esc_html_e('Update MailChimp Setting','wpmembership'); ?></button>
							</div>
						</div>
					</div>
					<div class="tab-pane fade " id="tax">
						<form class="form-horizontal" role="form"  name='tax_settings' id='tax_settings'>
							<div class="form-group">
								<h3  class="col-md-12   page-header"><?php esc_html_e('Tax Setting','wpmembership'); ?> </h3>
							</div>
							<?php
								$tax_type= get_option('_iv_tax_type');
								$countries_tax_array= get_option('_iv_countries_tax');
								$common_tax_value= get_option('_iv_comman_tax_value');
								$active_module=get_option('_iv_membership_active_tax');
								$active_check_y=''; $active_check_n='';
								if($active_module=='yes' )
								{	$active_check_n='';
									$active_check_y=' checked';
									}else{
									$active_check_y='';
									$active_check_n=' checked';
								}
								if($active_module=='' ){ $active_check_y=' checked';$active_check_n='';	}
							?>
							<div class="row">
								<label  class="col-md-2  pull-left"> <?php esc_html_e('Tax Module ','wpmembership'); ?>:</label>
								<div class="col-md-3">
									<label>
										<input type="radio" name="active_tax" id="active_tax" value='yes' <?php echo esc_html($active_check_y); ?> >
										<?php esc_html_e('Active Tax On Registration','wpmembership'); ?>
									</label>
								</div>
								<div class="col-md-3">
									<label>
										<input type="radio"  name="active_tax" id="active_tax" value='no' <?php echo esc_html($active_check_n); ?> > <?php esc_html_e('No Tax','wpmembership'); ?>
									</label>
								</div>
								<div class="col-md-3">
									<button type="button" onclick="return  iv_update_tax_settings();" class="btn btn-success"><?php esc_html_e('Update','wpmembership'); ?></button>
								</div>
							</div>
							<div class="row">
								<label  class="col-md-2  pull-left"> <?php esc_html_e('Tax Type ','wpmembership'); ?>:</label>
								<div class="col-md-3">
									<label>
										<input type="radio" name="tax_type" id="tax_type" value='common' onclick="return iv_show_common_tax();" <?php echo ($tax_type=='common'? 'checked':''); ?> >
										<?php esc_html_e('Common Tax','wpmembership'); ?>
									</label>
								</div>
								<div class="col-md-3">
									<label>
										<input type="radio"  name="tax_type" id="tax_type" value='country' onclick="return iv_show_country_tax();" <?php echo ($tax_type=='country'? 'checked':''); ?> > <?php esc_html_e('Tax By Country','wpmembership'); ?>
									</label>
								</div>
							</div>
							<!-- Common -->
							<div class="row " id="common_tax" style="<?php echo ($tax_type=='common'? '':'display: none;'); ?>">
								<label  class="col-md-2  pull-left"> <?php esc_html_e('Common Tax % ','wpmembership'); ?>:</label>
								<div class="col-md-3">
									<input type="text" name="common_tax_input" id="common_tax_input" value='<?php echo esc_html($common_tax_value); ?>' placeholder="<?php esc_html_e('only number','wpmembership'); ?>" >
								</div>
							</div>
							<!-- Country -->
							<div class="row " id="country_tax" style="<?php echo ($tax_type=='country'? '':'display: none;'); ?>">
								<div class="col-md-8 tblcont" >
									<table class="table table-bordered table-responsive table-hover ">											
										<tbody>
											<tr>
												<td ><?php esc_html_e('Country','wpmembership'); ?> </td>
												<td ><?php esc_html_e('Tax %','wpmembership'); ?> </td>
											</tr>
											<?php
												$countries = array(
												"AF" => "Afghanistan (‫افغانستان‬‎)",
												"AX" => "Åland Islands (Åland)",
												"AL" => "Albania (Shqipëri)",
												"DZ" => "Algeria (‫الجزائر‬‎)",
												"AS" => "American Samoa",
												"AD" => "Andorra",
												"AO" => "Angola",
												"AI" => "Anguilla",
												"AQ" => "Antarctica",
												"AG" => "Antigua and Barbuda",
												"AR" => "Argentina",
												"AM" => "Armenia (Հայաստան)",
												"AW" => "Aruba",
												"AC" => "Ascension Island",
												"AU" => "Australia",
												"AT" => "Austria (Österreich)",
												"AZ" => "Azerbaijan (Azərbaycan)",
												"BS" => "Bahamas",
												"BH" => "Bahrain (‫البحرين‬‎)",
												"BD" => "Bangladesh (বাংলাদেশ)",
												"BB" => "Barbados",
												"BY" => "Belarus (Беларусь)",
												"BE" => "Belgium (België)",
												"BZ" => "Belize",
												"BJ" => "Benin (Bénin)",
												"BM" => "Bermuda",
												"BT" => "Bhutan (འབྲུག)",
												"BO" => "Bolivia",
												"BA" => "Bosnia and Herzegovina (Босна и Херцеговина)",
												"BW" => "Botswana",
												"BV" => "Bouvet Island",
												"BR" => "Brazil (Brasil)",
												"IO" => "British Indian Ocean Territory",
												"VG" => "British Virgin Islands",
												"BN" => "Brunei",
												"BG" => "Bulgaria (България)",
												"BF" => "Burkina Faso",
												"BI" => "Burundi (Uburundi)",
												"KH" => "Cambodia (កម្ពុជា)",
												"CM" => "Cameroon (Cameroun)",
												"CA" => "Canada",
												"IC" => "Canary Islands (islas Canarias)",
												"CV" => "Cape Verde (Kabu Verdi)",
												"BQ" => "Caribbean Netherlands",
												"KY" => "Cayman Islands",
												"CF" => "Central African Republic (République centrafricaine)",
												"EA" => "Ceuta and Melilla (Ceuta y Melilla)",
												"TD" => "Chad (Tchad)",
												"CL" => "Chile",
												"CN" => "China (中国)",
												"CX" => "Christmas Island",
												"CP" => "Clipperton Island",
												"CC" => "Cocos (Keeling) Islands (Kepulauan Cocos (Keeling))",
												"CO" => "Colombia",
												"KM" => "Comoros (‫جزر القمر‬‎)",
												"CD" => "Congo (DRC) (Jamhuri ya Kidemokrasia ya Kongo)",
												"CG" => "Congo (Republic) (Congo-Brazzaville)",
												"CK" => "Cook Islands",
												"CR" => "Costa Rica",
												"CI" => "Côte d’Ivoire",
												"HR" => "Croatia (Hrvatska)",
												"CU" => "Cuba",
												"CW" => "Curaçao",
												"CY" => "Cyprus (Κύπρος)",
												"CZ" => "Czech Republic (Česká republika)",
												"DK" => "Denmark (Danmark)",
												"DG" => "Diego Garcia",
												"DJ" => "Djibouti",
												"DM" => "Dominica",
												"DO" => "Dominican Republic (República Dominicana)",
												"EC" => "Ecuador",
												"EG" => "Egypt (‫مصر‬‎)",
												"SV" => "El Salvador",
												"GQ" => "Equatorial Guinea (Guinea Ecuatorial)",
												"ER" => "Eritrea",
												"EE" => "Estonia (Eesti)",
												"ET" => "Ethiopia",
												"FK" => "Falkland Islands (Islas Malvinas)",
												"FO" => "Faroe Islands (Føroyar)",
												"FJ" => "Fiji",
												"FI" => "Finland (Suomi)",
												"FR" => "France",
												"GF" => "French Guiana (Guyane française)",
												"PF" => "French Polynesia (Polynésie française)",
												"TF" => "French Southern Territories (Terres australes françaises)",
												"GA" => "Gabon",
												"GM" => "Gambia",
												"GE" => "Georgia (საქართველო)",
												"DE" => "Germany (Deutschland)",
												"GH" => "Ghana (Gaana)",
												"GI" => "Gibraltar",
												"GR" => "Greece (Ελλάδα)",
												"GL" => "Greenland (Kalaallit Nunaat)",
												"GD" => "Grenada",
												"GP" => "Guadeloupe",
												"GU" => "Guam",
												"GT" => "Guatemala",
												"GG" => "Guernsey",
												"GN" => "Guinea (Guinée)",
												"GW" => "Guinea-Bissau (Guiné Bissau)",
												"GY" => "Guyana",
												"HT" => "Haiti",
												"HM" => "Heard & McDonald Islands",
												"HN" => "Honduras",
												"HK" => "Hong Kong (香港)",
												"HU" => "Hungary (Magyarország)",
												"IS" => "Iceland (Ísland)",
												"IN" => "India (भारत)",
												"ID" => "Indonesia",
												"IR" => "Iran (‫ایران‬‎)",
												"IQ" => "Iraq (‫العراق‬‎)",
												"IE" => "Ireland",
												"IM" => "Isle of Man",
												"IL" => "Israel (‫ישראל‬‎)",
												"IT" => "Italy (Italia)",
												"JM" => "Jamaica",
												"JP" => "Japan (日本)",
												"JE" => "Jersey",
												"JO" => "Jordan (‫الأردن‬‎)",
												"KZ" => "Kazakhstan (Казахстан)",
												"KE" => "Kenya",
												"KI" => "Kiribati",
												"XK" => "Kosovo (Kosovë)",
												"KW" => "Kuwait (‫الكويت‬‎)",
												"KG" => "Kyrgyzstan (Кыргызстан)",
												"LA" => "Laos (ລາວ)",
												"LV" => "Latvia (Latvija)",
												"LB" => "Lebanon (‫لبنان‬‎)",
												"LS" => "Lesotho",
												"LR" => "Liberia",
												"LY" => "Libya (‫ليبيا‬‎)",
												"LI" => "Liechtenstein",
												"LT" => "Lithuania (Lietuva)",
												"LU" => "Luxembourg",
												"MO" => "Macau (澳門)",
												"MK" => "Macedonia (FYROM) (Македонија)",
												"MG" => "Madagascar (Madagasikara)",
												"MW" => "Malawi",
												"MY" => "Malaysia",
												"MV" => "Maldives",
												"ML" => "Mali",
												"MT" => "Malta",
												"MH" => "Marshall Islands",
												"MQ" => "Martinique",
												"MR" => "Mauritania (‫موريتانيا‬‎)",
												"MU" => "Mauritius (Moris)",
												"YT" => "Mayotte",
												"MX" => "Mexico (México)",
												"FM" => "Micronesia",
												"MD" => "Moldova (Republica Moldova)",
												"MC" => "Monaco",
												"MN" => "Mongolia (Монгол)",
												"ME" => "Montenegro (Crna Gora)",
												"MS" => "Montserrat",
												"MA" => "Morocco (‫المغرب‬‎)",
												"MZ" => "Mozambique (Moçambique)",
												"MM" => "Myanmar (Burma) (မြန်မာ)",
												"NA" => "Namibia (Namibië)",
												"NR" => "Nauru",
												"NP" => "Nepal (नेपाल)",
												"NL" => "Netherlands (Nederland)",
												"NC" => "New Caledonia (Nouvelle-Calédonie)",
												"NZ" => "New Zealand",
												"NI" => "Nicaragua",
												"NE" => "Niger (Nijar)",
												"NG" => "Nigeria",
												"NU" => "Niue",
												"NF" => "Norfolk Island",
												"MP" => "Northern Mariana Islands",
												"KP" => "North Korea (조선 민주주의 인민 공화국)",
												"NO" => "Norway (Norge)",
												"OM" => "Oman (‫عُمان‬‎)",
												"PK" => "Pakistan (‫پاکستان‬‎)",
												"PW" => "Palau",
												"PS" => "Palestine (‫فلسطين‬‎)",
												"PA" => "Panama (Panamá)",
												"PG" => "Papua New Guinea",
												"PY" => "Paraguay",
												"PE" => "Peru (Perú)",
												"PH" => "Philippines",
												"PN" => "Pitcairn Islands",
												"PL" => "Poland (Polska)",
												"PT" => "Portugal",
												"PR" => "Puerto Rico",
												"QA" => "Qatar (‫قطر‬‎)",
												"RE" => "Réunion (La Réunion)",
												"RO" => "Romania (România)",
												"RU" => "Russia (Россия)",
												"RW" => "Rwanda",
												"BL" => "Saint Barthélemy (Saint-Barthélemy)",
												"SH" => "Saint Helena",
												"KN" => "Saint Kitts and Nevis",
												"LC" => "Saint Lucia",
												"MF" => "Saint Martin (Saint-Martin (partie française))",
												"PM" => "Saint Pierre and Miquelon (Saint-Pierre-et-Miquelon)",
												"WS" => "Samoa",
												"SM" => "San Marino",
												"ST" => "São Tomé and Príncipe (São Tomé e Príncipe)",
												"SA" => "Saudi Arabia (‫المملكة العربية السعودية‬‎)",
												"SN" => "Senegal (Sénégal)",
												"RS" => "Serbia (Србија)",
												"SC" => "Seychelles",
												"SL" => "Sierra Leone",
												"SG" => "Singapore",
												"SX" => "Sint Maarten",
												"SK" => "Slovakia (Slovensko)",
												"SI" => "Slovenia (Slovenija)",
												"SB" => "Solomon Islands",
												"SO" => "Somalia (Soomaaliya)",
												"ZA" => "South Africa",
												"GS" => "South Georgia & South Sandwich Islands",
												"KR" => "South Korea (대한민국)",
												"SS" => "South Sudan (‫جنوب السودان‬‎)",
												"ES" => "Spain (España)",
												"LK" => "Sri Lanka (ශ්‍රී ලංකාව)",
												"VC" => "St. Vincent & Grenadines",
												"SD" => "Sudan (‫السودان‬‎)",
												"SR" => "Suriname",
												"SJ" => "Svalbard and Jan Mayen (Svalbard og Jan Mayen)",
												"SZ" => "Swaziland",
												"SE" => "Sweden (Sverige)",
												"CH" => "Switzerland (Schweiz)",
												"SY" => "Syria (‫سوريا‬‎)",
												"TW" => "Taiwan (台灣)",
												"TJ" => "Tajikistan",
												"TZ" => "Tanzania",
												"TH" => "Thailand (ไทย)",
												"TL" => "Timor-Leste",
												"TG" => "Togo",
												"TK" => "Tokelau",
												"TO" => "Tonga",
												"TT" => "Trinidad and Tobago",
												"TA" => "Tristan da Cunha",
												"TN" => "Tunisia (‫تونس‬‎)",
												"TR" => "Turkey (Türkiye)",
												"TM" => "Turkmenistan",
												"TC" => "Turks and Caicos Islands",
												"TV" => "Tuvalu",
												"UM" => "U.S. Outlying Islands",
												"VI" => "U.S. Virgin Islands",
												"UG" => "Uganda",
												"UA" => "Ukraine (Україна)",
												"AE" => "United Arab Emirates (‫الإمارات العربية المتحدة‬‎)",
												"GB" => "United Kingdom",
												"US" => "United States",
												"UY" => "Uruguay",
												"UZ" => "Uzbekistan (Oʻzbekiston)",
												"VU" => "Vanuatu",
												"VA" => "Vatican City (Città del Vaticano)",
												"VE" => "Venezuela",
												"VN" => "Vietnam (Việt Nam)",
												"WF" => "Wallis and Futuna",
												"EH" => "Western Sahara (‫الصحراء الغربية‬‎)",
												"YE" => "Yemen (‫اليمن‬‎)",
												"ZM" => "Zambia",
												"ZW" => "Zimbabwe");
												foreach($countries as $key=>$country) {
													echo'<tr>';
													echo ' <th scope="row">'.$country.'</th> ';
													$tax_value=0;
													if(!empty($countries_tax_array)){
														foreach($countries_tax_array as $c_name=>$country_tax) {
															if(isset($countries_tax_array[$key]) and $c_name==$key)
															{
																if(array_key_exists($key , $countries_tax_array)){
																	$tax_value=$country_tax;
																}
															}
														}
													}
													echo '<td "><input type="text" name="'.esc_html($key).'" id="'.esc_html($key).'"   value="'.esc_html($tax_value).'" placeholder="Only Number"></td>';
													echo'</tr>';
												}
											?>
										</tbody>
									</table>
								</div>
							</div>
							<br/>
							<div class=" col-md-12  bs-callout bs-callout-info">
								<?php
									_e('Note : Tax will not work on Stripe Ruccring Subscriotion Payment','wpmembership');
								?>
							</div>
							<div class="form-group">
								<label  class="col-md-3 control-label" id="tax_message"> </label>
								<div class="col-md-8">
									<button type="button" onclick="return  iv_update_tax_settings();" class="btn btn-success"><?php esc_html_e('Update','wpmembership'); ?></button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
