<?php
	wp_enqueue_script('jquery.form-validator', WP_iv_membership_URLPATH . 'admin/files/js/jquery.form-validator.js');
	$newpost_id='';
	$currencyCode= get_option('_iv_membership_api_currency');
	$iv_gateway = get_option('iv_membership_payment_gateway');
	$post_name='iv_membership_stripe_setting';
	$row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_name = '%s' ", $post_name));
	if(isset($row->ID )){
		$newpost_id= $row->ID;
	}
	$stripe_mode=get_post_meta( $newpost_id,'iv_membership_stripe_mode',true);
	$stripe_publishable='';
	if($stripe_mode=='test'){
		$stripe_publishable =get_post_meta($newpost_id, 'iv_membership_stripe_publishable_test',true);
		}else{
		$stripe_publishable =get_post_meta($newpost_id, 'iv_membership_stripe_live_publishable_key',true);
	}
	
	wp_enqueue_script('stripe', 'https://js.stripe.com/v2/');		
?>
<div id="payment-errors"></div>
<div id="stripe_form">
	<div class="row form-group">
		<label for="text" class="col-md-4 col-xs-4 col-sm-4 control-label"><?php  esc_html_e('Package Name','wpmembership');?></label>
		<div class="col-md-8 col-xs-8 col-sm-8 ">
			<?php
				$iv_membership_pack='iv_membership_pack';
				$sql=$wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_type = '%s'  and post_status='draft' ",$iv_membership_pack);
				$membership_pack = $wpdb->get_results($sql);
				$total_package=count($membership_pack);
				if(sizeof($membership_pack)>0){
					$i=0; $current_package_id=get_user_meta($current_user->ID,'iv_membership_package_id',true);
					echo'<select name="package_sel" id ="package_sel" class=" form-control">';
					foreach ( $membership_pack as $row )
					{
						if($current_package_id==$row->ID){
							echo '<option value="'. esc_html($row->ID).'" >'. esc_html($row->post_title).' [Your Current Package]</option>';
							}else{
							echo '<option value="'. esc_html($row->ID).'" >'. esc_html($row->post_title).'</option>';
						}
						if($i==0){
							$package_id=$row->ID;
							if(get_post_meta($row->ID, 'iv_membership_package_recurring',true)=='on'){
								$package_amount=get_post_meta($row->ID, 'iv_membership_package_recurring_cost_initial', true);
								}else{
								$package_amount=get_post_meta($row->ID, 'iv_membership_package_cost',true);
							}
						}
						$i++;
					}
					echo '</select>';
				}
			?>
		</div>
	</div>
	<div class="row form-group">
		<label for="text" class="col-md-4 col-xs-4 col-sm-4 control-label"><?php  esc_html_e('Amount','wpmembership');?></label>
		<div class="col-md-8 col-xs-8 col-sm-8 " id="p_amount"> <label class="control-label"> <?php  echo esc_html($amount).' '.esc_html($recurring_text); ?> </label>
		</div>
	</div>
	<?php
		$api_currency= 'USD';
		if( get_option('_iv_membership_api_currency' )!=FALSE ) {
			$api_currency= get_option('_iv_membership_api_currency' );
		}
		$tax_total=0;
		$tax_type= (get_option('_iv_tax_type')!=""? get_option('_iv_tax_type'):"country");
		$tax_active_module=get_option('_iv_membership_active_tax');
		$country_id= get_user_meta($userId, 'country_code',true);  
		if($tax_active_module=='yes'){
		?>
		<div class="row form-group">
			<label for="text" class="col-md-4 control-label"><?php  esc_html_e('Vat/Tax','wpmembership');?></label>
			<div class="col-md-8" id="tax">
				<?php
					$tax_type= get_option('_iv_tax_type');
					$tax_active_module=get_option('_iv_membership_active_tax');
					if($tax_active_module=='' ){ $tax_active_module='yes';	}
					if($tax_type==''){$tax_type='country';}
					if($tax_active_module=='yes' AND $tax_type=='country'){
						$countries_tax_array= (get_option('_iv_countries_tax')!=''? get_option('_iv_countries_tax'): array()) ;
						if(array_key_exists($country_id , $countries_tax_array)){
							$country_tax_value= $countries_tax_array[$country_id];
							$tax_total=$package_amount * $country_tax_value/100;
						}
					}
					if($tax_active_module=='yes' AND $tax_type=='common'){
						$common_tax_value= get_option('_iv_comman_tax_value');
						$tax_total=$package_amount * $common_tax_value/100;
					}
					echo esc_html($tax_total).''.esc_html($api_currency);
				?>
			</div>
		</div>
		<?php
		}
	?>
	<div class="row form-group">
		<label for="text" class="col-md-4 control-label"><?php  esc_html_e('Total','wpmembership');?></label>
		<div class="col-md-8" id="total"><label class="control-label">  <?php  $package_amount= $package_amount+$tax_total; echo esc_html($package_amount).''.esc_html($api_currency); ?></label>
		</div>
	</div>
	<div class="row form-group">
		<label for="text" class="col-md-4 col-xs-4 col-sm-4 control-label"><?php  esc_html_e('Card Number','wpmembership');?></label>
		<div class="col-md-8 col-xs-8 col-sm-8 " >
			<input type="text" name="card_number" id="card_number"  data-validation="creditcard required"  class="form-control ctrl-textbox" placeholder="<?php  esc_html_e('Enter card number','wpmembership');?>" data-validation-error-msg="<?php  esc_html_e('Card number is not correct','wpmembership');?> " >
		</div>
	</div>
	<div class="row form-group">
		<label for="text" class="col-md-4 col-xs-4 col-sm-4 control-label"><?php  esc_html_e('Card CVV','wpmembership');?> </label>
		<div class="col-md-8 col-xs-8 col-sm-8 " >
			<input type="text" name="card_cvc" id="card_cvc" class="form-control ctrl-textbox"   data-validation="number"
			data-validation-length="2-6" data-validation-error-msg="<?php esc_html_e( 'CVV number is not correct', 'wpmembership' );?>" placeholder="<?php esc_html_e('Enter card CVV', 'wpmembership'); ?>" >
		</div>
	</div>
	<div class="row form-group">
		<label for="text" class="col-md-4 col-xs-4 col-sm-4 control-label"><?php  esc_html_e('Expiration (MM/YYYY)','wpmembership');?></label>
		<div class="col-md-4 col-xs-4 col-sm4" >
			<select name="card_month" id="card_month"  class="card-expiry-month stripe-sensitive required form-control">
				<option value="01" selected="selected"> <?php esc_html_e('01','wpmembership'); ?></option>
				<option value="02"><?php esc_html_e('02','wpmembership'); ?></option>
				<option value="03">
					<?php esc_html_e('03','wpmembership'); ?>
				</option>
				<option value="04">
					<?php esc_html_e('04','wpmembership'); ?>
				</option>
				<option value="05">
					<?php esc_html_e('05','wpmembership'); ?>
				</option>
				<option value="06">
					<?php esc_html_e('06','wpmembership'); ?>
				</option>
				<option value="07">
					<?php esc_html_e('07','wpmembership'); ?>
				</option>
				<option value="08">
					<?php esc_html_e('08','wpmembership'); ?>
				</option>
				<option value="09">
					<?php esc_html_e('09','wpmembership'); ?>
				</option>
				<option value="10">
					<?php esc_html_e('10','wpmembership'); ?>
				</option>
				<option value="11">
					<?php esc_html_e('11','wpmembership'); ?>
				</option>
				<option value="12" selected >
					<?php esc_html_e('12','wpmembership'); ?>
				</option>
			</select>
		</div>
		<div class="col-md-4 col-xs-4 col-sm-4 " >
			<select name="card_year"  id="card_year"  class="card-expiry-year stripe-sensitive  form-control">
			</select>
			
		</div>
	</div>
	<?php
		$iv_membership_payment_terms=get_option('iv_membership_payment_terms');
		$term_text='I have read & accept the Terms & Conditions';
		if( get_option( 'iv_membership_payment_terms_text' ) ) {
			$term_text= get_option('iv_membership_payment_terms_text');
		}
		if($iv_membership_payment_terms=='yes'){
		?>
			<div class="row form-group">
			<div class="col-md-4 col-xs-4 col-sm-4 ">
			</div>
			<div class="col-md-8 col-xs-8 col-sm-8 ">
				<label>
					<input type="checkbox" data-validation="required" 
					data-validation-error-msg="<?php esc_html_e( 'You have to agree to our terms', 'wpmembership' );?> "  name="check_terms" id="check_terms" > <?php echo esc_html($term_text); ?>
					</label>
			
			</div>
				<div class="text-danger" id="error_message" ></div>
		</div>
		<?php
		}
	?>
	<input type="hidden" name="country_select" id="country_select" value="<?php echo esc_html($country_id); ?>">
	<input type="hidden" name="package_id" id="package_id" value="<?php echo esc_html($package_id); ?>">
	<input type="hidden" name="coupon_code" id="coupon_code" value="">
	<input type="hidden" name="redirect" value="<?php echo get_permalink(); ?>"/>
	<input type="hidden" name="stripe_nonce" value="<?php echo wp_create_nonce('stripe-nonce'); ?>"/>
	<div class="row form-group">
		<label for="text" class="col-md-4 col-xs-4 col-sm-4 control-label"></label>
		<div class="col-md-8 col-xs-8 col-sm-8 " > <div id="loading"> </div>
			<button  id="submit_iv_membership_payment"  type="submit" class="btn btn-info ctrl-btn"  > <?php  esc_html_e('Submit','wpmembership');?> </button>
		</div>
	</div>
</div>
<?php
	wp_enqueue_script('wp-iv_membership-my-account-stripe', WP_iv_membership_URLPATH.'admin/files/js/stripe-upgrade.js');
	wp_localize_script('wp-iv_membership-my-account-stripe', 'ep_data_stripe', array( 			'ajaxurl' 			=> admin_url( 'admin-ajax.php' ),
	'loading_image'		=> '<img src="'.WP_iv_membership_URLPATH.'admin/files/images/loader.gif">',	
	'profilenonce'=> wp_create_nonce("settings"),
	'signup'=> wp_create_nonce("signup"),	
	'currencyCode'=> $currencyCode,
	'iv_gateway'=> $iv_gateway,
	'stripe_publishable'=> $stripe_publishable,
	) );
	
?>	