<div class="profile-content">
	<div class="portlet light">
		<div class="portlet-title tabbable-line clearfix">
			<div class="caption caption-md">
				<span class="caption-subject"><?php  esc_html_e('Edit','wpmembership');?> <?php
					$iv_post = get_option( '_iv_membership_profile_post');
					if($iv_post!=''){
						echo esc_html($iv_post);
						}else{
						echo 'Post';
					}
				?></span>
			</div>
		</div>
		<div class="portlet-body">
			<div class="tab-content">
				<div class="tab-pane active" id="tab_1_1">
					<?php
						$curr_post_id=sanitize_text_field($_REQUEST['post-id']);
						$current_post = $curr_post_id;
						$post_edit = get_post($curr_post_id);
						$title = $post_edit->post_title;
						$content = $post_edit->post_content;
						// Author Check
						if ( $post_edit->post_author != $current_user->ID) {
							$iv_redirect = get_option( '_iv_membership_login_page');
							$reg_page= get_permalink( $iv_redirect);
						?>
						<?php  esc_html_e('Please','wpmembership');?> <a href="<?php echo esc_html($reg_page); ?>" title="Login"><?php  esc_html_e('Login','wpmembership');?></a> <?php  esc_html_e('To Edit The Post.','wpmembership');?>
						<?php
							}else{
						?>
						<div class="row">
							<div class="col-md-12">
								<form action="" id="edit_post" name="edit_post"  method="POST" role="form">
									<div class=" form-group">
										<label for="text" class=" control-label"><?php  esc_html_e('Title','wpmembership');?></label>
										<div class="  ">
											<input type="text" class="form-control" name="title" id="title" value="<?php echo esc_html($title);?>" placeholder=" <?php esc_html_e('Enter Title Here', 'wpmembership'); ?>">
										</div>
									</div>
									<div class="form-group">
										<div class=" ">
											<?php
												$settings_a = array(
												'textarea_rows' =>10,
												'editor_class' => 'form-control'
												);
												$content_client =$content;
												$editor_id = 'edit_post_content';
												wp_editor( $content_client, $editor_id,$settings_a );
											?>
										</div>
									</div>
									<div class=" row form-group ">
										<label for="text" class=" col-md-5 control-label"><?php  esc_html_e('Feature Image','wpmembership');?> </label>
										<div class="col-md-4" id="post_image_div">
											<?php $feature_image = wp_get_attachment_image_src( get_post_thumbnail_id( $curr_post_id ), 'thumbnail' );
												if($feature_image[0]!=""){ ?>
												<img title="profile image" class=" img-responsive" src="<?php  echo esc_html($feature_image[0]); ?>">
												<?php
												}else{ ?>
												<a href="javascript:void(0);" onclick="edit_post_image('post_image_div');"  >
													<?php  echo '<img src="'. WP_iv_membership_URLPATH.'assets/images/image-add-icon.png">'; ?>
												</a>
												<?php
												}
												$feature_image_id=get_post_thumbnail_id( $curr_post_id );
											?>
										</div>
										<input type="hidden" name="feature_image_id" id="feature_image_id" value="<?php echo esc_html($feature_image_id);  ?>">
										<div class="col-md-3" id="post_image_edit">
											<?php
												if($feature_image[0]!=""){
												?>
												<button type="button" onclick="edit_post_image('post_image_div');"  class="btn btn-xs green-haze"><?php  esc_html_e('Edit','wpmembership');?></button>
												<button type="button" onclick="remove_post_image('post_image_div');"  class="btn btn-xs green-haze"><?php  esc_html_e('Remove','wpmembership');?></button>
												<?php
												}else{ ?>
												<button type="button" onclick="edit_post_image('post_image_div');"  class="btn btn-xs green-haze"><?php  esc_html_e('Add','wpmembership');?></button>
												<?php
												}
											?>
										</div>
									</div>
									<div class="clearfix"></div>
									<?php
										$custom_fields = get_post_custom($curr_post_id);
									?>
									<label for="text" class="row col-md-12 control-label"><?php  esc_html_e('Custom Fields','wpmembership');?> </label>
									<div id="custom_field_div">
										<?php
											foreach ( $custom_fields as $field_key => $field_values ) {
												if(!isset($field_values[0])){ continue;}
												$underscore_str=substr($field_key,0,1);
												if($underscore_str!='_'){
													echo '<div class="row form-group "><div class=" col-md-6"> <input type="text" class="form-control" name="custom_name[]" id="custom_name[]" value="'.esc_html($field_key) . '" placeholder="Custom Field Name"> </div>
													<div  class=" col-md-6">
													<textarea name="custom_value[]" id="custom_value[]"  class="form-control col-md-12"  rows="1" placeholder="Value">'.esc_html($field_values[0]).'</textarea>
													</div></div>';
												}
											}
										?>
									</div>
									<div class=" row  form-group ">
										<div class="col-md-12" >
											<button type="button" onclick="add_custom_field();"  class="btn btn-xs green-haze"><?php  esc_html_e('More Field','wpmembership');?></button>
										</div>
									</div>
									<div class="clearfix"></div>
									<div class=" row form-group ">
										<label for="text" class=" col-md-12 control-label"><?php  esc_html_e('Post Status','wpmembership');?>  </label>
										<div class="col-md-12" id="">
											<select name="post_status" id="post_status"  class="form-control">
												<option value="pending"<?php echo (get_post_status( $post_edit->ID )=='pending'?'selected="selected"':'' ) ; ?> ><?php  esc_html_e('Pending Review','wpmembership');?></option>
												<option value="draft" <?php echo (get_post_status( $post_edit->ID )=='draft'?'selected="selected"':'' ) ; ?> ><?php  esc_html_e('Draft','wpmembership');?></option>
											</select>
										</div>
									</div>
									<div class="clearfix"></div>
									<div class=" row form-group">
										<label for="text" class=" col-md-10 control-label"><?php  esc_html_e('Category','wpmembership');?></label>
										<div class=" col-md-12 ">
											<?php
												$postId = $curr_post_id; 
												$currentCategory='';$currentCategoryId='';
												if(get_the_category($postId)){
													$currentCategory = get_the_category($postId);  
													$currentCategoryId = $currentCategory[0]->term_id; 
												}
												$categories = get_categories('hide_empty=0'); 
												$package_id= get_user_meta($post_edit->post_author,'iv_membership_package_id',true);
												$allow_cats= explode("|",get_post_meta($package_id, 'iv_membership_package_category_ids', true));
												$optionname = "postcats"; 
												$emptyvalue = "";
												$selected="";											
												echo '<select name="'.esc_html($optionname).'" class="form-control">
												<option selected="'.esc_html($selected).'" value="'.esc_html($emptyvalue).'">'.esc_html__('Choose a category','wpmembership').'</option>';
												foreach($categories as $category){
													if($currentCategoryId == $category->term_id) {
														$selected = 'selected="selected"';
														} else {
														$selected = '';
													}
													$allow =in_array( 'all', $allow_cats) ? 'all' : '';
													$allow_2 =in_array( $category->term_id, $allow_cats) ? '1' : '0';
													if($allow=='all' or $allow_2=='1'){
														echo '<option name="'.esc_html($category->term_id).'" value="'.esc_html($category->term_id).'" '.esc_html($selected).'>'.esc_html($category->name).'</option>';
													}
												}
												echo '</select>';
											?>
										</div>
									</div>
									<div class="margiv-top-10">
								    <div class="" id="update_message"></div>
										<input type="hidden" name="user_post_id" id="user_post_id" value="<?php echo esc_html($curr_post_id); ?>">
								    <button type="button" onclick="iv_update_post();"  class="btn green-haze"><?php  esc_html_e('Update Post','wpmembership');?></button>
									</div>
								</form>
							</div>
						</div>
						<?php
						} 
					?>
				</div>
			</div>
		</div>
	</div>
</div>
