(function($){

  'use strict';

  function initializeChosen(){

    'use strict';

    let chosen_elements = [];

    for(let i=1;i<=100;i++){

      if( $('#language' + i).length && $('#locale' + i).length ){

        chosen_elements.push('#language' + i);
        chosen_elements.push('#script' + i);
        chosen_elements.push('#locale' + i);

      }

    }

    chosen_elements.push('#inherited');

    $(chosen_elements.join(',')).chosen();

  }

  $(document).ready(function(){

    'use strict';

    removeBorderLastTableTr();

    $('.group-trigger').click(function() {

      //open and close the various sections of the tables area
      const target = $(this).attr('data-trigger-target');
      $('.' + target).toggle();

      $(this).find('.expand-icon').toggleClass('arrow-down');

      removeBorderLastTableTr();

      /**
       * Prevent a bug that causes the "All" text (used in the chosen multiple when there are no items selected) to be
       * hidden.
       */
      $('.chosen-container-multi .chosen-choices .search-field input').each(function() {
        $(this).css('width', 'auto');
      });

    });

    initializeChosen();

  });

  /*
 Remove the bottom border on the last visible tr included in the form
 */
  function removeBorderLastTableTr() {
    $('table.daext-form tr > *').css('border-bottom-width', '1px');
    $('table.daext-form tr:visible:last > *').css('border-bottom-width', '0');
  }

})(jQuery);