<?php

if ( ! current_user_can(get_option($this->shared->get('slug') . "_wizard_menu_capability"))) {
    wp_die(esc_attr__('You do not have sufficient permissions to access this page.'));
}

?>

<!-- process data -->

<!-- output -->

<div class="wrap">

    <?php

    if (isset($_GET['invalid_name'])) {
        $process_data_message = '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_html__('Please enter a valid value in the "Name" field.',
                'dahm') . '</p></div>';
    }

    if (isset($_GET['result'])) {

        $result = sanitize_key($_GET['result']);
        if($result !== 'error'){
	        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . intval($_GET['result'],
			        10) . esc_html__(' connections have been successfully added.', 'dahm') . '</p></div>';
        }

	    $result_alternate = sanitize_key($_GET['result_alternate']);
	    if($result_alternate !== 'error' and intval($result_alternate, 10) > 0 and isset($process_data_message)){
		    $process_data_message .= '<div class="updated settings-error notice is-dismissible below-h2"><p>' . intval($_GET['result_alternate'],
				    10) . esc_html__(' connections of the alternate pages have been successfully added.', 'dahm') . '</p></div>';
	    }

    }

    ?>

    <div id="daext-header-wrapper" class="daext-clearfix">

        <h2><?php esc_html_e('Hreflang Manager - Wizard', 'dahm'); ?></h2>

    </div>

    <div id="daext-menu-wrapper">

        <?php if (isset($invalid_data_message)) {
            echo $invalid_data_message;
        } ?>
        <?php if (isset($process_data_message)) {
            echo $process_data_message;
        } ?>

        <!-- table -->

        <form method="POST" action="admin.php?page=<?php echo $this->shared->get('slug'); ?>_wizard" autocomplete="off">

            <!-- Create New Autolink -->

            <div class="daext-form-container">

                <div class="daext-form-title"><?php esc_html_e('Wizard', 'dahm'); ?></div>

                <table class="daext-form">

                    <!-- Data -->
                    <tr valign="top">
                        <td id="dahm-table-td">
                            <div id="dahm-table"></div>
                        </td>
                    </tr>

                </table>

                <!-- submit button -->
                <div class="daext-form-action">
                    <input id="generate-connections" class="button" type="submit" value="<?php esc_attr_e('Generate Connections', 'dahm'); ?>">
                </div>

            </div>

        </form>

    </div>

</div>