(function($) {
	jQuery(document).ready(function($){
		var $doc = $(document),
			$win = $(window);

		$doc.on("wgextra:wpmedia-open-modal", _.debounce(function(){
			var $img = $('.media-modal img.details-image, .wp_attachment_image img.thumbnail').eq(0),
				$input = $('input:regex(name, attachments\\[\\d+\\]\\[wgextra_focus_point\\])'),
				inputValue = $input.val(),
				jCrop = false,
				jcrop_api, selection = [];

			$img.attr('draggable', 'false');

			if (inputValue) {
				try {
					selection = eval(inputValue);
				} catch(e){}
			}

			$doc.on("wgextra:wpmedia-dom-refresh.focuspoint", function(){
				$input = $('input:regex(name, attachments\\[\\d+\\]\\[wgextra_focus_point\\])');
			}).on("wgextra:wpmedia-close-modal.focuspoint", function(){
				$doc.off(".focuspoint");
			});

			var handleCoords = _.debounce(function (coords) {
					if (coords.w < 5 || coords.h < 5)
						$input.val('').trigger('change');
					else {
						var imgWidth = $img.width(),
							imgHeight = $img.height(),
							x = Number((coords.x / imgWidth).toFixed(2)),
							y = Number((coords.y / imgHeight).toFixed(2)),
							x2 = Number((coords.x2 / imgWidth).toFixed(2)),
							y2 = Number((coords.y2 / imgHeight).toFixed(2));

						if (selection[0] == x && selection[1] == y && selection[2] == x2 && selection[3] == y2)
							return;

						selection = [x, y, x2, y2];
						$input.val( JSON.stringify( selection ) ).trigger('change');
					}
				}, 500),
				runJCrop = function (coords) {
					if (jCrop)
						return;

					$img.Jcrop({
						onChange: handleCoords,
						onSelect: handleCoords
					}, function() {
						jcrop_api = this;

						if (selection.length) {
							try {
								var imgWidth = $img.width(),
									imgHeight = $img.height(),
									area = [ selection[0] * imgWidth, selection[1] * imgHeight, selection[2] * imgWidth, selection[3] * imgHeight ];
								jcrop_api.setSelect(area);
							} catch(e){}
						}
					});

					$doc.on("DOMNodeInserted", ".jcrop-holder", function() {
						$(this).find('img').removeClass('details-image');
					});

					jCrop = true;
				};

			$img.on('load', runJCrop);
			runJCrop();
		}, 10) );
	});
}(jQuery));