(function($) {
	var $win = $(window),
		$doc = $(document);

	// Find elements with cache feature
	var $FIND = (function($) {
		var DOMCACHESTORE = {};

		return function(selector, force) {
			if (DOMCACHESTORE[selector] === undefined || force)
				DOMCACHESTORE[selector] = $(selector);
			return DOMCACHESTORE[selector];
		}
	})($);

	function i18n(str) {
		if (wgextra[str])
			return wgextra[str];
		else
			return str;
	}

	function ui_initialize($element, reInitialize) {
		if ($element.hasClass('ui-initialized') && !reInitialize)
			return;

		// Enable tabs
		$element.find( '[rel="tabs"]' ).not($element.find('.ui-tabs-panel [rel="tabs"]')).tabs({
			activate: function( event, ui ) {
				ui_initialize( ui.newPanel );
				// reload codemirrors
				ui.newPanel.find('textarea.css, textarea.html, textarea.javascript, textarea.pug').each(function(){
					var editor = $(this).data('editor');
					if(editor)
						editor.refresh();
				});
			},
			create: function( event, ui ) {
				if (ui.panel.is(':visible'))
					ui_initialize( ui.panel );
			}
		}).find('.ui-tabs-nav li a').on('click', function () {
			var scrollLocation = $win.scrollTop();
			location.hash = $(this).attr('href');
			$win.scrollTop( scrollLocation );
		});

		// Enable buttons
		var buttonsEachFn = function(){
			var $this = $(this),
				data = $this.data(),
				icon = data.icon || '';

			$this.button({
				icon: icon
			});
		};
		$element.find( 'button, input[type="button"], a.ui-button' ).not($element.find('.ui-tabs-panel button, .ui-tabs-panel input[type="button"], .ui-tabs-panel a.ui-button')).each(buttonsEachFn);

		// Enable selectboxes
		var selectboxEachFn = function(){
			var $this = $(this),
				name = this.name,
				width = $this.outerWidth();

			$this.selectmenu({
				width: width || false,
				open: function(event) {
					var $menu = $FIND('#' + event.target.id + '-menu'),
						$activeItem = $menu.find('.ui-state-active'),
						height = $menu.outerHeight(),
						offsetTop = $activeItem[0].offsetTop;

					$menu.scrollTop(offsetTop + ($activeItem.outerHeight() / 2) - (height / 2));
				},
				change: function(event) {
					$(event.target).trigger('change');
				}
			});
		};
		var $select = $element.find( "select").not('[multiple], .in-controlgroup').not($element.find('.ui-tabs-panel select'));
		$select.filter(':hidden').one('visible', selectboxEachFn);
		$select.filter(':visible').each(selectboxEachFn);


		// Enable multiple selectboxes
		$element.find( "select[multiple]").not($element.find('.ui-tabs-panel select[multiple]')).multiSelect({
			selectableOptgroup: true,
			selectableHeader: "<input type='text' class='search-input' autocomplete='off' placeholder='" + i18n('Type to Search...') + "'>",
			selectionHeader: "<input type='text' class='search-input' autocomplete='off' placeholder='" + i18n('Type to Search...') + "'>",
			afterInit: function(ms) {
				var that = this,
					$selectableSearch = that.$selectableUl.prev(),
					$selectionSearch = that.$selectionUl.prev(),
					selectableSearchString = '#' + that.$container.attr('id') + ' .ms-elem-selectable:not(.ms-selected)',
					selectionSearchString = '#' + that.$container.attr('id') + ' .ms-elem-selection.ms-selected';

				that.qs1 = $selectableSearch.quicksearch(selectableSearchString)
					.on('keydown', function(e) {
						if (e.which === 40) {
							that.$selectableUl.focus();
							return false;
						}
					});

				that.qs2 = $selectionSearch.quicksearch(selectionSearchString)
					.on('keydown', function(e) {
						if (e.which == 40) {
							that.$selectionUl.focus();
							return false;
						}
					});
			},
			afterSelect: function() {
				this.qs1.cache();
				this.qs2.cache();
			},
			afterDeselect: function() {
				this.qs1.cache();
				this.qs2.cache();
			}
		});
		// Enable radios
		$element.find( 'input[type="radio"], input[type="checkbox"]' ).not('.onoffswitch-checkbox').not($element.find('.ui-tabs-panel input[type="radio"], .ui-tabs-panel input[type="checkbox"]')).checkboxradio({
			icon: false
		});
		// Control group
		var controlgroupEachFn = function(){
			$( this ).controlgroup();
		};
		var $controlgroup = $element.find( '.switch-field, .controlgroup' ).not($element.find('.ui-tabs-panel .switch-field, .ui-tabs-panel .controlgroup'));
		$controlgroup.filter( ':hidden' ).one( 'visible', controlgroupEachFn );
		$controlgroup.filter( ':visible' ).each( controlgroupEachFn );

		// Enable spinner
		var spinnerEachFn = function(){
			var $spinner = $(this),
				options = $spinner.data('options');

			if (options)
				options = eval("({" + options + "})");
			else
				options = {};

			var max = parseFloat(options.max) || null,
				min = parseFloat(options.min) || 0,
				step = parseFloat(options.step) || 1;

			$spinner.spinner({
				min: min,
				max: max,
				step: step,
				stop: function( event, ui ) {
					$spinner.trigger('change');
				}
			});
		};
		$element.find( 'input[rel="number"]' ).not($element.find('.ui-tabs-panel input[rel="number"]')).each(spinnerEachFn);

		// Enable range slider
		var rangeEachFn = function(){
			var $input = $(this),
				$slider = $('<div></div>'),
				options = $input.data('options'),
				value = eval($input.val());

			if (options)
				options = eval("({" + options + "})");
			else
				options = {};

			var range = options.range || false,
				max = parseFloat(options.max) || 100,
				min = parseFloat(options.min) || 0,
				step = parseFloat(options.step) || 1,
				pips = options.pips || false,
				type = options.type || "",
				forceTip = options.forceTip || false;

			$slider.insertAfter( $input );
			$input.hide();

			if ( options.class )
				$slider.addClass( options.class );

			if ( forceTip )
				$slider.addClass( 'ui-slider-force-tip' );

			if ( type === 'circle' )
				$slider.addClass( 'ui-circle-slider' );
			else if ( type === 'scale' )
				$slider.addClass( 'ui-scale-slider' );

			var sliderOptions = {
				range: range,
				min: min,
				max: max,
				step: step,
				slide: function( event, ui ) {
					if ( ui.values )
						$input.val( JSON.stringify( ui.values ) );
					else
						$input.val( ui.value );
				},
				stop: function( event, ui ) {
					$input.trigger('change');
				}
			};

			sliderOptions[$.isArray( value ) ? 'values' : 'value'] = value;

			$slider.slider(sliderOptions);

			if (pips)
				$slider.slider("pips", pips).slider("float");
		};
		$element.find( 'input[rel="range"]' ).not($element.find('.ui-tabs-panel input[rel="range"]')).each(rangeEachFn);

		// Enable textarea
		var textareaEachFn = function() {
			var element = this,
				$this = $( element ),
				$parent = $this.parents('.inside'),
				className = element.className;

			if ( $this.is('.css, .html, .javascript, .twig') ) {
				var options = {
						selectionPointer: true,
						styleActiveLine: true,
						lineNumbers: true,
						matchBrackets: true,
						matchTags: {bothTags: true},
						indentUnit: 4,
						indentWithTabs: true,
						autoCloseBrackets: true,
						autoCloseTags: true,
						keyMap: 'sublime',
						extraKeys: {
							"Ctrl-Space": "autocomplete",
							"Ctrl-K": function (cm, event) {
								cm.state.colorpicker.popup_color_picker();
							}
						},
						viewportMargin: Infinity,
						theme: "mdn-like"
					};

				if (className.indexOf('css') !== -1) {
					options.mode = "text/x-less";
					options.colorpicker = {
						mode: 'edit'
					};
				}
				else if (className.indexOf('javascript') !== -1) {
					options.mode = "text/javascript";
				}
				else if (className.indexOf('twig') !== -1) {
					//options.mode = { name: "twig", htmlMode: true, alignCDATA: true };
					CodeMirror.defineMode("htmltwig", function(config, parserConfig) {
						return CodeMirror.overlayMode(CodeMirror.getMode(config, parserConfig.backdrop || "text/html"), CodeMirror.getMode(config, "twig"));
					});
					options.mode = { name: "htmltwig", htmlMode: true, alignCDATA: true };
				}
				else if (className.indexOf('html') !== -1) {
					options.mode = { name: "htmlmixed", alignCDATA: true };
				}

				var editor = CodeMirror.fromTextArea(element, options);

				//editor.setSize(width);
				editor.display.wrapper.style.maxWidth = ($parent.width() - 210) + "px";

				$this.data('editor', editor);

				editor.on("change", function(instance, changeObj) {
					$this.val(editor.getValue()).trigger('input');
				});

				editor.on("keyup", function (cm, event) {
					if ( !cm.state.completionActive && event.keyCode != 13) {
						cm.showHint({completeSingle: false});
					}
				});

				$this.on('update', function(){
					editor.setValue($this.val());
					editor.refresh();
				});

				$win.on('resize', $.debounce( 250, function(){
					editor.display.wrapper.style.maxWidth = ($parent.width() - 210) + "px";
				} ) );
			}

			// Enable elastic
			else {
				var initialHeight = initialHeight || $this.height(),
					delta = parseInt( $this.css('paddingBottom') ) + parseInt( $this.css( 'paddingTop' ) ) || 0,
					resize = function() {
						$this.height( initialHeight );
						$this.height( element.scrollHeight - delta );
					};

				$this.on( 'input change keyup', resize );
				resize();
			}
		};
		var $textarea = $element.find( 'textarea' ).not($element.find('.ui-tabs-panel textarea'));
		$textarea.filter(':hidden').one('visible', textareaEachFn);
		$textarea.filter(':visible').each(textareaEachFn);

		// Enable colorpicker
		$element.find( '[rel="colorpicker"]' ).not($element.find('.ui-tabs-panel [rel="colorpicker"]')).minicolors({
			control: 'hue',
			format: 'rgb',
			inline: false,
			opacity: true,
			theme: 'bootstrap',
			changeDelay: 300,
			change: function(value, opacity) {
				$(this).trigger('change');
			}
		});

		// Enable datepicker
		$element.find( '[rel="datepicker"]' ).not($element.find('.ui-tabs-panel [rel="datepicker"]')).datepicker({
			changeMonth: true,
			changeYear: true
		});

		// Enable datepicker range
		var dateRangeFn = function(){
			var $this = $(this),
				dateFormat = "mm/dd/yy",
				$from = $this.find( '[rel="from_date"]' ).datepicker({
					defaultDate: "+1w",
					changeMonth: true,
					changeYear: true
				})
				.on( "change", function() {
					$to.datepicker( "option", "minDate", getDate( this ) );
				}),
				$to = $this.find( '[rel="to_date"]' ).datepicker({
					defaultDate: "+1w",
					changeMonth: true,
					changeYear: true
				})
				.on( "change", function() {
					$from.datepicker( "option", "maxDate", getDate( this ) );
				});

			function getDate( element ) {
				var date;

				try {
					date = $.datepicker.parseDate( dateFormat, element.value );
				} catch( error ) {
					date = null;
				}

				return date;
			}
		};
		$element.find( '[rel="date_range"]' ).not($element.find('.ui-tabs-panel [rel="date_range"]')).each(dateRangeFn);

		// Enable image chooser
		var imageChooserEachFn = function(){
			var $input = $(this),
				value = $input.val() || '{}',
				data = JSON.parse(value),
				isSmall = $input[0].hasAttribute('small'),
				classList = ['ui-image-chooser'],
				$thumbnailShower;

			if (isSmall)
				classList.push('small');

			var $holder = $('<div/>',{
					 class: classList.join(' '),
					 html: '<a></a><span></span>'
				});

			$thumbnailShower = $holder.find('span');

			if(value && data.thumb) {
				$holder.addClass('setted');
				$thumbnailShower.css('backgroundImage', "url('" + data.thumb + "')");
			}

			$input.after($holder).detach().prependTo($holder).prop( { 'type': 'hidden' } ).addClass('initialized');
			$input.on('change', function(){
				value = $input.val() || '{}',
				data = JSON.parse(value);

				if (data.image)
					$holder.addClass('setted');
				else
					$holder.removeClass('setted');

				if(data.thumb || data.image)
					$thumbnailShower.css('backgroundImage', "url('" + (data.thumb || data.image) + "')");
				else
					$thumbnailShower.css('backgroundImage', "");
			});
			$holder.on('click', '> span, > a', function(){
				var $parent = $(this).parent(),
					tagName = this.tagName.toLowerCase();

				if (!$parent.hasClass('setted') || tagName === 'span')
					imageChooser(data.id, function(attachment) {
						if (attachment) {
							var sizes = attachment.sizes;
							var size = sizes.large && 'large' || sizes.medium && 'medium' || sizes.thumbnail && 'thumbnail' || 'full';
							var image = sizes[size].url;
							var thumbnail = sizes.medium && sizes.medium.url || sizes.thumbnail && sizes.thumbnail.url || sizes.large && sizes.large.url || sizes.full.url;

							$input.val(JSON.stringify({ image:image, id:attachment.id, thumb:thumbnail })).trigger('change');
						}
					});
				else if ($parent.hasClass('setted') && tagName === 'a')
					$input.val('').trigger('change');
			});
		};
		$element.find( '[rel="image"]' ).not($element.find('.ui-tabs-panel [rel="image"]')).each(imageChooserEachFn);

		// Tooltip
		$element.tooltip({
			position: {
				my: "center bottom-20",
				at: "center top",
				using: function( position, feedback ) {
					$( this ).css( position );
					$( "<div>" )
					.addClass( "arrow" )
					.addClass( feedback.vertical )
					.addClass( feedback.horizontal )
					.appendTo( this );
				}
			},
			content: function () {
				return $(this).prop('title');
			}
		});

		$element.addClass('ui-initialized');
	}

	$doc.ready(function() {
		$body = $(document.body);

		var $wgextra = $doc.find('#wgextra'),
			$template_settings_form = $wgextra.find('#wgextra_template_form').find('#wgextra-settings, #wgextra-display'),
			$template_styling_form = $wgextra.find('#wgextra_template_form #wgextra-styling'),
			$source_settings_form = $wgextra.find('#wgextra_template_form #wgextra-source'),
			$images_sizes_form = $wgextra.find('#wgextra_images_sizes_form'),
			$settings_form = $wgextra.find('#wgextra_settings_form'),
			$template_settings_fields = $template_settings_form.find('.field'),
			$template_styling_fields = $template_styling_form.find('.field'),
			$source_settings_fields = $source_settings_form.find('.field'),
			$template_settings_inputs = $template_settings_form.find('input, select, textarea'),
			$template_styling_inputs = $template_styling_form.find('input, select, textarea'),
			$source_settings_inputs = $source_settings_form.find('input, select, textarea'),
			$settings_inputs = $settings_form.find('input, select, textarea'),
			$sizes_to_rebuild = $wgextra.find('#sizes_to_rebuild'),
			$custom_gallery_structure = $wgextra.find('#custom_gallery_structure'),
			$button_box = $wgextra.find('.button_box'),
			defaults = $wgextra.find('form.warn-about-change').serializeJSON(true),
			animationDuration = 0,
			animationEffect = null;

		ui_initialize($wgextra);
		$wgextra.find(".box-title").sticky({ topSpacing: $FIND('#wpadminbar').height() });

		setTimeout(function(){
			animationDuration = 300;
			animationEffect = "blind";
		}, 1000);

		var $tilt_inside = $template_settings_fields.filter('[rel="tilt"]').find('.inside-table'),
			$lightbox_magnific = $template_settings_fields.find('#magnific-popup-settings'),
			$lightbox_photoswipe = $template_settings_fields.find('#photoswipe-settings'),
			$lightbox_fancybox = $template_settings_fields.find('#fancybox-settings'),
			$lightbox_ilightbox = $template_settings_fields.find('#ilightbox-settings'),
			$lightbox_custom = $template_settings_fields.find('#custom_lightbox'),
			$slider_styles = $template_styling_form.find('#slider-styles'),
			$thumbnail_ratio_inside = $template_settings_fields.filter('[rel="thumbnail_ratio"]').find('.inside-table'),
			$grouped_items_template = $template_settings_form.find('[rel="grouped_items_template"]'),
			$wgextra_link_url = $template_settings_form.find('.wgextra_link_url');

		$template_settings_form
			.on('change', 'input, select', $.debounce( 50, function(event) {
				var name = this.name,
					data = $template_settings_inputs.serializeJSON(true);


				// Handle templates fields
				if (name === 'wgextra_template') {
					var fields = getVisibleFields('template', data.wgextra_template);

					$template_settings_fields.addClass('hidden').filter(fields).removeClass('hidden');

					// Slider styles
					$slider_styles[data.wgextra_template === 'slider' ? 'removeClass' : 'addClass']('hidden');
				}

				// Grid loading animation
				$template_settings_fields.filter('[rel="loading_grid_animation"]')[data.wgextra_loading_type !== 'none' ? 'removeClass' : 'addClass']('hidden');

				// Use low-res preview image
				$template_settings_fields.filter('[rel="use_lowres_image"]')[data.wgextra_loading_type === 'lazyload' ? 'removeClass' : 'addClass']('hidden');

				// Gallery Structure
				$custom_gallery_structure[data.wgextra_structure_type === 'auto' ? 'hide' : 'show'](animationEffect, animationDuration);

				// Magnific Lightbox
				$lightbox_magnific[data.wgextra_lightbox_type != 'magnific' ? 'hide' : 'show']();
				$lightbox_photoswipe[data.wgextra_lightbox_type != 'photoswipe' ? 'hide' : 'show']();
				$lightbox_fancybox[data.wgextra_lightbox_type != 'fancybox' ? 'hide' : 'show']();
				$lightbox_ilightbox[data.wgextra_lightbox_type != 'ilightbox' ? 'hide' : 'show']();

				// Custom Lightbox
				$lightbox_custom[data.wgextra_lightbox_type != 'custom' ? 'hide' : 'show'](animationEffect, animationDuration);

				// Tilt
				$tilt_inside[data.wgextra_tilt_effect === 'yes' ? 'show' : 'hide'](animationEffect, animationDuration);

				// Link Custom URL
				$wgextra_link_url[data.wgextra_link_to === 'custom' ? 'removeClass' : 'addClass']('hidden');

				// Caption source
				$template_settings_fields.filter('[rel="caption_custom"]')[data.wgextra_caption_source === 'custom' ? 'removeClass' : 'addClass']('hidden');

				// Thumbnail Ratio
				$thumbnail_ratio_inside[data.wgextra_thumbnail_ratio === 'manual' ? 'show' : 'hide'](animationEffect, animationDuration);

				// Grouped Items Template
				$grouped_items_template[data.wgextra_grouped_items_mode === 'slider' ? 'removeClass' : 'addClass']('hidden');
			} ) );

		// trigger first change for initilization
		$template_settings_inputs.filter('[name="wgextra_template"]').trigger('change');



		var $border_inside = $template_styling_fields.filter('[rel="border"]').find('.inside-table'),
			$shadow_inside = $template_styling_fields.filter('[rel="shadow"]').find('.inside-table'),
			$placeholder_inside = $template_styling_fields.filter('[rel="placeholder"]').find('.inside-table'),
			$icon_inside = $template_styling_fields.filter('[rel="icon"]').find('.inside-table'),
			$overlay_inside = $template_styling_fields.filter('[rel="overlay"]').find('.inside-table:eq(0)'),
			$overlay_background_inside = $template_styling_fields.filter('[rel="overlay"]').find('#wgextra_style_overlay_background .inside-table'),
			$caption_inside = $template_styling_fields.filter('[rel="caption"]').find('.inside-table:eq(0)'),
			$caption_background_inside = $template_styling_fields.filter('[rel="caption"]').find('#wgextra_style_caption_background .inside-table'),
			$scrollbar_track_color_inside = $slider_styles.find('#wgextra_style_slider_scrollbar_track_color .inside-table'),
			$scrollbar_handle_color_inside = $slider_styles.find('#wgextra_style_slider_scrollbar_handle_color .inside-table'),
			$time_loader_loader_color_inside = $slider_styles.find('#wgextra_style_slider_time_loader_loader_color .inside-table');

		$template_styling_form
			.on('change', 'input, select', $.debounce( 50, function(event, isTrigger) {
				var name = this.name,
					data = $template_styling_inputs.serializeJSON(true);

				if (name == 'wgextra_style') {
					var preset = JSON.parse(data.preset_styles);
					if (preset[data.wgextra_style] && preset[data.wgextra_style].form_data)
						$template_styling_inputs.setValues(preset[data.wgextra_style].form_data);
				}
				else {
					if (!isTrigger) {
						$template_styling_inputs.filter('[name="wgextra_style"][value="default"]').prop('checked', true);
						$template_styling_inputs.filter('[name="wgextra_style"]').checkboxradio('refresh', true);
					}
				}

				// Border
				$border_inside[data.wgextra_style_border ? 'show' : 'hide'](animationEffect, animationDuration);

				// Shadow
				$shadow_inside[data.wgextra_style_shadow ? 'show' : 'hide'](animationEffect, animationDuration);

				// Placeholder
				$placeholder_inside[data.wgextra_style_use_placeholder ? 'show' : 'hide'](animationEffect, animationDuration);

				// Icon
				$icon_inside[data.wgextra_style_icon ? 'show' : 'hide'](animationEffect, animationDuration);

				// Overlay
				$overlay_inside[data.wgextra_style_overlay ? 'show' : 'hide'](animationEffect, animationDuration);
				// Caption background
				if (data.wgextra_style_overlay_background === 'solid') {
					$overlay_background_inside.filter('#wgextra_style_overlay_background_solid').show();
					$overlay_background_inside.filter('#wgextra_style_overlay_background_gradient').hide();
				}
				else if (data.wgextra_style_overlay_background === 'gradient') {
					$overlay_background_inside.filter('#wgextra_style_overlay_background_solid').hide();
					$overlay_background_inside.filter('#wgextra_style_overlay_background_gradient').show();
				}
				else {
					$overlay_background_inside.hide();
				}

				// Caption
				$caption_inside[data.wgextra_style_caption ? 'show' : 'hide'](animationEffect, animationDuration);
				// Caption background
				if (data.wgextra_style_caption_background === 'solid') {
					$caption_background_inside.filter('#wgextra_style_caption_background_solid').show();
					$caption_background_inside.filter('#wgextra_style_caption_background_gradient').hide();
				}
				else if (data.wgextra_style_caption_background === 'gradient') {
					$caption_background_inside.filter('#wgextra_style_caption_background_solid').hide();
					$caption_background_inside.filter('#wgextra_style_caption_background_gradient').show();
				}
				else {
					$caption_background_inside.hide();
				}

				// Scrollbar track color
				if (data.wgextra_style_slider_scrollbar_track_color === 'solid') {
					$scrollbar_track_color_inside.filter('#wgextra_style_slider_scrollbar_track_color_solid').show();
					$scrollbar_track_color_inside.filter('#wgextra_style_slider_scrollbar_track_color_gradient').hide();
				}
				else if (data.wgextra_style_slider_scrollbar_track_color === 'gradient') {
					$scrollbar_track_color_inside.filter('#wgextra_style_slider_scrollbar_track_color_solid').hide();
					$scrollbar_track_color_inside.filter('#wgextra_style_slider_scrollbar_track_color_gradient').show();
				}
				else {
					$scrollbar_track_color_inside.hide();
				}

				// Scrollbar handle color
				if (data.wgextra_style_slider_scrollbar_handle_color === 'solid') {
					$scrollbar_handle_color_inside.filter('#wgextra_style_slider_scrollbar_handle_color_solid').show();
					$scrollbar_handle_color_inside.filter('#wgextra_style_slider_scrollbar_handle_color_gradient').hide();
				}
				else if (data.wgextra_style_slider_scrollbar_handle_color === 'gradient') {
					$scrollbar_handle_color_inside.filter('#wgextra_style_slider_scrollbar_handle_color_solid').hide();
					$scrollbar_handle_color_inside.filter('#wgextra_style_slider_scrollbar_handle_color_gradient').show();
				}
				else {
					$scrollbar_handle_color_inside.hide();
				}

				// Time Loader loader color
				if (data.wgextra_style_slider_time_loader_loader_color === 'solid') {
					$time_loader_loader_color_inside.filter('#wgextra_style_slider_time_loader_loader_color_solid').show();
					$time_loader_loader_color_inside.filter('#wgextra_style_slider_time_loader_loader_color_gradient').hide();
				}
				else if (data.wgextra_style_slider_time_loader_loader_color === 'gradient') {
					$time_loader_loader_color_inside.filter('#wgextra_style_slider_time_loader_loader_color_solid').hide();
					$time_loader_loader_color_inside.filter('#wgextra_style_slider_time_loader_loader_color_gradient').show();
				}
				else {
					$time_loader_loader_color_inside.hide();
				}

				return false;
			} ) );

		// trigger first change for initilization
		$template_styling_inputs.filter('[name="wgextra_style"]:checked').trigger('change');


		var $post_types_select = $source_settings_form.find('select#wgextra_post_types'),
			$taxonomy_terms_select = $source_settings_form.find('select#wgextra_taxonomies'),
			$wgextra_ordering_meta_key = $source_settings_form.find('.wgextra_ordering_meta_key');

		$source_settings_form
			.on('change', 'input, select', $.debounce( 50, function(event) {
				var name = this.name,
					data = $source_settings_inputs.serializeJSON(true);

					console.log(event);

				// Handle sources fields
				if (name === 'wgextra_source') {
					var fields = getVisibleFields('source', data.wgextra_source);

					$source_settings_fields.addClass('hidden').filter(fields).removeClass('hidden');

					if (data.wgextra_source === 'woocommerce') {
						$post_types_select.multiSelect('deselect_all');
						$post_types_select.multiSelect('select', ['product']);
					}

					if (event.isTrigger)
						set_taxonomies_selectbox($taxonomy_terms_select, data);
				}

				// Handle sources fields
				else if (name === 'wgextra_post_types') {
					set_taxonomies_selectbox($taxonomy_terms_select, data);
				}

				// Handle sources ordering order by field
				$wgextra_ordering_meta_key[(data.wgextra_ordering_order_by || '').indexOf('meta_value') !== -1 || (data.wgextra_ordering_order_by_fallback || '').indexOf('meta_value') !== -1 ? 'removeClass' : 'addClass']('hidden');

			} ) );

		// trigger first change for initilization
		$source_settings_inputs.filter('[name="wgextra_source"]:checked').trigger('change');


		$settings_form
			.on('change', 'input, select', $.debounce( 50, function(event) {
				var name = this.name,
					data = $settings_inputs.serializeJSON(true);

			} ) );

		// trigger first change for initilization
		$settings_inputs.eq(0).trigger('change');

		var $submitButton = $wgextra.find('button[type="submit"]').eq(0),
			lada = $submitButton[0] ? Ladda.create( $submitButton[0] ) : null,
			windowPrompt = false;

		$win.on('beforeunload', function (e) {
			if (!windowPrompt)
				return undefined;

			var confirmationMessage = i18n('It looks like you have been editing something. If you leave before saving, your changes will be lost.');

			(e || window.event).returnValue = confirmationMessage; //Gecko + IE
			return confirmationMessage; //Gecko + Webkit, Safari, Chrome etc.
		});

		$doc.find('#wgextra')
		.on('change', 'form.warn-about-change', $.debounce( 250, function() {
			var $form = $(this),
				data = $form.serializeJSON(true),
				equal = JSON.stringify( defaults ) === JSON.stringify( data );
				console.log(data, defaults);

			// Settings changed notification
			$FIND('#wgextra-settings-notice')[equal ? 'hide' : 'show']();
			windowPrompt = !equal;
		} ))
		.on('submit', 'form', function() {
			var $form = $(this),
				$message = $form.find('.wgextra_ajax_message'),
				serialize = $form.serializeJSON();

			delete serialize.preset_styles;

			console.log('submit', $form);

			if(lada)
				lada.start();
			serialize.action = "wgextra";

			$.ajax({
				method: "POST",
				url: ajaxurl,
				data: serialize,
				xhr: function() {
					var xhr = $.ajaxSettings.xhr(),
						percent = 0;
					xhr.upload.addEventListener("progress", function(evt) {
						if (evt.lengthComputable) {
							percent = evt.loaded / evt.total;
							if(lada)
								lada.setProgress( percent );
						}
					}, false);

					return xhr;
				}
			})
			.done(function(data) {
				if(lada)
					lada.stop();
				var message = '<strong>' + data.message + '</strong>';

				if (data.status === 200) {
					new Noty({
						text: message,
						type: 'success',
						layout: 'bottomCenter',
						theme: 'mint',
						timeout: 5000,
						progressBar: true,
						killer: true
					}).show();
					defaults = $form.serializeJSON(true);
					windowPrompt = false;
					$FIND('#wgextra-settings-notice').hide();

					if (serialize.wgextra_task === 'start_regenerator') {
						start_regenerator(data);
					}
					else if (serialize.wgextra_task === 'save_images_sizes') {
						var newSizes = [],
							newOption = '<option value="<%= size %>" selected="selected"><%= name %></option>',
							newOptionsHTML = '';

						$.each(serialize.image_size, function(key, value){
							if (!value.delete)
								newOptionsHTML += _.template(newOption)({
									size: key,
									name: value.name
								});
						});

						$sizes_to_rebuild.html(newOptionsHTML);
						$sizes_to_rebuild.multiSelect("refresh");

						$form.find('.self_created input[type="checkbox"].delete-switch:checked').each(function () {
							$(this).parents('tr').eq(1).remove();
						});
					}
				} else {
					if (data.error)
						message += '<ul>' + data.error.join('') + '</ul>';
					new Noty({
						text: message,
						type: 'error',
						layout: 'bottomCenter',
						theme: 'mint',
						timeout: 5000,
						progressBar: true,
						killer: true
					}).show();
				}
			})
			.fail(function(data) {
				if(lada)
					lada.stop();
				new Noty({
					text: i18n('Request failed, please try again.'),
					type: 'error',
					layout: 'bottomCenter',
					theme: 'mint',
					killer: true
				}).show();
			});

			return false;
		})
		.on('click', 'button[type="submit"]', function() {
			$wgextra.find('form').eq(0).submit();
		})
		.on('click', '#wgextra_new_template, #wgextra_new_source', function() {
			var $this = $(this),
				id = this.id,
				$table = $wgextra.find('table').first(),
				$empty = $wgextra.find('#empty_templates, #empty_sources'),
				type = id === 'wgextra_new_template' ? 'template' : 'source';

			ui_prompt(
				i18n(type === 'template' ? 'Create a new template' : 'Create a new source'),
				i18n(type === 'template' ? 'Please enter your new template name.' : 'Please enter your new source name.'),
				'',
				function (response) {
					if (response) {
						showProcessing();

						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								name: response,
								wgextra_task: type === 'template' ? "create_new_template" : "create_new_source",
								wgextra_nonce: type === 'template' ? wgextra.nonce.create_new_template : wgextra.nonce.create_new_source
							}
						})
						.done(function(data) {
							hideProcessing();

							if (data.status === 200) {
								var html = $(type === 'template' ? 'script#new_template_row' : 'script#new_source_row').html();
								html = _.template(html)(data);
								var $html = $(html);

								$table.show().prepend($html);
								ui_initialize($html);
								$empty.hide();
							} else {
								ui_alert(data.message);
							}
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert(i18n('Request failed, please try again.'));
						});
					}
				}
			);
		})
		.on('click', '#wgextra_import_template', function() {
			showProcessing();

			$.ajax({
				method: "GET",
				url: 'https://wgextra.iprodev.com/templates/',
				data: {
					version: wgextra.version
				}
			})
			.done(function(response) {
				hideProcessing();

				if (response.status === 200) {
					console.log(response);
					show_templates(response.templates);
				} else {
					ui_alert(response.message);
				}
			})
			.fail(function(response) {
				hideProcessing();
				ui_alert(i18n('Request failed, please try again.'));
			});
		})
		.on('click', '[rel="duplicate_template"],[rel="duplicate_source"]', function() {
			var $this = $(this),
				$table = $wgextra.find('table').first(),
				item_id = $this.attr('identifier'),
				rel = this.rel,
				type = rel === 'duplicate_template' ? 'template' : 'source';

			ui_confirm(
				i18n(type === 'template' ? 'Duplicate Template' : 'Duplicate Source'),
				i18n(type === 'template' ? 'Are you sure you want to duplicate this gallery template?' : 'Are you sure you want to duplicate this grid source?'),
				function (response) {
					if (response) {
						showProcessing();

						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								id: item_id,
								wgextra_task: type === 'template' ? "duplicate_template" : "duplicate_source",
								wgextra_nonce: type === 'template' ? wgextra.nonce.duplicate_template : wgextra.nonce.duplicate_source
							}
						})
						.done(function(data) {
							hideProcessing();

							if (data.status === 200) {
								var html = $(type === 'template' ? 'script#new_template_row' : 'script#new_source_row').html();
								html = _.template(html)(data);
								var $html = $(html);

								$table.prepend($html);
								ui_initialize($html);
							} else {
								ui_alert(data.message);
							}
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert(i18n('Request failed, please try again.'));
						});
					}
				}
			);
		})
		.on('click', '[rel="delete_template"],[rel="delete_source"]', function() {
			var $this = $(this),
				rel = this.rel,
				type = rel === 'delete_template' ? 'template' : 'source',
				$table = $wgextra.find('table'),
				$empty = $wgextra.find(type === 'template' ? '#empty_templates' : '#empty_sources'),
				$parent = $this.parents('tr').last(),
				item_id = $this.attr('identifier');

			ui_confirm(
				i18n(type === 'template' ? 'Delete Template' : 'Delete Source'),
				i18n(type === 'template' ? 'Are you sure you want to delete this gallery template?' : 'Are you sure you want to delete this grid source?'),
				function (response) {
					if (response) {
						showProcessing();

						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								id: item_id,
								wgextra_task: type === 'template' ? "delete_template" : "delete_source",
								wgextra_nonce: type === 'template' ? wgextra.nonce.delete_template : wgextra.nonce.delete_source
							}
						})
						.done(function(data) {
							hideProcessing();

							if (data.status === 200) {
								if ( $parent.parent().children('tr').length === 1 ) {
									$table.hide();
									$empty.show();
								}
								$parent.remove();
							} else {
								ui_alert(data.message);
							}
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert(i18n('Request failed, please try again.'));
						});
					}
				}
			);
		})
		.on('click', '.add-css-selector', function() {
			var $this = $(this),
				rel = $this.attr('rel'),
				$textarea = $this.parents('td').find('textarea'),
				editor = $textarea.data('editor'),
				content = editor.getValue(),
				cursor = $.extend({}, editor.getCursor()),
				lastLine = editor.lastLine();

			cursor.line = lastLine === 0 ? lastLine + 1 : lastLine + 2;
			cursor.ch = 2;

			if (rel === 'gallery')
				content += "\n%gallery% {\n\t\n}";
			else if (rel === 'item') {
				content += "\n%gallery% {\n\t.wgextra-item {\n\t\t\n\t}\n}";
				cursor.line = lastLine === 0 ? lastLine + 2 : lastLine + 3;
				cursor.ch = 3;
			}
			else if (rel === 'thumb') {
				content += "\n%gallery% {\n\t.wgextra-item {\n\t\t.wgextra-thumb {\n\t\t\t\n\t\t}\n\t}\n}";
				cursor.line = lastLine === 0 ? lastLine + 3 : lastLine + 4;
				cursor.ch = 4;
			}
			else if (rel === 'thumb-image') {
				content += "\n%gallery% {\n\t.wgextra-item {\n\t\t.wgextra-thumb {\n\t\t\timg {\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t}\n}";
				cursor.line = lastLine === 0 ? lastLine + 4 : lastLine + 5;
				cursor.ch = 5;
			}
			else if (rel === 'thumb-overlay') {
				content += "\n%gallery% {\n\t.wgextra-item {\n\t\t.wgextra-thumb {\n\t\t\t&:after {\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t}\n}";
				cursor.line = lastLine === 0 ? lastLine + 4 : lastLine + 5;
				cursor.ch = 5;
			}
			else if (rel === 'inner-caption') {
				content += "\n%gallery% {\n\t.wgextra-item {\n\t\t.wgextra-thumb {\n\t\t\t.wgextra-caption-inner {\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t}\n}";
				cursor.line = lastLine === 0 ? lastLine + 4 : lastLine + 5;
				cursor.ch = 5;
			}
			else if (rel === 'outer-caption') {
				content += "\n%gallery% {\n\t.wgextra-item {\n\t\tfigcaption.wp-caption-text {\n\t\t\t\n\t\t}\n\t}\n}";
				cursor.line = lastLine === 0 ? lastLine + 3 : lastLine + 4;
				cursor.ch = 4;
			}
			else if (rel === 'icon') {
				content += "\n%gallery% {\n\t.wgextra-item {\n\t\t.wgextra-thumb {\n\t\t\t.wgextra-icon:before {\n\t\t\t\t\n\t\t\t}\n\t\t}\n\t}\n}";
				cursor.line = lastLine === 0 ? lastLine + 4 : lastLine + 5;
				cursor.ch = 5;
			}

			if (lastLine === 0)
				content = $.trim(content);

			editor.setValue(content);
			editor.setCursor(cursor);
			editor.focus();
		})
		.on('click', '#css-to-less', function() {
			var $this = $(this),
				$textarea = $this.parents('td').find('textarea'),
				editor = $textarea.data('editor'),
				value = editor.getValue();

			ui_confirm(
				i18n('Convert to LESS'),
				i18n('Are you sure you want to convert your CSS to LESS?'),
				function (response) {
					if (response) {
						showProcessing();

						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								css: value,
								wgextra_task: "convert_to_less",
								wgextra_nonce: wgextra.nonce.general
							}
						})
						.done(function(data) {
							hideProcessing();

							console.log(data);
							if (data.status === 200) {
								editor.setValue(data.less);
								editor.setCursor({ line:0, ch:0 });
								editor.focus();
							} else {
								ui_alert(data.message);
							}
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert(i18n('Request failed, please try again.'));
						});
					}
				}
			);
		})
		.on('click', '#add_new_image_size', function() {
			var $parent = $(this).parents('tr').eq(0);

			ui_prompt(
				i18n('Register a new image size'),
				i18n('Please enter a valid ID for your new image size.'),
				'',
				function (response) {
					if (response) {
						showProcessing();

						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								id: response,
								wgextra_task: "verify_image_size_id",
								wgextra_nonce: wgextra.nonce.verify_image_size_id
							}
						})
						.done(function(data) {
							hideProcessing();

							if (data.status === 200) {
								var template = $FIND('script#new_image_size_row').html();
								template = _.template(template)(data);
								var $template = $(template);

								$parent.before($template);
								ui_initialize($template);

								var serialize = $images_sizes_form,
									newOption = '<option for="<%= size %>" selected="selected"><%= name %></option>',
									newOptionHTML = _.template(newOption)({
										size: data.id,
										name: data.id
									});

								$sizes_to_rebuild.append(newOptionHTML);
								$sizes_to_rebuild.multiSelect("refresh");
							} else {
								ui_alert(data.message);
							}
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert(i18n('Request failed, please try again.'));
						});
					}
				}
			);
		})
		.on('click', '#backup_thumbnails', function() {
			var $parent = $(this).parent();

			ui_confirm(
				i18n('Backup Thumbnails'),
				i18n('Are you sure you want to backup your current thumbnails?'),
				function (response) {
					if (response) {
						showProcessing();

						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								wgextra_task: "backup_thumbnails",
								wgextra_nonce: wgextra.nonce.backup
							}
						})
						.done(function(data) {
							hideProcessing();

							if (data.status === 200) {
								$parent.find('#restore_backup, #delete_backup').removeAttr('disabled');
								$parent.find('#last-backup em').text(data.time);
							}
							
							if (data.message)
								ui_alert(data.message);
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert( i18n( 'Request failed, please try again.' ) );
						});
					}
				}
			);
		})
		.on('click', '#restore_backup:not([disabled])', function() {
			ui_confirm(
				i18n('Restore Backup'),
				i18n('Are you sure you want to restore your last backup?'),
				function (response) {
					if (response) {
						showProcessing();

						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								id: response,
								wgextra_task: "restore_backup",
								wgextra_nonce: wgextra.nonce.restore
							}
						})
						.done(function(data) {
							hideProcessing();

							if (data.message)
								ui_alert(data.message);
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert(i18n('Request failed, please try again.'));
						});
					}
				}
			);
		})
		.on('click', '#delete_backup:not([disabled])', function() {
			var $parent = $(this).parent();

			ui_confirm(
				i18n('Delete Backup'),
				i18n('Are you sure you want to delete your thumbnails backup?'),
				function (response) {
					if (response) {
						showProcessing();

						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								id: response,
								wgextra_task: "delete_backup",
								wgextra_nonce: wgextra.nonce.delete_backup
							}
						})
						.done(function(data) {
							hideProcessing();

							if (data.status === 200) {
								$parent.find('#restore_backup, #delete_backup').attr('disabled', 'disabled');
								$parent.find('#last-backup em').text(i18n('Never'));
							}

							if (data.message)
								ui_alert(data.message);
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert(i18n('Request failed, please try again.'));
						});
					}
				}
			);
		})
		.on('click', '#analyze_thumbnails', function() {
			var $parent = $(this).parents('td.parent').eq(0),
				$analysis_results = $parent.find('#analysis_results'),
				after_date = $parent.find('[name="after_date"]').val(),
				before_date = $parent.find('[name="before_date"]').val();

			showProcessing();

			$.ajax({
				method: "POST",
				url: ajaxurl,
				data: {
					action: "wgextra",
					after_date: after_date,
					before_date: before_date,
					wgextra_task: "analyze_thumbnails",
					wgextra_nonce: wgextra.nonce.clean_thumbnails
				}
			})
			.done(function(data) {
				hideProcessing();

				if (data.status === 200) {
					$parent.find('#delete_thumbnails_holder, #analysis_results').show();
					$analysis_results.find('#original_files').text(data.original_files);
					$analysis_results.find('#thumbnail_files').text(data.thumbnail_files);
					$analysis_results.find('#total_file_size').text(data.total_file_size);
				}

				if (data.message)
					ui_alert(data.message);
			})
			.fail(function(data) {
				hideProcessing();
				ui_alert(i18n('Request failed, please try again.'));
			});
		})
		.on('click', '#delete_thumbnails', function() {
			var $parent = $(this).parents('td.parent').eq(0),
				$analysis_results = $parent.find('#analysis_results'),
				after_date = $parent.find('[name="after_date"]').val(),
				before_date = $parent.find('[name="before_date"]').val();

			ui_confirm(
				i18n('Delete Thumbnails'),
				i18n('Are you sure you want to delete thumbnails?'),
				function (response) {
					if (response) {
						showProcessing();

						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								after_date: after_date,
								before_date: before_date,
								wgextra_task: "clean_thumbnails",
								wgextra_nonce: wgextra.nonce.clean_thumbnails
							}
						})
						.done(function(data) {
							hideProcessing();

							if (data.status === 200) {
								$analysis_results.find('#original_files').text(data.original_files);
								$analysis_results.find('#thumbnail_files').text(data.thumbnail_files);
								$analysis_results.find('#total_file_size').text(data.total_file_size);
							}

							if (data.message)
								ui_alert(data.message);
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert(i18n('Request failed, please try again.'));
						});
					}
				}
			);
		})
		.on('click', '#activate_wgextra', function() {
			var popupWidth = Math.min(screen.availWidth, 500),
				popupHeight = Math.min(screen.availHeight, screen.availHeight - 100, 885),
				top = screen.availHeight / 2 - popupHeight / 2,
				left = screen.availWidth / 2 - popupWidth / 2,
				popup = window.open("https://verify.iprodev.com?item=wgextra&site=" + encodeURIComponent(wgextra.site_url) + "&redirect_uri=" + encodeURIComponent(wgextra.activation_url), "license_activator", "width=" + popupWidth + ",height=" + popupHeight + ",top=" + top + ",left=" + left + ",menubar=no,location=no,resizable=yes,scrollbars=yes,status=no");
		})
		.on('click', '#deactivate_wgextra', function() {
			deactivate_product(wgextra.license_id, wgextra.license_nonce);
		})
		.on('click', '.license-notify', function() {
			window.location.href = wgextra.activation_page;
		})
		.on('click', '#check_iprodev_contact', function() {
			var $this = $(this),
				$parent = $this.parent(),
				$tr = $parent.parent();

			showProcessing();

			$.ajax({
				method: "POST",
				url: ajaxurl,
				data: {
					action: "wgextra",
					wgextra_task: "check_iprodev_server_contact",
					wgextra_nonce: wgextra.nonce.check_iprodev_server_contact
				}
			})
			.done(function(data) {
				hideProcessing();

				$this.remove();
				if (data.status == 200) {
					$parent.text(i18n('Yes'));
					$tr.find('.dashicons').addClass('dashicons-yes').parent().addClass('success');
				} else {
					$parent.text(i18n('No'));
					$tr.find('.dashicons').addClass('dashicons-no-alt').parent().addClass('alert');
				}
			})
			.fail(function() {
				hideProcessing();
				ui_alert(i18n('Request failed, please try again.'));
			});
		});

		window.activate_product = function (license_id, license_nonce) {
			if (!license_id || !license_nonce) {
				return;
			}

			showProcessing();

			$.ajax({
				method: "POST",
				url: ajaxurl,
				data: {
					action: "wgextra",
					license_id: license_id,
					license_nonce: license_nonce,
					wgextra_task: "activate_license",
					wgextra_nonce: wgextra.nonce.activate_license
				}
			})
			.done(function(data) {
				hideProcessing();

				if (data.status == 200) {
					$button_box.filter('.activation_box').hide();
					$button_box.filter('.deactivation_box').show();
					wgextra.license_id = license_id;
					wgextra.license_nonce = license_nonce;
				}

				if (data.message)
					ui_alert(data.message);
			})
			.fail(function(data) {
				hideProcessing();
				ui_alert(i18n('Request failed, please try again.'));
			});
		}

		window.deactivate_product = function (license_id, license_nonce) {
			if (!license_id || !license_nonce) {
				return;
			}

			showProcessing();

			$.ajax({
				method: "POST",
				url: ajaxurl,
				data: {
					action: "wgextra",
					license_id: license_id,
					license_nonce: license_nonce,
					wgextra_task: "deactivate_license",
					wgextra_nonce: wgextra.nonce.deactivate_license
				}
			})
			.done(function(data) {
				hideProcessing();

				if (data.status == 200) {
					$button_box.filter('.activation_box').show();
					$button_box.filter('.deactivation_box').hide();
					wgextra.license_id = "";
					wgextra.license_nonce = "";
				}

				if (data.message)
					ui_alert(data.message);
			})
			.fail(function(data) {
				hideProcessing();
				ui_alert(i18n('Request failed, please try again.'));
			});
		}

		window.iprodev_alert = function (errors) {
			if (!errors) {
				return;
			}

			if (!$.isArray(errors)) {
				errors = [errors];
			}

			var message = i18n(errors[0]);

			ui_alert(message);
		}

		/*start_regenerator({
			keep: true,
			list: [1, 2]
		});*/

		function start_regenerator(data) {
			var template = $FIND('script#regenator_dialog').html();

			template = _.template(template)({
				totalItems: data.list.length
			});

			var listLength = data.list.length,
				remain = data.list.length;

			$( template ).dialog({
				resizable: true,
				height: "auto",
				maxHeight: 400,
				width: 790,
				modal: true,
				closeOnEscape: false,
				classes: {
					"ui-dialog": "wgextra-dialog"
				},
				open: function( event, ui ) {
					var $dialog = $( this );

					var $successes = $dialog.find('#total-successes em');
					var $failures = $dialog.find('#total-failures em');
					var $logdiv = $dialog.find('.dialog-bottom');
					var $loglist = $logdiv.find('ol');
					var $progressbar = $dialog.find('progress');

					function check_progress() {
						if (remain <= 0)
							return;

						var current = listLength - remain,
							id = data.list[current];

						process_image_rebuild(id, data.sizes, function(data) {
							remain--;

							$progressbar[0].value = ((current + 1) / listLength) * 100;

							if (data.status == 200) {
								$loglist.append('<li>' + data.message + '</li>');
								$successes.text( parseInt( $successes.text() ) + 1 );
							}
							else {
								$loglist.append('<li class="failure">' + data.message + '</li>');
								$failures.text( parseInt( $failures.text() ) + 1 );
							}

							if (remain === 0)
								$logdiv.append('<p>' + i18n('Finished.') + '</p>');

							$logdiv[0].scrollTop = $logdiv[0].scrollHeight;

							if (remain > 0)
								check_progress();
						});
					}

					check_progress();

					$(window).on( 'resize.dialog scroll.dialog', $.debounce( 50, function(){
						$dialog.dialog("option", "position", { my: "center", at: "center", of: window });
					} ) );
				},
				close: function( event, ui ) {
					remain = 0;
					$( this ).remove();
					$(window).off('.dialog');
				}
			});
		}

		function process_image_rebuild(id, thumbnails, callback) {
			$.ajax({
				method: "POST",
				url: ajaxurl,
				data: {
					action: "wgextra",
					id: id,
					thumbnails: thumbnails,
					wgextra_task: "process_image_resize",
					wgextra_nonce: wgextra.nonce.process_image_resize
				}
			})
			.done(function(data) {
				callback(data);
			})
			.fail(function(data) {
				callback(false);
			});
		}

		function ui_prompt(title, message, defaultValue, callback) {
			var template = $FIND('script#prompt_dialog').html();

			template = _.template(template)({
				title: title,
				message: message,
				defaultValue: defaultValue || ''
			});

			var callbackSend = 0;

			$( template ).dialog({
				classes: {
					"ui-dialog": "wgextra-dialog ui-corner-all ui-no-close"
				},
				width: 500,
				resizable: false,
				modal: true,
				closeOnEscape: false,
				buttons: [
					{
						text: wgextra.ok,
						class: "primary",
						click: function() {
							var $dialog = $( this ),
								$input = $dialog.find('input[name="prompt"]'),
								value = $input.val();

							callback(value);
							callbackSend = 1;
							$dialog.dialog( "close" );
						}
					},
					{
						text: wgextra.cancel,
						click: function() {
							$( this ).dialog( "close" );
						}
					}
				],
				open: function( event, ui ) {
					var $dialog = $( this );

					$(window).on( 'resize.dialog scroll.dialog', $.debounce( 50, function(){
						$dialog.dialog("option", "position", { my: "center", at: "center", of: window });
					} ) );

					$dialog.on('keydown.dialog', 'input[name="prompt"]', function(e){
						if (e.keyCode === 13)
							$dialog.parent().find( "button.primary" ).click();
					})
				},
				close: function( event, ui ) {
					$( this ).off('.dialog').dialog( "destroy" ).remove();
					$(window).off('.dialog');
					if (!callbackSend)
						callback(false);
				}
			});
		}

		function ui_confirm(title, message, callback) {
			var template = $FIND('script#confirm_dialog').html();

			template = _.template(template)({
				title: title,
				message: message
			});

			var callbackSend = 0;

			$( template ).dialog({
				classes: {
					"ui-dialog": "wgextra-dialog ui-corner-all ui-no-close"
				},
				width: 500,
				resizable: false,
				modal: true,
				closeOnEscape: false,
				buttons: [
					{
						text: wgextra.ok,
						class: "primary",
						click: function() {
							callback(true);
							callbackSend = 1;
							$( this ).dialog( "close" );
						}
					},
					{
						text: wgextra.cancel,
						click: function() {
							$( this ).dialog( "close" );
						}
					}
				],
				open: function( event, ui ) {
					var $dialog = $( this );

					$(window).on( 'resize.dialog scroll.dialog', $.debounce( 50, function(){
						$dialog.dialog("option", "position", { my: "center", at: "center", of: window });
					} ) );
				},
				close: function( event, ui ) {
					$( this ).dialog( "destroy" ).remove();
					$(window).off('.dialog');
					if (!callbackSend)
						callback(false);
				}
			});
		}

		function ui_alert(message) {
			var template = $FIND('script#alert_dialog').html();

			template = _.template(template)({
				message: message
			});

			$( template ).dialog({
				classes: {
					"ui-dialog": "wgextra-dialog ui-corner-all ui-no-close"
				},
				width: 500,
				resizable: false,
				modal: true,
				closeOnEscape: false,
				buttons: [
					{
						text: wgextra.ok,
						click: function() {
							$( this ).dialog( "close" );
						}
					}
				],
				open: function( event, ui ) {
					var $dialog = $( this );

					$(window).on( 'resize.dialog scroll.dialog', $.debounce( 50, function(){
						$dialog.dialog("option", "position", { my: "center", at: "center", of: window });
					} ) );
				},
				close: function( event, ui ) {
					$( this ).dialog( "destroy" ).remove();
					$(window).off('.dialog');
				}
			});
		}

		function show_templates(templates) {
			var $this = $(this),
				$table = $wgextra.find('table').first(),
				$empty = $wgextra.find('#empty_templates'),
				templateHTML = $FIND('script#show_templates').html();

			templateHTML = _.template(templateHTML)({
				title: i18n('Import Template'),
				templates: templates
			});

			$( templateHTML ).dialog({
				draggable: false,
				resizable: false,
				height: window.innerHeight - 100,
				width: window.innerWidth - 130,
				modal: true,
				closeOnEscape: true,
				classes: {
					"ui-dialog": "wgextra-dialog"
				},
				open: function( event, ui ) {
					var $dialog = $( this ),
						$isotope = $dialog.find('#importable-templates'),
						$availItems = $isotope.children(),
						$quicksearch = $dialog.find('input[type="search"]');

					ui_initialize($dialog);

					$( window ).on( 'resize.dialog scroll.dialog', $.debounce( 50, function(){
						$dialog.dialog("option", "width", window.innerWidth - 130);
						$dialog.dialog("option", "height", window.innerHeight - 100);
						$dialog.dialog("option", "position", { my: "center", at: "center", of: window });
					} ) );

					$isotope.isotope({
						transitionDuration: '0.65s',
						getSortData: {
							name: '[data-name]',
							date: '[data-date]'
						},
						sortBy: 'date',
						sortAscending: false
					});

					$dialog
					.on('change.dialog', '#template_type', function () {
						var selector = this.value;

						$isotope.isotope({ filter: selector });
						$availItems = $isotope.children().filter(selector);
						$quicksearch.val('');
					})
					// use value of search field to filter
					.on('keyup.dialog', 'input[type="search"]', $.debounce( 400, function() {
						var qsRegex = new RegExp( $quicksearch.val(), 'gi' );
						$isotope.isotope({ filter: function() {
							var $this = $(this);
							if ($availItems.index($this) === -1)
								return false;
							return qsRegex ? $this.text().match( qsRegex ) : true;
						} });
					} ) )
					.on('click.dialog', '.template-action.import', function () {
						var id = this.getAttribute('rel');

						console.log(id);
						$dialog.dialog("close");
						showProcessing();
						$.ajax({
							method: "POST",
							url: ajaxurl,
							data: {
								action: "wgextra",
								id: id,
								wgextra_task: "import_template",
								wgextra_nonce: wgextra.nonce.import_template
							}
						})
						.done(function(data) {
							hideProcessing();

							if (data.status == 200) {
								var templateRowHTML = $FIND('script#new_template_row').html();
								templateRowHTML = _.template(templateRowHTML)(data);
								var $templateRow = $(templateRowHTML);

								$table.show().prepend($templateRow);
								ui_initialize($templateRow);
								$empty.hide();
							}

							if (data.message)
								ui_alert(data.message);
						})
						.fail(function(data) {
							hideProcessing();
							ui_alert(i18n('Request failed, please try again.'));
						});
					});
				},
				close: function( event, ui ) {
					$( this ).off('.dialog').dialog( "destroy" ).remove();
					$( window ).off('.dialog');
				}
			});
		}

		function set_taxonomies_selectbox($taxonomy_terms_select, data) {
			var wgextra_post_types = $.isArray(data.wgextra_post_types) ? data.wgextra_post_types : [data.wgextra_post_types],
				taxonomies = wgextra.source_data.taxonomies,
				html = '';

			$.each(wgextra_post_types, function(pi, post_type) {
				if(wgextra.post_types_taxonomies[post_type]) {
					$.each(wgextra.post_types_taxonomies[post_type], function(tax_key, taxonomy) {
						if (taxonomy.terms.length === 0)
							return true;

						html += "<optgroup label='" + taxonomy.label + "'>";
							$.each(taxonomy.terms, function(i, term) {
								var optionValue = tax_key + ":" + term.slug,
									selected = taxonomies.indexOf(optionValue) !== -1 ? ' selected' : '';
								html += "<option value='" + optionValue + "'" + selected + ">" + term.name + " (" + term.count + " " + i18n('post(s)') + ")</option>";
							});
						html += "</optgroup>";
					});
				}
			});

			$taxonomy_terms_select.html(html);
			$taxonomy_terms_select.multiSelect('refresh');
		}

	});

	function imageChooser(id, callback) {
		if(wp.media.frames.wgextra) {
			wp.media.frames.wgextra.dispose();
		}

		// Store the current gallery frame.
		wp.media.frames.wgextra = wp.media({
			title: i18n('Select an image'),
			multiple : false,
			library : { type : 'image' }
		});

		// opens the modal with the correct attachments already selected
		if(id)
			wp.media.frames.wgextra.on('open', function() {
				var selection = wp.media.frames.wgextra.state().get('selection'),
					attachment;

				wp.media.frames.wgextra.reset();
				try {
					attachment = wp.media.attachment(id);
					if (attachment.id) {
						selection.add(attachment);
					}
				} catch(e) {}
			});

		wp.media.frames.wgextra.on('select', function() {
			callback(wp.media.frames.wgextra.state().get('selection').first().toJSON());
			wp.media.frames.wgextra.dispose();
		});

		wp.media.frames.wgextra.open();
		wp.media.frames.wgextra.$el.find('.media-menu a').eq(1).hide();
	}

	function showLoader($element) {
		var $loader = $element.find('.circle-loader');
		$loader[0].style.display = 'inline-block';
	}

	function hideLoader($element) {
		var $loader = $element.find('.circle-loader');
		$loader.removeClass('load-complete').hide();
	}

	function showProcessing() {
		window.$processing = $('<div class="processing"><div class="overlay"></div><div class="box"><span>Processing...</span><div class="progress"><div class="indeterminate"></div></div></div></div>');
		$body.append(window.$processing);
	}

	function hideProcessing() {
		window.$processing.remove();
	}

	function getVisibleFields(mode, type) {
		var types = wgextra[mode === 'template' ? 'templates_types' : 'sources_types'],
			type_fields = types[type].fields,
			split_fields = type_fields.split(',');

		split_fields = split_fields.map(function(x) {
			return '[rel="' + $.trim(x) + '"]';
		});

		return split_fields.join(', ');
	}

	var rCRLF = /\r?\n/g,
		rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
		rsubmittable = /^(?:input|select|textarea|keygen)/i,
		rcheckableType = (/^(?:checkbox|radio)$/i);

	$.fn.serializeJSON = function(filter, defaultObj) {
		"use strict";

		var array = this.map(function() {
				// Can add propHook for "elements" to filter or add form elements
				var elements = $.prop(this, "elements");
				return elements ? $.makeArray(elements) : this;
			})
			.filter(function() {
				var type = this.type;

				// Use .is( ":disabled" ) so that fieldset[disabled] works
				return this.name && !$(this).is(":disabled") &&
					rsubmittable.test(this.nodeName) && !rsubmitterTypes.test(type) &&
					(this.checked || !rcheckableType.test(type));
			})
			.map(function(i, elem) {
				var val = $(this).val(),
					name = elem.name;

				return val == null || (filter && !val) || (defaultObj && defaultObj[name] === val) ?
					null :
					$.isArray(val) ?
					$.map(val, function(val) {
						return {
							name: name,
							value: val.replace(rCRLF, "\r\n")
						};
					}) : {
						name: name,
						value: val.replace(rCRLF, "\r\n")
					};
			}).get();

		var serialize = deparam($.param(array));

		return serialize;
	};

	function deparam(params, coerce) {
		var obj = {},
			coerce_types = {
				'true': !0,
				'false': !1,
				'null': null
			};

		// Iterate over all name=value pairs.
		$.each(params.replace(/\+/g, ' ').split('&'), function(j, v) {
			var param = v.split('='),
				key = decodeURIComponent(param[0]),
				val,
				cur = obj,
				i = 0,

				// If key is more complex than 'foo', like 'a[]' or 'a[b][c]', split it
				// into its component parts.
				keys = key.split(']['),
				keys_last = keys.length - 1;

			// If the first keys part contains [ and the last ends with ], then []
			// are correctly balanced.
			if (/\[/.test(keys[0]) && /\]$/.test(keys[keys_last])) {
				// Remove the trailing ] from the last keys part.
				keys[keys_last] = keys[keys_last].replace(/\]$/, '');

				// Split first keys part into two parts on the [ and add them back onto
				// the beginning of the keys array.
				keys = keys.shift().split('[').concat(keys);

				keys_last = keys.length - 1;
			} else {
				// Basic 'foo' style key.
				keys_last = 0;
			}

			// Are we dealing with a name=value pair, or just a name?
			if (param.length === 2) {
				val = decodeURIComponent(param[1]);

				// Coerce values.
				if (coerce) {
					val = val && !isNaN(val) ? +val // number
						:
						val === 'undefined' ? undefined // undefined
						:
						coerce_types[val] !== undefined ? coerce_types[val] // true, false, null
						:
						val; // string
				}

				if (keys_last) {
					// Complex key, build deep object structure based on a few rules:
					// * The 'cur' pointer starts at the object top-level.
					// * [] = array push (n is set to array length), [n] = array if n is 
					//   numeric, otherwise object.
					// * If at the last keys part, set the value.
					// * For each keys part, if the current level is undefined create an
					//   object or array based on the type of the next keys part.
					// * Move the 'cur' pointer to the next level.
					// * Rinse & repeat.
					for (; i <= keys_last; i++) {
						key = keys[i] === '' ? cur.length : keys[i];
						cur = cur[key] = i < keys_last ? cur[key] || (keys[i + 1] && isNaN(keys[i + 1]) ? {} : []) : val;
					}

				} else {
					// Simple key, even simpler rules, since only scalars and shallow
					// arrays are allowed.

					if ($.isArray(obj[key])) {
						// val is already an array, so push on the next value.
						obj[key].push(val);

					} else if (obj[key] !== undefined) {
						// val isn't an array, but since a second value has been specified,
						// convert val into an array.
						obj[key] = [obj[key], val];

					} else {
						// val is a scalar.
						obj[key] = val;
					}
				}

			} else if (key) {
				// No value was defined, so set something meaningful.
				obj[key] = coerce ? undefined : '';
			}
		});

		return obj;
	}

	function jQueryDummy($real, delay, _fncQueue) {
		// A Fake jQuery-like object that allows us to resolve the entire jQuery
		// method chain, pause, and resume execution later.

		var dummy = this;
		this._fncQueue = (typeof _fncQueue === 'undefined') ? [] : _fncQueue;
		this._delayCompleted = false;
		this._$real = $real;

		if (typeof delay === 'number' && delay >= 0 && delay < Infinity)
			this.timeoutKey = window.setTimeout(function() {
				dummy._performDummyQueueActions();
			}, delay);

		else if (delay !== null && typeof delay === 'object' && typeof delay.promise === 'function')
			delay.then(function() {
				dummy._performDummyQueueActions();
			});

		else if (typeof delay === 'string')
			$real.one(delay, function() {
				dummy._performDummyQueueActions();
			});

		else
			return $real;
	}

	jQueryDummy.prototype._addToQueue = function(fnc, arg) {
		// When dummy functions are called, the name of the function and
		// arguments are put into a queue to execute later

		this._fncQueue.unshift({
			fnc: fnc,
			arg: arg
		});

		if (this._delayCompleted)
			return this._performDummyQueueActions();
		else
			return this;
	};

	jQueryDummy.prototype._performDummyQueueActions = function() {
		// Start executing queued actions.  If another `wait` is encountered,
		// pass the remaining stack to a new jQueryDummy

		this._delayCompleted = true;

		var next;
		while (this._fncQueue.length > 0) {
			next = this._fncQueue.pop();

			if (next.fnc === 'wait') {
				next.arg.push(this._fncQueue);
				return this._$real = this._$real[next.fnc].apply(this._$real, next.arg);
			}

			this._$real = this._$real[next.fnc].apply(this._$real, next.arg);
		}

		return this;
	};

	$.fn.wait = function(delay, _queue) {
		// Creates dummy object that dequeues after a times delay OR promise

		return new jQueryDummy(this, delay, _queue);
	};

	for (var fnc in $.fn) {
		// Add shadow methods for all jQuery methods in existence.  Will not
		// shadow methods added to jQuery _after_ this!
		// skip non-function properties or properties of Object.prototype

		if (typeof $.fn[fnc] !== 'function' || !$.fn.hasOwnProperty(fnc))
			continue;

		jQueryDummy.prototype[fnc] = (function(fnc) {
			return function() {
				var arg = Array.prototype.slice.call(arguments);
				return this._addToQueue(fnc, arg);
			};
		})(fnc);
	}
	var jq_throttle;

	// Method: jQuery.throttle
	$.throttle = jq_throttle = function(delay, no_trailing, callback, debounce_mode) {
		// After wrapper has stopped being called, this timeout ensures that
		// `callback` is executed at the proper times in `throttle` and `end`
		// debounce modes.
		var timeout_id,

			// Keep track of the last time `callback` was executed.
			last_exec = 0;

		// `no_trailing` defaults to falsy.
		if (typeof no_trailing !== 'boolean') {
			debounce_mode = callback;
			callback = no_trailing;
			no_trailing = undefined;
		}

		// The `wrapper` function encapsulates all of the throttling / debouncing
		// functionality and when executed will limit the rate at which `callback`
		// is executed.
		function wrapper() {
			var that = this,
				elapsed = +new Date() - last_exec,
				args = arguments;

			// Execute `callback` and update the `last_exec` timestamp.
			function exec() {
				last_exec = +new Date();
				callback.apply(that, args);
			};

			// If `debounce_mode` is true (at_begin) this is used to clear the flag
			// to allow future `callback` executions.
			function clear() {
				timeout_id = undefined;
			};

			if (debounce_mode && !timeout_id) {
				// Since `wrapper` is being called for the first time and
				// `debounce_mode` is true (at_begin), execute `callback`.
				exec();
			}

			// Clear any existing timeout.
			timeout_id && clearTimeout(timeout_id);

			if (debounce_mode === undefined && elapsed > delay) {
				// In throttle mode, if `delay` time has been exceeded, execute
				// `callback`.
				exec();

			} else if (no_trailing !== true) {
				// In trailing throttle mode, since `delay` time has not been
				// exceeded, schedule `callback` to execute `delay` ms after most
				// recent execution.
				// 
				// If `debounce_mode` is true (at_begin), schedule `clear` to execute
				// after `delay` ms.
				// 
				// If `debounce_mode` is false (at end), schedule `callback` to
				// execute after `delay` ms.
				timeout_id = setTimeout(debounce_mode ? clear : exec, debounce_mode === undefined ? delay - elapsed : delay);
			}
		};

		// Set the guid of `wrapper` function to the same of original callback, so
		// it can be removed in jQuery 1.4+ .unbind or .die by using the original
		// callback as a reference.
		if ($.guid) {
			wrapper.guid = callback.guid = callback.guid || $.guid++;
		}

		// Return the wrapper function.
		return wrapper;
	};

	// Method: jQuery.debounce
	$.debounce = function(delay, at_begin, callback) {
		return callback === undefined ?
			jq_throttle(delay, at_begin, false) :
			jq_throttle(delay, callback, at_begin !== false);
	};

	$.fn.setValues = function(values) {
		var $fields = this;

		if(!$.isPlainObject(values))
			return;

		$.each(values, function (name, value) {
			var $element = $fields.filter('[name="' + name + '"]');

			if ($element[0]) {
				var type = ($element[0].type || $element[0].tagName).toLowerCase().replace('select-one', 'select');

				if (type === 'radio') {
					$element.filter('[value="' + value + '"]').prop('checked', true).trigger('change', [ true ]);
					if ($element.hasClass('ui-checkboxradio'))
						$element.checkboxradio( "refresh" );
				}
				else if (type === 'checkbox') {
					$element.prop('checked', !!value).trigger('change', [ true ]);
				}
				else if (type === 'select') {
					$element.val(value).trigger('change', [ true ]);

					try {
						$element.selectmenu('refresh');
					}
					catch (e) {}
				}
				else {
					if ($element.val() !== value) {
						$element.val(value).trigger('change', [ true ]);
						if ($element.hasClass('minicolors-input')) {
							$element.minicolors('value', { color: value });
						}
					}
				}
			}
		});

		return this;
	};
})(jQuery);