<?php
	$wge_page = "images-sizes";
	$options = $this->OPTIONS;

	$pagename = __( 'Images Sizes', 'wordpress-gallery-extra' );
	$box_title_elements = array(
		array(
			"tag" => "button",
			"attributes" => array(
				"type" => "submit",
				"class" => array("submit-button", "blue"),
				"data-style" => "expand-left"
			),
			"nodes" => array(
				__( "Save Changes", 'wordpress-gallery-extra' )
			)
		)
	);
	include_once 'header.php';

?>
				<div class="inside" id="wgextra-images-sizes">
					<p><?php _e( "The sizes listed below determine the maximum dimensions in pixels to use when adding an image to the Media Library.", 'wordpress-gallery-extra' ); ?></p>

					<form class="warn-about-change" id="wgextra_images_sizes_form" method="post" action="">
						<input type="hidden" name="wgextra_task" value="save_images_sizes">
						<input type="hidden" name="wgextra_nonce" value="<?php echo esc_attr( wp_create_nonce( 'wgextra_save_images_sizes' ) ); ?>">
						<table class="form-table">
<?php
	$image_sizes = $options['image_sizes'];
	$sizes = $this->get_image_sizes();
	$cropping_positions = $this->get_available_crop();
	$possible_sizes_names = apply_filters( 'image_size_names_choose', array(
		'thumbnail'       => __('Thumbnail'),
		'medium'          => __('Medium'),
		'large'           => __('Large')
	) );

	$sizes = array_replace_recursive( $sizes, $image_sizes );
	$sizes_keys = array_keys( $sizes );
	$order = array_slice( $sizes_keys, 0, array_search( 'large', $sizes_keys ) + 1 );
	$order_rest = array_slice( $sizes_keys, array_search( 'large', $sizes_keys ) + 1 );

	sort( $order_rest );

	$order = array_merge( $order, $order_rest );

	uksort( $sizes, function ( $a, $b ) use ( &$order ) {
		$pos_a = array_search( $a, $order );
		$pos_b = array_search( $b, $order );
		return $pos_a - $pos_b;
	} );

	foreach ( $sizes as $key => $size ) {
		// Get the vars
		$size_name    = isset( $possible_sizes_names[$key] ) ? $possible_sizes_names[$key] : $key;
		$width        = $size['width'];
		$height       = $size['height'];
		$crop         = $size['crop'];
		$show         = isset( $possible_sizes_names[$key] ) ? 'yes' : 'no';
		$is_native    = in_array( $key, array('thumbnail', 'medium', 'medium_large', 'large') );
		$self_created = !$is_native && isset( $image_sizes[ $key ] ) && isset( $image_sizes[ $key ]['self_created'] ) && $image_sizes[ $key ]['self_created'];
		$disabled     = !$is_native && !$self_created && $image_sizes[ $key ]['delete'] === 'yes';

		if ( isset( $image_sizes[$key] ) && isset( $image_sizes[$key]['show'] ) ) {
			$show = $image_sizes[$key]['show'];
		}

		if ( is_array( $crop ) ) {
			$crop = implode( ',', $crop );
		}

?>
							<tr class="ad_opt<?php if ( $self_created ) echo " self_created"; if ( $self_created ) echo " disabled"; ?>">
<?php
		if ( $is_native ) {
?>
								<th scope="row"><?php echo $size_name; ?><input type="hidden" name="<?php echo "image_size[{$key}][name]"; ?>" value="<?php echo esc_attr( $size_name ); ?>" /></th><?php
		} else {
?>
								<th scope="row"><input type="text" name="<?php echo "image_size[{$key}][name]"; ?>" value="<?php echo esc_attr( $size_name ); ?>" /></th><?php
		}
?>
								<td>
									<div class="inside-table">
										<table class="form-table">
											<thead>
												<tr>
													<th scope="row"><label for="<?php echo "{$key}"; ?>-size-width"><?php _e( "Max Width", 'wordpress-gallery-extra' ); ?></label></th>
													<th scope="row"><label for="<?php echo "{$key}"; ?>-size-height"><?php _e( "Max Height", 'wordpress-gallery-extra' ); ?></label></th>
<?php
		if ( $key === "thumbnail" ) {
?>
													<th scope="row"><label for="<?php echo "{$key}"; ?>-size-crop"><?php _e( "Cropping", 'wordpress-gallery-extra' ); ?></label></th>
<?php
		}
?>
<?php
		if ( !$is_native ) {
?>
													<th scope="row"><label for="<?php echo "{$key}"; ?>-size-crop"><?php _e( "Cropping", 'wordpress-gallery-extra' ); ?></label></th>
													<th scope="row"><label for="<?php echo "{$key}"; ?>-size-show"><?php _e( "Show in post insertion?", 'wordpress-gallery-extra' ); ?></label></th>
													<th scope="row"><label for="<?php echo "{$key}"; ?>-size-delete"><?php $self_created ? _e( "Delete", 'wordpress-gallery-extra' ) : _e( "Disable", 'wordpress-gallery-extra' ); ?></label></th>
<?php
		}
?>
												</tr>
											</thead>
											<tbody>
												<tr>
													<td>
														<input rel="number" id="<?php echo "{$key}"; ?>-size-width" name="<?php echo "image_size[{$key}][width]"; ?>" value="<?php echo esc_attr( $width ); ?>" />
													</td>
													<td>
														<input rel="number" id="<?php echo "{$key}"; ?>-size-height" name="<?php echo "image_size[{$key}][height]"; ?>" value="<?php echo esc_attr( $height ); ?>" />
													</td>
<?php
		if ( $key === "thumbnail" ) {
?>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="<?php echo "image_size[{$key}][crop]"; ?>" class="onoffswitch-checkbox" id="<?php echo "{$key}"; ?>-size-crop"<?php checked( $crop, '1' ); ?> />
															<label class="onoffswitch-label" for="<?php echo "{$key}"; ?>-size-crop">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
<?php
		}
?>
<?php
		if ( !$is_native ) {
?>
													<td>
														<select id="<?php echo "{$key}"; ?>-size-crop" name="<?php echo "image_size[{$key}][crop]"; ?>">
<?php
			foreach ($cropping_positions as $crop_pos => $crop_pos_name) {
?>
															<option value="<?php echo $crop_pos; ?>"<?php selected( $crop_pos, $crop ); ?>><?php echo $crop_pos_name; ?></option>
<?php
			}
?>
														</select>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="<?php echo "image_size[{$key}][show]"; ?>" class="onoffswitch-checkbox" id="<?php echo "{$key}"; ?>-size-show"<?php checked( $show, 'yes' ); ?> />
															<label class="onoffswitch-label" for="<?php echo "{$key}"; ?>-size-show">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
													<td>
														<div class="onoffswitch">
															<input type="checkbox" name="<?php echo "image_size[{$key}][delete]"; ?>" class="onoffswitch-checkbox delete-switch" id="<?php echo "{$key}"; ?>-size-delete"<?php checked( $disabled ); ?> />
															<label class="onoffswitch-label" for="<?php echo "{$key}"; ?>-size-delete">
																<div class="onoffswitch-inner">
																	<div class="onoffswitch-active">ON</div>
																	<div class="onoffswitch-inactive">OFF</div>
																</div>
																<div class="onoffswitch-switch"></div>
															</label>
														</div>
													</td>
<?php
		}
?>
												</tr>
											</tbody>
										</table>
									</div>
								</td>
							</tr>
<?php
	}
?>
							<tr class="field">
								<th scope="row"><label><?php _e( "New size", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<a class="ui-button" id="add_new_image_size"><span class="dashicons dashicons-plus"></span><?php _e( "Register a new image size", 'wordpress-gallery-extra' ); ?></a>
								</td>
							</tr>
							<tr class="field">
								<th scope="row"><label for="wgextra-image-quality"><?php _e( "Image Quality", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<input rel="number" data-options="max:100, min:0" id="wgextra-image-quality" name="wgextra_image_quality" value="<?php echo esc_attr( $options['image_quality'] ); ?>" />
									<p class="description"><?php _e( "Change the Image compression-level of uploaded images and thumbnails.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
<?php
	$this->do_settings_fields( $wge_page, 'general', 'default' );
?>
						</table>
					</form>
					<br />
					<hr />
					<h3 id="thumbnails_cleaner"><?php _e( 'Thumbnails Cleaner', 'wordpress-gallery-extra' ); ?></h3>
					<p><?php _e( "Use this tool to clean unwanted thumbnails files from your uploads directory to optimize and tidy up your WordPress installation.", 'wordpress-gallery-extra' ); ?></p>
					<p><?php _e( "To make sure you don't lose any data, please hit the <em>Backup Now</em> button before you start.", 'wordpress-gallery-extra' ); ?></p>

					<form id="wgextra_regenerator_form" method="post" action="">
						<input type="hidden" name="wgextra_task" value="start_regenerator">
						<table class="form-table">
							<tr>
								<th scope="row"><label><?php _e( "Backup", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<a class="ui-button" id="backup_thumbnails"><span class="dashicons dashicons-backup"></span><?php _e( "Backup Now", 'wordpress-gallery-extra' ); ?></a>
<?php
	$backup_file   = ABSPATH . "wp-content/backups/wordpress-gallery-extra/backup.zip";
	$backup_exists = file_exists( $backup_file );
	if ( $backup_exists ) {
		//$last_backup = date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), filemtime( $backup_file ) );
		$last_backup = sprintf( __( "%s ago", 'wordpress-gallery-extra' ), human_time_diff( filemtime( $backup_file ) ) );
	}
	else {
		$last_backup = __( "Never", 'wordpress-gallery-extra' );
	}
?>
									<a class="ui-button" id="restore_backup"<?php if ( !$backup_exists ) echo ' disabled="disabled"' ?>><span class="dashicons dashicons-update"></span><?php _e( "Restore Backup", 'wordpress-gallery-extra' ); ?></a>
									<a class="ui-button" id="delete_backup"<?php if ( !$backup_exists ) echo ' disabled="disabled"' ?>><span class="dashicons dashicons-trash"></span><?php _e( "Delete Backup", 'wordpress-gallery-extra' ); ?></a>
									<span id="last-backup"><strong>Last backup:</strong> <em><?php echo $last_backup; ?></em></span>
									<p class="description"><?php _e( "Creates a zipped archive of your <code>uploads</code> directory and saves it in <code>wp-content/backups/wordpress-gallery-extra/</code> (recommended).", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
							<tr>
								<th scope="row"><label><?php _e( "Clean Thumbnails", 'wordpress-gallery-extra' ); ?></label></th>
								<td class="parent">
									<div id="analyze_thumbnails_holder">
										<a id="analyze_thumbnails" class="ui-button"><span class="dashicons dashicons-chart-bar"></span><?php _e( "Start Analyzing", 'wordpress-gallery-extra' ); ?></a>
										<span rel="date_range">
											<input type="text" class="small" name="after_date" rel="from_date" placeholder="<?php esc_attr_e( 'After Date', 'wordpress-gallery-extra' ); ?> <?php esc_attr_e( '(Optional)', 'wordpress-gallery-extra' ); ?>" title="<?php esc_attr_e( 'Date to clean thumbnails after.', 'wordpress-gallery-extra' ); ?>" />
											<input type="text" class="small" name="before_date" rel="to_date" placeholder="<?php esc_attr_e( 'Before Date', 'wordpress-gallery-extra' ); ?> <?php esc_attr_e( '(Optional)', 'wordpress-gallery-extra' ); ?>" title="<?php esc_attr_e( 'Date to clean thumbnails before.', 'wordpress-gallery-extra' ); ?>" />
										</span>
										<p class="description"><?php _e( "Scans your <code>uploads</code> directory for thumbnails and returns the total amount without deleting any files.", 'wordpress-gallery-extra' ); ?></p>
									</div>
									<div id="analysis_results" style="display: none;">
										<h4>Analysis Results</h4>
										<div class="inside-table">
											<table class="form-table">
												<thead>
													<tr>
														<th scope="row"><?php _e( "Original Files", 'wordpress-gallery-extra' ); ?></th>
														<th scope="row"><?php _e( "Thumbnail Files", 'wordpress-gallery-extra' ); ?></th>
														<th scope="row"><?php _e( "Total File Size", 'wordpress-gallery-extra' ); ?></th>
													</tr>
												</thead>
												<tbody>
													<tr>
														<td id="original_files"></td>
														<td id="thumbnail_files"></td>
														<td id="total_file_size"></td>
													</tr>
												</tbody>
											</table>
										</div>
									</div>
									<div id="delete_thumbnails_holder" style="display: none;">
										<a id="delete_thumbnails" class="ui-button"><span class="dashicons dashicons-trash"></span><?php _e( "Delete Thumbnails", 'wordpress-gallery-extra' ); ?></a>
										<p class="description"><?php _e( "Deletes <strong>all</strong> thumbnails within your <code>uploads</code> directory.", 'wordpress-gallery-extra' ); ?></p>
										<div class="description">
											<strong><?php _e( "Note:", 'wordpress-gallery-extra' ); ?></strong>
											<ol>
												<li><?php _e( "Keep old thumbnails to avoid any broken images due to hard-coded URLs.", 'wordpress-gallery-extra' ); ?></li>
												<li><?php _e( "Unless you have created a backup, this <strong>cannot</strong> be reversed.", 'wordpress-gallery-extra' ); ?></li>
											</ol>
										</div>
									</div>
								</td>
							</tr>
<?php
	$this->do_settings_fields( $wge_page, 'general', 'thumbnails-cleaner' );
?>
						</table>
						<hr />
						<h3 id="thumbnails_regenerator"><?php _e( 'Thumbnails Regenerator', 'wordpress-gallery-extra' ); ?></h3>
						<p><?php _e( "Use this tool to regenerate thumbnails for all images that you have uploaded to your blog.", 'wordpress-gallery-extra' ); ?></p>
						<p><?php printf( __( "You can regenerate specific images (rather than all images) from the <a href='%s'>Media</a> page. Hover over an image's row and click the link to resize just that one image.", 'wordpress-gallery-extra' ), admin_url( 'upload.php?mode=list' ) ); ?></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label><?php _e( "Sizes to rebuild", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<select name="wgextra_thumbnails[]" id="sizes_to_rebuild" multiple>
<?php
	foreach ( $sizes as $key => $size ) {
		$size_name = isset( $possible_sizes_names[$key] ) ? $possible_sizes_names[$key] : $key;
		$key_esc_attr = esc_attr( $key );
		$is_native    = in_array( $key, array('thumbnail', 'medium', 'medium_large', 'large') );
		$self_created = !$is_native && isset( $image_sizes[ $key ] ) && isset( $image_sizes[ $key ]['self_created'] ) && $image_sizes[ $key ]['self_created'];
		$disabled     = !$is_native && !$self_created && $image_sizes[ $key ]['delete'] === 'yes';

		if ( $disabled )
			continue;
?>
										<option value="<?php echo $key_esc_attr; ?>" selected="selected"><?php echo $size_name; ?></option>
<?php
	}
?>
									</select>
									<p class="description"><?php _e( "Select which image sizes you want to rebuild.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
							<tr>
								<th scope="row"><label><?php _e( "Post types to rebuild", 'wordpress-gallery-extra' ); ?></label></th>
								<td>
									<div class="switch-field">
<?php
	// Diplay the post types
	$post_types = get_post_types( array( 'public' => true ), 'objects' );
	foreach ( $post_types as $post_type ) {
		// Avoid the post_types without post thumbnails feature
		if ( ! isset ( $_wp_post_type_features[ $post_type->name ] ) || ! array_key_exists( 'thumbnail', $_wp_post_type_features[ $post_type->name ] ) || false == $_wp_post_type_features[ $post_type->name ] ) {
			continue;
		}
		$pname_esc_attr = esc_attr( $post_type->name );
?>
										<label for="wgextra_post_types-<?php echo $pname_esc_attr; ?>"><?php echo esc_html( $post_type->labels->name ); ?></label>
										<input type="checkbox" name="wgextra_post_types[]" id="wgextra_post_types-<?php echo $pname_esc_attr; ?>" value="<?php echo $pname_esc_attr; ?>" />
<?php
	}
?>
									</div>
									<p class="description"><?php _e( "Select which post type source thumbnails only you want to rebuild.", 'wordpress-gallery-extra' ); ?></p>
								</td>
							</tr>
<?php
	$this->do_settings_fields( $wge_page, 'general', 'thumbnails-regenerator' );
?>
						</table>
						<p class="submit">
							<input type="submit" class="button-primary" value="<?php esc_attr_e( 'Start Regenerator', 'wordpress-gallery-extra' ); ?>" />
							<input type="hidden" name="wgextra_nonce" value="<?php echo esc_attr( wp_create_nonce( 'wgextra_start_regenerator' ) ); ?>">
							<span class="circle-loader"><span class="checkmark draw"></span></span>
							<span class="wgextra_ajax_message">Error</span>
						</p>
					</form>
				</div><!-- end of inside -->
			<script id="new_image_size_row" type="text/template">
<tr>
	<th scope="row"><input type="text" name="image_size[<%= id %>][name]" value="<%= id %>"></th>
	<td>
		<div class="inside-table">
			<table class="form-table">
				<thead>
					<tr>
						<th scope="row"><label for="<%= id %>-size-width"><?php _e( "Max Width", 'wordpress-gallery-extra' ); ?></label></th>
						<th scope="row"><label for="<%= id %>-size-height"><?php _e( "Max Height", 'wordpress-gallery-extra' ); ?></label></th>
						<th scope="row"><label for="<%= id %>-size-cropping"><?php _e( "Cropping", 'wordpress-gallery-extra' ); ?></label></th>
						<th scope="row"><label for="<%= id %>-size-show"><?php _e( "Show in post insertion?", 'wordpress-gallery-extra' ); ?></label></th>
						<th scope="row"><label for="<%= id %>-size-delete"><?php _e( "Delete", 'wordpress-gallery-extra' ); ?></label></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td>
							<input rel="number" id="<%= id %>-size-width" name="image_size[<%= id %>][width]" value="<%= width %>" />
						</td>
						<td>
							<input rel="number" id="<%= id %>-size-height" name="image_size[<%= id %>][height]" value="<%= height %>">
						</td>
						<td>
							<select id="<%= id %>-size-cropping" name="image_size[<%= id %>][crop]">
<?php
			foreach ($cropping_positions as $crop_pos => $crop_pos_name) {
?>
								<option value="<?php echo $crop_pos; ?>"<?php selected( $crop_pos, $crop ); ?>><?php echo $crop_pos_name; ?></option>
<?php
			}
?>
							</select>
						</td>
						<td>
							<div class="onoffswitch">
								<input type="checkbox" name="image_size[<%= id %>][show]" class="onoffswitch-checkbox" id="<%= id %>-size-show" checked="checked" />
								<label class="onoffswitch-label" for="<%= id %>-size-cropping-button">
									<div class="onoffswitch-inner">
										<div class="onoffswitch-active">ON</div>
										<div class="onoffswitch-inactive">OFF</div>
									</div>
									<div class="onoffswitch-switch"></div>
								</label>
							</div>
						</td>
						<td>
							<div class="onoffswitch">
								<input type="checkbox" name="image_size[<%= id %>][delete]" class="onoffswitch-checkbox" id="<%= id %>-size-delete">
								<label class="onoffswitch-label" for="<%= id %>-size-delete">
									<div class="onoffswitch-inner">
										<div class="onoffswitch-active">ON</div>
										<div class="onoffswitch-inactive">OFF</div>
									</div>
									<div class="onoffswitch-switch"></div>
								</label>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</td>
</tr>
			</script>

			<?php
	include_once 'footer.php';
?>