<?php

/**
 *
 *
 * @version $Id$
 * @copyright 2003
 **/

class wlb_gutenberg {
	var $content = array();
	var $show_ui = false;
	var $widgets_form = '';
	function __construct($args=array()){
		global $wlb_plugin;
		//------
		$defaults = array(
			'id'				=> $wlb_plugin->id.'-bra',
			'show_ui'			=> true,
			'show_in_menu'		=> 'white-label-branding',
			'menu_name'			=> __('Gutenberg','wlb')
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----
		add_filter("pop-options_{$this->id}",array($this,'wlb_options'),10,1);
		add_action('admin_head', array($this,'admin_head'));
	}

	function wlb_options($t,$for_admin=true){
		global $wlb_plugin;
		if(  '1'!=$wlb_plugin->get_option('use_branding_customization') )return $t;

		$i=intval(count($t));
		//-------
		$i = count($t);
		$t[$i]=(object)array();
		$t[$i]->id 			= 'gutenberg';
		$t[$i]->label 		= __('Gutenberg','wlb');//title on tab
		$t[$i]->right_label	= __('Gutenberg branding','wlb');//title on tab
		$t[$i]->page_title	= __('Gutenberg','wlb');//title on content
		$t[$i]->options = array(
			(object)array(
				'type'=>'subtitle',
				'label'=>__('Gutenberg WP logo','wlb')
			),
			(object)array(
				'id'	=> 'gutenberg_wp_logo',
				'type'	=>'fileuploader',
				'label'	=> __('Gutenberg WP logo url','wlb'),
				'description'=> __('Replace the top left Gutenberg WP logo','wlb'),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'	=> 'gutenberg_wp_logo_padding',
				'type'	=> 'range',
				'min'	=> 0,
				'max'	=> 10,
				'step'	=> 1,
				'default'=> 0,
				'label'=> __('Logo container padding','wlb'),
				'el_properties' => array('size'=>'5'),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'	=> 'gutenberg_wp_logo_bg_color',
				'type'	=> 'farbtastic',
				'label'	=> __('background-color code','wlb'),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'	=> 'gutenberg_wp_logo_bg_color_hover',
				'type'	=> 'farbtastic',
				'label'	=> __('hover background-color code','wlb'),
				'save_option'=>true,
				'load_option'=>true
			),

		);


		$t[$i]->options[]=(object)array('type'=>'clear');
		$t[$i]->options[]=(object)array('label'=>__('Save Changes','wlb'),'type'=>'submit','class'=>'button-primary', 'value'=> '' );
		//-------
		return $t;
	}

	function admin_head(){
?>
<script>
( function($) {
	//note: colorpicker does not trigger the change event.
	function _timed_color_change(){

		bg_color = $('#gutenberg_wp_logo_bg_color').val();
		if( bg_color && bg_color.length > 1 ){
			current_bg_color = $('#gutenberg_wp_logo_preview img').data('bg_color');
			$('#gutenberg_wp_logo_preview img').data('bg_color',bg_color );
			if( bg_color != current_bg_color ){
				$('#gutenberg_wp_logo_preview img').trigger('mouseleave');
			}

		} else {
			$('#gutenberg_wp_logo_preview img').css('background-color', 'transparent' );
		}

		h_bg_color = $('#gutenberg_wp_logo_bg_color_hover').val();
		if( h_bg_color && h_bg_color.length > 1){
			$('#gutenberg_wp_logo_preview img').data('h_bg_color',h_bg_color );
		}else{
			$('#gutenberg_wp_logo_preview img').data('h_bg_color', 'transparent' );
		}



		setTimeout(function(){
			_timed_color_change()
		},1000);
	}
	$( document ).ready(function() {

		$('#gutenberg_wp_logo_preview img').wrap("<a href='#' class='gutenberg_wp_logo_preview_wrap'></a>");
		$('#gutenberg_wp_logo_preview').css('display','flex').css('height','56px');
		$('#gutenberg_wp_logo_preview img').css('height','100%');
		$('.gutenberg_wp_logo_preview_wrap').css('text-align', 'center');


		_timed_color_change();



		$('#gutenberg_wp_logo_preview img').hover(
			function(){
				$('.gutenberg_wp_logo_preview_wrap').css('background-color', $(this).data('h_bg_color') );
			},
			function(){
				$('.gutenberg_wp_logo_preview_wrap').css('background-color', $(this).data('bg_color') );
			}
		).trigger('mouseleave');;

		$('#gutenberg_wp_logo_padding').change(function(e,o){
			padding = $(this).val();
			if( padding!='' ){
				$('.gutenberg_wp_logo_preview_wrap').css('padding', padding+'px' );
			}
		}).trigger('change');
	});
})(jQuery);
</script>
<?php
	}




}


?>