(function($){function init(plot){var canvas=null;var target=null;var maxRadius=null;var centerLeft=null;var centerTop=null;var total=0;var redraw=true;var redrawAttempts=10;var shrink=0.95;var legendWidth=0;var processed=false;var raw=false;plot.hooks.processOptions.push(checkPieEnabled);function checkPieEnabled(plot,options){if(options.series.pie.show){options.grid.show=false;if(options.series.pie.label.show=='auto')if(options.legend.show)options.series.pie.label.show=false;else options.series.pie.label.show=true;if(options.series.pie.radius=='auto')if(options.series.pie.label.show)options.series.pie.radius=3/4;else options.series.pie.radius=1;if(options.series.pie.tilt>1)options.series.pie.tilt=1;if(options.series.pie.tilt<0)options.series.pie.tilt=0;plot.hooks.processDatapoints.push(processDatapoints);plot.hooks.draw.push(draw)}}function alertObject(obj){var msg='';function traverse(obj,depth){if(!depth)depth=0;for(var i in obj){for(var j=0;j<depth;j++)msg+='\t';if(typeof obj[i]=="object"){msg+=''+i+':\n';traverse(obj[i],depth+1)}else{msg+=''+i+': '+obj[i]+'\n'}}}traverse(obj);alert(msg)}function calcTotal(data){for(var i in data){var item=parseFloat(data[i].data[0][1]);if(item)total+=item}}function processDatapoints(plot,series,data,datapoints){if(!processed){processed=true;canvas=plot.getCanvas();target=$(canvas).parent();options=plot.getOptions();plot.setData(combine(plot.getData()))}}function setupPie(){legendWidth=target.children().filter('.legend').children().width();maxRadius=Math.min(canvas.width,canvas.height)/2;centerTop=(canvas.height/2)+options.series.pie.offset.top;centerLeft=(canvas.width/2);if(options.series.pie.offset.left=='auto')if(options.legend.position.match('w'))centerLeft+=legendWidth/2;else centerLeft-=legendWidth/2;else centerLeft+=options.series.pie.offset.left;if(centerLeft<maxRadius)centerLeft=maxRadius;else if(centerLeft>canvas.width-maxRadius)centerLeft=canvas.width-maxRadius}function fixData(data){for(var i in data){if(typeof(data[i].data)=='number')data[i].data=[[1,data[i].data]];else if(typeof(data[i].data)=='undefined'||typeof(data[i].data[0])=='undefined'){if(typeof(data[i].data)!='undefined'&&typeof(data[i].data.label)!='undefined')data[i].label=data[i].data.label;data[i].data=[[1,0]]}}return data}function combine(data){data=fixData(data);calcTotal(data);var combined=0;var numCombined=0;var color=options.series.pie.combine.color;var newdata=[];for(var i in data){data[i].data[0][1]=parseFloat(data[i].data[0][1]);if(!data[i].data[0][1])data[i].data[0][1]=0;if(data[i].data[0][1]/total<=options.series.pie.combine.threshold){combined+=data[i].data[0][1];numCombined++;if(!color)color=data[i].color}else{newdata.push({data:[[1,data[i].data[0][1]]],color:data[i].color,label:data[i].label,angle:(data[i].data[0][1]*(Math.PI*2))/total,percent:(data[i].data[0][1]/total*100)})}}if(numCombined>0)newdata.push({data:[[1,combined]],color:color,label:options.series.pie.combine.label,angle:(combined*(Math.PI*2))/total,percent:(combined/total*100)});return newdata}function draw(plot,ctx){setupPie();var slices=plot.getData();var attempts=0;while(redraw&&attempts<redrawAttempts){redraw=false;if(attempts>0)maxRadius*=shrink;attempts+=1;clear();if(options.series.pie.tilt<=0.8)drawShadow();drawPie()}if(attempts>=redrawAttempts){clear();target.prepend('<div class="error">Could not draw pie with labels contained inside canvas</div>')}if(plot.setSeries&&plot.insertLegend){plot.setSeries(slices);plot.insertLegend()}function clear(){ctx.clearRect(0,0,canvas.width,canvas.height);target.children().filter('.pieLabel, .pieLabelBackground').remove()}function drawShadow(){var shadowLeft=5;var shadowTop=15;var edge=10;var alpha=0.02;if(options.series.pie.radius>1)var radius=options.series.pie.radius;else var radius=maxRadius*options.series.pie.radius;if(radius>=(canvas.width/2)-shadowLeft||radius*options.series.pie.tilt>=(canvas.height/2)-shadowTop||radius<=edge)return;ctx.save();ctx.translate(shadowLeft,shadowTop);ctx.globalAlpha=alpha;ctx.fillStyle='#000';ctx.translate(centerLeft,centerTop);ctx.scale(1,options.series.pie.tilt);for(var i=1;i<=edge;i++){ctx.beginPath();ctx.arc(0,0,radius,0,Math.PI*2,false);ctx.fill();radius-=i}ctx.restore()}function drawPie(){startAngle=Math.PI*options.series.pie.startAngle;if(options.series.pie.radius>1)var radius=options.series.pie.radius;else var radius=maxRadius*options.series.pie.radius;ctx.save();ctx.translate(centerLeft,centerTop);ctx.scale(1,options.series.pie.tilt);ctx.save();var currentAngle=startAngle;for(var i in slices)drawSlice(slices[i].angle,slices[i].color,true);ctx.restore();ctx.save();ctx.lineWidth=options.series.pie.stroke.width;currentAngle=startAngle;for(var i in slices)drawSlice(slices[i].angle,options.series.pie.stroke.color,false);ctx.restore();if(options.series.pie.label.show)drawLabels();ctx.restore();function drawSlice(angle,color,fill){if(angle<=0)return;if(fill)ctx.fillStyle=color;else ctx.strokeStyle=color;ctx.beginPath();if(angle!=Math.PI*2)ctx.moveTo(0,0);ctx.arc(0,0,radius,currentAngle,currentAngle+angle,false);ctx.closePath();currentAngle+=angle;if(fill)ctx.fill();else ctx.stroke()}function drawLabels(){var currentAngle=startAngle;if(options.series.pie.label.radius>1)var radius=options.series.pie.label.radius;else var radius=maxRadius*options.series.pie.label.radius;for(var i in slices){if(slices[i].percent>=options.series.pie.label.threshold*100)drawLabel(slices[i],currentAngle,i);currentAngle+=slices[i].angle}function drawLabel(slice,startAngle,index){if(slice.data[0][1]==0)return;var lf=options.legend.labelFormatter,text,plf=options.series.pie.label.formatter;if(lf)text=lf(slice.label,slice);else text=slice.label;if(plf)text=plf(text,slice);var halfAngle=((startAngle+slice.angle)+startAngle)/2;var x=centerLeft+Math.round(Math.cos(halfAngle)*radius);var y=centerTop+Math.round(Math.sin(halfAngle)*radius)*options.series.pie.tilt;var html='<span class="pieLabel" id="pieLabel'+index+'" style="position:absolute;top:'+y+'px;left:'+x+'px;">'+text+"</span>";target.append(html);var label=target.children('#pieLabel'+index);var labelTop=(y-label.height()/2);var labelLeft=(x-label.width()/2);label.css('top',labelTop);label.css('left',labelLeft);if(0-labelTop>0||0-labelLeft>0||canvas.height-(labelTop+label.height())<0||canvas.width-(labelLeft+label.width())<0)redraw=true;if(options.series.pie.label.background.opacity!=0){var c=options.series.pie.label.background.color;if(c==null){c=slice.color}var pos='top:'+labelTop+'px;left:'+labelLeft+'px;';$('<div class="pieLabelBackground" style="position:absolute;width:'+label.width()+'px;height:'+label.height()+'px;'+pos+'background-color:'+c+';"> </div>').insertBefore(label).css('opacity',options.series.pie.label.background.opacity)}}}}}}var options={series:{pie:{show:false,radius:'auto',startAngle:3/2,tilt:1,offset:{top:0,left:'auto'},stroke:{color:'#FFF',width:1},label:{show:'auto',formatter:function(label,slice){return'<div style="font-size:x-small;text-align:center;padding:2px;color:'+slice.color+';">'+label+'<br/>'+Math.round(slice.percent)+'%</div>'},radius:1,background:{color:null,opacity:0},threshold:0},combine:{threshold:-1,color:null,label:'Other'}}}};$.plot.plugins.push({init:init,options:options,name:"pie",version:"0.4"})})(jQuery);