<?php
/**
 *  Copyright 2011 Wordnik, Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 *
 * NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
 */

require(dirname(__FILE__) . '/Taxamo/Swagger.php');

class Taxamo {

    public static $VERSION = "1.0.21";

	function __construct($apiClient) {
	  $this->apiClient = $apiClient;
	}

  /**
	 * createRefund
	 * Create a refund
   * key, string: Transaction key. (required)

   * body, createRefundIn: Input (required)

   * @return createRefundOut
	 */

   public function createRefund($key, $body) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}/refunds";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "POST";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'createRefundOut');
  		return $responseObject;

      }
  /**
	 * createPayment
	 * Register a payment
   * key, string: Transaction key. (required)

   * body, createPaymentIn: Input (required)

   * @return createPaymentOut
	 */

   public function createPayment($key, $body) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}/payments";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "POST";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'createPaymentOut');
  		return $responseObject;

      }
  /**
	 * listPayments
	 * List payments
   * limit, string: Max record count (no more than 100, defaults to 10). (optional)

   * offset, string: How many records need to be skipped, defaults to 0. (optional)

   * key, string: Transaction key. (required)

   * @return listPaymentsOut
	 */

   public function listPayments($limit=null, $offset=null, $key) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}/payments";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($limit != null) {
  		  $queryParams['limit'] = $this->apiClient->toQueryValue($limit);
  		}
  		if($offset != null) {
  		  $queryParams['offset'] = $this->apiClient->toQueryValue($offset);
  		}
  		if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'listPaymentsOut');
  		return $responseObject;

      }

  /**
	 * capturePayment
	 * Capture payment
   * key, string: Transaction key. (required)

   * @return capturePaymentOut
	 */

   public function capturePayment($key) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}/payments/capture";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "POST";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'capturePaymentOut');
  		return $responseObject;

      }
  /**
	 * emailInvoice
	 * Email invoice to transaction.buyer_email or to provided email.
   * key, string: Transaction key. (optional)

   * body, emailInvoiceIn: Input (required)

   * @return emailInvoiceOut
	 */

   public function emailInvoice($key=null, $body) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}/invoice/send_email";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "POST";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'emailInvoiceOut');
  		return $responseObject;

      }
  /**
	 * createTransaction
	 * Store transaction
   * body, createTransactionIn: Input (required)

   * @return createTransactionOut
	 */

   public function createTransaction($body) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "POST";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      //make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'createTransactionOut');
  		return $responseObject;

      }
  /**
	 * getTransaction
	 * Retrieve transaction data.
   * key, string: Transaction key (required)

   * @return getTransactionOut
	 */

   public function getTransaction($key) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getTransactionOut');
  		return $responseObject;

      }
  /**
	 * updateTransaction
	 * Update transaction
   * key, string: Transaction key. (optional)

   * body, updateTransactionIn: Input (required)

   * @return updateTransactionOut
	 */

   public function updateTransaction($key=null, $body) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "PUT";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'updateTransactionOut');
  		return $responseObject;

      }
  /**
	 * confirmTransaction
	 * Confirm transaction
   * key, string: Transaction key. (optional)

   * body, confirmTransactionIn: Input (required)

   * @return confirmTransactionOut
	 */

   public function confirmTransaction($key=null, $body) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}/confirm";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "POST";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'confirmTransactionOut');
  		return $responseObject;

      }
  /**
	 * cancelTransaction
	 * Delete transaction
   * key, string: Transaction key (optional)

   * @return cancelTransactionOut
	 */

   public function cancelTransaction($key=null) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "DELETE";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'cancelTransactionOut');
  		return $responseObject;

      }

  /**
	 * unconfirmTransaction
	 * Un-confirm the transaction. Un-confirmed transaction can be edited or canceled like a newly created one.
   * key, string: Transaction key. (optional)

   * body, unconfirmTransactionIn: Input (required)

   * @return unconfirmTransactionOut
	 */

   public function unconfirmTransaction($key=null, $body) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions/{key}/unconfirm";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "POST";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($key != null) {
  			$resourcePath = str_replace("{" . "key" . "}",
  			                            $this->apiClient->toPathValue($key), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'unconfirmTransactionOut');
  		return $responseObject;

      }
  /**
	 * listTransactions
	 * Browse transactions
   * statuses, string: Comma separated list of of transaction statuses. (optional)

   * sort_reverse, bool: If true, results are sorted in descending order. (optional)

   * tax_country_code, string: Two letter ISO tax country code. (optional)

   * order_date_from, string: Order date from in yyyy-MM-dd format. (optional)

   * key_or_custom_id, string: Taxamo provided transaction key or custom id (optional)

   * offset, integer: Offset (optional)

   * filter_text, string: Filtering expression (optional)

   * format, string: Output format - supports 'csv' value for this operation. (optional)

   * order_date_to, string: Order date to in yyyy-MM-dd format. (optional)

   * currency_code, string: Three letter ISO currency code. (optional)

   * limit, integer: Limit (optional)

   * @return listTransactionsOut
	 */

   public function listTransactions($statuses=null, $sort_reverse=null, $tax_country_code=null, $order_date_from=null, $key_or_custom_id=null, $offset=null, $filter_text=null, $format=null, $order_date_to=null, $currency_code=null, $limit=null) {

  		//parse inputs
  		$resourcePath = "/api/v1/transactions";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($statuses != null) {
  		  $queryParams['statuses'] = $this->apiClient->toQueryValue($statuses);
  		}
  		if($sort_reverse != null) {
  		  $queryParams['sort_reverse'] = $this->apiClient->toQueryValue($sort_reverse);
  		}
  		if($tax_country_code != null) {
  		  $queryParams['tax_country_code'] = $this->apiClient->toQueryValue($tax_country_code);
  		}
  		if($order_date_from != null) {
  		  $queryParams['order_date_from'] = $this->apiClient->toQueryValue($order_date_from);
  		}
  		if($key_or_custom_id != null) {
  		  $queryParams['key_or_custom_id'] = $this->apiClient->toQueryValue($key_or_custom_id);
  		}
  		if($offset != null) {
  		  $queryParams['offset'] = $this->apiClient->toQueryValue($offset);
  		}
  		if($filter_text != null) {
  		  $queryParams['filter_text'] = $this->apiClient->toQueryValue($filter_text);
  		}
  		if($format != null) {
  		  $queryParams['format'] = $this->apiClient->toQueryValue($format);
  		}
  		if($order_date_to != null) {
  		  $queryParams['order_date_to'] = $this->apiClient->toQueryValue($order_date_to);
  		}
  		if($currency_code != null) {
  		  $queryParams['currency_code'] = $this->apiClient->toQueryValue($currency_code);
  		}
  		if($limit != null) {
  		  $queryParams['limit'] = $this->apiClient->toQueryValue($limit);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'listTransactionsOut');
  		return $responseObject;

      }
  /**
	 * calculateTax
	 * Calculate tax
   * body, calculateTaxIn: Input (required)

   * @return calculateTaxOut
	 */

   public function calculateTax($body) {

  		//parse inputs
  		$resourcePath = "/api/v1/tax/calculate";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "POST";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      //make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'calculateTaxOut');
  		return $responseObject;

      }
  /**
	 * calculateSimpleTax
	 * Simple tax
   * buyer_credit_card_prefix, string: Buyer's credit card prefix. (optional)

   * buyer_tax_number, string:  Buyer's tax number - EU VAT number for example. If using EU VAT number, it is possible to provide country code in it (e.g. IE1234567X) or simply use billing_country_code field for that. In the first case, if billing_country_code value was provided, it will be overwritten with country code value extracted from VAT number - but only if the VAT has been verified properly. (optional)

   * product_type, string: Product type, according to dictionary /dictionaries/product_types.  (optional)

   * force_country_code, string: Two-letter ISO country code, e.g. FR. Use it to force country code for tax calculation. (optional)

   * quantity, number: Quantity Defaults to 1. (optional)

   * unit_price, number: Unit price. (optional)

   * total_amount, number: Total amount. Required if amount is not provided. (optional)

   * tax_deducted, bool: If the transaction is in a country supported by Taxamo, but the tax is not calculated due to merchant settings or EU B2B transaction for example. (optional)

   * amount, number: Amount. Required if total amount is not provided. (optional)

   * billing_country_code, string: Billing two letter ISO country code. (optional)

   * currency_code, string: Currency code for transaction - e.g. EUR. (required)

   * order_date, string: Order date in yyyy-MM-dd format, in merchant's timezone. If provided by the API caller, no timezone conversion is performed. Default value is current date and time. When using public token, the default value is used. (optional)

   * @return calculateSimpleTaxOut
	 */

   public function calculateSimpleTax($buyer_credit_card_prefix=null, $buyer_tax_number=null, $product_type=null, $force_country_code=null, $quantity=null, $unit_price=null, $total_amount=null, $tax_deducted=null, $amount=null, $billing_country_code=null, $currency_code, $order_date=null) {

  		//parse inputs
  		$resourcePath = "/api/v1/tax/calculate";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($buyer_credit_card_prefix != null) {
  		  $queryParams['buyer_credit_card_prefix'] = $this->apiClient->toQueryValue($buyer_credit_card_prefix);
  		}
  		if($buyer_tax_number != null) {
  		  $queryParams['buyer_tax_number'] = $this->apiClient->toQueryValue($buyer_tax_number);
  		}
  		if($product_type != null) {
  		  $queryParams['product_type'] = $this->apiClient->toQueryValue($product_type);
  		}
  		if($force_country_code != null) {
  		  $queryParams['force_country_code'] = $this->apiClient->toQueryValue($force_country_code);
  		}
  		if($quantity != null) {
  		  $queryParams['quantity'] = $this->apiClient->toQueryValue($quantity);
  		}
  		if($unit_price != null) {
  		  $queryParams['unit_price'] = $this->apiClient->toQueryValue($unit_price);
  		}
  		if($total_amount != null) {
  		  $queryParams['total_amount'] = $this->apiClient->toQueryValue($total_amount);
  		}
  		if($tax_deducted != null) {
  		  $queryParams['tax_deducted'] = $this->apiClient->toQueryValue($tax_deducted);
  		}
  		if($amount != null) {
  		  $queryParams['amount'] = $this->apiClient->toQueryValue($amount);
  		}
  		if($billing_country_code != null) {
  		  $queryParams['billing_country_code'] = $this->apiClient->toQueryValue($billing_country_code);
  		}
  		if($currency_code != null) {
  		  $queryParams['currency_code'] = $this->apiClient->toQueryValue($currency_code);
  		}
  		if($order_date != null) {
  		  $queryParams['order_date'] = $this->apiClient->toQueryValue($order_date);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'calculateSimpleTaxOut');
  		return $responseObject;

      }
  /**
	 * validateTaxNumber
	 * Validate VAT number
   * country_code, string: Two-letter ISO country code. (optional)

   * tax_number, string: Tax number (required)

   * @return validateTaxNumberOut
	 */

   public function validateTaxNumber($country_code=null, $tax_number) {

  		//parse inputs
  		$resourcePath = "/api/v1/tax/vat_numbers/{tax_number}/validate";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($country_code != null) {
  		  $queryParams['country_code'] = $this->apiClient->toQueryValue($country_code);
  		}
  		if($tax_number != null) {
  			$resourcePath = str_replace("{" . "tax_number" . "}",
  			                            $this->apiClient->toPathValue($tax_number), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'validateTaxNumberOut');
  		return $responseObject;

      }
  /**
	 * calculateTaxLocation
	 * Calculate location
   * billing_country_code, string: Billing two letter ISO country code. (optional)

   * buyer_credit_card_prefix, string: Buyer's credit card prefix. (optional)

   * @return calculateTaxLocationOut
	 */

   public function calculateTaxLocation($billing_country_code=null, $buyer_credit_card_prefix=null) {

  		//parse inputs
  		$resourcePath = "/api/v1/tax/location/calculate";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($billing_country_code != null) {
  		  $queryParams['billing_country_code'] = $this->apiClient->toQueryValue($billing_country_code);
  		}
  		if($buyer_credit_card_prefix != null) {
  		  $queryParams['buyer_credit_card_prefix'] = $this->apiClient->toQueryValue($buyer_credit_card_prefix);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'calculateTaxLocationOut');
  		return $responseObject;

      }
  /**
	 * locateMyIP
	 * Locate IP
   * @return locateMyIPOut
	 */

   public function locateMyIP() {

  		//parse inputs
  		$resourcePath = "/api/v1/geoip";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      //make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'locateMyIPOut');
  		return $responseObject;

      }
  /**
	 * locateGivenIP
	 * Locate provided IP
   * ip, string: IP address. (optional)

   * @return locateGivenIPOut
	 */

   public function locateGivenIP($ip=null) {

  		//parse inputs
  		$resourcePath = "/api/v1/geoip/{ip}";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($ip != null) {
  			$resourcePath = str_replace("{" . "ip" . "}",
  			                            $this->apiClient->toPathValue($ip), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'locateGivenIPOut');
  		return $responseObject;

      }
  /**
	 * getTransactionsStats
	 * Transaction stats
   * date_from, string: Date from in yyyy-MM format. (required)

   * date_to, string: Date to in yyyy-MM format. (required)

   * interval, string: Interval. Accepted values are 'day', 'week' and 'month'. (optional)

   * @return getTransactionsStatsOut
	 */

   public function getTransactionsStats($date_from, $date_to, $interval=null) {

  		//parse inputs
  		$resourcePath = "/api/v1/stats/transactions";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($date_from != null) {
  		  $queryParams['date_from'] = $this->apiClient->toQueryValue($date_from);
  		}
  		if($date_to != null) {
  		  $queryParams['date_to'] = $this->apiClient->toQueryValue($date_to);
  		}
  		if($interval != null) {
  		  $queryParams['interval'] = $this->apiClient->toQueryValue($interval);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getTransactionsStatsOut');
  		return $responseObject;

      }
  /**
	 * getSettlementStatsByCountry
	 * Settlement by country
   * date_from, string: Date from in yyyy-MM format. (required)

   * date_to, string: Date to in yyyy-MM format. (required)

   * @return getSettlementStatsByCountryOut
	 */

   public function getSettlementStatsByCountry($date_from, $date_to) {

  		//parse inputs
  		$resourcePath = "/api/v1/stats/settlement/by_country";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($date_from != null) {
  		  $queryParams['date_from'] = $this->apiClient->toQueryValue($date_from);
  		}
  		if($date_to != null) {
  		  $queryParams['date_to'] = $this->apiClient->toQueryValue($date_to);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getSettlementStatsByCountryOut');
  		return $responseObject;

      }
  /**
	 * getSettlementStatsByTaxationType
	 * Settlement by tax type
   * date_from, string: Date from in yyyy-MM format. (required)

   * date_to, string: Date to in yyyy-MM format. (required)

   * @return getSettlementStatsByTaxationTypeOut
	 */

   public function getSettlementStatsByTaxationType($date_from, $date_to) {

  		//parse inputs
  		$resourcePath = "/api/v1/stats/settlement/by_taxation_type";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($date_from != null) {
  		  $queryParams['date_from'] = $this->apiClient->toQueryValue($date_from);
  		}
  		if($date_to != null) {
  		  $queryParams['date_to'] = $this->apiClient->toQueryValue($date_to);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getSettlementStatsByTaxationTypeOut');
  		return $responseObject;

      }
  /**
	 * getRefunds
	 * Fetch refunds
   * format, string: Output format. 'csv' value is accepted as well (optional)

   * moss_country_code, string: MOSS country code, used to determine currency. If ommited, merchant default setting is used. (optional)

   * date_from, string: Take only refunds issued at or after the date. Format: yyyy-MM-dd (required)

   * @return getRefundsOut
	 */

   public function getRefunds($format=null, $moss_country_code=null, $date_from) {

  		//parse inputs
  		$resourcePath = "/api/v1/settlement/refunds";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($format != null) {
  		  $queryParams['format'] = $this->apiClient->toQueryValue($format);
  		}
  		if($moss_country_code != null) {
  		  $queryParams['moss_country_code'] = $this->apiClient->toQueryValue($moss_country_code);
  		}
  		if($date_from != null) {
  		  $queryParams['date_from'] = $this->apiClient->toQueryValue($date_from);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getRefundsOut');
  		return $responseObject;

      }
  /**
	 * getSettlement
	 * Fetch settlement
   * format, string: Output format. 'csv' value is accepted as well (optional)

   * moss_country_code, string: MOSS country code, used to determine currency. If ommited, merchant default setting is used. (optional)

   * quarter, string: Quarter in yyyy-MM format. (required)

   * @return getSettlementOut
	 */

   public function getSettlement($format=null, $moss_country_code=null, $quarter) {

  		//parse inputs
  		$resourcePath = "/api/v1/settlement/{quarter}";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($format != null) {
  		  $queryParams['format'] = $this->apiClient->toQueryValue($format);
  		}
  		if($moss_country_code != null) {
  		  $queryParams['moss_country_code'] = $this->apiClient->toQueryValue($moss_country_code);
  		}
  		if($quarter != null) {
  			$resourcePath = str_replace("{" . "quarter" . "}",
  			                            $this->apiClient->toPathValue($quarter), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getSettlementOut');
  		return $responseObject;

      }
  /**
	 * getSettlementSummary
	 * Fetch summary
   * moss_country_code, string: MOSS country code, used to determine currency. If ommited, merchant default setting is used. (optional)

   * quarter, string: Quarter in yyyy-MM format. (required)

   * @return getSettlementSummaryOut
	 */

   public function getSettlementSummary($moss_country_code=null, $quarter) {

  		//parse inputs
  		$resourcePath = "/api/v1/settlement/summary/{quarter}";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($moss_country_code != null) {
  		  $queryParams['moss_country_code'] = $this->apiClient->toQueryValue($moss_country_code);
  		}
  		if($quarter != null) {
  			$resourcePath = str_replace("{" . "quarter" . "}",
  			                            $this->apiClient->toPathValue($quarter), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getSettlementSummaryOut');
  		return $responseObject;

      }
  /**
	 * createSMSToken
	 * Create SMS token
   * body, createSMSTokenIn: Input (required)

   * @return createSMSTokenOut
	 */

   public function createSMSToken($body) {

  		//parse inputs
  		$resourcePath = "/api/v1/verification/sms";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "POST";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      //make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'createSMSTokenOut');
  		return $responseObject;

      }
  /**
	 * verifySMSToken
	 * Verify SMS token
   * token, string: Provided token. (required)

   * @return verifySMSTokenOut
	 */

   public function verifySMSToken($token) {

  		//parse inputs
  		$resourcePath = "/api/v1/verification/sms/{token}";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($token != null) {
  			$resourcePath = str_replace("{" . "token" . "}",
  			                            $this->apiClient->toPathValue($token), $resourcePath);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'verifySMSTokenOut');
  		return $responseObject;

      }
  /**
	 * getCurrenciesDict
	 * Currencies
   * @return getCurrenciesDictOut
	 */

   public function getCurrenciesDict() {

  		//parse inputs
  		$resourcePath = "/api/v1/dictionaries/currencies";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      //make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getCurrenciesDictOut');
  		return $responseObject;

      }
  /**
	 * getProductTypesDict
	 * Product types
   * @return getProductTypesDictOut
	 */

   public function getProductTypesDict() {

  		//parse inputs
  		$resourcePath = "/api/v1/dictionaries/product_types";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      //make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getProductTypesDictOut');
  		return $responseObject;

      }
  /**
	 * getCountriesDict
	 * Countries
   * tax_supported, bool: Should only countries with tax supported be listed? (optional)

   * @return getCountriesDictOut
	 */

   public function getCountriesDict($tax_supported=null) {

  		//parse inputs
  		$resourcePath = "/api/v1/dictionaries/countries";
  		$resourcePath = str_replace("{format}", "json", $resourcePath);
  		$method = "GET";
      $queryParams = array();
      $headerParams = array();
      $headerParams['Accept'] = 'application/json';
      $headerParams['Content-Type'] = 'application/json';

      if($tax_supported != null) {
  		  $queryParams['tax_supported'] = $this->apiClient->toQueryValue($tax_supported);
  		}
  		//make the API Call
      if (! isset($body)) {
        $body = null;
      }
  		$response = $this->apiClient->callAPI($resourcePath, $method,
  		                                      $queryParams, $body,
  		                                      $headerParams);


      if(! $response){
          return null;
        }

  		$responseObject = $this->apiClient->deserialize($response,
  		                                                'getCountriesDictOut');
  		return $responseObject;

      }


}
