<?php

namespace AustraliaPost\Core\Api;

use AustraliaPost\Helpers\Utilities;

abstract class Abstract_Calculator {

	private $settings;

	/**
	 * Abstract_Calculator constructor.
	 *
	 * @param $settings
	 */
	public function __construct($settings) {
		$this->settings = $settings;
		//since 1.7.1 improve debugging mode
		$this->debug(__('Australia Post debug mode is on - to hide these messages, turn debug mode off in the plugin\'s settings page.', 'woocommerce-australia-post-pro'));
		$this->debug_environment();
		$this->debug('Plugin Settings', $this->settings);
	}

	public abstract function calculate( $package_details, $package);

	/**
	 * [calculate the handling fees]
	 *
	 * @param $cost
	 *
	 * @return int|string [number]       [description]
	 * @internal param $ [number] $cost [description]
	 */
	public function calculate_handling_fee($cost)
	{
		if ($this->settings['handling_fee'] == '') {
			return 0;
		}

		if (substr($this->settings['handling_fee'], -1) == '%') {
			$handling_fee = trim(str_replace('%', '', $this->settings['handling_fee']));
			$result = ($cost * ($handling_fee / 100));
			return $result;
		}

		if (is_numeric($this->settings['handling_fee'])) {
			return $this->settings['handling_fee'];
		}
		return 0;
	}

	/**
	 * Output a message
	 *
	 * @param string $title
	 * @param mixed $data
	 * @param string $type
	 */
	protected function debug($title, $data = null, $type = 'notice')
	{

		if (!isset($this->settings['debug_mode']))
			return;

		if ($this->settings['debug_mode'] !== 'yes')
			return;

		if (!current_user_can('manage_options'))
			return;

		if (!$data) {
			$message = $title;
		} else {
			$message = sprintf('%s: <pre>%s</pre>', $title,  Utilities::_json_encode($data, JSON_PRETTY_PRINT));
		}

		wc_add_notice($message, $type);
	}

	private function debug_environment()
	{
		$this->debug('Environment',
			[
				'plugin_version' => AUSPOST_CURRENT_VERSION,
				'php_version' => phpversion(),
			]
		);
	}

	/**
	 * @param $rate_cost
	 *
	 * @return float
	 */
	protected function strip_shipping_tax($rate_cost){
		if ( 'yes' !== $this->settings['enable_stripping_tax']) {
			return $rate_cost;
		}
		return round($rate_cost / 1.1, 2);
	}
}
