<?php

// *****************************************************************************
// WOOCOMMERCE-ALIPAY-CROSS-BORDER / CLASS-WOOCOMMERCE-ALIPAY-CROSS-BORDER.PHP
// OPMC AUSTRALIA
// (C) Peter Newman 2013 - 2014. All rights reserved.
//
// This WordPress plugin is a WooCommerce extension that adds the Alipay
// "Cross-Border" payment gateway to WooCommerce.
//
// The Alipay "Cross-Border" payment gateway is described here:-
//      http://global.alipay.com/ospay/home.htm
//
// This current __FILE__ - "class-woocommerce-alipay-cross-border.php"
// contains the MAIN CODE for the payment gateway itself.  It's
// required/included from:-
//      woocommerce-alipay-cross-border.php
//
// (which is essentially the payment gateway's interface to WooCommerce).
// *****************************************************************************

// =============================================================================
// Abort if we're not being called from WordPress...
// =============================================================================

    if ( ! defined('ABSPATH' ) ) {
        exit() ;
    }

/**
 * Class: WC_Payment_Gateway_Alipay_Cross_Border
 *
 * A standard "WC_Payment_Gateway" class - for the Alipay "Cross-Border"
 * payment gateway.
 *
 * See:  http://docs.woothemes.com/document/payment-gateway-api/
 */
class WC_Payment_Gateway_Alipay_Cross_Border extends WC_Payment_Gateway {

    public function __construct() {

        global $woocommerce;

        $this->id = 'alipay_cross_border' ;

        $this->icon = '';

        $this->has_fields = false ;

        $this->method_title = 'Alipay Cross-Border' ;

        $style_div = '';

        $style_div = str_replace( "\n" , '' , $style_div ) ;

        $this->method_description = sprintf( __('
<div style="%s">Allows visitors from <b>Mainland China</b> to purchase goods from this website:-<br />
&nbsp;&nbsp;&nbsp;&nbsp;a)&nbsp;&nbsp; By using their <b>Debit/Credit Card</b> or <b>Aliway Account</b>, and;<br />
&nbsp;&nbsp;&nbsp;&nbsp;b)&nbsp;&nbsp; Paying in <b>Renminbi</b>.<br />
<br />
<a target="_blank" href="%s" style="text-decoration:none"><b>Alipay</b></a> is Mainland China\'s largest payment gateway.&nbsp; With over 700 million users, it\'s <a target="_blank" href="%s">larger than PayPal</a>.
</div>
', 'alipay-cross-border'), $style_div, "http://global.alipay.com/", "http://en.wikipedia.org/wiki/Alibaba_Group" );

        $this->init_form_fields();

        $this->init_settings();

        if ( method_exists( $this , 'get_option' ) ) {
            //  WC 2+
            $this->enabled              = $this->get_option( 'enabled'              ) ;
            $this->title                = $this->get_option( 'title'                ) ;
            $this->description          = $this->get_option( 'description'          ) ;
            $this->alipay_partner_id    = $this->get_option( 'alipay_partner_id'    ) ;
            $this->alipay_security_code = $this->get_option( 'alipay_security_code' ) ;
            $this->alipay_border_setting= $this->get_option( 'alipay_border_setting' ) ;
			$this->alipay_settlement_currency = $this->get_option( 'alipay_settlement_currency' ) ;
            $this->alipay_allow_test_transactions = $this->get_option( 'alipay_allow_test_transactions' ) ;
            $this->alipay_trade_information = $this->get_option( 'alipay_trade_information' ) ;

        }

	    add_action( 'woocommerce_update_options_payment_gateways_' . $this->id ,
                    array( $this, 'process_admin_options' )
                    ) ;

		// add_action( 'init', array($this, 'alipay_response') );
		// add_action( 'woocommerce_api_wc_alipay', array(&$this, 'alipay_response') );
		add_action( 'init', array( $this, 'check_callback' ) ); /* 1.6.6 */
		add_action( 'woocommerce_thankyou_alipay_cross_border', array( $this, 'alipay_response' ) );
		
		/* initiation of logging instance */
		$this->log = new WC_Logger();
    }   //  END __construct()

    /**
     * Standard "WC_Payment_Gateway_Xxx" "init_form_fields()" routine.
     *
     * Use this method to set $this->form_fields – these are the options you’ll
     * show in admin on your gateway’s settings page and make use of the
     * WC Settings API.
     */
    function init_form_fields() {

        $default_description = __('
Pay in Renminbi/Yuan, using your Mainland China Debit/Credit Card or Alipay
Account
', 'alipay-cross-border');

        $alipay_pid_help_text = sprintf( __('
Please enter the <b>16-character</b> &ldquo;Partner ID&rdquo; (PID), that Alipay
assigned you when you opened your Alipay account.&nbsp; You can sign up for an
Alipay account at <a target="_blank"
href="%1$s"
>%1$s</a>.&nbsp; It\'s an account for the
&ldquo;<b>Cross-border Website Payment</b>&rdquo; product that you need.<br />
<br />
Note that once you\'ve signed-up for the Alipay web-site, you then have to
apply for the Alipay Merchant Account proper at <a target="_blank"
href="%2$s">%2$s</a>.
', 'alipay-cross-border'), 'http://global.alipay.com/ospay/home.htm', 'http://global.alipay.com/product/websitepayment.htm' );

        $alipay_security_code_help_text = __('
Please enter the <b>32-character</b> &ldquo;Security Code&rdquo; that Alipay
assigned you when you opened your Alipay account.&nbsp; This Security Code is
also known as the &lsquo;Secret Key&rsquo; for the &lsquo;MD5 Signature
Mechanism&rsquo;.
', 'alipay-cross-border');

		$alipay_allow_test_transactions_help_text = __('
Alipay allow you to make FREE test transactions (to check that this plugin and
your Alipay account are both setup and working correctly).<br /><br />For
security reasons, you should <strong>DIS-ALLOW</strong> test transactions -
except when actually making them.<br /><br />Please refer to our <a href="http://docs.woothemes.com/document/alipay-cross-border-payment-gateway/" target="_blank">online
documentation</a> for full details of how to make Alipay test transactions (and
in particular, the additional setup required to do this).
', 'alipay-cross-border');

        $sub_header_style = '' ;

        $alipay_gateway_title_for_checkout_page = __('
This controls the title which the user sees during checkout.<br />
<br />
<u>NOTE!</u><br />
Although this plugin is an "Alipay Cross-Border" payment gateway (rather than
an "Alipay" payment gateway), we describe it (by default), to the customer as
"Alipay".&nbsp; This is because it\'s of no concern to the customer whether the
Merchant is one whoose bank account is outside Mainland China (and who 
therefore uses the "Alipay Cross-Border" payment gateway).&nbsp; Or whether the
Merchant is one whoose bank account is inside Mainland China (and who therefore
uses the "Alipay" payment gateway).<br /><br />
All the customer cares about, is that he wants to pay by "Alipay".
', 'alipay-cross-border');

        $alipay_settlement_currency_help_text = __('
Please select the settlement currency of your Alipay account.<br /><br />
Please note: If your WooCommerce store currency is set to <b>Chinese Yuan (¥)</b> your 
customers will need to agree to a disclaimer to purchase foreign currency during 
the AliPay payment process.', 'alipay-cross-border');

        //  NOTE!
        //  =====
        //  There's a BUG in either WordPress or WooCommerce.
        //  In that WooCommerce form field names (or WordPress "meta_key"
        //  names) must be no more than 32 chars.
        //
        //  So:-
        //      'alipay_allow_test_transactions' => array(
        //
        //  is OK.  But:-
        //      'alipay_allow_alipay_test_transactions' => array(
        //
        //  isn't.

        $form_fields_array = array(

	    'group_title_basic_settings' => array(
            'title'         => __( '<h3 style="' . $sub_header_style . '">Basic Settings...</h3>' , 'alipay_cross_border' ) ,
            'type'          => 'title' ,
            'description'   => ''
        ),

        'enabled' => array(
           	'title'         => __( 'Enable/Disable', 'alipay-cross-border' ),
           	'type'          => 'checkbox',
           	'label'         => __( 'Enable Alipay Cross-Border', 'alipay_cross_border' ),
           	'default'       => 'yes'
        ),
         'custom_cate_field' => array(
            'title'         => __( 'Enable/Disable Trade Info Categories', 'alipay-cross-border' ),
            'type'          => 'checkbox',
            'label'         => __( 'Enable Alipay Trade info Categories', 'alipay_cross_border' ),
            'default'       => 'no'
        ),
        'custom_arrtibutes_field' => array(
            'title'         => __( 'Enable/Disable Trade info Product Attributes', 'alipay-cross-border' ),
            'type'          => 'checkbox',
            'label'         => __( 'Enable Alipay Trade info Product Attributes', 'alipay_cross_border' ),
            'default'       => 'no'
        ),

        'title' => array(
    		'title'         => __( 'Title', 'alipay-cross-border' ),
    		'type'          => 'text',
    		'description'   => __( 'This controls the title which the user sees during checkout.', 'alipay-cross-border' ) ,
    		'default'       => __( 'Alipay', 'alipay_cross_border' ) ,
    		'desc_tip'      => FALSE ,
        ),

        'description' => array(
    		'title'         => __( 'Customer Message', 'alipay-cross-border' ) ,
    		'type'          => 'textarea' ,
    		'description'   => __( 'This controls the description which the user sees during checkout.' , 'alipay-cross-border' ) ,
    		'default'       => $default_description
        ),

        'group_title_alipay_account_details' => array(
            'title'         => __( '<h3 style="' . $sub_header_style . '">Your Alipay Account Details...</h3>' , 'alipay_cross_border' ) ,
            'type'          => 'title' ,
            'description'   => ''
        ),

        'alipay_partner_id' => array(
    		'title'             => __( 'Alipay Partner ID (PID)' , 'alipay_cross_border' ) ,
    		'type'              => 'text' ,
    		'description'       => __( $alipay_pid_help_text , 'alipay_cross_border' ) ,
    		'custom_attributes' => array( 'maxlength' => '16' )
        ),

        'alipay_security_code' => array(
        	'title'             => __( 'Alipay Security Code' , 'alipay_cross_border' ) ,
        	'type'              => 'text' ,
        	'description'       => __( $alipay_security_code_help_text , 'alipay_cross_border' ) ,
        	'custom_attributes' => array( 'maxlength' => '32' )
        ),

        'alipay_settlement_currency' => array(
    		'title'      => __( 'Settlement Currency' , 'alipay_cross_border' ) ,
    		'label'      => __( ' ', 'alipay_cross_border' ),
    		'description'=> __( $alipay_settlement_currency_help_text , 'alipay_cross_border' ) ,
    		'id' 		 => 'alipay_settlement_currency',
    		'css' 		 => 'min-width:350px;',
    		'default'	 => 'AUD',
    		'type' 		 => 'select',
    		'class'		 => 'chosen_select',
    		'options'    => array(
    			'AUD'       =>  'Australian Dollar' 			. ' (' . get_woocommerce_currency_symbol( 'AUD' ) . ')' ,
    			'NZD'       =>  'New Zealand Dollar' 			. ' (' . get_woocommerce_currency_symbol( 'NZD' ) . ')' ,
    			'CAD'       =>  'Canada Dollar' 				. ' (' . get_woocommerce_currency_symbol( 'CAD' ) . ')' ,
    			'CHF'       =>  'Confederation Helvetica Franc' . ' (' . get_woocommerce_currency_symbol( 'CHF' ) . ')' ,
                'CNY'       =>  'Chinese yuan'                  . ' (' . get_woocommerce_currency_symbol( 'CNY' ) . ')' ,
    			'DKK'       =>  'Danish Krone' 					. ' (' . get_woocommerce_currency_symbol( 'DKK' ) . ')' ,
    			'EUR'       =>  'Euro' 							. ' (' . get_woocommerce_currency_symbol( 'EUR' ) . ')'	,
    			'GBP'       =>  'British Sterling' 				. ' (' . get_woocommerce_currency_symbol( 'GBP' ) . ')' ,
    			'HKD'       =>  'Hong Kong Dollar' 				. ' (' . get_woocommerce_currency_symbol( 'HKD' ) . ')' ,
    			'JPY'       =>  'Japanese Yen' 					. ' (' . get_woocommerce_currency_symbol( 'JPY' ) . ')' ,
    			'NOK'       =>  'Norwegian Krone' 				. ' (' . get_woocommerce_currency_symbol( 'NOK' ) . ')' ,
    			'SEK'       =>  'Swedish Krona' 				. ' (' . get_woocommerce_currency_symbol( 'SEK' ) . ')' ,
    			'SGD'       =>  'Singapore Dollar' 				. ' (' . get_woocommerce_currency_symbol( 'SGD' ) . ')' ,
    			'THB'       =>  'Thai Baht' 				    . ' (' . get_woocommerce_currency_symbol( 'THB' ) . ')' ,
    			'USD'       =>  'U.S. Dollar' 					. ' (' . get_woocommerce_currency_symbol( 'USD' ) . ')' ,

    		)
        ),
            
            
        'alipay_border_setting' => array(
    		'title'      => __( 'Payment Setting' , 'alipay_cross_border' ) ,
    		'label'      => __( ' ', 'alipay_cross_border' ),
    		'id' 		 => 'alipay_border_setting',
    		'css' 		 => 'min-width:350px;',
    		'default'	 => 'NB',
    		'type' 		 => 'select',
    		'class'		 => 'chosen_select',
    		'options'    => array(
    			'NB'       =>  'New Cross-border Online Payment',
    			'OB'       =>  'Old Cross-border Online Payment',
    		)	
        ),
        
        'alipay_trade_information' => array(
            'title'      => __( 'Trade Information' , 'alipay_cross_border' ) ,
            'label'      => __( ' ', 'alipay_cross_border' ),
            'id'         => 'alipay_trade_information',
            'css'        => 'min-width:350px;',
            'default'    => '4',
            'type'       => 'select',
            'class'      => 'chosen_select',
            'options'    => array(
                '4'       =>  'Retailing',
                '5'       =>  'Other',
            )   
        ),
        
		'group_title_alipay_test_transactions' => array(
            'title'         => __( '<h3 style="' . $sub_header_style . '">Alipay Test Transactions?</h3>' , 'alipay_cross_border' ) ,
            'type'          => 'title' ,
            'description'   => ''
        ),

            //'alipay_allow_test_transactions' => array(
        'alipay_allow_test_transactions'  => array(
    		'title'             => __( 'Allow Alipay Test Transactions?' , 'alipay_cross_border' ) ,
    		'type'              => 'checkbox' ,
    		'description'       => __( $alipay_allow_test_transactions_help_text , 'alipay_cross_border' ) ,
                'default'           =>  'no'
            )
        );

        $this->form_fields = $form_fields_array ;

    }   // END of "init_form_fields()"


    public function process_payment( $order_id ) {  //  See NOTE below.

        $missing_arg_line = __LINE__ - 3 ;      //  See below...

        // =====================================================================
        // NOTE!
        // -----
        // To stop the following error message being issued (by PHP, if
        // "error_reporting" and "display_errors" are both ON):-
        //      "Strict Standards: Declaration of WC_Gateway_Payment_Express::process_payment()
        //      should be compatible with that of WC_Payment_Gateway::process_payment() in
        //          /home/plugtest/public_html/site/wp-content/plugins/woocommerce-payment-express-v1.6/gateway-dps-express.php
        //      on line 47"
        //
        // we define the process_payment() function the same as it was defined
        // in the ABSTRACT "WC_Payment_Gateway" class.  Ie, with NO
        // parameters.
        //
        // Then we check for the single expected $order_id parameter manually.
        // =====================================================================

        if ( func_num_args() !== 1 ) {

            $fn   = __FUNCTION__ ;
            $file = __FILE__ ;

$msg = __('
<b>Warning</b>: Missing argument 1 for '. $fn .'}, in <b>' .$file .'</b> on line </b>'. $missing_arg_line .'</b>
', 'alipay-cross-border');

			if ( function_exists( 'wc_add_notice' ) ) {
				wc_add_notice( __( $msg, 'alipay-cross-border' ), $notice_type = 'notice' ); 
			} else {
				$woocommerce->add_error( __( 'Payment error.', 'alipay-cross-border' ) ) ; 
			}
			
        }

        if (    ! is_string( $this->alipay_partner_id )
                ||
                ! ctype_alnum( $this->alipay_partner_id )
                ||
                strlen( $this->alipay_partner_id ) != 16
            ) {

            $msg = __('
&nbsp;&nbsp; Sorry, but the <strong>Alipay Cross-Border</strong> payment
method <strong>isn\'t currently available</strong>.&nbsp; Because although
this web site has enabled it, they haven\'t specified a valid Alipay
"Partner ID" (in their <em>WooCommerce &raquo; Payment Gateways
&raquo; Alipay Cross-Border</em> settings).&nbsp; Please contact the
web-site, and ask them to enter or correct their Partner ID.
', 'alipay-cross-border');
            global $woocommerce ;
			
			$this->log->add( 'ALIPAY', print_r( array( 'Payment error:' => $msg ), true ) );

			if ( function_exists( 'wc_add_notice' ) ) {
				wc_add_notice( __( 'Payment error.', 'alipay-cross-border' ), $notice_type = 'error' ); 
			} else {
				$woocommerce->add_error( __( 'Payment error.', 'alipay-cross-border' ) ) ; 
			}

            return ;

        }

        $order = new WC_Order( $order_id ) ;

        require_once( dirname( __FILE__ ) . '/includes/get-url-and-query-string-for-payment-request.php' ) ;

/*         $notify_url = plugins_url(
                            'includes/payment-notification-handler.php'     ,
                            __FILE__
                            ) ; */

		$notify_url         = WC()->api_request_url( 'WC_Payment_Gateway_Alipay_Cross_Border' );
		/* [notify_url:] => http://test-website.nicer4.com/wc-api/WC_Payment_Gateway_Alipay_Cross_Border/*/

$this->log->add( 'ALIPAY', print_r( array( 'notify_url:' => $notify_url ), true ) );

        if ( strlen( $notify_url ) > 200 ) {
            $msg = __('
"notify_url" is too long (must be max. 200 chars)
', 'alipay-cross-border');

			$this->log->add( 'ALIPAY', print_r( array( 'Payment error:' => $msg ), true ) );
            
			if ( function_exists( 'wc_add_notice' ) ) {
				wc_add_notice( __( 'Payment error.', 'alipay-cross-border' ) . 'Invalid notify URL', $notice_type = 'error' ); 
			} else {
				global $woocommerce ;
				$woocommerce->add_error( __( 'Payment error.', 'alipay-cross-border' ) . 'Invalid notify URL' ) ; 
			}
            return ;
        }

        // ---------------------------------------------------------------------
        // RETURN_URL
        // ---------------------------------------------------------------------

        $return_url = $this->get_return_url( $order ) ;

        // ---------------------------------------------------------------------

        if ( strlen( $return_url ) > 200 ) {
            $msg = __('
"return_url" is too long (must be max. 200 chars)
', 'alipay-cross-border');

			$this->log->add( 'ALIPAY', print_r( array( 'Payment error:' => $msg ), true ) );
			
            global $woocommerce ;
            if ( function_exists( 'wc_add_notice' ) ) {
				wc_add_notice( __( 'Payment error.', 'alipay-cross-border' ), $notice_type = 'error' );
			} else { 
				$woocommerce->add_error( __( 'Payment error.', 'alipay-cross-border' ) ) ;
			}
            return ;
        }

        $subject =  get_bloginfo('name') .
                    ': Order No. ' .
                    $order->get_id() .
                    ' from ' .
                    $order->get_billing_email() .	
                    ' (' . $order->get_billing_first_name() . chr(32) . $order->get_billing_last_name() . ')' .	
                    ' on ' .
                    $order->get_date_created() 
                    ;

        $out_trade_no = $order->get_order_key() . '_' . $order->get_id() ;

        $currency = get_woocommerce_currency();
		
		if( get_woocommerce_currency() == 'CNY' ) { $currency = $this->alipay_settlement_currency; }		/** get_woocommerce_currency() == 'CNY' implies that rmb_fee will be used instead of total_fee. **/

        // ---------------------------------------------------------------------

		if ( version_compare( WOOCOMMERCE_VERSION, '2.1', '>' ) ) {
			
			$total_fee = $order->get_total() ;

		} else {
			
			$total_fee = $order->get_order_total() ;
			
		}
		
        // ---------------------------------------------------------------------

        $order_gmt_date = $order->get_date_created() ; 


        


        $order_gmt_date = gmdate( 'Y-m-d H:i:s' , strtotime( $order_gmt_date ) ) ;

        $alipay_params = array(
            //  REQUIRED...
            'notify_url'            =>  $notify_url                 ,
            'subject'               =>  $subject                    ,
            'out_trade_no'          =>  $out_trade_no               ,
            'currency'              =>  $currency                   ,
            'total_fee'             =>  $total_fee                  ,
            //  OPTIONAL...
            'return_url'            =>  $return_url
//          'order_gmt_create'      =>  $order_gmt_date
            ) ;

        // ---------------------------------------------------------------------

        if (    $this->alipay_allow_test_transactions === 'yes'
                &&
                $order->get_billing_email() === 'alipay_test@alipay.com' 
            ) {
            $is_alipay_test_transaction = TRUE ;
        } else {
            $is_alipay_test_transaction = FALSE ;
        }

        // ---------------------------------------------------------------------

//ob_start() ;
		$alipay_payment_currency_rmb = 'no';
		if( get_woocommerce_currency() == 'CNY' ) { $alipay_payment_currency_rmb = 'yes'; }	/** get_woocommerce_currency() == 'CNY' implies that rmb_fee will be used instead of total_fee. **/

        $result = \greatKiwi_paymentGateways_alipayCrossBorder\get_url_and_query_string_for_payment_request(
                          $this->alipay_partner_id
                        , $this->alipay_security_code
                        , $is_alipay_test_transaction
                        , $alipay_params
                        , $alipay_payment_currency_rmb,
                        $this->alipay_border_setting
					) ;

//$ps = ob_get_clean() ;

        // ---------------------------------------------------------------------

        if ( is_string( $result ) ) {
            global $woocommerce ;

			$this->log->add( 'ALIPAY', print_r( array( 'Payment error:' => $result ), true ) );
			
            if ( function_exists( 'wc_add_notice' ) ) {
				wc_add_notice( __( 'Payment error.', 'alipay-cross-border' ), $notice_type = 'error' );
			} else { 
				$woocommerce->add_error( __( 'Payment error.', 'alipay-cross-border' ) ) ; 
			}
			
            return ;
        }

        // ---------------------------------------------------------------------
//$alipay_payment_request_url = 'https://openapi.alipaydev.com/gateway.do';
        list(   $alipay_payment_request_url             ,
                $alipay_payment_request_query_string
                ) = $result ;
        // =====================================================================
        // Tell WooCommerce to redirect to Alipay...
        // =====================================================================
if($this->alipay_allow_test_transactions == 'yes') {
    $alipay_payment_request_url = "https://mapi.alipaydev.com/gateway.do";
}else {	$alipay_payment_request_url = "https://intlmapi.alipay.com/gateway.do";}
        $redirect = $alipay_payment_request_url . '?' .
                    $alipay_payment_request_query_string ;
//		echo $redirect; exit();			
$this->log->add( 'ALIPAY', print_r( array("redirect_url>>>" => $redirect), true ) );

error_log( print_r( array("redirect_url>>>" => $redirect), true ) );
//		echo $redirect; exit();
        return array(
                    'result'   => 'success'     ,
                    'redirect' => $redirect
                    ) ;

        // =====================================================================
        // That's that!
        // =====================================================================

    }

	public function alipay_response(){
		
		$this->log->add( 'ALIPAY > Notify', print_r( array("_REQUEST >>> " => $_REQUEST), true ) );
		
	    ob_start() ;

		error_reporting( E_ALL | E_STRICT ) ;
		ini_set( 'display_errors' , '1' ) ;


    // =========================================================================
    // Does $_REQUEST contain the fields expected in an Alipay result
    // notification?
    //
    // If not, IGNORE it...
    // =========================================================================

    $alipay_result_notification_field_names = array(
//        'notify_type'       ,
//        'notify_id'         ,
//        'notify_time'       ,
        'sign'              ,
        'sign_type'         ,
        'out_trade_no'      ,
        'trade_status'      ,
        'trade_no'          ,
        'currency'          ,
        'total_fee'
        ) ;

    $allowed_trade_statuses = array(
        'TRADE_FINISHED'        ,
        'TRADE_CLOSED'
        ) ;

    // -------------------------------------------------------------------------
    if ( ! in_array( $_REQUEST['trade_status'] , $allowed_trade_statuses , TRUE ) ) {
        $msg = <<<EOT
Unrecognised/unsupported "trade_status" value - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;

    }

    if ( $_REQUEST['sign_type'] !== 'MD5' ) {
        $msg = <<<EOT
Unrecognised/unsupported "sign_type" value - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;

    }

    if (    strlen( $_REQUEST['sign'] ) !== 32
            ||
            ! ctype_xdigit( $_REQUEST['sign'] )
        ) {
        $msg = <<<EOT
Bad "sign" value - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;
    }

    if (    strlen( $_REQUEST['trade_no'] ) > 28
            ||
            trim( $_REQUEST['trade_no'] ) === ''
        ) {
        $msg = <<<EOT
Unexpected "trade_no" value - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;
    }

    if (    strlen( $_REQUEST['out_trade_no'] ) > 64
            ||
            trim( $_REQUEST['out_trade_no'] ) === ''
        ) {
        $msg = <<<EOT
Unexpected "out_trade_no" value - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;
    }

    if (    strlen( $_REQUEST['currency'] ) > 10
            ||
            trim( $_REQUEST['currency'] ) === ''
        ) {
        $msg = <<<EOT
Unexpected "currency" value - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;
    }

    if (    strlen( $_REQUEST['total_fee'] ) > 10
            ||
            trim( $_REQUEST['total_fee'] ) === ''
        ) {
        $msg = <<<EOT
Unexpected "total_fee" value - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;
    }
    if ( $_REQUEST['sign_type'] === 'MD5' ) {

        // ---------------------------------------------------------------------

        $ok = ksort( $_REQUEST ) ;

        // ---------------------------------------------------------------------

        if ( $ok !== TRUE ) {
            $msg = <<<EOT
&nbsp;&nbsp; "ksort()" failure preparing \$_POST for sign calculation - in Alipay result notification
EOT;
            $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
            return ;
        }
        // ---------------------------------------------------------------------

        $sign = '' ;

        $comma = '' ;

    } else {

        $msg = <<<EOT
Unrecognised/unsupported "sign_type" - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;

    }

    $out_trade_no_parts = explode( '_' , $_REQUEST['out_trade_no'] ) ;

    // -------------------------------------------------------------------------

    $bad_out_trade_no_msg = <<<EOT
Bad "out_trade_no" (unrecognised/unsupported format) - in Alipay result notification
EOT;

    // -------------------------------------------------------------------------

    if ( count( $out_trade_no_parts ) < 2 ) {

		$this->log->add( 'ALIPAY > ACB_ERROR', $bad_out_trade_no_msg );
        return ;
    }

    // -------------------------------------------------------------------------

    $out_trade_no_order_id = $out_trade_no_parts[
                                count( $out_trade_no_parts ) - 1
                                ] ;     //  Ie; the last entry

    // -------------------------------------------------------------------------

    if ( ! ctype_digit( $out_trade_no_order_id ) ) {
		$this->log->add( 'ALIPAY > ACB_ERROR', $bad_out_trade_no_msg );
        return ;
    }

    // -------------------------------------------------------------------------

    $order_key = substr(    $_REQUEST['out_trade_no']      ,
                            0                           ,
                            strlen( $_REQUEST['out_trade_no'] ) - strlen( $out_trade_no_order_id ) - 1
                            ) ;

    // -------------------------------------------------------------------------
    if ( function_exists( 'wc_get_order_id_by_order_key' ) ) {

        // ---------------------------------------------------------------------
        //  WooCommerce 2...
        // ---------------------------------------------------------------------

        $order_id = wc_get_order_id_by_order_key( $order_key ) ;
                        //  The ID of an order, or 0 if the order could not be
                        //  found.

        // ---------------------------------------------------------------------

    } 

    // -------------------------------------------------------------------------

    if ( $order_id < 1 ) {
        $msg = <<<EOT
Bad "out_trade_no" (order not found) - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;
    }

    // -------------------------------------------------------------------------

    if ( $order_id != $out_trade_no_order_id ) {
        $msg = <<<EOT
Bad "out_trade_no" (order ID mismatch) (#1) - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;
    }
    // -------------------------------------------------------------------------
   /*  $order = new \WC_Order( $order_id ) ; */
	$order = wc_get_order( $order_id );
                //  Get the order if ID is passed, otherwise the order is new
                //  and empty.

    // -------------------------------------------------------------------------

    if ( ! is_object( $order ) ) {
        $msg = <<<EOT
PROBLEM: Order not found (bad "out_trade_no"?) - in Alipay result notification
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;
    }

    // -------------------------------------------------------------------------

    if ( ! function_exists( 'wc_get_order_id_by_order_key' ) ) {

        if ( $order->get_order_key() !== $order_key ) {  
            $msg = <<<EOT
Bad "out_trade_no" (order ID mismatch) (#2) - in Alipay result notification
EOT;
            $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
            return ;

        }

    }

    if ( $this->alipay_allow_test_transactions === 'yes' && $order->get_billing_email() === 'alipay_test@alipay.com' ) {
        $is_alipay_test_transaction = TRUE ;
    } else {
        $is_alipay_test_transaction = FALSE ;
    }


	global $woocommerce ;

    // -------------------------------------------------------------------------

    if (   floatval ( $_REQUEST['total_fee'] ) !== floatval($order->get_total())
            &&
            ( $_REQUEST['total_fee'] === '0.01')
        ) { error_log( print_r( array(floatval ( $_REQUEST['total_fee'] ) . "===".$order->get_total()  ), true ) );
        $msg = <<<EOT
Bad "total_fee" value - in Alipay result notification
(doesn't match the order total in the WooCommerce order record)
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;
    }

//    $notification_verification_request_data = array() ;
//
//    $notification_verification_request_data['service'] =
//        'notify_verify'
//        ;
//
//    $notification_verification_request_data['partner'] =
////      $gateway->get_option( 'alipay_partner_id' )     //  WC 2 only
//        $this->settings['alipay_partner_id']
//        ;
//
//    $notification_verification_request_data['notify_id'] =
//        $_REQUEST['notify_id']
//        ;

//    $alipay_notify_verify_url = 'https://openapi.alipaydev.com/gateway.do' ;
//
//    // -------------------------------------------------------------------------
//
//    $query_string = '' ;
//
//    $comma = '' ;


//    foreach ( $notification_verification_request_data as $name => $value ) {
//        $query_string .= $comma . $name . '=' . urlencode( $value ) ;
//        $comma = '&' ;
////      $comma = '%26' ;    //  Defeat the "&not" browser bug
//    }
//
//    // -------------------------------------------------------------------------
//
//    $result = wp_remote_get(
//                    $alipay_notify_verify_url . '?' . $query_string
//                    ) ;
//					
////error_log( print_r( array(">>> Resutl from alipay notification verification: " => $result), true ) );
//error_log( print_r( array("*****************************************************"), true ) );
//		error_log( print_r( array("result>>>" => $result), true ) );
//    if ( is_wp_error( $result ) ) {
//
//		$this->log->add( 'ALIPAY > ACB_ERROR', $result->get_error_message() );
//        return ;
//    }
//
//    if ( $result['body'] !== 'true' ) {
//
//        $msg = <<<EOT
//NOTIFICATION VERIFICATION FAILURE!
//----------------------------------
//Alipay are saying that they DIDN'T send this
//payment notification (which looked perfectly OK
//to us). Either this is a one-off Internet problem
//(or the like). Or perhaps someone is trying to
//hack your site (by sending a payment notification
//that says they've paid for some goods. When in
//fact, they haven't).
//EOT;
//
//        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
//        return ;
//
//    }


    $order_status_BEFORE_payment_processing = $order->get_status() ; 

$this->log->add( 'ALIPAY > ACB_ERROR', 'order_status_BEFORE_payment_processing>>>>ACB_error'.$order_status_BEFORE_payment_processing );
error_log( print_r( array("order_status_BEFORE_payment_processing>>>error_log" => $order_status_BEFORE_payment_processing), true ) );
    // -------------------------------------------------------------------------

    if ( $_REQUEST['trade_status'] === 'TRADE_FINISHED' ) {

        if ( ! in_array( $order->get_status() , array( 'processing' , 'completed' ) , TRUE ) ) {  

            $order->payment_complete() ;

            if ( $order->get_status() === $order_status_BEFORE_payment_processing ) {  
                /* $order = new WC_Order( $order_id ) ; */
				$order = wc_get_order( $order_id );

            }

        }

    } 
	elseif ( $_REQUEST['trade_status'] === 'TRADE_CLOSED' ) {

        if ( $order->get_status() !== 'cancelled' ) {   

            $order->cancel_order() ;

            if ( $order->get_status() === $order_status_BEFORE_payment_processing ) {  

                /* $order = new \WC_Order( $order_id ) ; */
				$order = wc_get_order( $order_id );
				
            }

            // -----------------------------------------------------------------

        }

        // ---------------------------------------------------------------------

    } else {

        // ---------------------------------------------------------------------

        $msg = <<<EOT
PROBLEM: Unrecognised/unsupported "trade_status"
in Alipay payment notification for WooCommerce
Order# {$order_id}
EOT;
        $this->log->add( 'ALIPAY > ACB_ERROR', $msg );
        return ;

        // ---------------------------------------------------------------------

    }

    // -------------------------------------------------------------------------

    $order_status_AFTER_payment_processing = $order->get_status() ;  

    $order_amount = $order->get_total() ;

    // -------------------------------------------------------------------------

    if (    in_array(   $order_status_AFTER_payment_processing     ,
                        array( 'processing' , 'cancelled' )         ,
                        TRUE
                        )
            &&
            $order_status_AFTER_payment_processing !==
                $order_status_BEFORE_payment_processing
        ) {

        // ---------------------------------------------------------------------
        // Order Note Required
        // ---------------------------------------------------------------------

        if ( $_REQUEST['trade_status'] === 'TRADE_FINISHED' ) {

            // -----------------------------------------------------------------

            $amount_paid = $_REQUEST['total_fee'] ;

            // -----------------------------------------------------------------

            if ( $_REQUEST['total_fee'] == $order_amount ) {
                $result = '***PAID IN FULL***' ;

            } elseif ( $_REQUEST['total_fee'] < $order_amount ) {
                $result = 'WARNING: ***PART PAYMENT ONLY***' ;

            } else {
                $result = 'WARNING: ***OVER-PAYMENT***' ;

            }

            // -----------------------------------------------------------------

        } else {

            // -----------------------------------------------------------------

            $amount_paid = '-' ;

            // -----------------------------------------------------------------

            $result = <<<EOT
WARNING: ***NOT PAID***
EOT;

            // -----------------------------------------------------------------

        }

        // ---------------------------------------------------------------------

        $datetime = date( 'D j F Y G:i (g:ia)' ) ;

        // ---------------------------------------------------------------------

        $note = <<<EOT
<table border="0" cellpadding="0" cellspacing="0">
    <tr>
        <td align="right">Date/Time:</td>
        <td>&nbsp;&nbsp;</td>
        <td>{$datetime}</td>
    </tr>
    <tr>
        <td align="right">Order Total:</td>
        <td>&nbsp;&nbsp;</td>
        <td>&nbsp;<b>{$order_amount}</b></td>
    </tr>
    <tr>
        <td align="right">Amount Paid:</td>
        <td>&nbsp;&nbsp;</td>
        <td>&nbsp;<b>{$amount_paid}</b></td>
    </tr>
    <tr>
        <td align="center" colspan="3"><b>{$result}</b></td>
    </tr>
</table>
EOT;

        // ---------------------------------------------------------------------

        $is_customer_note = 0 ;

        $comment_id = $order->add_order_note( $note , $is_customer_note ) ;

        // ---------------------------------------------------------------------

    }

    // =========================================================================
    // More progress tracking...
    // =========================================================================

    $msg = <<<EOT
Alipay Payment Notification Verified!
-------------------------------------
Order#: {$order_id}
Order Amount: {$order_amount}\n
EOT;

    // -------------------------------------------------------------------------

    if ( $_REQUEST['trade_status'] === 'TRADE_FINISHED' ) {

        // ---------------------------------------------------------------------

        if ( $_REQUEST['total_fee'] == $order_amount ) {
            $result = 'THE CUSTOMER HAS ***PAID IN FULL***' ;

        } elseif ( $_REQUEST['total_fee'] < $order_amount ) {
            $result = 'WARNING: ***PART PAYMENT ONLY***' ;

        } else {
            $result = 'WARNING: ***OVER-PAYMENT***' ;

        }

        // ---------------------------------------------------------------------

        $msg .= <<<EOT
Amount Paid: {$_REQUEST['total_fee']}
{$result}
EOT;

        // ---------------------------------------------------------------------

    } else {

        // ---------------------------------------------------------------------

        $msg .= <<<EOT
Amount Paid: -
THE CUSTOMER ***DID NOT PAY***
EOT;

        // ---------------------------------------------------------------------

    }

    // -------------------------------------------------------------------------

    $msg .= <<<EOT
\n---
Order Status BEFORE Payment Processing: {$order_status_BEFORE_payment_processing}
Order Status AFTER Payment Processing: {$order_status_AFTER_payment_processing}
EOT;

    // -------------------------------------------------------------------------


    $ob = ob_get_clean() ;

    echo 'success' ;

    ob_start() ;

    echo $ob ;

	
	}
	
}   //  END of "class WC_Payment_Gateway_Alipay_Cross_Border extends WC_Gateway"

