<?php

// *****************************************************************************
// GREAT-KIWI / PAYMENT-GATEWAYS / ALIPAY / CROSS-BORDER /
//      GET-URL-AND-QUERY-STRING-FOR-PAYMENT-REQUEST.PHP
// OPMC Australia - www.opmc.com.au
// (C) 2013 - 2014 Peter Newman. All Rights Reserved.
// *****************************************************************************

    namespace greatKiwi_paymentGateways_alipayCrossBorder ;

/**
 * Builds and returns the URL and query string for an Alipay Cross-Border
 * payment request.  
 *
 * Also does error checking of the payment request parameters (to be sent to
 * Alipay in the query string).
 *
 * @param string $alipay_partner_id The merchant's 16-digit "Partner ID"
 * @param string $alipay_partner_id The merchant's 32-alnum "Security Code"     
 * @param bool   $is_alipay_test_transaction Buyer email is "alipay_test@alipay.com"
 * @param array  $alipay_params_in An associative array with info. needed for 
 *                                 the payment request.
 *
 * @return mixed $result    Numerically indexed array on SUCCESS:-
 *                              $result = array( 
 *                                          $alipay_gateway_url     ,
 *                                          $query_string
 *                                          )
 *                          Or $error_message string on FAILURE.
 */
function get_url_and_query_string_for_payment_request(
    $alipay_partner_id                  ,
    $alipay_security_code               ,
    $is_alipay_test_transaction         ,
    $alipay_params_in                   ,
    $pay_in_rmb                         ,
    $payment_border_setting    
    ) {

    $alipay_params_to_send = array() ;

    
	if(wp_is_mobile()){	
		$alipay_params_to_send['service'] = 'create_forex_trade_wap' ;
	}else{
		$alipay_params_to_send['service'] = 'create_forex_trade' ;
	}

    $alipay_settings = get_option( 'woocommerce_alipay_cross_border_settings' );
   // print_r($alipay_settings);die;
    $custom_arrtibute_field = $alipay_settings['custom_arrtibutes_field'];
    $custome_cate_feild = $alipay_settings['custom_cate_field'];
    $trade_info = $alipay_settings['alipay_trade_information'];

    if($trade_info == '1') {
        

    } else if($trade_info == '2'){


    } else if($trade_info == '3'){


    } else if($trade_info == '4'){
        
        $items = WC()->cart->get_cart();
            $goods_info = '';
            $total_qty = '';
        foreach($items as $item => $values) { 

            $_product =  wc_get_product( $values['data']->get_id());
            //print_R($_product);die;
            $product_type = $_product->post_type;
            $parent_id = $_product->get_parent_id();
            if($parent_id != '0')
            {
                $term_id = get_the_terms( $parent_id, 'product_cat' );
                $term_name = $term_id[0]->name;
            }			
			$product_category_ids = $_product->get_category_ids();
            $cat_iddd = $product_category_ids[0];
            $cate_name = get_the_category_by_ID( $cat_iddd );
            if($product_type == 'product')
            {
                $category_name=$cate_name;
                
            }else
            {
                $category_name=$term_name;
                
            }
            $prod_variations = $_product->get_attributes();
            $res = array_values($prod_variations);
            $p_attributes = implode(' ',$res);
            $product_name = $_product->get_title();
            $product_qty = $values['quantity']; 
            $total_qty = WC()->cart->get_cart_contents_count();
            if($custome_cate_feild == 'yes' && $custom_arrtibute_field =='yes')
            {
               $goods_info .= $product_name." ".$p_attributes." ".$category_name."^".$product_qty."|";
            }
            else if($custome_cate_feild == 'yes')
            {
               $goods_info .= $product_name." ".$category_name."^".$product_qty."|";
            }
            else if($custom_arrtibute_field == 'yes')
            {
               $goods_info .= $product_name." ".$p_attributes."^".$product_qty."|";
            }else
            {
               $goods_info .= $product_name."^".$product_qty."|";
            }
        }
            $goods_info =  substr($goods_info, 0, -1);
		
            $alipay_params_to_send['trade_information'] = '{"business_type":"4","goods_info":"'.$goods_info.'", "total_quantity":"'.$total_qty.'"}';
	

     //   $alipay_params_to_send['trade_information'] = json_encode(array("business_type" => "4","goods_info"=>$goods_info, "total_quantity"=>$total_qty));
	

    }else if($trade_info == '5'){

        $items = WC()->cart->get_cart();
            $goods_info = '';
            $total_qty = '';
        foreach($items as $item => $values) { 

            $_product =  wc_get_product( $values['data']->get_id());
            //print_R($_product);die;
            $product_type = $_product->post_type;
            $parent_id = $_product->get_parent_id();
            if($parent_id != '0')
            {
                $term_id = get_the_terms( $parent_id, 'product_cat' );
                $term_name = $term_id[0]->name;
            }
            $product_category_ids = $_product->get_category_ids();
            $cat_iddd = $product_category_ids[0];
            $cate_name = get_the_category_by_ID( $cat_iddd );
            if($product_type == 'product')
            {
                $category_name=$cate_name;
                
            }else
            {
                $category_name=$term_name;
                
            }
            $prod_variations = $_product->get_attributes();
            $res = array_values($prod_variations);
            $p_attributes = implode(' ',$res);
            $product_name = $_product->get_title();
            $product_qty = $values['quantity']; 
            $total_qty = WC()->cart->get_cart_contents_count();
            if($custome_cate_feild == 'yes' && $custom_arrtibute_field =='yes')
            {
               $goods_info .= $product_name." ".$p_attributes." ".$category_name."^".$product_qty."|";
            }
            else if($custome_cate_feild == 'yes')
            {
               $goods_info .= $product_name." ".$category_name."^".$product_qty."|";
            }
            else if($custom_arrtibute_field == 'yes')
            {
               $goods_info .= $product_name." ".$p_attributes."^".$product_qty."|";
            }else
            {
               $goods_info .= $product_name."^".$product_qty."|";
            }
        }
            $goods_info =  substr($goods_info, 0, -1);
        
			$alipay_params_to_send['trade_information'] = '{"business_type":"5","goods_info":"'.$goods_info.'", "total_quantity":"'.$total_qty.'"}';

        //$alipay_params_to_send['trade_information'] = json_encode(array("business_type" => "5","goods_info"=>$goods_info, "total_quantity"=>$total_qty));

    }







    //$alipay_params_to_send['trade_information'] = $alipay_params_in['notify_url'];
    if($payment_border_setting != "OB"){
		if(wp_is_mobile()){
			$alipay_params_to_send['app_pay'] = 'Y' ;
			$alipay_params_to_send['product_code'] = 'NEW_WAP_OVERSEAS_SELLER' ;
		}else{
			$alipay_params_to_send['product_code'] = 'NEW_OVERSEAS_SELLER' ;
		}
    }
    if (    ! is_string( $alipay_partner_id )
            ||
            ! ctype_digit( $alipay_partner_id )
            ||
            strlen( $alipay_partner_id ) !== 16
        ) {

        return __('Bad "<strong>alipay_partner_id</strong>" (must be exactly 16 digits)', 'alipay-cross-border');

    }

    $alipay_params_to_send['partner'] = $alipay_partner_id ;
	/*Refer url*/
	
	$alipay_params_to_send['refer_url'] = get_home_url();
	
	/*End Refer url*/

    if (    ! is_string( $alipay_security_code )
            ||
            ! ctype_alnum( $alipay_security_code )
            ||
            strlen( $alipay_security_code ) !== 32
        ) {

        return __('Bad "<strong>Alipay Security Code</strong>" (must be a 32-character alphanumeric string)', 'alipay-cross-border');

    }

    if ( ! isset( $alipay_params_in['notify_url'] ) ) {
        return __('"notify_url" parameter is REQUIRED (when making Alipay payment requests)', 'alipay-cross-border');
    }

    if ( ! is_string( $alipay_params_in['notify_url'] ) ) {
        return __('Bad "notify_url" parameter (for Alipay payment request).&nbsp; String required.', 'alipay-cross-border');
    }

    $alipay_params_in['notify_url'] = trim( $alipay_params_in['notify_url'] ) ;

    if ( $alipay_params_in['notify_url'] === '' ) {
        return __('Bad "notify_url" parameter (for Alipay payment request).&nbsp; Must be non-empty/non-blank string.', 'alipay-cross-border');
    }

    $min_notify_url_length = strlen( 'http://' . $_SERVER['HTTP_HOST'] ) ;

    if ( strlen( $alipay_params_in['notify_url'] ) < $min_notify_url_length ) {
        return __('Bad "notify_url" parameter (for Alipay payment request).&nbsp; Doesn\'t appear to be a valid URL on this site.', 'alipay-cross-border');
    }

    if ( strlen( $alipay_params_in['notify_url'] ) > 200 ) {
        return __('Bad "notify_url" parameter (for Alipay payment request).&nbsp; Must be no longer than 200 characters.', 'alipay-cross-border');
    }

    $alipay_params_to_send['notify_url'] = $alipay_params_in['notify_url'] ;

    if ( isset( $alipay_params_in['return_url'] ) ) {

        if ( ! is_string( $alipay_params_in['return_url'] ) ) {
            return __('Bad "return_url" parameter (for Alipay payment request).&nbsp; String required.', 'alipay-cross-border');
        }

        $alipay_params_in['return_url'] = trim( $alipay_params_in['return_url'] ) ;

        if ( $alipay_params_in['return_url'] === '' ) {
            return __('Bad "return_url" parameter (for Alipay payment request).&nbsp; Must be non-empty/non-blank string.', 'alipay-cross-border');
        }

        $min_return_url_length = strlen( 'http://' . $_SERVER['HTTP_HOST'] ) ;

        if ( strlen( $alipay_params_in['return_url'] ) < $min_return_url_length ) {
            return __('Bad "return_url" parameter (for Alipay payment request).&nbsp; Doesn\'t appear to be a valid URL on this site.', 'alipay-cross-border');
        }

        if ( strlen( $alipay_params_in['return_url'] ) > 200 ) {
            return __('Bad "return_url" parameter (for Alipay payment request).&nbsp; Must be no longer than 200 characters.', 'alipay-cross-border');
        }

        $alipay_params_to_send['return_url'] = $alipay_params_in['return_url'] ;

    }
	
    if ( ! isset( $alipay_params_in['subject'] ) ) {
        return __('"subject" parameter is REQUIRED (when making Alipay payment requests)', 'alipay-cross-border');
    }

    if ( ! is_string( $alipay_params_in['subject'] ) ) {
        return __('Bad "subject" parameter (for Alipay payment request).&nbsp; String required.', 'alipay-cross-border');
    }

    $alipay_params_in['subject'] = trim( $alipay_params_in['subject'] ) ;

    if ( $alipay_params_in['subject'] === '' ) {
        return __('Bad "subject" parameter (for Alipay payment request).&nbsp; Must be non-empty/non-blank string.', 'alipay-cross-border');
    }

    $min_subject_length = strlen( 'http://' . $_SERVER['HTTP_HOST'] ) ;

    if ( strlen( $alipay_params_in['subject'] ) < $min_subject_length ) {
        return __('Bad "subject" parameter (for Alipay payment request).&nbsp; Doesn\'t appear to be a valid URL on this site.', 'alipay-cross-border');
    }

    if ( strlen( $alipay_params_in['subject'] ) > 256 ) {
        return __('Bad "subject" parameter (for Alipay payment request).&nbsp; Must be no longer than 256 characters.', 'alipay-cross-border');
    }

    $alipay_params_to_send['subject'] = $alipay_params_in['subject'] ;

    if ( isset( $alipay_params_in['body'] ) ) {

        if ( ! is_string( $alipay_params_in['body'] ) ) {
            return __('Bad "body" parameter (for Alipay payment request).&nbsp; String required.', 'alipay-cross-border');
        }

        $alipay_params_in['body'] = trim( $alipay_params_in['body'] ) ;

        if ( $alipay_params_in['body'] === '' ) {
            return __('Bad "body" parameter (for Alipay payment request).&nbsp; Must be non-empty/non-blank string.', 'alipay-cross-border');
        }

        if ( strlen( $alipay_params_in['body'] ) > 400 ) {
            return __('Bad "body" parameter (for Alipay payment request).&nbsp; Must be no longer than 400 characters.', 'alipay-cross-border');
        }

        $alipay_params_to_send['body'] = $alipay_params_in['body'] ;

    }

    if ( ! isset( $alipay_params_in['out_trade_no'] ) ) {
        return __('"out_trade_no" parameter is REQUIRED (when making Alipay payment requests)', 'alipay-cross-border');
    }

    if ( ! is_string( $alipay_params_in['out_trade_no'] ) ) {
        return __('Bad "out_trade_no" parameter (for Alipay payment request).&nbsp; String required.', 'alipay-cross-border');
    }

    $alipay_params_in['out_trade_no'] = trim( $alipay_params_in['out_trade_no'] ) ;

    if ( $alipay_params_in['out_trade_no'] === '' ) {
        return __('Bad "out_trade_no" parameter (for Alipay payment request).&nbsp; Must be non-empty/non-blank string.', 'alipay-cross-border');
    }

    if ( strlen( $alipay_params_in['out_trade_no'] ) > 64 ) {
        return __('Bad "out_trade_no" parameter (for Alipay payment request).&nbsp; Must be no longer than 64 characters.', 'alipay-cross-border');
    }

    $alipay_params_to_send['out_trade_no'] = $alipay_params_in['out_trade_no'] ;

    if ( ! isset( $alipay_params_in['currency'] ) ) {
        return __('"currency" parameter is REQUIRED (when making Alipay payment requests)', 'alipay-cross-border');
    }

    if ( ! is_string( $alipay_params_in['currency'] ) ) {
        return __('Bad "currency" parameter (for Alipay payment request).&nbsp; String required.', 'alipay-cross-border');
    }

    $alipay_params_in['currency'] = trim( $alipay_params_in['currency'] ) ;

    if ( $alipay_params_in['currency'] === '' ) {
        return __('Bad "currency" parameter (for Alipay payment request).&nbsp; Must be non-empty/non-blank string.', 'alipay-cross-border');
    }

    if (    strlen( $alipay_params_in['currency'] ) !== 3
            ||
            ! ctype_alpha( $alipay_params_in['currency'] )
        ) {
        return __('Bad "currency" parameter (for Alipay payment request).&nbsp; Not a 3 letter currency code.', 'alipay-cross-border');
    }

    $alipay_supported_currencies = array(
        'GBP'       =>  'British Sterling'                  ,
        'HKD'       =>  'Hong Kong Dollar'                  ,
        'USD'       =>  'U.S. Dollar'                       ,
        'CHF'       =>  'Confederation Helvetica Franc'     ,
        'CNY'       =>  'Chinese yuan'                      ,
        'SGD'       =>  'Singapore Dollar'                  ,
        'SEK'       =>  'Swedish Krona'                     ,
        'DKK'       =>  'Danish Krone'                      ,
        'NOK'       =>  'Norwegian Krone'                   ,
        'JPY'       =>  'Japanese Yen'                      ,
        'CAD'       =>  'Canada Dollar'                     ,
        'AUD'       =>  'Australian Dollar'                 ,
        'NZD'       =>  'New Zealand Dollar'                 ,
        'THB'       =>  'Thai Baht'                 ,
        'EUR'       =>  'Euro'								
        ) ;

        //  NOTE!
        //  -----
        //  All but JPY have 2 digits after the decimal point.
        //  JPY has NO such digits.

    $alipay_params_in['currency'] = strtoupper( $alipay_params_in['currency'] ) ;
    // -------------------------------------------------------------------------

    if ( ! array_key_exists( $alipay_params_in['currency'] , $alipay_supported_currencies ) ) {
        return sprintf( __('Bad "currency" parameter (for Alipay payment request).&nbsp; <strong>%s</strong> isn\'t supported by Alipay Cross-Border.', 'alipay-cross-border'), $alipay_params_in['currency'] );
    }

    $alipay_params_to_send['currency'] = $alipay_params_in['currency'] ;
	
    if ( ! isset( $alipay_params_in['total_fee'] ) ) {
        return __('"total_fee" parameter is REQUIRED (when making Alipay payment requests)', 'alipay-cross-border');
    }

    // -------------------------------------------------------------------------
    // NOTE!
    // -----
    // The spec. for "total_fee" is somewhat confusing:-
    //
    //      1.  "Number(8,2)" appears to suggest the SQL way of specifying
    //          numbers.  Ie:-
    //          o   Max 8 digits in total
    //          o   Exactly 2 digits after the decimal point.
    //
    //          Ie:-
    //              Min:    0.00
    //              Max:    999999.99
    //
    //      2.  "A floating number ranging 0.01 to 1000000.00" says:-
    //
    //              Min:    0.00
    //              Max:    1000000.00
    //
    // For now, we'll resolve this by assuming that BOTH:-
    //      o   Number(8,2)
    //      o   1000000.00
    //
    // are valid.
    //
    // ---
    //
    // To further complicate things, the "Currency List" in Section 6.1 of:-
    //      https://download.alipay.com/ui/doc/global/cross-border_website_payment.zip
    //
    // says that for JPY, there are NO digits after the decimal point.  And for
    // all other currencies there are 2 digits.
    //
    // So we assume that for JPY, the max. value is:-
    //      99999999
    //
    // Ie; Max 8 digits.
    // -------------------------------------------------------------------------

    if (    is_float( $alipay_params_in['total_fee'] )
            ||
            is_int( $alipay_params_in['total_fee'] )
        ) {

        $alipay_params_in['total_fee'] = (string) $alipay_params_in['total_fee'] ;

    } elseif ( is_string( $alipay_params_in['total_fee'] ) ) {

        $alipay_params_in['total_fee'] = trim( $alipay_params_in['total_fee'] ) ;

    } else {

        return __('Bad "total_fee" parameter (for Alipay payment request).&nbsp; String, float or int required.', 'alipay-cross-border');

    }

    // -------------------------------------------------------------------------

    $alipay_params_in['total_fee'] = ltrim( $alipay_params_in['total_fee'] , '0' ) ;

    // -------------------------------------------------------------------------

    if ( $alipay_params_in['total_fee'] === '' ) {

        return __('Unexpected "total_fee" parameter (for Alipay payment request).&nbsp; There is <strong>NOTHING TO PAY</strong>.', 'alipay-cross-border');

    }

    // -------------------------------------------------------------------------

    if ( $alipay_params_in['currency'] === 'JPY' ) {

        // ---------------------------------------------------------------------
        // JPY
        // ---------------------------------------------------------------------

        if (    ! ctype_digit( $alipay_params_in['total_fee'] )
                ||
                strlen( $alipay_params_in['total_fee'] ) > 8
            ) {
            return __('Bad "total_fee" parameter (for Alipay payment request).&nbsp; For JPY, must be 1 to 99999999 Yen.', 'alipay-cross-border');
        }

        // ---------------------------------------------------------------------

    } else {

        // ---------------------------------------------------------------------
        // Other Currencies
        // ---------------------------------------------------------------------

        if ( $alipay_params_in['total_fee'][0] === '.' ) {
            $alipay_params_in['total_fee'] = '0' . $alipay_params_in['total_fee'] ;
        }
            //  Replace stripped leading 0, if needed

        // ---------------------------------------------------------------------

        if ( floatval($alipay_params_in['total_fee']) < 0.01 or floatval($alipay_params_in['total_fee']) > 1000000.00  ){// === '0.00' ) {
            return __('Bad "total_fee" parameter (for Alipay payment request01).&nbsp; Must be 0.01 to 1000000.00', 'alipay-cross-border');
        }

    }

    // -------------------------------------------------------------------------

    $alipay_params_to_send['total_fee'] = round(floatval($alipay_params_in['total_fee']),2) ;

    if ( $is_alipay_test_transaction and !($pay_in_rmb == 'yes') ) {

        // ---------------------------------------------------------------------

        if ( $alipay_params_in['currency'] === 'JPY' ) {
            $alipay_params_to_send['total_fee'] = '1' ;

        } else {
            $alipay_params_to_send['total_fee'] = '0.01' ;

        }

    }

	if($pay_in_rmb == 'yes'){
		$alipay_params_to_send['rmb_fee'] = $alipay_params_to_send['total_fee'];
		unset($alipay_params_to_send['total_fee']);
	}

    if ( isset( $alipay_params_in['order_gmt_create'] ) ) {

        // ---------------------------------------------------------------------

        if ( ! is_string( $alipay_params_in['order_gmt_create'] ) ) {
            return __('Bad "order_gmt_create" parameter (for Alipay payment request).&nbsp; String required.', 'alipay-cross-border');
        }

        $alipay_params_in['order_gmt_create'] = trim( $alipay_params_in['order_gmt_create'] ) ;

        if ( $alipay_params_in['order_gmt_create'] === '' ) {
            return __('Bad "order_gmt_create" parameter (for Alipay payment request).&nbsp; Must be non-empty/non-blank string.', 'alipay-cross-border');
        }

        $regex_order_gmt_create = '/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/' ;
            //  Ie: It's like a MySQL format date/time.

        $number_matches = preg_match(
                                $regex_order_gmt_create                 ,
                                $alipay_params_in['order_gmt_create']
                                ) ;

        if ( $number_matches === FALSE ) {
            return __('"preg_match()" failure checking "order_gmt_create" parameter (for Alipay payment request).', 'alipay-cross-border');
        }

        // -----------------------------------------------------------------

        if ( $number_matches !== 1 ) {
            return sprintf( __('Bad "order_gmt_create" parameter (for Alipay payment request).&nbsp; Must be "%s".&nbsp; Was: %s', 'alipay-cross-border'), "YYYY-MM-DD HH:MM:SS", $alipay_params_in['order_gmt_create'] );
        }


        $alipay_params_to_send['order_gmt_create'] = $alipay_params_in['order_gmt_create'] ;

    }

    $allowed_alipay_paramater_names = array(
        //  REQUIRED
        'notify_url'            ,
        'return_url'            ,
        'subject'               ,
        'out_trade_no'          ,
        'currency'              ,
        'total_fee'             ,
        'trade_information'     ,
		'refer_url'				,		'product_code'			,
        //  OPTIONAL
        'return_url'            ,
        'body'                  ,
        'order_gmt_create'
        ) ;

    // --------------------------------------------------------------------------

    foreach ( $alipay_params_in as $name => $value ) {

        if ( ! in_array( $name , $allowed_alipay_paramater_names , TRUE ) ) {
            return sprintf( __('Unrecognised/unsupported parameter "%s" (for Alipay payment request).', 'alipay-cross-border'), $name );
        }

    }

/*
 *	this is extra parameter added to include _input_charset parameter to the url request
 */
$alipay_params_to_send['_input_charset'] = "utf-8" ;
    // -------------------------------------------------------------------------
    // bool ksort ( array &$array [, int $sort_flags = SORT_REGULAR ] )
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    // Sorts an array by key, maintaining key to data correlations.  This is
    // useful mainly for associative arrays.
    //
    // Returns TRUE on success or FALSE on failure.
    // -------------------------------------------------------------------------

    $ok = ksort( $alipay_params_to_send ) ;

    // -------------------------------------------------------------------------

    if ( $ok !== TRUE ) {
        return __('"ksort()" failure #1 - preparing query string parameters for Alipay', 'alipay-cross-border');
    }

    // -------------------------------------------------------------------------

    $signature_string = '' ;
    $comma = '' ;
error_log(print_r(array('alipay_params_to_send before concatenating in signature string'=>$alipay_params_to_send),true));
    foreach ( $alipay_params_to_send as $name => $value ) {
	
if($name == 'return_url'){
	$value = urldecode($value); 
}

        if ( trim( $value ) !== '' ) {
            $signature_string .= $comma . $name . '=' . $value ;
            $comma = '&' ;
        }
    }

    $signature_string .= $alipay_security_code ;
	
  
error_log(print_r(array('signature_string before md5'=>$signature_string),true));

    $md5 = md5( $signature_string ) ;
error_log(print_r(array('signature_string after md5'=>$md5),true));

    // -------------------------------------------------------------------------

    $alipay_params_to_send['sign']      = $md5  ;
    $alipay_params_to_send['sign_type'] = 'MD5' ;

    // -------------------------------------------------------------------------

    $ok = ksort( $alipay_params_to_send ) ;

    // -------------------------------------------------------------------------

    if ( $ok !== TRUE ) {
        return __('"ksort()" failure #2 - preparing query string parameters for Alipay', 'alipay-cross-border');
    }

    // =========================================================================
    // Create the Alipay GET request URL and Query String...
    // =========================================================================

    //$url = 'https://mapi.alipay.com/gateway.do' ;
    $url = 'https://intlmapi.alipay.com/gateway.do' ;

    // -------------------------------------------------------------------------

    $query_string = '' ;

    $comma = '' ;

    // -------------------------------------------------------------------------
	
    foreach ( $alipay_params_to_send as $name => $value ) {
		
		if($name == 'return_url'){
			$pieces = explode("?", $value);
			
			$r_url = (  $pieces[0] . '?' . urlencode( $pieces[1] ));
			
			$r_url = str_replace( ":","%3A", $r_url );
			$r_url = str_replace( "/","%2F", $r_url );
			$r_url = str_replace( "?","%3F", $r_url );
			
			$query_string .= $comma . $name . '=' . $r_url ;
		} else {
			$query_string .= $comma . $name . '=' . urlencode( $value ) ;
		}
        $comma = '&' ;
//        $comma = '%26' ;    //  To defeat the "&not" / "&curren" (etc)
                            //  browser bug ("feature?")
    }
	/* echo '<pre>';
	
	print_r($query_string);
	die; */

    // =========================================================================
    // SUCCESS!
    // =========================================================================
/* print_r(array(
                $url            ,
                $query_string
                ) );
				
			echo urldecode($query_string);
				exit;  */
				
				
				
    return array(
                $url            ,
                $query_string
                ) ;

    // =========================================================================
    // That's that!
    // =========================================================================

}