<?php

// *****************************************************************************
// GREAT-KIWI / PAYMENT-GATEWAYS / ALIPAY / CROSS-BORDER /
//      PAYMENT-NOTIFICATION-HANDLER.PHP
// OPMC Australia - www.opmc.com.au
// (C) 2013 - 2014 Peter Newman. All Rights Reserved.
// *****************************************************************************

    namespace greatKiwi_paymentGateways_alipayCrossBorder ;

/**
 * Handles the POST request from Alipay - that tells us whether the customer
 * paid for the order or not.
 * 
 * If the customer PAID, calls **`$order->payment_complete()`** (which changes
 * the order status from "pending" to "processing").
 *
 * If the customer DIDN'T PAY, calls **`$order->cancel_order()`** (which 
 * changes the order status from "pending" to "cancelled").
 *
 * Also, compares the amount paid with the order total - and adds one of the
 * following notes to the order, as appropriate:-<ul>
 *      <li>**\*\*\*PAID IN FULL\*\*\***</li>
 *      <li>WARNING: **\*\*\*PART PAYMENT ONLY\*\*\***</li>
 *      <li>WARNING: **\*\*\*OVER-PAYMENT\*\*\***</li>
 * </ul>
 *
 * In addition, if the payment notification is received and processed
 * successfully, returns the string "success" to Alipay.  This tells Alipay
 * that it can stop resending/retrying the payment notifications.
 *
 * @return void
 */

function payment_notification_handler1() {
}

