<?php

// *****************************************************************************
// PLUGINS / WOOCOMMERCE-ALIPAY-CROSS-BORDER / INCLUDES / GREAT-KIWI /
//      PAYMENT-GATEWAYS / ALIPAY / CROSS-BORDER /
//      PROGRESS-TRACKING-AND-ERROR-HANDLING.PHP
// OPMC Australia - www.opmc.com.au
// (C) 2013 - 2014 Peter Newman. All Rights Reserved.
// *****************************************************************************

    namespace greatKiwi_paymentGateways_alipayCrossBorder ;

// =============================================================================
// Ignore call if WordPress NOT loaded...
// =============================================================================

    if ( ! defined('ABSPATH' ) ) {
        exit() ;
    }

// =============================================================================
// $GLOBALS['ALIPAY_CROSS_BORDER']['question_support_plugin_ready']
// =============================================================================

    $GLOBALS['ALIPAY_CROSS_BORDER']['question_support_plugin_ready'] =
        NULL
        ;

// =============================================================================
// ACB_question_support_plugin_ready()
// =============================================================================

/**
 * Returns TRUE if the companion "Alipay CB Support" plugin has been installed
 * and activated; FALSE otherwise.
 *
 * The "Alipay CB Support" plugin is to help when testing/debugging the Alipay
 * "payment-notification-handler.php".  This file is called by Alipay using a
 * POST request.  Thus, neither it's progress tracking, nor any PHP error 
 * output, can be seen by the tester/debugger (that output just gets sent back
 * to Alipay and discarded).
 *
 * When the "Alipay CB Support" plugin is installed, the script's output is
 * stored in the PHP output buffer.  And can then be emailed to the
 * tester/debugger when either; a FATAL error occurs or; the script ends.
 *
 * With the plugin installed and activated, the following three routines
 * are available (to help with progress tracking and error handling):-<ul>
 *      <li>`ACB_track( $progress_message )`</li>
 *      <li>`ACB_error( $error_message )`</li>
 *      <li>`ACB_send_tracking_email()`</li>
 * </ul>
 **/
function ACB_question_support_plugin_ready() {

    // -------------------------------------------------------------------------

    if ( is_bool( $GLOBALS['ALIPAY_CROSS_BORDER']['question_support_plugin_ready'] ) ) {
        return $GLOBALS['ALIPAY_CROSS_BORDER']['question_support_plugin_ready'] ;
    }

    // -------------------------------------------------------------------------

    $GLOBALS['ALIPAY_CROSS_BORDER']['question_support_plugin_ready'] = FALSE ;

    // -------------------------------------------------------------------------

    while ( TRUE ) {

        // ---------------------------------------------------------------------

        if (    ! defined( 'WOOCOMMERCE_ALIPAY_CROSS_BORDER_SUPPORT_PLUGIN' )
                ||
                WOOCOMMERCE_ALIPAY_CROSS_BORDER_SUPPORT_PLUGIN !== 'installed'
                ||
                ! defined( 'WOOCOMMERCE_ALIPAY_CROSS_BORDER_SUPPORT_PLUGIN_NAME' )
                ||
                ! defined( 'WOOCOMMERCE_ALIPAY_CROSS_BORDER_PLUGIN_ROOT_DIR' )
                ||
                ! is_file( dirname( WOOCOMMERCE_ALIPAY_CROSS_BORDER_PLUGIN_ROOT_DIR ) .
                                '/' .
                                WOOCOMMERCE_ALIPAY_CROSS_BORDER_SUPPORT_PLUGIN_NAME )
            ) {
            break ;
        }

        // ---------------------------------------------------------------------

        require_once( ABSPATH . 'wp-admin/includes/plugin.php' ) ;

        // -------------------------------------------------------------------------
        // is_plugin_active($plugin)
        // - - - - - - - - - - - - -
        //      $plugin
        //          (string) (required) The name of the plugin
        //          sub-directory/file.
        //
        //          Default: None
        //
        // Returns TRUE if plugin is activated, else FALSE.
        // -------------------------------------------------------------------------

        $GLOBALS['ALIPAY_CROSS_BORDER']['question_support_plugin_ready'] =
            is_plugin_active( WOOCOMMERCE_ALIPAY_CROSS_BORDER_SUPPORT_PLUGIN_NAME )
            ;

        // ---------------------------------------------------------------------

        break ;

        // ---------------------------------------------------------------------

    }

    // -------------------------------------------------------------------------

    return $GLOBALS['ALIPAY_CROSS_BORDER']['question_support_plugin_ready'] ;

    // -------------------------------------------------------------------------

}

// =============================================================================
// ACB_track()
// =============================================================================

/**
 * Appends a single or multi-line progress message to a list of the same.
 *
 * So that when either:-<ul>
 *      <li>`ACB_error( $error_message )`, or;</li>
 *      <li>`ACB_send_tracking_email()`</li>
 * </ul>
 *
 * are called, that list - along with any PHP Errors, Notices or Warnings, etc
 * (issued between this and the previous progress message) - will be emailed
 * to the tester/debugger.
 **/
function ACB_track( $tracking_text ) {

    // -------------------------------------------------------------------------

    if (    ACB_question_support_plugin_ready()
            &&
            function_exists( '\greatKiwi_paymentGateways_alipayCrossBorder_support\ACB_track' )
        ) {
        \greatKiwi_paymentGateways_alipayCrossBorder_support\ACB_track( $tracking_text ) ;
    }

    // -------------------------------------------------------------------------

}

// =============================================================================
// ACB_send_tracking_email()
// =============================================================================

/**
 * Emails the progress messages and PHP output accumulated thus far.
 *
 * More specifically, emails the progress messages accumulated by:-<ul>
 *      <li>`AB_track( $progress_message )`</li>
 * </ul>
 *
 * (along with any PHP Errors, Notices or Warnings, etc, occuring between
 * them), to the tester/debugger.
 **/
function ACB_send_tracking_email() {

    // -------------------------------------------------------------------------

    if (    ACB_question_support_plugin_ready()
            &&
            function_exists( '\greatKiwi_paymentGateways_alipayCrossBorder_support\ACB_send_tracking_email' )
        ) {
        \greatKiwi_paymentGateways_alipayCrossBorder_support\ACB_send_tracking_email() ;
    }

    // -------------------------------------------------------------------------

}

// =============================================================================
// ACB_error()
// =============================================================================

/**
 * Adds a single or multi-line error message to the list of progress messages -
 * and then emails that list (along with any PHP Errors, Notices or Warnings,
 * etc, issued to date), to the tester/debugger.
 **/
function ACB_error( $error_message ) {

    // -------------------------------------------------------------------------
$logger = new \WC_Logger();
$logger->add( 'ALIPAY > progress-tracking-and-error-handling', print_r( array(">>> ACB_ERROR object: " => $error_message), true ) );

    if (    ACB_question_support_plugin_ready()
            &&
            function_exists( '\greatKiwi_paymentGateways_alipayCrossBorder_support\ACB_error' )
        ) {
        \greatKiwi_paymentGateways_alipayCrossBorder_support\ACB_error( $error_message ) ;
    }

    // -------------------------------------------------------------------------

}

// =============================================================================
// That's that!
// =============================================================================

