<?php

// *****************************************************************************
// INCLUDES / UPTO.PHP
// OPMC Australia - www.opmc.com.au
// (C) 2013 Peter Newman. All Rights Reserved.
// *****************************************************************************

    namespace greatKiwi_paymentGateways_alipayCrossBorder ;

// =============================================================================
// upto()
// =============================================================================

/**
 * Walks UP an absolute pathspec until it finds the target directory name; 
 * then returns the absolute pathspec to the named directory.
 *
 * Example:-<pre>
 *      upto( 'wp-content' , __FILE__ ) 
 * </pre>
 * 
 * called in:-<pre>
 *      /home/someuser/somesite/wp-content/plugins/some-plugin/some-plugin.php
 * </pre>
 *
 * would return:-<pre>
 *      /home/someuser/somesite/wp-content
 * </pre>
 *
 * And:-<pre>
 *      upto( 'php' , __FILE__ )
 * </pre>
 *
 * called in:-<pre>
 *      /home/user/projects/php/project1/js/simple-calendar/php/index.php
 * </pre>
 * 
 * would return:-<pre>
 *      /home/user/projects/php/project1/js/simple-calendar/php
 * </pre>
 *
 * @param string $dirname_to_search_for
 * @param string $absolute_path_to_search_in Eg; __FILE__
 *
 * @return mixed $result One of; (string) 
 *                      **$absolute_pathspec_of_dirname_searched_for** on
 *                      SUCCESS or; (bool) **FALSE** on FAILURE.
 */
function upto( $dirname_to_search_for , $absolute_path_to_search_in ) {

    $path_fragments = explode( '/' , trim( $absolute_path_to_search_in , '/' ) ) ;

    $path_fragments = array_reverse( $path_fragments ) ;

    $question_collect = FALSE ;

    $out = FALSE ;

    // -------------------------------------------------------------------------

    foreach ( $path_fragments as $this_path_fragment ) {

        if ( $question_collect ) {
            $out = '/' . $this_path_fragment . $out ;

        } else {
            if ( $this_path_fragment === $dirname_to_search_for ) {
                $question_collect = TRUE ;
                $out = '/' . $this_path_fragment ;
            }

        }

    }

    // -------------------------------------------------------------------------

    return $out ;

    // -------------------------------------------------------------------------

}

// =============================================================================
// upto_or_die()
// =============================================================================

/**
 * Walks UP an absolute pathspec until it finds the target directory name; 
 * then returns the absolute pathspec to the named directory.
 * 
 * Returns **$absolute_pathspec_of_dirname_searched_for** on SUCCESS.
 *
 * Dies with an:-<pre>
 *      PROBLEM: "upto_or_die()" failure (target directory "xxx" not found)
 * </pre> error message on FAILURE.
 *
 * @param string $dirname_to_search_for
 * @param string $absolute_path_to_search_in Eg; __FILE__
 *
 * @return string $absolute_pathspec_of_dirname_searched_for on SUCCESS
 */
function upto_or_die( $dirname_to_search_for , $absolute_path_to_search_in ) {

    $result = upto( $dirname_to_search_for , $absolute_path_to_search_in ) ;

    // -------------------------------------------------------------------------

    if ( $result === FALSE ) {

        $msg = <<<EOT
PROBLEM: "upto_or_die()" failure (target directory "{$dirname_to_search_for}" not found)
EOT;

        die( $msg ) ;

    }

    // -------------------------------------------------------------------------

    return $result ;

    // -------------------------------------------------------------------------

}

// =============================================================================
// downto()
// =============================================================================

/**
 * Walks DOWN an absolute pathspec until it finds the target directory name; 
 * then returns the absolute pathspec to the named directory.
 *
 * Example:-<pre>
 *      downto( 'wp-content' , __FILE__ ) 
 * </pre>
 * 
 * called in:-<pre>
 *      /home/someuser/somesite/wp-content/plugins/some-plugin/some-plugin.php
 * </pre>
 *
 * would return:-<pre>
 *      /home/someuser/somesite/wp-content
 * </pre>
 *
 * And:-<pre>
 *      downto( 'php' , __FILE__ )
 * </pre>
 *
 * called in:-<pre>
 *      /home/user/projects/php/project1/js/simple-calendar/php/index.php
 * </pre>
 * 
 * would return:-<pre>
 *      /home/user/projects/php
 * </pre>
 *
 * @param string $dirname_to_search_for
 * @param string $absolute_path_to_search_in Eg; __FILE__
 *
 * @return mixed $result One of; (string) 
 *                      **$absolute_pathspec_of_dirname_searched_for** on
 *                      SUCCESS or; (bool) **FALSE** on FAILURE.
 */
function downto( $dirname_to_search_for , $absolute_path_to_search_in ) {

    $path_fragments = explode( '/' , trim( $absolute_path_to_search_in , '/' ) ) ;

    $out = '' ;

    // -------------------------------------------------------------------------

    foreach ( $path_fragments as $this_path_fragment ) {

        $out .= '/' . $this_path_fragment ;

        if ( $this_path_fragment === $dirname_to_search_for ) {
            return $out ;
        }

    }

    // -------------------------------------------------------------------------

    return FALSE ;

    // -------------------------------------------------------------------------

}

// =============================================================================
// downto_or_die()
// =============================================================================

/**
 * Walks DOWN an absolute pathspec until it finds the target directory name; 
 * then returns the absolute pathspec to the named directory.
 * 
 * Returns **$absolute_pathspec_of_dirname_searched_for** on SUCCESS.
 *
 * Dies with an:-<pre>
 *      PROBLEM: "downto_or_die()" failure (target directory "xxx" not found)
 * </pre> error message on FAILURE.
 *
 * @param string $dirname_to_search_for
 * @param string $absolute_path_to_search_in Eg; __FILE__
 *
 * @return string $absolute_pathspec_of_dirname_searched_for on SUCCESS
 */
function downto_or_die( $dirname_to_search_for , $absolute_path_to_search_in ) {

    $result = downto( $dirname_to_search_for , $absolute_path_to_search_in ) ;

    // -------------------------------------------------------------------------

    if ( $result === FALSE ) {

        $msg = <<<EOT
PROBLEM: "downto_or_die()" failure (target directory "{$dirname_to_search_for}" not found)
EOT;

        die( $msg ) ;

    }

    // -------------------------------------------------------------------------

    return $result ;

    // -------------------------------------------------------------------------

}

// =============================================================================
// That's that!
// =============================================================================

