<?php

// *****************************************************************************\
// WEBWIZ_TEST_DEBUG.PHP
// OPMC Australia - www.opmc.com.au
// (C) 2013 Peter Newman. All Rights Reserved.
// *****************************************************************************

    namespace greatKiwi_paymentGateways_alipayCrossBorder ;

    if ( ! function_exists( 'pr' ) ) {

/**
 * A version of PHP's "print_r()" - that gives better looking output in an HTML
 * environment (by wrapping "print_r()"'s output in PRE tags).
 * 
 * Examples:-<ul>
 *      <li>`pr( $_POST ) ;`</li>
 *      <li>`pr( $_GET, '$_GET' ) ;`</li>
 * </ul>
 *
 * @param mixed $value The value to dump (typically an array or object).
 * @param string $name The variable name of the value being dumped.  Optional.
 *
 * @return void
 */
function pr( $value , $name = NULL ) {
    if ( $name === NULL ) {
        echo '<pre>' ;
    } else {
        echo '<h2>' , $name , '</h2><pre>' ;
    }
    print_r( $value ) ;
    echo '</pre>' ;
}

    }

    // -------------------------------------------------------------------------
    // pr_text() / pr_text_inner()
    // -------------------------------------------------------------------------

    if ( ! function_exists( 'pr_text_inner' ) ) {

        // ---------------------------------------------------------------------
        // pr_text_inner()
        // ---------------------------------------------------------------------

        /**
         * Does the hard work for "pr_text()".
         **/
        function pr_text_inner( $value , $name = '' , $depth = 0 ) {

            // -----------------------------------------------------------------

            if ( is_array( $value ) ) {

                // -------------------------------------------------------------
                // Get the length of the longest key...
                // -------------------------------------------------------------

                $longest_key = 0 ;

                foreach ( $value as $this_key => $this_value ) {

                    if ( strlen( $this_key ) > $longest_key ) {
                        $longest_key = strlen( $this_key ) ;
                    }

                }

                // -------------------------------------------------------------
                // Build the plain text version of the array - recursing
                // as required...
                // -------------------------------------------------------------

                $plain_text = '' ;

                // -------------------------------------------------------------

                $indent = str_repeat( chr(32) , 4 * ( $depth + 1 ) ) ;

                // -------------------------------------------------------------

                foreach ( $value as $this_key => $this_value ) {

                    if ( is_array( $this_value ) ) {

                        $plain_text .=  $indent .
                                        $this_key .
                                        str_repeat( chr(32) , $longest_key - strlen( $this_key ) ) .
                                        ' = ' .
                                        pr_text_inner( $this_value , '' , $depth + 1 )
                                        ;

                    } else {

                        $plain_text .=  $indent .
                                        $this_key .
                                        str_repeat( chr(32) , $longest_key - strlen( $this_key ) ) .
                                        ' : ' .
                                        $this_value .
                                        PHP_EOL
                                        ;

                    }

                }

                // -------------------------------------------------------------

                if ( $plain_text === '' ) {
                    $plain_text = 'array()' . PHP_EOL ;

                } else {
                    $plain_text = 'array(' . PHP_EOL . $plain_text . $indent . ')' . PHP_EOL ;

                }

                // -------------------------------------------------------------

                if ( $name !== '' ) {
                    $plain_text = $name . ' = ' . $plain_text ;
                }

                // -------------------------------------------------------------

            } else {

                // -------------------------------------------------------------

                $plain_text = (string) $value ;

                // -------------------------------------------------------------

                if ( $name !== '' ) {
                    $plain_text = $name . ' = ' . $plain_text ;
                }

                // -------------------------------------------------------------

                $plain_text .= PHP_EOL ;

                // -------------------------------------------------------------

            }

            // -----------------------------------------------------------------

            return $plain_text ;

            // -----------------------------------------------------------------

        }

        // ---------------------------------------------------------------------

    }

    // -------------------------------------------------------------------------

    if ( ! function_exists( 'pr_text' ) ) {

        // ---------------------------------------------------------------------
        // pr_text()
        // ---------------------------------------------------------------------

/**
 * A version of PHP's "print_r()" for use in the console/terminal.
 *
 * Useful for dumping arrays (and other variables - except objects, which
 * aren't supported yet), into (eg):-<ul>
 *      <li>STDOUT/STDERR</li>
 *      <li>Text files</li>
 *      <li>Text emails.</li>
 * </ul>
 * 
 * Examples:-<ul>
 *      <li>`pr_text( $_POST ) ;`</li>
 *      <li>`pr_text( $_GET, '$_GET' ) ;`</li>
 * </ul>
 *
 * Can also be used in an HTML environment, if you wrap the output in PRE tags.
 *
 * @param mixed  $value The value to dump (typically an array or object).
 * @param string $name  The variable name of the value being dumped.  Optional.
 *
 * @return void
 */
function pr_text( $value , $name = '' ) {
    return pr_text_inner( $value , $name , 0 ) ;
}


    }
	
    // -------------------------------------------------------------------------
    // That's that!
    // -------------------------------------------------------------------------

