<?php

/**
 * Plugin Name: WooCommerce Alipay Cross-Border
 * Plugin URI: http://www.woothemes.com/products/alipay-cross-border/
 * Description: Allows merchants <strong>outside Mainland China</strong> to accept Credit Card or Alipay payments from residents of Mainland China.  Alipay is China's biggest/most popular payment gateway.
 * Version: 3.0
 * Author: WooThemes
 * Author URI: http://woothemes.com/
 * Developer: OPMC Australia
 * Developer URI: http://www.opmc.com.au/alipay-cross-border-payment-gateway/
 * Woo: 260107:5c941c1d6b42ae0418d03ca800ccbd22
 * Text Domain: alipay-cross-border
 * Domain Path: /lang
 */

    if ( ! defined('ABSPATH' ) ) {
        exit() ;
    }


	/**
	 * Required functions
	 */
	if ( ! function_exists( 'woothemes_queue_update' ) ) {
		require_once( 'woo-includes/woo-functions.php' );
	}

	/**
	 * Plugin updates
	 */
	woothemes_queue_update( plugin_basename( __FILE__ ), '5c941c1d6b42ae0418d03ca800ccbd22', '260107' );

    add_action( 'plugins_loaded' , 'init_woocommerce_alipay_cross_border' ) ;


    function init_woocommerce_alipay_cross_border() {
        if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
            return ;
        }
        load_plugin_textdomain( 'alipay_cross_border' ) ;
	    require_once( dirname( __FILE__ ) . '/class-woocommerce-alipay-cross-border.php' ) ;
        add_filter( 'woocommerce_payment_gateways', 'add_woocommerce_alipay_cross_border' ) ;
    }


    function add_woocommerce_alipay_cross_border( $methods ) {
	    $methods[] = 'WC_Payment_Gateway_Alipay_Cross_Border';
	    return $methods;
    }


    define( 'WOOCOMMERCE_ALIPAY_CROSS_BORDER_PLUGIN_ROOT_DIR' ,
            dirname( __FILE__ )
            ) ;

// =============================================================================
// That's that!
// =============================================================================

