<?php
/*
Plugin Name: WC Autoship Payflow Payments
Plugin URI: http://wooautoship.com
Description: Payflow Payments for WC Autoship
Version: 3.0.4
Author: Patterns in the Cloud
Author URI: http://patternsinthecloud.com
License: Single-site
*/

define( 'WC_AUTOSHIP_PAYFLOW_PAYMENTS_VERSION', '3.0.4' );
define( 'WC_AUTOSHIP_PAYFLOW_PAYMENTS_PLUGIN_FILE', __FILE__ );
define( 'WC_AUTOSHIP_PAYFLOW_PAYMENTS_PLUGIN_DIR', __DIR__ );

function wc_autoship_payflow_payments_install() {

}
register_activation_hook( __FILE__, 'wc_autoship_payflow_payments_install' );

function wc_autoship_payflow_payments_deactivate() {

}
register_deactivation_hook( __FILE__, 'wc_autoship_payflow_payments_deactivate' );

function wc_autoship_payflow_payments_uninstall() {

}
register_uninstall_hook( __FILE__, 'wc_autoship_payflow_payments_uninstall' );

function wc_autoship_payflow_payments_register_gateway( $methods ) {
	require_once( 'classes/wc-autoship-payflow-gateway.php' );
	$methods[] = 'WC_Autoship_Payflow_Gateway';
	return $methods;
}
add_filter( 'woocommerce_payment_gateways', 'wc_autoship_payflow_payments_register_gateway' );

function wc_autoship_payflow_payments_scripts() {
	$base_uri = plugins_url( '' , __FILE__ );

	wp_enqueue_style( 'wc-autoship-payflow-payments-checkout', $base_uri . '/css/checkout.css', array(), WC_AUTOSHIP_PAYFLOW_PAYMENTS_VERSION );
	wp_enqueue_script( 'wc-autoship-payflow-payments-checkout', $base_uri . '/js/checkout.js', array( 'jquery' ), WC_AUTOSHIP_PAYFLOW_PAYMENTS_VERSION );
}
add_action( 'wp_enqueue_scripts', 'wc_autoship_payflow_payments_scripts' );

function wc_autoship_payflow_payments_addon_license_keys( $addon_license_keys ) {
	if ( ! isset( $addon_license_keys['wc_autoship_payflow_payments_license_key'] ) ) {
		$settings = get_option( 'woocommerce_wc_autoship_payflow_settings' );
		if ( ! $settings ) {
			return;
		}

		if ( ! isset( $settings['license_key'] ) ) {
			return;
		}

		$license_key = trim( $settings['license_key'] );
		$addon_license_keys['wc_autoship_payflow_payments_license_key'] = array(
			'item_name' => 'WC Autoship Payflow Payments',
			'license' => $license_key,
			'version' => WC_AUTOSHIP_PAYFLOW_PAYMENTS_VERSION,
			'plugin_file' => __FILE__
		);
	}
	return $addon_license_keys;
}
add_filter( 'wc_autoship_addon_license_keys', 'wc_autoship_payflow_payments_addon_license_keys', 10, 1 );

function wc_as_payflow_payments() {

	$item_name = "WC Autoship Payflow Payments";
	$settings = get_option( 'woocommerce_wc_autoship_payflow_settings' );

	if(!isset($settings["license_key"])){
		# we do not have license show some message
		return;
	}

	$license_key = $settings["license_key"];

	if ( empty( $license_key ) || empty($item_name) ) {
		# license field is empty, show some message
		return;
	}

	#This will make sure that code does not break the website
	if ( function_exists( 'wc_autoship_get_licensing_url' ) ) {
		require_once( 'classes/edd/wc-autoship-plugin-updater.php' );

		new WC_AS_PAYFLOW_PAYMENTS_Plugin_Updater( wc_autoship_get_licensing_url(), __FILE__, array(
			'version'   => WC_AUTOSHIP_PAYFLOW_PAYMENTS_VERSION,
			'license'   => $license_key,
			'item_name' => $item_name,
			'author'    => 'Patterns In the Cloud'
		) );
	} else {
		# Display a message that wc_auto_ship plugin is not activated, so customer knows what is going on
	}
}

add_action( 'admin_init', 'wc_as_payflow_payments', 0 );
