/* global wc_psigate_params */
(function ($) {
	var wcPsigateOrderCapture = {
		init: function () {
			$('#woocommerce-order-items')
				.on('click', 'button.wc-psigate-capture-payment-init', this.initOrderCapture)
				.on('click', 'button.wc-psigate-capture-cancel', this.cancelOrderCapture)
				.on('click', 'button.wc-psigate-capture-payment', this.processCapture);

		},

		initOrderCapture: function () {
			$('.wc-psigate-capture-payment-wrapper').show();
			$('.wc-psigate-capture-allowed-amount-wrapper').show();
			$('.wc-psigate-capture-amount-wrapper').show();
			$('.wc-psigate-capture-cancel').show();
			$('button.wc-psigate-capture-payment-init').hide();
		},

		cancelOrderCapture: function () {
			$('.wc-psigate-capture-payment-wrapper').hide();
			$('.wc-psigate-capture-allowed-amount-wrapper').hide();
			$('.wc-psigate-capture-amount-wrapper').hide();
			$('.wc-psigate-capture-cancel').hide();
			$('button.wc-psigate-capture-payment-init').show();
		},

		processCapture: function () {
			var orderItems = $('#woocommerce-order-items');
			orderItems.block();

			if (!window.confirm(wc_psigate_params.i18n_capture_payment)) {
				orderItems.unblock();
				return false;
			}

			var captureAmount = $('.wc-psigate-capture-amount-wrapper input.wc-psigate-capture-amount').val();

			if ('' === captureAmount) {
				orderItems.unblock();
				return false;
			}

			var data = {
				action        : 'wc_psigate_capture_payment',
				order_id      : woocommerce_admin_meta_boxes.post_id,
				capture_amount: captureAmount,
				security      : wc_psigate_params.capture_payment
			};

			$.post(wc_psigate_params.ajax_url, data, function (response) {
				if (true === response.success) {
					// Redirect to same page for show the refunded status
					window.alert(response.data.message);

					window.location.href = window.location.href;
				} else {
					window.alert(response.data.message);
					orderItems.unblock();
				}
			});
		},
	};

	var wcPsigateSettings = {
		init: function () {
			this.onSaveCustomersChange();
			this.onHtmlApiChange();
			this.onTestmodeChange();
		},


		onSaveCustomersChange: function () {
			$('#woocommerce_psigate_save_customers').on('change', this.showHideSaveCustomersSettings).change();
		},

		onHtmlApiChange: function () {
			$('#woocommerce_psigate_interac_enable').on('change', this.showHideHtmlApiSettings).change();
		},

		onTestmodeChange: function () {
			$('#woocommerce_psigate_testmode').on('change', this.showHideTestmodeSettings).change();
		},

		showHideSaveCustomersSettings: function (e) {
			var el = $(e.target);
			var showHideEl = $('.show_if_save_customers');
			var showHideBlock = showHideEl.closest('tr');

			if (el.is(':checked')) {
				showHideBlock.show();
				showHideEl.show();
			} else {
				showHideBlock.hide();
				showHideEl.hide();
			}
		},

		showHideHtmlApiSettings: function (e) {
			var el = $(e.target);
			var showHideEl = $('.show_if_interac_enable');
			var showHideBlock = showHideEl.closest('tr');

			if ('1' === el.val()) {
				showHideBlock.show();
				showHideEl.show();
			} else {
				showHideBlock.hide();
				showHideEl.hide();
			}
		},

		showHideTestmodeSettings: function (e) {
			var el = $(e.target);
			var showHideEl = $('.show_if_testmode');
			var showHideBlock = showHideEl.closest('tr');

			if (el.is(':checked')) {
				showHideBlock.show();
				showHideEl.show();
			} else {
				showHideBlock.hide();
				showHideEl.hide();
			}
		},
	};

	wcPsigateOrderCapture.init();
	wcPsigateSettings.init();
})(jQuery);