<?php

namespace WcPsigate\Admin;

use WcPsigate\Ajax\Admin\Admin_Ajax;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Admin class to handle any additions for the plugin on the WC Admin
 *
 * @since  1.5.0
 * @author VanboDevelops | Ivan Andreev
 *
 *        Copyright: (c) 2018 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Admin {
	
	public function __construct() {
		$this->load_admin_notices();
		$this->load_capture();
		$this->load_ajax();
	}
	
	/**
	 * Loads the admin notices
	 *
	 * @since 1.5.0
	 */
	public function load_admin_notices() {
		// Load admin notices
		$notices = new Admin_Notices();
		$notices->hooks();
	}
	
	/**
	 * Loads the Admin Capture procedure setup
	 *
	 * @since 1.5.0
	 */
	public function load_capture() {
		$capture = new Capture();
		$capture->hooks();
	}
	
	/**
	 * Loads Ajax
	 *
	 * @since 1.5.0
	 */
	public function load_ajax() {
		$ajax = new Admin_Ajax();
		$ajax->hooks();
	}
}