<?php

namespace WcPsigate\Ajax\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Ajax class to handle ajax requests
 *
 * @since  1.5.0
 * @author VanboDevelops | Ivan Andreev
 *
 *        Copyright: (c) 2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

class Admin_Ajax {
	
	public function hooks() {
		add_action( 'wp_ajax_wc_psigate_capture_payment', array( $this, 'capture_payment' ) );
	}
	
	/**
	 * Handle a refund via the edit order screen.
	 *
	 * @since 2.0
	 */
	public function capture_payment() {
		ob_start();
		
		check_ajax_referer( 'capture-payment', 'security' );
		
		if ( ! current_user_can( 'edit_shop_orders' ) ) {
			wp_die( - 1 );
		}
		
		$order_id       = (int) \WC_PsiGate::get_field( 'order_id', $_POST, 0 );
		$capture_amount = wc_format_decimal( sanitize_text_field( \WC_PsiGate::get_field( 'capture_amount', $_POST, 0 ) ), wc_get_price_decimals() );
		try {
			$order = wc_get_order( $order_id );
			
			// Init the gateways
			WC()->payment_gateways();
			
			if ( ! $capture_amount ) {
				throw new \Exception( __( 'Invalid capture amount', \WC_PsiGate::TEXT_DOMAIN ) );
			}
			
			// Run the capture payment action
			$result = apply_filters( 'wc_psigate_capture_payment_for_order', $order, $capture_amount );
			
			if ( true !== $result ) {
				wp_send_json_error( array( 'message' => $result ) );
			}
			
			wp_send_json_success( array( 'message' => __( 'Amount was successfully captured', \WC_PsiGate::TEXT_DOMAIN ) ) );
		}
		catch ( \Exception $e ) {
			wp_send_json_error( array( 'error' => $e->getMessage() ) );
		}
	}
}