<?php

namespace WcPsigate\Api\Html_Api;

use WcPsigate\Compatibility;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since  1.5.0
 * @author VanboDevelops | Ivan Andreev
 *
 *        Copyright: (c) 2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
abstract class Abstract_Commons {
	
	/**
	 * @param \WC_Gateway_PsiGate $gateway
	 */
	public function __construct( \WC_Gateway_PsiGate $gateway ) {
		$this->gateway = $gateway;
	}
	
	public function get_gateway() {
		return $this->gateway;
	}
	
	public function get_html_api_url() {
		if ( 'yes' == $this->get_gateway()->testmode ) {
			return $this->get_gateway()->html_test_url;
		}
		
		return $this->get_gateway()->html_live_url;
	}
	
	/**
	 * Generates a Security hash string
	 *
	 * @param array $parameters
	 *
	 * @return string
	 */
	public function generate_security_hash_string( array $parameters ) {
		$string = '';
		foreach ( $parameters as $parameter ) {
			$string .= $parameter . '+';
		}
		
		$string .= $this->get_html_api_passphrase();
		
		$sha1 = sha1( $string );
		
		\WC_PsiGate::add_debug_log( 'Security String: ' . $sha1 );
		
		return $sha1;
	}
	
	/**
	 * Returns the hash from the order
	 *
	 * @param $order
	 *
	 * @return mixed
	 */
	public function get_html_api_security_hash( $order ) {
		return get_post_meta( Compatibility::get_order_id( $order ), 'psigate_html_api_security_hash', true );
	}
	
	/**
	 * Returns the pass phrase we will use to generate security check
	 *
	 * @return string
	 */
	public function get_html_api_passphrase() {
		if ( '' != $this->get_gateway()->html_pass_phrase ) {
			return $this->get_gateway()->html_pass_phrase;
		}
		
		return $this->get_gateway()->Passphrase;
	}
}