<?php

namespace WcPsigate\Api\Html_Api;

use WcPsigate\Compatibility;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since    1.4
 * @version  1.5.0
 * @author   VanboDevelops | Ivan Andreev
 *
 *        Copyright: (c) 2016 - 2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Html_Request extends Abstract_Commons {
	
	public function generate_payment_form( $order_id ) {
		$order = wc_get_order( $order_id );
		
		//Debug log
		\WC_PsiGate::add_debug_log( 'Generating payment form for order #' . $order_id );
		
		$payment_arguments = array(
			'ShippingTotal'    => $this->get_gateway()->format_amount( Compatibility::get_total_shipping( $order ) ),
			'Tax1'             => $this->get_gateway()->format_amount( $order->get_total_tax() ),
			'SubTotal'         => $this->get_gateway()->format_amount( $order->get_total() - Compatibility::get_total_shipping( $order ) - $order->get_total_tax() ),
			'PaymentType'      => 'DB',
			'Email'            => $this->get_gateway()->format_string( Compatibility::get_order_billing_email( $order ), 50 ),
			'CardAction'       => '0',
			'CustomerLanguage' => $this->get_gateway()->html_page_language,
			'ThanksURL'        => WC()->api_request_url( 'wc_gateway_psigate' ),
			'NoThanksURL'      => WC()->api_request_url( 'wc_gateway_psigate' ),
			'ResponseFormat'   => 'HTML',
			'OrderID'          => $this->get_gateway()->format_string( $this->get_gateway()->generate_gateway_order_id( $order ), 20 ),
			'Bname'            => $this->get_gateway()->format_string( Compatibility::get_order_billing_first_name( $order ) . ' ' . Compatibility::get_order_billing_last_name( $order ), 100 ),
			'Bcompany'         => $this->get_gateway()->format_string( Compatibility::get_order_billing_company( $order ), 100 ),
			'Baddress1'        => $this->get_gateway()->format_string( Compatibility::get_order_billing_address_1( $order ), 100 ),
			'Baddress2'        => $this->get_gateway()->format_string( Compatibility::get_order_billing_address_2( $order ), 100 ),
			'Bcity'            => $this->get_gateway()->format_string( Compatibility::get_order_billing_city( $order ), 100 ),
			'Bprovince'        => $this->get_gateway()->format_string( Compatibility::get_order_billing_state( $order ), 100 ),
			'Bpostalcode'      => $this->get_gateway()->format_string( Compatibility::get_order_billing_postcode( $order ), 100 ),
			'Bcountry'         => $this->get_gateway()->format_string( Compatibility::get_order_billing_country( $order ), 50 ),
			'Sname'            => $this->get_gateway()->format_string( Compatibility::get_order_shipping_first_name( $order ) . ' ' . Compatibility::get_order_shipping_last_name( $order ), 100 ),
			'Saddress1'        => $this->get_gateway()->format_string( Compatibility::get_order_shipping_address_1( $order ), 100 ),
			'Saddress2'        => $this->get_gateway()->format_string( Compatibility::get_order_shipping_address_2( $order ), 100 ),
			'Scity'            => $this->get_gateway()->format_string( Compatibility::get_order_shipping_city( $order ), 100 ),
			'Sprovince'        => $this->get_gateway()->format_string( Compatibility::get_order_shipping_state( $order ), 100 ),
			'Spostalcode'      => $this->get_gateway()->format_string( Compatibility::get_order_shipping_postcode( $order ), 100 ),
			'Scountry'         => $this->get_gateway()->format_string( Compatibility::get_order_shipping_country( $order ), 50 ),
			'Phone'            => $this->get_gateway()->format_string( Compatibility::get_order_billing_phone( $order ), 50 ),
			'Comments'         => $this->get_gateway()->format_string( Compatibility::get_order_customer_note( $order ), 300 ),
		);
		
		// Allow for parameter modifications
		$payment_arguments = apply_filters( 'wc_psigate_form_request_arguments', $payment_arguments, $order );
		
		$array = array(
			$payment_arguments['PaymentType'],
			Compatibility::get_order_id( $order ),
			$this->get_gateway()->format_amount( $payment_arguments['ShippingTotal'] + $payment_arguments['Tax1'] + $payment_arguments['SubTotal'] )
		);
		
		\WC_PsiGate::add_debug_log( 'Request Validation: ' . print_r( $array, true ) );
		
		// Save the hash to the order, we'll need it
		update_post_meta( Compatibility::get_order_id( $order ), 'psigate_html_api_security_hash', $this->generate_security_hash_string( $array ) );
		
		//Debug log
		\WC_Psigate::add_debug_log( 'Order form parameters: ' . print_r( $payment_arguments, true ) );
		
		$payment_arguments['StoreKey'] = $this->get_gateway()->html_store_key;
		
		$form_array = array();
		foreach ( $payment_arguments as $key => $value ) {
			$form_array[] = '<input type="hidden" name="' . esc_attr( $key ) . '" value="' . esc_attr( $value ) . '" />';
		}
		
		wc_enqueue_js(
			'
			jQuery("body").block({
				message: "<img src=\"' . esc_url( Compatibility::force_https( \WC_PsiGate::plugin_url() ) ) . '/assets/images/wpspin.gif\" alt=\"Redirecting...\"'
			. ' style=\"float:left; margin-right: 10px;\" />' . __( 'Thank you for your order. We are now redirecting you to the payment page.', \WC_PsiGate::TEXT_DOMAIN ) . '",
				overlayCSS: {
					background: "#fff",
					opacity: 0.6
				},
				css: {
					padding:        20,
					textAlign:      "center",
					color:          "#555",
					border:         "3px solid #aaa",
					backgroundColor:"#fff",
					cursor:         "wait",
					lineHeight:	"32px",
					zIndex:         "9999999"
				}
			});
			jQuery("#submit_psigate_payment_form").click();
		'
		);
		
		return '<form action="' . esc_url( $this->get_html_api_url() ) . '" method="post" id="psigate_payment_form" target="_top">
			' . implode( '', $form_array ) . '
			<input type="submit" class="button-alt" id="submit_psigate_payment_form" value="' . __( 'Pay via Psigate', \WC_PsiGate::TEXT_DOMAIN ) . '" />'
		       . '<a class="button cancel" href="' . esc_url( $order->get_cancel_order_url() ) . '">' . __( 'Cancel order &amp; restore cart', \WC_PsiGate::TEXT_DOMAIN ) . '</a>
			</form>';
	}
}