<?php

namespace WcPsigate\Api;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Description
 *
 * @since  1.5.0
 * @author VanboDevelops | Ivan Andreev
 *
 *        Copyright: (c) 2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Response {
	
	protected $response;
	
	/**
	 * @param \SimpleXMLElement $response
	 */
	public function __construct( \SimpleXMLElement $response ) {
		$this->response = $response;
	}
	
	public function get_response() {
		return $this->response;
	}
	
	public function __get( $name ) {
		$name = trim( $name );
		
		return new Response( $this->get_response()->{$name} );
	}
	
	public function get_value( $name, $type = 'string' ) {
		$name = trim( $name );
		
		if ( 'int' == $type ) {
			return (int) $this->get_response()->{$name};
		} elseif ( 'double' == $type ) {
			return (double) $this->get_response()->{$name};
		}
		
		return (string) $this->get_response()->{$name};
	}
}