<?php

namespace WcPsigate;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Handles script loading
 *
 * @since  1.5.0
 * @author VanboDevelops | Ivan Andreev
 *
 *        Copyright: (c) 2019 VanboDevelops
 *        License: GNU General Public License v3.0
 *        License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
class Scripts {
	
	public function __construct() {
		$this->suffix     = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
		$this->version    = $this->suffix ? \WC_PsiGate::VERSION : rand( 1, 999 );
		$this->gateway_id = 'psigate';
	}
	
	public function hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
	}
	
	/**
	 * Adds admin scripts
	 *
	 * @since 1.5.0
	 */
	public function admin_scripts() {
		$screen    = get_current_screen();
		$screen_id = $screen ? $screen->id : '';
		
		wp_register_script( 'psigate-admin', \WC_PsiGate::plugin_url() . '/assets/js/admin' . $this->suffix . '.js', array( 'jquery' ), $this->version, true );
		
		if ( in_array( str_replace( 'edit-', '', $screen_id ), wc_get_order_types( 'order-meta-boxes' ) ) ) {
			wp_enqueue_script( 'psigate-admin' );
			
			wp_localize_script( 'psigate-admin', 'wc_psigate_params', array(
				'i18n_capture_payment' => _x( 'Are you sure you want to capture the payment?', 'capture payment', \WC_PsiGate::TEXT_DOMAIN ),
				'ajax_url'             => admin_url( 'admin-ajax.php' ),
				'capture_payment'      => wp_create_nonce( 'capture-payment' ),
			) );
		}
	}
}