<?php
/**
 * PsiGate Payment Form Template
 *
 * @var string $save_customers          Is the merchant saving cards to vault
 * @var array  $saved_cards             Add customer saved cards
 * @var string $gateway                 The gateway ID
 * @var bool   $display_save_to_account Should we display the save to account field
 * @var string $save_to_account_text    The text for the save to account field
 */
wp_enqueue_script( 'wc-credit-card-form' );
?>
<div id="credit_card_info" style="display: block">
	<?php
	// TODO: Refactor this to single template, always output the new card input(hide with js)
	if ( 'yes' == $save_customers && ! empty( $saved_cards ) ) {
		wc_get_template(
			'checkout/psigate-saved-cards.php',
			array(
				'saved_cards' => $saved_cards,
			),
			'',
			WC_PsiGate::plugin_path() . '/templates/'
		);
	} else { ?>
		<input style="display: none !important;" type="radio" id="new" name="psigate-used-cc" style="width:auto;" <?php checked( 1, 1 ) ?> value="new" />
		<?php
	}
	$fields = array(
		'card-number-field' => '<p class="form-row form-row-wide">
			<label for="' . esc_attr( $gateway ) . '-card-number">' . __( "Card Number", WC_PsiGate::TEXT_DOMAIN ) . ' <span class="required">*</span></label>
			<input id="' . esc_attr( $gateway ) . '-card-number" class="input-text wc-credit-card-form-card-number" type="tel" maxlength="20" autocomplete="cc-number" inputmode="numeric" autocorrect="no" autocapitalize="no" spellcheck="no" placeholder="•••• •••• •••• ••••" name="' . $gateway . '-card-number" />
		</p>',
		'card-expiry-field' => '<p class="form-row form-row-first">
			<label for="' . esc_attr( $gateway ) . '-card-expiry">' . __( "Expiry (MM/YY)", WC_PsiGate::TEXT_DOMAIN ) . ' <span class="required">*</span></label>
			<input id="' . esc_attr( $gateway ) . '-card-expiry" class="input-text wc-credit-card-form-card-expiry" type="tel" inputmode="numeric" autocomplete="cc-exp" autocorrect="no" autocapitalize="no" spellcheck="no" placeholder="' . esc_attr( __( 'MM / YY', WC_PsiGate::TEXT_DOMAIN ) ) . '" name="' . $gateway . '-card-expiry" />
		</p>',
		'card-cvc-field'    => '<p class="form-row form-row-last">
			<label for="' . esc_attr( $gateway ) . '-card-cvc">' . __( "Card Code", WC_PsiGate::TEXT_DOMAIN ) . ' <span class="required">*</span></label>
			<input id="' . esc_attr( $gateway ) . '-card-cvc" class="input-text wc-credit-card-form-card-cvc" type="tel" inputmode="numeric" autocomplete="off" autocorrect="no" autocapitalize="no" spellcheck="no" maxlength="4" placeholder="' . esc_attr( __( 'CVC', WC_PsiGate::TEXT_DOMAIN ) ) . '" name="' . $gateway . '-card-cvc" />
		</p>',
	);
	
	if ( $display_save_to_account ) {
		$save_to_account_field = '<div class="create-account ' . esc_attr( $gateway ) . '-create-account">
	<p class="form-row form-row-wide">
		<input id="' . esc_attr( $gateway ) . '-save-card" style="width:auto;" checked="checked" class="' . esc_attr( $gateway ) . '_save_card" value="1" type="checkbox" name="' . esc_attr( $gateway ) . '-save-card" />
		<label for="' . esc_attr( $gateway ) . '-save-card" style="display:inline;">' . $save_to_account_text . ' <span class="required">*</span></label>
	</p></div>';
		
		$fields['save-to-account-field'] = apply_filters( 'wc_psigate_save_to_account_field', $save_to_account_field, $gateway, $display_save_to_account, $save_to_account_text );
	}
	
	$fields = apply_filters( 'wc_psigate_payment_fields', $fields, $gateway );
	?>
	<fieldset id="<?php echo $gateway; ?>-cc-form">
		<?php
		
		do_action( 'wc_psigate_form_before', $gateway );
		
		echo WC_PsiGate::get_field( 'card-number-field', $fields, '' );
		echo WC_PsiGate::get_field( 'card-expiry-field', $fields, '' );
		echo WC_PsiGate::get_field( 'card-cvc-field', $fields, '' );
		echo WC_PsiGate::get_field( 'save-to-account-field', $fields, '' );
		
		do_action( 'wc_psigate_form_after', $gateway );
		?>
		<div class="clear"></div>
	</fieldset>
	<?php
	if ( 'yes' == $save_customers && ! empty( $saved_cards ) ) { ?>
		<script type="text/javascript">
					jQuery('#order_review')
						.on('change', 'input[name=psigate-used-cc]', function () {
							if (jQuery('input[name=psigate-used-cc]:checked').val() == 'new') {
								jQuery('fieldset#<?php echo $gateway; ?>-cc-form').show();
							} else {
								jQuery('fieldset#<?php echo $gateway; ?>-cc-form').slideUp(250);
							}
						});
		</script>
		<?php
	}
	?>
</div>