<?php
/**
 * Template displaying the radio buttons to switch between Cards and Interac Online payment
 *
 * Override this template by copying it to yourtheme/woocommerce/checkout/psigate-switch-forms.php
 *
 * @var WC_Gateway_PsiGate $gateway_id The gateway ID
 *
 * @since 1.4
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
	<div id="<?php echo esc_attr( $gateway->id ); ?>_payment_choices_wrapper" class="<?php echo esc_attr( $gateway->id ); ?>_payment_choices_wrapper">
		<p><?php _e( 'How would you like to pay?', WC_PsiGate::TEXT_DOMAIN ); ?></p>
		<p class="psigate-choise-inputs">
			<label for="<?php echo esc_attr( $gateway->id ); ?>_cc_choice"><?php _e( 'Credit Card', WC_PsiGate::TEXT_DOMAIN ); ?></label>
			<input type="radio" id="<?php echo esc_attr( $gateway->id ); ?>_cc_choice" checked="checked" value="cc" name="<?php echo esc_attr( $gateway->id ); ?>_payment_type_choice">
			<label for="<?php echo esc_attr( $gateway->id ); ?>_interac_online_choice"><?php _e( 'Interac Online', WC_PsiGate::TEXT_DOMAIN ); ?></label>
			<input type="radio" id="<?php echo esc_attr( $gateway->id ); ?>_interac_online_choice" value="interac" name="<?php echo esc_attr( $gateway->id ); ?>_payment_type_choice">
		</p>
		<p></p>
	</div>
<?php
if ( $gateway->has_html_api_features() ) {
	?>
	<script type="text/javascript">
		(function ($) {
			$('#order_review').on('click', '#psigate_payment_choices_wrapper input', function () {
				var root = $(this).closest('.payment_method_psigate');
				var card_block = root.find('#credit_card_info');
				var interac_block = root.find('.psigate_interac_description');

				if ($(this).val() == 'interac') {
					card_block.hide();
					interac_block.show();
				} else {
					card_block.show();
					interac_block.hide()
				}

			}).trigger('click');

		})(jQuery);
	</script>
	<?php
}
?>