<?php
/**
 * Template to display and manage the customer saved cards
 */
?>
<h2 id="psigate-saved-cards" style="margin-top:40px;"><?php _e( 'Saved Cards', WC_PsiGate::TEXT_DOMAIN ); ?></h2>
<table class="shop_table">
	<thead>
	<tr>
		<th><?php _e( 'Card Type', WC_PsiGate::TEXT_DOMAIN ); ?></th>
		<th><?php _e( 'Last 4 digits on card', WC_PsiGate::TEXT_DOMAIN ); ?></th>
		<th><?php _e( 'Expiration Date', WC_PsiGate::TEXT_DOMAIN ); ?></th>
		<th><?php _e( 'Action', WC_PsiGate::TEXT_DOMAIN ); ?></th>
	</tr>
	</thead>
	<tbody>

	<?php foreach ( $saved_cards as $n => $card ) { ?>
		<tr>
			<td><?php if ( file_exists( WC_PsiGate::plugin_path() . '/assets/images/' . strtolower( isset( $card['card_type'] ) ? $card['card_type'] : '' ) . '.png' ) ) {
					echo '<img src="' . esc_url( WC_HTTPS::force_https_url( WC_PsiGate::plugin_url() . '/assets/images/' . strtolower( $card['card_type'] ) . '.png' ) ) . '" alt="' . esc_attr( strtolower( $card['card_type'] ) ) . '" />';
				}
				?></td>
			<td><?php echo $card['last4']; ?></td>
			<td><?php echo $card['exp_month'] . '/' . $card['exp_year'] ?></td>
			<td>
				<form method="post">
					<input type="hidden" name="psigate-delete-card" value="<?php echo $n; ?>" />
					<input type="submit" style="float:left;" class="button" value="<?php _e( 'Delete card', WC_PsiGate::TEXT_DOMAIN ); ?>" />
					<?php wp_nonce_field( 'psigate-verification', 'psigate-nonce' ); ?>
				</form>
			</td>
		</tr>
	<?php } ?>

	</tbody>
</table>