<?php
/**
 * Redsys errors
 *
 * @package WooCommerce Redsys Gateway
 * @since 2.0.0
 * @author José Conti.
 * @link https://joseconti.com
 * @link https://redsys.joseconti.com
 * @link https://woo.com/products/redsys-gateway/
 * @license GNU General Public License v3.0
 * @license URI: http://www.gnu.org/licenses/gpl-3.0.html
 * @copyright 2013-2024 José Conti.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Get Redsys errors.
 *
 * @return array
 */
function redsys_return_dserrors() {
	return array(
		'SIS0001'  => 'Error Interno',
		'SIS0002'  => 'Error genérico',
		'SIS0003'  => 'Error genérico',
		'SIS0004'  => 'Error genérico',
		'SIS0005'  => 'Error genérico',
		'SIS0006'  => 'Error genérico',
		'SIS0007'  => 'El mensaje de petición no es correcto, debe revisar el formato',
		'SIS0008'  => 'falta Ds_Merchant_MerchantCode',
		'SIS0009'  => 'Error de formato en Ds_Merchant_MerchantCode',
		'SIS0010'  => 'Error falta Ds_Merchant_Terminal',
		'SIS0011'  => 'Error de formato en Ds_Merchant_Terminal',
		'SIS0012'  => 'Error genérico',
		'SIS0013'  => 'Error genérico',
		'SIS0014'  => 'Error de formato en Ds_Merchant_Order',
		'SIS0015'  => 'Error falta Ds_Merchant_Currency',
		'SIS0016'  => 'Error de formato en Ds_Merchant_Currency',
		'SIS0018'  => 'Falta Ds_Merchant_Amount',
		'SIS0019'  => 'Error de formato en Ds_Merchant_Amount',
		'SIS0020'  => 'Falta Ds_Merchant_MerchantSignature',
		'SIS0021'  => 'La Ds_Merchant_MerchantSignature viene vacía',
		'SIS0022'  => 'Error de formato en Ds_Merchant_TransactionType',
		'SIS0023'  => 'Ds_Merchant_TransactionType desconocido',
		'SIS0024'  => 'El Ds_Merchant_ConsumerLanguage tiene mas de 3 posiciones',
		'SIS0025'  => 'Error de formato en Ds_Merchant_ConsumerLanguage',
		'SIS0026'  => 'Problema con la configuración',
		'SIS0027'  => 'Revisar la moneda que está enviando',
		'SIS0028'  => 'Error Comercio / terminal está dado de baja',
		'SIS0029'  => 'Que revise como está montando el mensaje',
		'SIS0030'  => 'Nos llega un tipo de operación errónea',
		'SIS0031'  => 'Nos está llegando un método de pago erróneo',
		'SIS0032'  => 'Revisar como está montando el mensaje para la devolución.',
		'SIS0033'  => 'El tipo de operación es erróneo',
		'SIS0034'  => 'error interno',
		'SIS0035'  => 'Error interno al recuperar datos de sesión',
		'SIS0036'  => 'Error al tomar los datos para Pago Móvil desde el XML',
		'SIS0037'  => 'El número de teléfono no es válido',
		'SIS0038'  => 'Error genérico',
		'SIS0039'  => 'Error genérico',
		'SIS0040'  => 'El comercio tiene un error en la configuración, tienen que hablar con su entidad.',
		'SIS0041'  => 'Error en el cálculo de la firma',
		'SIS0042'  => 'Error en el cálculo de la firma',
		'SIS0043'  => 'Error genérico',
		'SIS0044'  => 'Error genérico',
		'SIS0045'  => 'Error genérico',
		'SIS0046'  => 'Problema con la configuración del bin de la tarjeta',
		'SIS0047'  => 'Error genérico',
		'SIS0048'  => 'Error genérico',
		'SIS0049'  => 'Error genérico',
		'SIS0050'  => 'Error genérico',
		'SIS0051'  => 'Error número de pedido repetido',
		'SIS0052'  => 'Error genérico',
		'SIS0053'  => 'Error genérico',
		'SIS0054'  => 'No existe operación sobre la que realizar la devolución',
		'SIS0055'  => 'existe más de un pago con el mismo número de pedido',
		'SIS0056'  => 'Revisar el estado de la autorización',
		'SIS0057'  => 'Que revise el importe que quiere devolver( supera el permitido)',
		'SIS0058'  => 'Que revise los datos con los que está validando la confirmación',
		'SIS0059'  => 'Revisar que existe esa operación',
		'SIS0060'  => 'Revisar que exista la confirmación',
		'SIS0061'  => 'Revisar el estado de la preautorización',
		'SIS0062'  => 'Que el comercio revise el importe a confirmar.',
		'SIS0063'  => 'Que el comercio revise el númer de tarjeta que nos están enviando.',
		'SIS0064'  => 'Número de posiciones de la tarjeta incorrecto',
		'SIS0065'  => 'El número de tarjeta no es numérico',
		'SIS0066'  => 'Error mes de caducidad',
		'SIS0067'  => 'El mes de la caducidad no es numérico',
		'SIS0068'  => 'El mes de la caducidad no es válido',
		'SIS0069'  => 'Año de caducidad no valido',
		'SIS0070'  => 'El Año de la caducidad no es numérico',
		'SIS0071'  => 'Tarjeta caducada',
		'SIS0072'  => 'Operación no anulable',
		'SIS0073'  => 'Error en la anulación',
		'SIS0074'  => 'Falta Ds_Merchant_Order ( Pedido )',
		'SIS0075'  => 'El comercio tiene que revisar cómo está enviando el número de pedido',
		'SIS0077'  => 'El comercio tiene que revisar el número de pedido',
		'SIS0078'  => 'Por la configuración de los métodos de pago de su comercio no se permiten los pagos con esa tarjeta.',
		'SIS0079'  => 'Error genérico',
		'SIS0080'  => 'Error genérico',
		'SIS0081'  => 'Se ha perdico los datos de la sesión',
		'SIS0082'  => 'Error genérico',
		'SIS0083'  => 'Error genérico',
		'SIS0084'  => 'El valor de Ds_Merchant_Conciliation es nulo.',
		'SIS0085'  => 'El valor de Ds_Merchant_Conciliation no es numérico.',
		'SIS0086'  => 'El valor de Ds_Merchant_Conciliation no ocupa 6 posiciones.',
		'SIS0087'  => 'El valor de Ds_Merchant_Session es nulo.',
		'SIS0088'  => 'El comercio tiene que revisar el valor que envía en ese campo.',
		'SIS0089'  => 'El valor de caducidad no ocupa 4 posiciones.',
		'SIS0090'  => 'Error genérico. Consulte con Soporte.',
		'SIS0091'  => 'Error genérico. Consulte con Soporte.',
		'SIS0092'  => 'Se ha introducido una caducidad incorrecta.',
		'SIS0093'  => 'Denegación emisor',
		'SIS0094'  => 'Denegación emisor',
		'SIS0095'  => 'Denegación emisor',
		'SIS0096'  => 'El formato utilizado para los datos 3DSecure es incorrecto',
		'SIS0097'  => 'Valor del campo Ds_Merchant_CComercio no válido',
		'SIS0098'  => 'Valor del campo Ds_Merchant_CVentana no válido',
		'SIS0099'  => 'Error al interpretar respuesta de autenticación',
		'SIS0103'  => 'Error al montar la petición de Autenticación',
		'SIS0104'  => 'Comercio con “titular seguro” y titular sin clave de compra segura',
		'SIS0112'  => 'Que revise que está enviando en el campo Ds_Merchant_Transacction_Type.',
		'SIS0113'  => 'Error interno',
		'SIS0114'  => 'Se está realizando la llamada por GET, la tiene que realizar por POST',
		'SIS0115'  => 'Que revise los datos de la operación que nos está enviando',
		'SIS0116'  => 'La operación sobre la que se desea pagar una cuota no es una operación válida',
		'SIS0117'  => 'La operación sobre la que se desea pagar una cuota no está autorizada',
		'SIS0118'  => 'Se ha excedido el importe total de las cuotas',
		'SIS0119'  => 'Valor del campo Ds_Merchant_DateFrecuency no válido ( Pagos recurrentes)',
		'SIS0120'  => 'Valor del campo Ds_Merchant_ChargeExpiryDate no válido',
		'SIS0121'  => 'Valor del campo Ds_Merchant_SumTotal no válido',
		'SIS0122'  => 'Formato incorrecto del campo Ds_Merchant_DateFrecuency o Ds_Merchant_SumTotal',
		'SIS0123'  => 'Se ha excedido la fecha tope para realiza la Transacción',
		'SIS0124'  => 'No ha transcurrido la frecuencia mínima en un pago recurrente sucesivo',
		'SIS0125'  => 'Error genérico',
		'SIS0126'  => 'Operación Duplicada',
		'SIS0127'  => 'Error Interno',
		'SIS0128'  => 'Error interno',
		'SIS0129'  => 'Error, se ha detectado un intento masivo de peticiones desde la ip',
		'SIS0130'  => 'Error Interno',
		'SIS0131'  => 'Error Interno',
		'SIS0132'  => 'La fecha de Confirmación de Autorización no puede superar en mas de 7 dias a la de Preautorización.',
		'SIS0133'  => 'La fecha de Confirmación de Autenticación no puede superar en mas de 45 días a la de Autenticacion Previa que el comercio revise la fecha de la Preautenticación',
		'SIS0134'  => 'El valor del Ds_MerchantCiers enviado no es válido',
		'SIS0135'  => 'Error generando un nuevo valor para el IDETRA',
		'SIS0136'  => 'Error al montar el mensaje de notificación',
		'SIS0137'  => 'Error al intentar validar la tarjeta como 3DSecure NACIONAL',
		'SIS0138'  => 'Error debido a que existe una Regla del ficheros de reglas que evita que se produzca la Autorizacion',
		'SIS0139'  => 'pago recurrente inicial está duplicado',
		'SIS0140'  => 'Error Interno',
		'SIS0141'  => 'Error formato no correcto para 3DSecure',
		'SIS0142'  => 'Tiempo excecido para el pago',
		'SIS0151'  => 'Error Interno',
		'SIS0169'  => 'El valor del campo Ds_Merchant_MatchingData ( Datos de Case) no es valido , que lo revise',
		'SIS0170'  => 'Que revise el adquirente que manda en el campo',
		'SIS0171'  => 'Que revise el CSB que nos está enviando',
		'SIS0172'  => 'El valor del campo PUCE Ds_Merchant_MerchantCode no es válido',
		'SIS0173'  => 'Que el comercio revise el campo de la URL OK',
		'SIS0174'  => 'Error Interno',
		'SIS0175'  => 'Error Interno',
		'SIS0181'  => 'Error Interno',
		'SIS0182'  => 'Error Interno',
		'SIS0183'  => 'Error interno',
		'SIS0184'  => 'Error interno',
		'SIS0186'  => 'Faltan datos para operación',
		'SIS0187'  => 'Error formato( Interno )',
		'SIS0197'  => 'Error al obtener los datos de cesta de la compra',
		'SIS0214'  => 'Su comercion no permite devoluciones por el tipo de firma ( Completo)',
		'SIS0216'  => 'El CVV2 tiene mas de 3 posiciones',
		'SIS0217'  => 'Error de formato en el CVV2',
		'SIS0218'  => 'El comercio no permite operaciones seguras por las entradas "operaciones" o "WebService"',
		'SIS0219'  => 'Se tiene que dirigir a su entidad.',
		'SIS0220'  => 'Se tiene que dirigir a su entidad.',
		'SIS0221'  => 'El cliente no está introduciendo el CVV2',
		'SIS0222'  => 'Existe una anulación asociada a la preautorización',
		'SIS0223'  => 'La preautorización que se desea anular no está autorizada',
		'SIS0224'  => 'Su comercio no permite anulaciones por no tener la firma ampliada',
		'SIS0225'  => 'No existe operación sobre la que realizar la anulación',
		'SIS0226'  => 'Error en en los datos de la anulación manual',
		'SIS0227'  => 'Que el comercio revise el campo Ds_Merchant_TransactionDate',
		'SIS0228'  => 'El tipo de tarjeta no puede realizar pago aplazado',
		'SIS0229'  => 'Error con el codigo de aplazamiento',
		'SIS0230'  => 'Su comercio no permite pago fraccionado( Consulte a su entidad)',
		'SIS0231'  => 'No hay forma de pago aplicable ( Consulte con su entidad)',
		'SIS0232'  => 'Forma de pago no disponible',
		'SIS0233'  => 'Forma de pago desconocida',
		'SIS0234'  => 'Nombre del titular de la cuenta no disponible',
		'SIS0235'  => 'Campo Sis_Numero_Entidad no disponible',
		'SIS0236'  => 'El campo Sis_Numero_Entidad no tiene la longitud requerida',
		'SIS0237'  => 'El campo Sis_Numero_Entidad no es numérico',
		'SIS0238'  => 'Campo Sis_Numero_Oficina no disponible',
		'SIS0239'  => 'El campo Sis_Numero_Oficina no tiene la longitud requerida',
		'SIS0240'  => 'El campo Sis_Numero_Oficina no es numérico',
		'SIS0241'  => 'Campo Sis_Numero_DC no disponible',
		'SIS0242'  => 'El campo Sis_Numero_DC no tiene la longitud requerida',
		'SIS0243'  => 'El campo Sis_Numero_DC no es numérico',
		'SIS0244'  => 'Campo Sis_Numero_Cuenta no disponible',
		'SIS0245'  => 'El campo Sis_Numero_Cuenta no tiene la longitud requerida',
		'SIS0246'  => 'El campo Sis_Numero_Cuenta no es numérico',
		'SIS0247'  => 'Dígito de Control de Cuenta Cliente no válido',
		'SIS0248'  => 'El comercio no permite pago por domiciliación',
		'SIS0249'  => 'Error genérico',
		'SIS0250'  => 'Error genérico',
		'SIS0251'  => 'No permite transferencias( Consultar con entidad )',
		'SIS0252'  => 'Por su configuración no puede enviar la tarjeta. ( Para modificarlo consualtar con la entidad)',
		'SIS0253'  => 'No se ha tecleado correctamente la tarjeta.',
		'SIS0254'  => 'Se tiene que dirigir a su entidad.',
		'SIS0255'  => 'Se tiene que dirigir a su entidad.',
		'SIS0256'  => 'El comercio no permite operativa de preautorizacion.',
		'SIS0257'  => 'La tarjeta no permite operativa de preautorizacion',
		'SIS0258'  => 'Tienen que revisar los datos de la validación',
		'SIS0259'  => 'No existe la operacion original para notificar o consultar',
		'SIS0260'  => 'Entrada incorrecta al SIS',
		'SIS0261'  => 'Se tiene que dirigir a su entidad.',
		'SIS0262'  => 'Moneda no permitida para operación de transferencia o domiciliacion',
		'SIS0263'  => 'Error calculando datos para procesar operación',
		'SIS0264'  => 'Error procesando datos de respuesta recibidos',
		'SIS0265'  => 'Error de firma en los datos recibidos',
		'SIS0266'  => 'No se pueden recuperar los datos de la operación recibida',
		'SIS0267'  => 'La operación no se puede procesar por no existir Codigo Cuenta Cliente',
		'SIS02648' => 'La devolución no se puede procesar por WebService',
		'SIS0269'  => 'No se pueden realizar devoluciones de operaciones de domiciliacion no descargadas',
		'SIS0270'  => 'El comercio no puede realizar preautorizaciones en diferido',
		'SIS0274'  => 'Tipo de operación desconocida o no permitida por esta entrada al SIS',
		'SIS0275'  => 'Premio sin IdPremio',
		'SIS076'   => 'Unidades del Premio no numericas.',
		'SIS0277'  => 'Error genérico. Consulte con Redsys',
		'SIS0278'  => 'Error en el proceso de consulta de premios',
		'SIS0279'  => 'El comercio no tiene activada la operativa de fidelización',
		'SIS0280'  => 'Se tiene que dirigir a su entidad.',
		'SIS0281'  => 'Se tiene que dirigir a su entidad.',
		'SIS0282'  => 'Se tiene que dirigir a su entidad.',
		'SIS0283'  => 'Se tiene que dirigir a su entidad.',
		'SIS0284'  => 'No existe operacion sobre la que realizar el Pago Adicional',
		'SIS0285'  => 'Tiene más de una operacion sobre la que realizar el Pago Adicional',
		'SIS0286'  => 'La operación sobre la que se quiere hacer la operación adicional no esta Aceptada',
		'SIS0287'  => 'la Operacion ha sobrepasado el importe para el Pago Adicional.',
		'SIS0288'  => 'No se puede realizar otro pago Adicional. se ha superado el numero de pagos',
		'SIS0289'  => 'El importe del pago Adicional supera el maximo días permitido.',
		'SIS0290'  => 'Se tiene que dirigir a su entidad.',
		'SIS0291'  => 'Se tiene que dirigir a su entidad.',
		'SIS0292'  => 'Se tiene que dirigir a su entidad.',
		'SIS0293'  => 'Se tiene que dirigir a su entidad.',
		'SIS0294'  => 'La tarjeta no es privada.',
		'SIS0295'  => 'duplicidad de operación. Se puede intentar de nuevo ( 1 minuto )',
		'SIS0296'  => 'No se encuentra la operación Tarjeta en Archivo inicial',
		'SIS0297'  => 'Número de operaciones sucesivas de Tarjeta en Archivo superado',
		'SIS0298'  => 'No puede realizar este tipo de operativa. (Contacte con su entidad)',
		'SIS0299'  => 'Error en pago con PayPal',
		'SIS0300'  => 'Error en pago con PayPal',
		'SIS0301'  => 'Error en pago con PayPal',
		'SIS0302'  => 'Moneda no válida para pago con PayPal',
		'SIS0304'  => 'No se permite pago fraccionado si la tarjeta no es de FINCONSUM',
		'SIS0305'  => 'Revisar la moneda de la operación',
		'SIS0306'  => 'Valor de Ds_Merchant_PrepaidCard no válido',
		'SIS0307'  => 'Que consulte con su entidad. Operativa de tarjeta regalo no permitida',
		'SIS0308'  => 'Tiempo límite para recarga de tarjeta regalo superado',
		'SIS0309'  => 'Faltan datos adicionales para realizar la recarga de tarjeta prepago',
		'SIS0310'  => 'Valor de Ds_Merchant_Prepaid_Expiry no válido',
		'SIS0311'  => 'Error genérico',
		'SIS0319'  => 'El comercio no pertenece al grupo especificado en Ds_Merchant_Group',
		'SIS0320'  => 'Error generando la referencia',
		'SIS0321'  => 'El identificador no está asociado al comercio',
		'SIS0322'  => 'Que revise el formato del grupo',
		'SIS0323'  => 'Para el tipo de operación F( pago en dos fases) es necesario enviar uno de estos campos. Ds_Merchant_Customer_Mobile o Ds_Merchant_Customer_Mail',
		'SIS0324'  => 'Imposible enviar el link al cliente( Que revise la dirección mail)',
		'SIS0326'  => 'Se han enviado datos de tarjeta en fase primera de un pago con dos fases',
		'SIS0327'  => 'No se ha enviado ni móvil ni email en fase primera de un pago con dos fases',
		'SIS0328'  => 'Token de pago en dos fases inválido',
		'SIS0329'  => 'No se puede recuperar el Token de pago en dos fases.',
		'SIS0330'  => 'Fechas incorrectas de pago dos fases',
		'SIS0331'  => 'La operación no tiene un estado válido o no existe.',
		'SIS0332'  => 'El importe de la operación original y de la devolución debe ser idéntico',
		'SIS0333'  => 'Error en una petición a MasterPass Wallet',
		'SIS0334'  => 'Bloqueo por control de Seguridad',
		'SIS0335'  => 'El valor del campo Ds_Merchant_Recharge_Commission no es válido',
		'SIS0336'  => 'Error genérico. Consulte con Redsys',
		'SIS0337'  => 'Error genérico. Consulte con Redsys',
		'SIS0338'  => 'No se encuentra la operación iUPAY',
		'SIS0339'  => 'El comercio no dispone de pago iUPAY',
		'SIS0340'  => 'Respuesta recibida desde iUPAY no válida',
		'SIS0341'  => 'Error genérico. Consulte con Redsys',
		'SIS0342'  => 'El comercio no permite realizar operaciones de pago de tributos',
		'SIS0343'  => 'Falta o es incorrecto el parámetro Ds_Merchant_Tax_Reference',
		'SIS0344'  => 'No se han aceptado las condiciones de las cuotas',
		'SIS0345'  => 'Se ha elegido un número de plazos incorrecto',
		'SIS0346'  => 'Error en el formato del campo DS_MERCHANT_PAY_TYPE',
		'SIS0347'  => 'El comercio no está configurado para realizar la consulta de BIN.',
		'SIS0348'  => 'El BIN indicado en la consulta no se reconoce',
		'SIS0349'  => 'Los datos de importe y DCC enviados no coinciden con los registrados en SIS',
		'SIS0350'  => 'No hay datos DCC registrados en SIS para este número de pedido',
		'SIS0351'  => 'Autenticación prepago incorrecta',
		'SIS0352'  => 'El tipo de firma del comercio no permite esta operativa',
		'SIS0353'  => 'El comercio no tiene definida una clave 3DES válida',
		'SIS0354'  => 'Error descifrando petición',
		'SIS0355'  => 'El comercio-terminal enviado en los datos cifrados no coincide con el enviado en la petición',
		'SIS0356'  => 'Existen datos de entrada para control de fraude y el comercio no tiene activo control de fraude',
		'SIS0357'  => 'El comercio tiene activo control de fraude y no existe campo ds_merchant_merchantscf',
		'SIS0358'  => 'La entidad no dispone de pago iUPAY',
		'SIS0370'  => 'Error en formato Scf_Merchant_Nif. Longitud máxima 16',
		'SIS0371'  => 'Error en formato Scf_Merchant_Name. Longitud máxima 30',
		'SIS0372'  => 'Error en formato Scf_Merchant_First_Name. Longitud máxima 30',
		'SIS0373'  => 'Error en formato Scf_Merchant_Last_Name. Longitud máxima 30',
		'SIS0374'  => 'Error en formato Scf_Merchant_User. Longitud máxima 45',
		'SIS0375'  => 'Error en formato Scf_Affinity_Card. Valores posibles «S» o «N». Longitud máxima 1',
		'SIS0376'  => 'Error en formato Scf_Payment_Financed. Valores posibles «S» o «N». Longitud máxima 1',
		'SIS0377'  => 'Error en formato Scf_Ticket_Departure_Point. Longitud máxima 30',
		'SIS0378'  => 'Error en formato Scf_Ticket_Destination. Longitud máxima 30',
		'SIS0379'  => 'Error en formato Scf_Ticket_Departure_Date. Debe tener formato yyyyMMddHHmmss.',
		'SIS080'   => 'Error en formato Scf_Ticket_Num_Passengers. Longitud máxima 1.',
		'SIS081'   => 'Error en formato Scf_Passenger_Dni. Longitud máxima 16.',
		'SIS082'   => 'Error en formato Scf_Passenger_Name. Longitud máxima 30.',
		'SIS0334'  => 'Se tiene que dirigir a su entidad.',
		'SIS0335'  => 'El valor del campo Ds_Merchant_Recharge_Commission no es válido',
		'SIS0336'  => 'Error genérico',
		'SIS0337'  => 'Error interno (iUPAY)',
		'SIS0338'  => 'No se encuentra la operación iUPAY',
		'SIS0339'  => 'El comercio no dispone de pago iUPAY ( Consulte a su entidad)',
		'SIS0340'  => 'Respuesta recibida desde iUPAY no válida',
		'SIS0341'  => 'Error interno (iUPAY)',
		'SIS0342'  => 'El comercio no permite realizar operaciones de pago de tributos',
		'SIS0343'  => 'Falta o es incorrecto el parámetro Ds_Merchant_Tax_Reference',
		'SIS0344'  => 'El usuario ha elegido aplazar el pago, pero no ha aceptado las condiciones de las cuotas',
		'SIS0345'  => 'Revisar el número de plazos que está enviando.',
		'SIS0346'  => 'Revisar formato en parámetro DS_MERCHANT_PAY_TYPE',
		'SIS0347'  => 'El comercio no está configurado para realizar la consulta de BIN.',
		'SIS0348'  => 'El BIN indicado en la consulta no se reconoce',
		'SIS0349'  => 'Los datos de importe y DCC enviados no coinciden con los registrados en SIS',
		'SIS0350'  => 'No hay datos DCC registrados en SIS para este número de pedido',
		'SIS0351'  => 'Autenticación prepago incorrecta',
		'SIS0352'  => 'El tipo de firma no permite esta operativa',
		'SIS0353'  => 'Clave no válida',
		'SIS0354'  => 'Error descifrando petición al SIS',
		'SIS0355'  => 'El comercio-terminal enviado en los datos cifrados no coincide con el enviado en la petición',
		'SIS0356'  => 'El comercio no tiene activo control de fraude ( Consulte con su entidad',
		'SIS0357'  => 'El comercio tiene activo control de fraude y no existe campo ds_merchant_merchantscf',
		'SIS0358'  => 'No dispone de pago iUPAY',
		'SIS0359'  => 'El comercio solamente permite pago de tributos y no se está informando el campo Ds_Merchant_TaxReference',
		'SIS0370'  => 'Error en formato Scf_Merchant_Nif. Longitud máxima 16',
		'SIS0371'  => 'Error en formato Scf_Merchant_Name. Longitud máxima 30',
		'SIS0372'  => 'Error en formato Scf_Merchant_First_Name. Longitud máxima 30',
		'SIS0373'  => 'Error en formato Scf_Merchant_Last_Name. Longitud máxima 30',
		'SIS0374'  => 'Error en formato Scf_Merchant_User. Longitud máxima 45',
		'SIS0375'  => 'Error en formato Scf_Affinity_Card. Valores posibles «S» o «N». Longitud máxima 1',
		'SIS0376'  => 'Error en formato Scf_Payment_Financed. Valores posibles «S» o «N». Longitud máxima 1',
		'SIS0377'  => 'Error en formato Scf_Ticket_Departure_Point. Longitud máxima 30',
		'SIS0378'  => 'Error en formato Scf_Ticket_Destination. Longitud máxima 30',
		'SIS0379'  => 'Error en formato Scf_Ticket_Departure_Date. Debe tener formato yyyyMMddHHmmss.',
		'SIS0380'  => 'Error en formato Scf_Ticket_Num_Passengers. Longitud máxima 1.',
		'SIS0381'  => 'Error en formato Scf_Passenger_Dni. Longitud máxima 16.',
		'SIS0382'  => 'Error en formato Scf_Passenger_Name. Longitud máxima 30.',
		'SIS0383'  => 'Error en formato Scf_Passenger_First_Name. Longitud máxima 30.',
		'SIS0384'  => 'Error en formato Scf_Passenger_Last_Name. Longitud máxima 30.',
		'SIS0385'  => 'Error en formato Scf_Passenger_Check_Luggage. Valores posibles «S» o «N». Longitud máxima 1.',
		'SIS0386'  => 'Error en formato Scf_Passenger_Special_luggage. Valores posibles «S» o «N». Longitud máxima 1.',
		'SIS0387'  => 'Error en formato Scf_Passenger_Insurance_Trip. Valores posibles «S» o «N». Longitud máxima 1.',
		'SIS0388'  => 'Error en formato Scf_Passenger_Type_Trip. Valores posibles «N» o «I». Longitud máxima 1.',
		'SIS0389'  => 'Error en formato Scf_Passenger_Pet. Valores posibles «S» o «N». Longitud máxima 1.',
		'SIS0390'  => 'Error en formato Scf_Order_Channel. Valores posibles «M»(móvil), «P»(PC) o «T»(Tablet)',
		'SIS0391'  => 'Error en formato Scf_Order_Total_Products. Debe tener formato numérico y longitud máxima de 3.',
		'SIS0392'  => 'Error en formato Scf_Order_Different_Products. Debe tener formato numérico y longitud máxima de 3.',
		'SIS0393'  => 'Error en formato Scf_Order_Amount. Debe tener formato numérico y longitud máxima de 19.',
		'SIS0394'  => 'Error en formato Scf_Order_Max_Amount. Debe tener formato numérico y longitud máxima de 19.',
		'SIS0395'  => 'Error en formato Scf_Order_Coupon. Valores posibles «S» o «N»',
		'SIS0396'  => 'Error en formato Scf_Order_Show_Type. Debe longitud máxima de 30.',
		'SIS0397'  => 'Error en formato Scf_Wallet_Identifier',
		'SIS0398'  => 'Error en formato Scf_Wallet_Client_Identifier',
		'SIS0399'  => 'Error en formato Scf_Merchant_Ip_Address',
		'SIS0400'  => 'Error en formato Scf_Merchant_Proxy',
		'SIS0401'  => 'Error en formato Ds_Merchant_Mail_Phone_Number. Debe ser numérico y de longitud máxima 19',
		'SIS0402'  => 'Error en llamada a SafetyPay para solicitar token url',
		'SIS0403'  => 'Error en proceso de solicitud de token url a SafetyPay',
		'SIS0404'  => 'Error en una petición a SafetyPay',
		'SIS0405'  => 'Solicitud de token url denegada SAFETYPAY',
		'SIS0406'  => 'Se tiene que poner en contacto con su entidad para que revisen la configuración del sector de actividad de su comercio',
		'SIS0407'  => 'El importe de la operación supera el máximo permitido para realizar un pago de premio de apuesta(Gambling)',
		'SIS0408'  => 'La tarjeta debe de haber operado durante el último año para poder realizar un pago de premio de apuesta (Gambling)',
		'SIS0409'  => 'La tarjeta debe ser una Visa o MasterCard nacional para realizar un pago de premio de apuesta (Gambling)',
		'SIS0410'  => 'Denegada por el emisor',
		'SIS0411'  => 'Error en la configuración del comercio (Remitir a su entidad)',
		'SIS0412'  => 'La firma no es correcta',
		'SIS0413'  => 'Denegada, consulte con su entidad.',
		'SIS0414'  => 'El plan de ventas no es correcto',
		'SIS0415'  => 'El tipo de producto no es correcto',
		'SIS0416'  => 'Importe no permitido en devolucion',
		'SIS0417'  => 'Fecha de devolucion no permitida',
		'SIS0418'  => 'No existe plan de ventas vigente',
		'SIS0419'  => 'Tipo de cuenta no permitida',
		'SIS0420'  => 'El comercio no dispone de formas de pago para esta operación',
		'SIS0421'  => 'Tarjeta no permitida. No es producto Agro',
		'SIS0422'  => 'Faltan datos para operacion Agro',
		'SIS0423'  => 'CNPJ del comecio incorrecto',
		'SIS0424'  => 'No se ha encontrado el establecimiento',
		'SIS0425'  => 'No se ha encontrado la tarjeta',
		'SIS0426'  => 'Enrutamiento no valido para el comercio',
		'SIS0427'  => 'La conexion con CECA no ha sido posible',
		'SIS0428'  => 'Operacion debito no segura',
		'SIS0429'  => 'Error en la versión enviada por el comercio (Ds_SignatureVersion)',
		'SIS0430'  => 'Error al decodificar el parámetro Ds_MerchantParameters',
		'SIS0431'  => 'Error del objeto JSON que se envía codificado en el parámetro Ds_MerchantParameters',
		'SIS0432'  => 'Error FUC del comercio erróneo',
		'SIS0433'  => 'Error Terminal del comercio erróneo',
		'SIS0434'  => 'Error ausencia de número de pedido en la op. del comercio',
		'SIS0435'  => 'Error en el cálculo de la firma',
		'SIS0436'  => 'Error en la construcción del elemento padre',
		'SIS0437'  => 'Error en la construcción del elemento',
		'SIS0438'  => 'Error en la construcción del elemento',
		'SIS0439'  => 'Error en la construcción del elemento',
		'SIS0440'  => 'Error genérico',
		'SIS0441'  => 'Error no tenemos bancos para Mybank',
		'SIS0442'  => 'Error genérico',
		'SIS0443'  => 'No se permite pago con esta tarjeta',
		'SIS0444'  => 'Se está intentando acceder usando firmas antiguas y el comercio está configurado como HMAC SHA256',
		'SIS0445'  => 'Error genérico',
		'SIS0446'  => 'Es obligatorio indicar la forma de pago',
		'SIS0447'  => 'Error, se está utilizando una referencia que se generó con un adquirente distinto al adquirente que la utiliza.',
		'SIS0448'  => 'El comercio no tiene el método de pago "Pago DINERS"',
		'SIS0449'  => 'Tipo de pago de la operación no permitido para este tipo de tarjeta',
		'SIS0450'  => 'Tipo de pago de la operación no permitido para este tipo de tarjeta',
		'SIS0451'  => 'Tipo de pago de la operación no permitido para este tipo de tarjeta',
		'SIS0453'  => 'No se permiten pagos con ese tipo de tarjeta',
		'SIS0454'  => 'No se permiten pagos con ese tipo de tarjeta',
		'SIS0455'  => 'No se permiten pagos con ese tipo de tarjeta',
		'SIS0456'  => 'No tiene método de pago configurado (Consulte a su entidad)',
		'SIS0457'  => 'Error, se aplica el método de pago "MasterCard SecureCode" con Respuesta [VEReq, VERes] = N con tarjeta MasterCard Comercial y el comercio no tiene el método de pago "MasterCard Comercial"',
		'SIS0458'  => 'Error, se aplica el método de pago "MasterCard SecureCode" con Respuesta [VEReq, VERes] = U con tarjeta MasterCard Comercial y el comercio no tiene el método de pago "MasterCard Comercial"',
		'SIS0459'  => 'No tiene método de pago configurado (Consulte a su entidad)',
		'SIS0460'  => 'No tiene método de pago configurado (Consulte a su entidad)',
		'SIS0461'  => 'No tiene método de pago configurado (Consulte a su entidad)',
		'SIS0462'  => 'Metodo de pago no disponible para conexión HOST to HOST',
		'SIS0463'  => 'Metodo de pago no permitido',
		'SIS0464'  => 'El comercio no tiene el método de pago "MasterCard Comercial"',
		'SIS0465'  => 'No tiene método de pago configurado (Consulte a su entidad)',
		'SIS0466'  => 'La referencia que se está utilizando no existe.',
		'SIS0467'  => 'La referencia que se está utilizando está dada de baja',
		'SIS0468'  => 'Se está utilizando una referencia que se generó con un adquirente distinto al adquirente que la utiliza.',
		'SIS0469'  => 'Error, no se ha superado el proceso de fraude MR',
		'SIS0470'  => 'Error la solicitud del primer factor ha fallado.',
		'SIS0471'  => 'Error en la URL de redirección de solicitud del primer factor.',
		'SIS0472'  => 'Error al montar la petición de Autenticación de PPII.',
		'SIS0473'  => 'Error la respuesta de la petición de Autenticación de PPII es nula.',
		'SIS0474'  => 'Error el statusCode de la respuesta de la petición de Autenticación de PPII es nulo',
		'SIS0475'  => 'Error el idOperación de la respuesta de la petición de Autenticación de PPII es nulo',
		'SIS0476'  => 'Error tratando la respuesta de la Autenticación de PPII',
		'SIS0477'  => 'Error se ha superado el tiempo definido entre el paso 1 y 2 de PPI',
		'SIS0478'  => 'Error tratando la respuesta de la Autorización de PPII',
		'SIS0479'  => 'Error la respuesta de la petición de Autorización de PPII es nula',
		'SIS0480'  => 'Error el statusCode de la respuesta de la petición de Autorización de PPII es nulo.',
		'SIS0481'  => 'Error, el comercio no es Payment Facilitator',
		'SIS0482'  => 'Error el idOperación de la respuesta de una Autorización OK es nulo o no coincide con el idOp. de la Auth.',
		'SIS0483'  => 'Error la respuesta de la petición de devolución de PPII es nula.',
		'SIS0484'  => 'Error el statusCode o el idPetición de la respuesta de la petición de Devolución de PPII es nulo.',
		'SIS0485'  => 'Error producido por la denegación de la devolución.',
		'SIS0486'  => 'Error la respuesta de la petición de consulta de PPII es nula.',
		'SIS0487'  => 'El comercio terminal no tiene habilitado el método de pago Paygold.',
		'SIS0488'  => 'El comercio no tiene el método de pago "Pago MOTO/Manual" y la operación viene marcada como pago MOTO.',
		'SIS0489'  => 'Error de datos. Operacion MPI Externo no permitida',
		'SIS0490'  => 'Error de datos. Se reciben parametros MPI Redsys en operacion MPI Externo',
		'SIS0491'  => 'Error de datos. SecLevel no permitido en operacion MPI Externo',
		'SIS0492'  => 'Error de datos. Se reciben parametros MPI Externo en operacion MPI Redsys',
		'SIS0493'  => 'Error de datos. Se reciben parametros de MPI en operacion no segura',
		'SIS0494'  => 'FIRMA OBSOLETA',
		'SIS0495'  => 'Configuración incorrecta ApplePay o AndroidPay',
		'SIS0496'  => 'No tiene dado de alta el método de pago AndroidPay',
		'SIS0497'  => 'No tiene dado de alta el método de pago ApplePay',
		'SIS0498'  => 'moneda / importe de la operación de ApplePay no coinciden',
		'SIS0499'  => 'Error obteniendo claves del comercio en Android/Apple Pay',
		'SIS0500'  => 'Error en el DCC Dinámico, se ha modificado la tarjeta.',
		'SIS0501'  => 'Error en La validación de datos enviados para genera el Id operación',
		'SIS0502'  => 'Error al validar Id Oper',
		'SIS0503'  => 'Error al validar el pedido',
		'SIS0504'  => 'Error al validar tipo de transacción',
		'SIS0505'  => 'Error al validar moneda',
		'SIS0506'  => 'Error al validar el importe',
		'SIS0507'  => 'Id Oper no tiene vigencia',
		'SIS0508'  => 'Error al validar Id Oper',
		'SIS0510'  => 'No se permite el envío de datos de tarjeta si se envía ID de operación',
		'SIS0511'  => 'Error en la respuesta de consulta de BINES',
		'SIS0515'  => 'El comercio tiene activado pago Amex en Perfil.',
		'SIS0516'  => 'Error al montar el mensaje de China Union Pay',
		'SIS0517'  => 'Error al establecer la clave para China Union Pay',
		'SIS0518'  => 'Error al grabar los datos para pago China Union Pay',
		'SIS0519'  => 'Mensaje de autenticación erróneo',
		'SIS0520'  => 'El mensaje SecurePlus de sesión está vacío',
		'SIS0521'  => 'El xml de respuesta viene vacío',
		'SIS0522'  => 'No se han recibido parametros en datosentrada',
		'SIS0523'  => 'La firma calculada no coincide con la recibida en la respuesta',
		'SIS0524'  => 'el resultado de la autenticación 3DSecure MasterCard es PARes="A" o VERes="N" y no recibimos CAVV del emisor',
		'SIS0525'  => 'No se puede utilizar la tarjeta privada en este comercio',
		'SIS0526'  => 'La tarjeta no es china',
		'SIS0527'  => 'Falta el parametro obligatorio DS_MERCHANT_BUYERID',
		'SIS0528'  => 'Formato erróneo del parametro DS_MERCHANT_BUYERID en operación Sodexo Brasil',
		'SIS0529'  => 'No se permite operación recurrente en pagos con tarjeta Voucher',
		'SIS0530'  => 'La fecha de Anulación no puede superar en mas de 7 dias a la de Preautorización.',
		'SIS0531'  => 'La fecha de Anulación no puede superar en mas de 72 horas a la de Preautorización diferida',
		'SIS0532'  => 'La moneda de la petición no coincide con la devuelta',
		'SIS0533'  => 'El importe de la petición no coincide con el devuelto',
		'SIS0534'  => 'No se recibe recaudación emisora o referencia del recibo',
		'SIS0535'  => 'Pago de tributo fuera de plazo',
		'SIS0536'  => 'Tributo ya pagado',
		'SIS0537'  => 'Pago de tributo denegado',
		'SIS0538'  => 'Rechazo en el pago de tributo',
		'SIS0539'  => 'Error en el envío de SMS',
		'SIS0540'  => 'El móvil enviado es demasiado largo (más de 12 posiciones)',
		'SIS0541'  => 'La referencia enviada es demasiada larga (más de 40 posiciones)',
		'SIS0542'  => 'Error genérico. Consulte con Redsys',
		'SIS0543'  => 'Error, la tarjeta de la operación es DINERS y el comercio no tiene el método de pago "Pago DINERS" o "Pago Discover No Seguro"',
		'SIS0544'  => 'Error, la tarjeta de la operación es DINERS y el comercio no tiene el método de pago "Pago Discover No Seguro"',
		'SIS0545'  => 'Error DISCOVER',
		'SIS0546'  => 'Error DISCOVER',
		'SIS0547'  => 'Error DISCOVER',
		'SIS0548'  => 'Error DISCOVER',
		'SIS0549'  => 'Error DISCOVER',
		'SIS0550'  => 'ERROR en el gestor de envío de los SMS. Consulte con Redsys',
		'SIS0551'  => 'ERROR en el proceso de autenticación.',
		'SIS0552'  => 'ERROR el resultado de la autenticacion PARes = «U»',
		'SIS0553'  => 'ERROR se ha intentado hacer un pago con el método de pago UPI y la tarjeta no es china',
		'SIS0554'  => 'ERROR el resultado de la autenticacion para UPI es PARes = «U» y el comercio no tiene métodos de pago no seguros UPI EXPRESSPAY',
		'SIS0555'  => 'ERROR la IP de conexión del módulo de administración no esta entre las permitidas.',
		'SIS0556'  => 'Se envía pago Tradicional y el comercio no tiene pago Tradicional mundial ni Tradicional UE.',
		'SIS0557'  => 'Se envía pago Tarjeta en Archivo y el comercio no tiene pago Tradicional mundial ni Tradicional UE.',
		'SIS0558'  => 'ERROR, el formato de la fecha dsMerchantP2FExpiryDate es incorrecto',
		'SIS0559'  => 'ERROR el id Operacion de la respuesta en la autenticación PPII es nulo o no se ha obtenido de la autenticación final',
		'SIS0560'  => 'ERROR al enviar la notificacion de autenticacion al comercio',
		'SIS0561'  => 'ERROR el idOperación de la respuesta de una confirmacion separada OK es nulo o no coincide con el idOp. de la Confirmacion.',
		'SIS0562'  => 'ERROR la respuesta de la petición de confirmacion separada de PPII es nula.',
		'SIS0563'  => 'ERROR tratando la respuesta de la confirmacion separada de PPII.',
		'SIS0564'  => 'ERROR chequeando los importes de DCC antes del envío de la operación a Stratus.',
		'SIS0565'  => 'Formato del importe del campo Ds_Merchant_Amount excede del límite permitido.',
		'SIS0566'  => 'Error de acceso al nuevo Servidor Criptográfico.',
		'SIS0567'  => 'ERROR se ha intentado hacer un pago con una tarjeta china UPI y el comercio no tiene método de pago UPI',
		'SIS0568'  => 'Operacion de consulta de tarjeta rechazada, tipo de transacción erróneo',
		'SIS0569'  => 'Operacion de consulta de tarjeta rechazada, no se ha informado la tarjeta',
		'SIS0570'  => 'Operacion de consulta de tarjeta rechazada, se ha enviado tarjeta y referencia',
		'SIS0571'  => 'Operacion de autenticacion rechazada, protocolVersion no indicado',
		'SIS0572'  => 'Operacion de autenticacion rechazada, protocolVersion no reconocido',
		'SIS0573'  => 'Operacion de autenticacion rechazada, browserAcceptHeader no indicado',
		'SIS0574'  => 'Operacion de autenticacion rechazada, browserUserAgent no indicado',
		'SIS0575'  => 'Operacion de autenticacion rechazada, browserJavaEnabled no indicado',
		'SIS0576'  => 'Operacion de autenticacion rechazada, browserLanguage no indicado',
		'SIS0577'  => 'Operacion de autenticacion rechazada, browserColorDepth no indicado',
		'SIS0578'  => 'Operacion de autenticacion rechazada, browserScreenHeight no indicado',
		'SIS0579'  => 'Operacion de autenticacion rechazada, browserScreenWidth no indicado',
		'SIS0580'  => 'Operacion de autenticacion rechazada, browserTZ no indicado',
		'SIS0581'  => 'Operacion de autenticacion rechazada, datos DS_MERCHANT_EMV3DS no está indicado o es demasiado grande y no se puede convertir en JSON',
		'SIS0582'  => 'Operacion de autenticacion rechazada, threeDSServerTransID no indicado',
		'SIS0583'  => 'Operacion de autenticacion rechazada, threeDSCompInd no indicado',
		'SIS0584'  => 'Operacion de autenticacion rechazada, notificationURL no indicado',
		'SIS0585'  => 'Operacion de autenticacion EMV3DS rechazada, no existen datos en la BBDD',
		'SIS0586'  => 'Operacion de autenticacion rechazada, PARes no indicado',
		'SIS0587'  => 'Operacion de autenticacion rechazada, MD no indicado',
		'SIS0588'  => 'Operacion de autenticacion rechazada, la versión no coincide entre los mensajes AuthenticationData y ChallengeResponse',
		'SIS0589'  => 'Operacion de autenticacion rechazada, respuesta sin CRes',
		'SIS0590'  => 'Operacion de autenticacion rechazada, error al desmontar la respuesta CRes',
		'SIS0591'  => 'Operacion de autenticacion rechazada, error la respuesta CRes viene sin threeDSServerTransID',
		'SIS0592'  => 'Operacion de autenticacion rechazada, error el transStatus del CRes no coincide con el transStatus de la consulta final de la operación',
		'SIS0593'  => 'Operacion de autenticacion rechazada, error el transStatus de la consulta final de la operación no está definido',
		'SIS0594'  => 'Operacion de autenticacion rechazada, CRes no indicado',
		'SIS0595'  => 'El comercio indicado no tiene métodos de pago seguros permitidos en 3DSecure V2',
		'SIS0596'  => 'Operacion de consulta de tarjeta rechazada,moneda errónea',
		'SIS0597'  => 'Operacion de consulta de tarjeta rechazada,importe erróneo',
		'SIS0598'  => 'Autenticación 3DSecure v2 errónea, y no se permite hacer fallback a 3DSecure v1',
		'SIS0599'  => 'Error en el proceso de autenticación 3DSecure v2',
		'SIS0600'  => 'Error en el proceso de autenticación 3DSecure v2 - Respuesta Areq N',
		'SIS0601'  => 'Error en el proceso de autenticación 3DSecure v2 - Respuesta Areq R',
		'SIS0602'  => 'Error en el proceso de autenticación 3DSecure v2 - Respuesta Areq U y el comercio no tiene método de pago U',
		'SIS0603'  => 'Error en el parámetro DS_MERCHANT_DCC de DCC enviado en operacion H2H (REST y SOAP)',
		'SIS0604'  => 'Error en los datos de DCC enviados en el parámetro DS_MERCHANT_DCC en operacion H2H (REST y SOAP)',
		'SIS0605'  => 'Error en el parámetro DS_MERCHANT_MPIEXTERNAL enviado en operacion H2H (REST y SOAP)',
		'SIS0606'  => 'Error en los datos de MPI enviados en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP)',
		'SIS0607'  => 'Error del parámetro TXID de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'SIS0608'  => 'Error del parámetro CAVV de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'SIS0609'  => 'Error del parámetro ECI de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'SIS0610'  => 'Error del parámetro threeDSServerTransID de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'SIS0611'  => 'Error del parámetro dsTransID de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'SIS0612'  => 'Error del parámetro authenticacionValue de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'SIS0613'  => 'Error del parámetro protocolVersion de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'SIS0614'  => 'Error del parámetro Eci de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'SIS0615'  => 'Error en MPI Externo, marca de tarjeta no permitida en SIS para MPI Externo',
		'SIS0616'  => 'Error del parámetro DS_MERCHANT_EXCEP_SCA tiene un valor erróneo',
		'SIS0617'  => 'Error del parámetro DS_MERCHANT_EXCEP_SCA es de tipo MIT y no vienen datos de COF o de pago por referencia',
		'SIS0618'  => 'Error la exención enviada no está permitida y el comercio no está preparado para autenticar',
		'SIS0619'  => 'Se recibe orderReferenceId de Amazon y no está el método de pago configurado',
		'SIS0620'  => 'Error la operación de DCC tiene asociado un markUp más alto del permitido, se borran los datos de DCC',
		'SIS0621'  => 'El amazonOrderReferenceId no es válido',
		'SIS0622'  => 'Error la operación original se hizo sin marca de Nuevo modelo DCC y el comercio está configurado como Nuevo Modelo DCC',
		'SIS0623'  => 'Error la operación original se hizo con marca de Nuevo modelo DCC y el comercio no está configurado como Nuevo Modelo DCC',
		'SIS0624'  => 'Error la operación original se hizo con marca de Nuevo modelo DCC pero su valor difiere del modelo configurado en el comercio',
		'SIS0625'  => 'Error en la anulación del pago, porque ya existe una devolución asociada a ese pago',
		'SIS0626'  => 'Error en la devolución del pago, ya existe una anulación de la operación que se desea devolver',
		'SIS0627'  => 'El número de referencia o solicitud enviada por CRTM no válida.',
		'SIS0628'  => 'Error la operación de viene con datos de 3DSecure y viene por la entrada SERMEPA',
		'SIS0629'  => 'Error no existe la operación de confirmación separada sobre la que realizar la anulación',
		'SIS0630'  => 'Error en la anulación de confirmación separada, ya existe una devolución asociada a la confirmación separada',
		'SIS0631'  => 'Error en la anulación de confirmación separada, ya existe una anulación asociada a la confirmación separada',
		'SIS0632'  => 'Error la confirmacion separada sobre la que se desea anular no está autorizada',
		'SIS0633'  => 'La fecha de Anulación no puede superar en los días configurados a la confirmacion separada.',
		'SIS0634'  => 'Error no existe la operación de pago sobre la que realizar la anulación',
		'SIS0635'  => 'Error en la anulación del pago, ya existe una anulación asociada al pago',
		'SIS0636'  => 'Error el pago que se desea anular no está autorizado',
		'SIS0637'  => 'La fecha de Anulación no puede superar en los días configurados al pago.',
		'SIS0638'  => 'Error existe más de una devolución que se quiere anular y no se ha especificado cual.',
		'SIS0639'  => 'Error no existe la operación de devolución sobre la que realizar la anulación',
		'SIS0640'  => 'Error la confirmacion separada sobre la que se desea anular no está autorizada o ya está anulada',
		'SIS0641'  => 'La fecha de Anulación no puede superar en los días configurados a la devolución.',
		'SIS0642'  => 'La fecha de la preautorización que se desea reemplazar no puede superar los 30 días de antigüedad',
		'SIS0643'  => 'Error al obtener la personalización del comercio',
		'SIS0644'  => 'Error en el proceso de autenticación 3DSecure v2 - Se envían datos de la entrada IniciaPetición a la entrada TrataPetición',
		'SIS0645'  => 'Unkonwn',
		'SIS0646'  => 'Unkonwn',
		'SIS0647'  => 'Unkonwn',
		'SIS0648'  => 'Unkonwn',
		'SIS0649'  => 'Unkonwn',
		'SIS0650'  => 'Error, la MAC no es correcta en la mensajeria de pago de tributos',
		'SIS0651'  => 'Error la exención exige SCA y el comercio no está preparado para autenticar',
		'SIS0652'  => 'Error la exención y la configuración del comercio exigen no SCA y el comercio no está configurado para autorizar con dicha marca de tarjeta',
		'SIS0653'  => 'Operacion de autenticacion rechazada, browserJavascriptEnabled no indicado',
		'SIS0654'  => 'Error, se indican datos de 3RI en Inicia Petición y la versión que se envía en el trataPetición no es 2.2',
		'SIS0655'  => 'Error, se indican un valor de Ds_Merchant_3RI_Ind no permitido',
		'SIS0656'  => 'Error, se indican un valor Ds_Merchant_3RI_Ind diferentes en el Inicia Petición y en el trataPetición',
		'SIS0657'  => 'Error, se indican datos de 3RI pero están incompletos',
		'SIS0658'  => 'Error, el parámetro threeRITrasactionID es erróneo o no se encuentran datos de operación original',
		'SIS0659'  => 'Error, los datos de FUC y Terminal obtenidos del threeRITrasactionID no corresponden al comercio que envía la operación',
		'SIS0660'  => '3RI',
		'SIS0661'  => '3RI',
		'SIS0662'  => 'Error, el comercio no está entre los permitidos para realizar confirmaciones parciales.',
		'SIS0663'  => 'No existe datos de Inicia Petición que concuerden con los enviados por el comercio en el mensaje Trata Petición',
		'SIS0664'  => 'No se envía el elemento Id Transaccion 3DS Server en el mensaje Trata Petición y dicho elemento existe en el mensaje Inicia Petición',
		'SIS0665'  => 'La moneda indicada por el comercio en el mensaje Trata Petición no corresponde con la enviada en el mensaje Inicia Petición',
		'SIS0666'  => 'El importe indicado por el comercio en el mensaje Trata Petición no corresponde con el enviado en el mensaje Inicia Petición',
		'SIS0667'  => 'El tipo de operación indicado por el comercio en el mensaje Trata Petición no corresponde con el enviado en el mensaje Inicia Petición',
		'SIS0668'  => 'La referencia indicada por el comercio en el mensaje Trata Petición no corresponde con la enviada en el mensaje Inicia Petición',
		'SIS0669'  => 'El Id Oper Insite indicado por el comercio en el mensaje Trata Petición no corresponde con el enviado en el mensaje Inicia Petición',
		'SIS0670'  => 'La tarjeta indicada por el comercio en el mensaje Trata Petición no corresponde con la enviada en el mensaje Inicia Petición',
		'SIS0671'  => 'Denegación por TRA Lynx',
		'SIS0672'  => 'Bizum. Fallo en la autenticación. Bloqueo tras tres intentos.',
		'SIS0673'  => 'Bizum. Operación cancelada. El usuario no desea seguir.',
		'SIS0674'  => 'Bizum. Abono rechazado por beneficiario.',
		'SIS0675'  => 'Bizum. Cargo rechazado por ordenante.',
		'SIS0676'  => 'Bizum. El procesador rechaza la operación.',
		'SIS0677'  => 'Bizum. Saldo disponible insuficiente.',
		'SIS0678'  => 'La versión de 3DSecure indicada en el Trata Petición es errónea o es superior a la devuelva en el inicia petición',
		'SIS0681'  => 'Error al insertar los datos de autenticación en una operación con MPI Externo',
		'SIS0682'  => 'Error la operación es de tipo Consulta de TRA y el parámetro Ds_Merchant_TRA_Data es erróneo',
		'SIS0683'  => 'Error la operación es de tipo Consulta de TRA Fase 1 y falta el parámetro Ds_Merchant_TRA_Type',
		'SIS0684'  => 'Error la operación es de tipo Consulta de TRA Fase 1 y el parámetro Ds_Merchant_TRA_Type tiene un valor no permitido',
		'SIS0685'  => 'Error la operación es de tipo Consulta de TRA Fase 1 y el perfil del comercio no le permite exención TRA',
		'SIS0686'  => 'Error la operación es de tipo Consulta de TRA Fase 1 y la confifguración del comercio no le permite usar el TRA de Redsys',
		'SIS0687'  => 'Error la operación es de tipo Consulta de TRA Fase 2 y falta el parámetro Ds_Merchant_TRA_Result o tiene un valor no permitido',
		'SIS0688'  => 'Error la operación es de tipo Consulta de TRA Fase 2 y falta el parámetro Ds_Merchant_TRA_Method o tiene un valor erróneo',
		'SIS0689'  => 'Error la operación es de tipo Consulta de TRA Fase 2, no existe una operación concreta de Fase 1',
		'SIS0690'  => 'Error la operación es de tipo Consulta de TRA Fase 2 y obtenemos un error en la respuesta de Lynx',
		'SIS0691'  => 'Se envían datos SamsungPay y el comercio no tiene dado de alta el método de pago SamsungPay',
		'SIS0692'  => 'Se envía petición con firma de PSP y el comercio no tiene asociado un PSP.',
		'SIS0693'  => 'No se han obtenido correctamente los datos enviados por SamsungPay.',
		'SIS0694'  => 'No ha podido realizarse el pago con SamsungPay',
		'SIS0700'  => 'PayPal a devuelto un KO',
		'SIS0801'  => 'Denegada por iUPAY',
		'SIS0883'  => 'Problema con MIT, probablemnte no activo en el terminal',
		'SIS0899'  => 'No están correctamente firmados los datos que nos envían en el Ds_Merchant_Data.',
		'SIS0900'  => 'SafetyPay ha devuelto un KO',
		'SIS0909'  => 'Error interno',
		'SIS0912'  => 'Emisor no disponible',
		'SIS0913'  => 'Excepción en el envío SOAP de la notificacion',
		'SIS0914'  => 'Respuesta KO en el envío SOAP de la notificacion',
		'SIS0915'  => 'Cancelado por el titular',
		'SIS0928'  => 'El titular ha cancelado la preautorización',
		'SIS0929'  => 'El titular ha cancelado la operación',
		'SIS0930'  => 'La transferencia está pendiente',
		'SIS0931'  => 'Consulte con su entidad',
		'SIS0932'  => 'Denegada por Fraude (LINX)',
		'SIS0933'  => 'Denegada por Fraude (LINX)',
		'SIS0944'  => 'Denegada ( Consulte con su entidad)',
		'SIS0935'  => 'Denegada ( Consulte con su entidad)',
		'SIS0966'  => 'BIZUM ha devuelto un KO en la autorización',
		'SIS0992'  => 'Solicitud de PAE',
		'SIS0994'  => 'No ha seleccionado ninguna tarjeta de la cartera.',
		'SIS0995'  => 'Recarga de prepago denegada',
		'SIS0996'  => 'No permite la recarga de tarjeta prepago',
		'SIS0997'  => 'Con una misma tarjeta hay varios pagos en "vuelo" en el momento que se finaliza uno el resto se deniegan con este código. Esta restricción se realiza por seguridad.',
		'SIS0998'  => 'Operación en proceso de solicitud de datos de tarjeta',
		'SIS0999'  => 'Operación que ha sido redirigida al emisor a autenticar',
		'101'      => 'Tarjeta caducada',
		'106'      => 'Tarjeta bloqueada, exceso de pin erróneo',
		'129'      => 'Código de seguridad CVV incorrecto.',
		'180'      => 'Denegación emisor',
		'184'      => 'el cliente de la operación no se ha autenticado',
		'XML0000'  => 'Errores en el proceso del XML-String recibido',
		'XML0001'  => 'Error en la generación del DOM a partir del XML-String recibido y la DTD definida',
		'XML0002'  => 'No existe el elemento "Message" en el XML-String recibido',
		'XML0003'  => 'El tipo de "Message" en el XML-String recibido tiene un valor desconcido o inválido en la petición',
		'XML0004'  => 'No existe el elemento "Ds_MerchantCode" en el XML-String recibido',
		'XML0005'  => 'El elemento "Ds_MerchantCode" viene vacío en el XML-String recibido',
		'XML0006'  => 'El elemento "Ds_MerchantCode" tiene una longitud incorrecta en el XML-String recibido',
		'XML0007'  => 'El elemento "Ds_MerchantCode" no tiene formato numérico en el XML-String recibido',
		'XML0008'  => 'No existe el elemento "Ds_Terminal" en el XML-String recibido',
		'XML0009'  => 'El elemento "Ds_Terminal" viene vacío en el XML-String recibido',
		'XML0010'  => 'El elemento "Ds_Terminal" tiene una longitud incorrecta en el XML-String recibido',
		'XML0011'  => 'El elemento "Ds_Terminal" no tiene formato numérico en el XML-String recibido',
		'XML0012'  => 'No existe el elemento "Ds_Order" en el XML-String recibido',
		'XML0013'  => 'El elemento "Ds_Order" viene vacío en el XML-String recibido',
		'XML0014'  => 'El elemento "Ds_Order" tiene una longitud incorrecta en el XML-String recibido',
		'XML0015'  => 'El elemento "Ds_Order" no tiene sus 4 primeras posiciones numéricas en el XML-String recibido',
		'XML0016'  => 'No existe el elemento "Ds_TransactionType" en el XML-String recibido',
		'XML0017'  => 'El elemento "Ds_TransactionType" viene vacío en el XML-String recibido',
		'XML0018'  => 'El elemento "Ds_TransactionType" tiene una longitud incorrecta en el XML-String recibido',
		'XML0019'  => 'El elemento "Ds_TransactionType" no tiene formato numérico en el XML-String recibido',
		'XML0020'  => 'El elemento "Ds_TransactionType" tiene un valor desconcido o inválido en un mensaje Transaction',
		'XML0021'  => 'No existe el elemento "Signature" en el XML-String recibido',
		'XML0022'  => 'El elemento "Signature" viene vacío en el XML-String recibido',
		'XML0023'  => 'La firma no es correcta',
		'XML0024'  => 'No existen operaciones para los datos solicitados',
		'XML0025'  => 'El XML de respuesta está mal formado',
		'XML0026'  => 'No existe el elemento "Ds_fecha_inicio" en el XML-String recibido',
		'XML0027'  => 'No existe el elemento "Ds_fecha_fin" en el XML-String recibido',
		'XML0028'  => 'El comercio-terminal está dado de baja',
		'XML0029'  => 'El elemento "SignatureVersion" viene vacío en el XML-String recibido',
		'XML0030'  => 'El elemento "SignatureVersion" viene con un valor erróneo en el XML-String recibido',
		'XML0031'  => 'El elemento "Entrada" viene con un valor no permitido en el XML-String recibido',
		'XML0032'  => 'El elemento "Autorizada" viene con un valor no permitido en el XML-String recibido',
		'XML0033'  => 'El elemento "ImporteMayor" viene con un valor no permitido en el XML-String recibido',
		'XML0034'  => 'El elemento "ImporteMenor" viene con un valor no permitido en el XML-String recibido',
		'XML0035'  => 'El elemento "Autenticada" viene con un valor no permitido en el XML-String recibido',
		'XML0036'  => 'El elemento "DCC" viene con un valor no permitido en el XML-String recibido',
		'XML0037'  => 'El elemento "Paymethod" viene con un valor no permitido en el XML-String recibido',
		'8102'     => 'Operación que ha sido redirigida al emisor a autenticar EMV3DS V1.0.2 (para H2H)',
		'8210'     => 'Operación que ha sido redirigida al emisor a autenticar EMV3DS V2.1.0 (para H2H)',
		'8220'     => 'Operación que ha sido redirigida al emisor a autenticar EMV3DS V2.2.0 (para H2H)',
		'9001'     => 'Error Interno',
		'9002'     => 'Error genérico',
		'9003'     => 'Error genérico',
		'9004'     => 'Error genérico',
		'9005'     => 'Error genérico',
		'9006'     => 'Error genérico',
		'9007'     => 'El mensaje de petición no es correcto, debe revisar el formato',
		'9008'     => 'falta Ds_Merchant_MerchantCode',
		'9009'     => 'Error de formato en Ds_Merchant_MerchantCode',
		'9010'     => 'Error falta Ds_Merchant_Terminal',
		'9011'     => 'Error de formato en Ds_Merchant_Terminal',
		'9012'     => 'Error genérico',
		'9013'     => 'Error genérico',
		'9014'     => 'Error de formato en Ds_Merchant_Order',
		'9015'     => 'Error falta Ds_Merchant_Currency',
		'9016'     => 'Error de formato en Ds_Merchant_Currency',
		'9018'     => 'Falta Ds_Merchant_Amount',
		'9019'     => 'Error de formato en Ds_Merchant_Amount',
		'9020'     => 'Falta Ds_Merchant_MerchantSignature',
		'9021'     => 'La Ds_Merchant_MerchantSignature viene vacía',
		'9022'     => 'Error de formato en Ds_Merchant_TransactionType',
		'9023'     => 'Ds_Merchant_TransactionType desconocido',
		'9024'     => 'El Ds_Merchant_ConsumerLanguage tiene mas de 3 posiciones',
		'9025'     => 'Error de formato en Ds_Merchant_ConsumerLanguage',
		'9026'     => 'Problema con la configuración',
		'9027'     => 'Revisar la moneda que está enviando',
		'9028'     => 'Error Comercio / terminal está dado de baja',
		'9029'     => 'Que revise como está montando el mensaje',
		'9030'     => 'Nos llega un tipo de operación errónea',
		'9031'     => 'Nos está llegando un método de pago erróneo',
		'9032'     => 'Revisar como está montando el mensaje para la devolución.',
		'9033'     => 'El tipo de operación es erróneo',
		'9034'     => 'error interno',
		'9035'     => 'Error interno al recuperar datos de sesión',
		'9037'     => 'El número de teléfono no es válido',
		'9038'     => 'Error genérico',
		'9039'     => 'Error genérico',
		'9040'     => 'El comercio tiene un error en la configuración, tienen que hablar con su entidad.',
		'9041'     => 'Error en el cálculo de la firma',
		'9042'     => 'Error en el cálculo de la firma',
		'9043'     => 'Error genérico',
		'9044'     => 'Error genérico',
		'9046'     => 'Problema con la configuración del bin de la tarjeta',
		'9047'     => 'Error genérico',
		'9048'     => 'Error genérico',
		'9049'     => 'Error genérico',
		'9050'     => 'Error genérico',
		'9051'     => 'Error número de pedido repetido',
		'9052'     => 'Error genérico',
		'9053'     => 'Error genérico',
		'9054'     => 'No existe operación sobre la que realizar la devolución',
		'9055'     => 'existe más de un pago con el mismo número de pedido',
		'9056'     => 'Revisar el estado de la autorización',
		'9057'     => 'Que revise el importe que quiere devolver( supera el permitido)',
		'9058'     => 'Que revise los datos con los que está validando la confirmación',
		'9059'     => 'Revisar que existe esa operación',
		'9060'     => 'Revisar que exista la confirmación',
		'9061'     => 'Revisar el estado de la preautorización',
		'9062'     => 'Que el comercio revise el importe a confirmar.',
		'9063'     => 'Que el comercio revise el númer de tarjeta que nos están enviando.',
		'9064'     => 'Número de posiciones de la tarjeta incorrecto',
		'9065'     => 'El número de tarjeta no es numérico',
		'9066'     => 'Error mes de caducidad',
		'9067'     => 'El mes de la caducidad no es numérico',
		'9068'     => 'El mes de la caducidad no es válido',
		'9069'     => 'Año de caducidad no valido',
		'9070'     => 'El Año de la caducidad no es numérico',
		'9071'     => 'Tarjeta caducada',
		'9072'     => 'Operación no anulable',
		'9073'     => 'Error en la anulación',
		'9074'     => 'Falta Ds_Merchant_Order ( Pedido )',
		'9075'     => 'El comercio tiene que revisar cómo está enviando el número de pedido',
		'9077'     => 'El comercio tiene que revisar el número de pedido',
		'9078'     => 'Por la configuración de los métodos de pago de su comercio no se permiten los pagos con esa tarjeta.',
		'9079'     => 'Error genérico',
		'9080'     => 'Error genérico',
		'9081'     => 'Se ha perdico los datos de la sesión',
		'9082'     => 'Error genérico',
		'9083'     => 'Error genérico',
		'9084'     => 'El valor de Ds_Merchant_Conciliation es nulo.',
		'9085'     => 'El valor de Ds_Merchant_Conciliation no es numérico.',
		'9086'     => 'El valor de Ds_Merchant_Conciliation no ocupa 6 posiciones.',
		'9087'     => 'El valor de Ds_Merchant_Session es nulo.',
		'9088'     => 'El comercio tiene que revisar el valor que envía en ese campo.',
		'9089'     => 'El valor de caducidad no ocupa 4 posiciones.',
		'9090'     => 'Error genérico. Consulte con Soporte.',
		'9091'     => 'Error genérico. Consulte con Soporte.',
		'9092'     => 'Se ha introducido una caducidad incorrecta.',
		'9093'     => 'Denegación emisor',
		'9094'     => 'Denegación emisor',
		'9095'     => 'Denegación emisor',
		'9096'     => 'El formato utilizado para los datos 3DSecure es incorrecto',
		'9097'     => 'Valor del campo Ds_Merchant_CComercio no válido',
		'9098'     => 'Valor del campo Ds_Merchant_CVentana no válido',
		'9099'     => 'Error al interpretar respuesta de autenticación',
		'9103'     => 'Error al montar la petición de Autenticación',
		'9104'     => 'Comercio con “titular seguro” y titular sin clave de compra segura',
		'9112'     => 'Que revise que está enviando en el campo Ds_Merchant_Transacction_Type.',
		'9113'     => 'Error interno',
		'9114'     => 'Se está realizando la llamada por GET, la tiene que realizar por POST',
		'9115'     => 'Que revise los datos de la operación que nos está enviando',
		'9116'     => 'La operación sobre la que se desea pagar una cuota no es una operación válida',
		'9117'     => 'La operación sobre la que se desea pagar una cuota no está autorizada',
		'9118'     => 'Se ha excedido el importe total de las cuotas',
		'9119'     => 'Valor del campo Ds_Merchant_DateFrecuency no válido ( Pagos recurrentes)',
		'9120'     => 'Valor del campo Ds_Merchant_ChargeExpiryDate no válido',
		'9121'     => 'Valor del campo Ds_Merchant_SumTotal no válido',
		'9122'     => 'Formato incorrecto del campo Ds_Merchant_DateFrecuency o Ds_Merchant_SumTotal',
		'9123'     => 'Se ha excedido la fecha tope para realiza la Transacción',
		'9124'     => 'No ha transcurrido la frecuencia mínima en un pago recurrente sucesivo',
		'9125'     => 'Error genérico',
		'9126'     => 'Operación Duplicada',
		'9127'     => 'Error Interno',
		'9128'     => 'Error interno',
		'9129'     => 'Error, se ha detectado un intento masivo de peticiones desde la ip',
		'9130'     => 'Error Interno',
		'9131'     => 'Error Interno',
		'9132'     => 'La fecha de Confirmación de Autorización no puede superar en mas de 7 dias a la de Preautorización.',
		'9133'     => 'La fecha de Confirmación de Autenticación no puede superar en mas de 45 días a la de Autenticacion Previa que el comercio revise la fecha de la Preautenticación',
		'9134'     => 'El valor del Ds_MerchantCiers enviado no es válido',
		'9135'     => 'Error generando un nuevo valor para el IDETRA',
		'9136'     => 'Error al montar el mensaje de notificación',
		'9137'     => 'Error al intentar validar la tarjeta como 3DSecure NACIONAL',
		'9138'     => 'Error debido a que existe una Regla del ficheros de reglas que evita que se produzca la Autorizacion',
		'9139'     => 'pago recurrente inicial está duplicado',
		'9140'     => 'Error Interno',
		'9141'     => 'Error formato no correcto para 3DSecure',
		'9142'     => 'Tiempo excecido para el pago',
		'9151'     => 'Error Interno',
		'9169'     => 'El valor del campo Ds_Merchant_MatchingData ( Datos de Case) no es valido , que lo revise',
		'9170'     => 'Que revise el adquirente que manda en el campo',
		'9171'     => 'Que revise el CSB que nos está enviando',
		'9172'     => 'El valor del campo PUCE Ds_Merchant_MerchantCode no es válido',
		'9173'     => 'Que el comercio revise el campo de la URL OK',
		'9174'     => 'Error Interno',
		'9175'     => 'Error Interno',
		'9181'     => 'Error Interno',
		'9182'     => 'Error Interno',
		'9183'     => 'Error interno',
		'9184'     => 'Error interno',
		'9186'     => 'Faltan datos para operación',
		'9187'     => 'Error formato( Interno )',
		'9197'     => 'Error al obtener los datos de cesta de la compra',
		'9214'     => 'Su comercion no permite devoluciones por el tipo de firma ( Completo)',
		'9216'     => 'El CVV2 tiene mas de 3 posiciones',
		'9217'     => 'Error de formato en el CVV2',
		'9218'     => 'El comercio no permite operaciones seguras por las entradas "operaciones" o "WebService"',
		'9219'     => 'Se tiene que dirigir a su entidad.',
		'9220'     => 'Se tiene que dirigir a su entidad.',
		'9221'     => 'El cliente no está introduciendo el CVV2',
		'9222'     => 'Existe una anulación asociada a la preautorización',
		'9223'     => 'La preautorización que se desea anular no está autorizada',
		'9224'     => 'Su comercio no permite anulaciones por no tener la firma ampliada',
		'9225'     => 'No existe operación sobre la que realizar la anulación',
		'9226'     => 'Error en en los datos de la anulación manual',
		'9227'     => 'Que el comercio revise el campo Ds_Merchant_TransactionDate',
		'9228'     => 'El tipo de tarjeta no puede realizar pago aplazado',
		'9229'     => 'Error con el codigo de aplazamiento',
		'9230'     => 'Su comercio no permite pago fraccionado( Consulte a su entidad)',
		'9231'     => 'No hay forma de pago aplicable ( Consulte con su entidad)',
		'9232'     => 'Forma de pago no disponible',
		'9233'     => 'Forma de pago desconocida',
		'9234'     => 'Nombre del titular de la cuenta no disponible',
		'9235'     => 'Campo Sis_Numero_Entidad no disponible',
		'9236'     => 'El campo Sis_Numero_Entidad no tiene la longitud requerida',
		'9237'     => 'El campo Sis_Numero_Entidad no es numérico',
		'9238'     => 'Campo Sis_Numero_Oficina no disponible',
		'9239'     => 'El campo Sis_Numero_Oficina no tiene la longitud requerida',
		'9240'     => 'El campo Sis_Numero_Oficina no es numérico',
		'9241'     => 'Campo Sis_Numero_DC no disponible',
		'9242'     => 'El campo Sis_Numero_DC no tiene la longitud requerida',
		'9243'     => 'El campo Sis_Numero_DC no es numérico',
		'9244'     => 'Campo Sis_Numero_Cuenta no disponible',
		'9245'     => 'El campo Sis_Numero_Cuenta no tiene la longitud requerida',
		'9246'     => 'El campo Sis_Numero_Cuenta no es numérico',
		'9247'     => 'Dígito de Control de Cuenta Cliente no válido',
		'9248'     => 'El comercio no permite pago por domiciliación',
		'9249'     => 'Error genérico',
		'9250'     => 'Error genérico',
		'9251'     => 'No permite transferencias( Consultar con entidad )',
		'9252'     => 'Por su configuración no puede enviar la tarjeta. ( Para modificarlo consualtar con la entidad)',
		'9253'     => 'No se ha tecleado correctamente la tarjeta.',
		'9254'     => 'Se tiene que dirigir a su entidad.',
		'9255'     => 'Se tiene que dirigir a su entidad.',
		'9256'     => 'El comercio no permite operativa de preautorizacion.',
		'9257'     => 'La tarjeta no permite operativa de preautorizacion',
		'9258'     => 'Tienen que revisar los datos de la validación',
		'9259'     => 'No existe la operacion original para notificar o consultar',
		'9260'     => 'Entrada incorrecta al SIS',
		'9261'     => 'Se tiene que dirigir a su entidad.',
		'9262'     => 'Moneda no permitida para operación de transferencia o domiciliacion',
		'9263'     => 'Error calculando datos para procesar operación',
		'9264'     => 'Error procesando datos de respuesta recibidos',
		'9265'     => 'Error de firma en los datos recibidos',
		'9266'     => 'No se pueden recuperar los datos de la operación recibida',
		'9267'     => 'La operación no se puede procesar por no existir Codigo Cuenta Cliente',
		'9268'     => 'La devolución no se puede procesar por WebService',
		'9269'     => 'No se pueden realizar devoluciones de operaciones de domiciliacion no descargadas',
		'9270'     => 'El comercio no puede realizar preautorizaciones en diferido',
		'9274'     => 'Tipo de operación desconocida o no permitida por esta entrada al SIS',
		'9275'     => 'Premio sin IdPremio',
		'9276'     => 'Unidades del Premio no numericas.',
		'9277'     => 'Error genérico. Consulte con Redsys',
		'9278'     => 'Error en el proceso de consulta de premios',
		'9279'     => 'El comercio no tiene activada la operativa de fidelización',
		'9280'     => 'Se tiene que dirigir a su entidad.',
		'9281'     => 'Se tiene que dirigir a su entidad.',
		'9282'     => 'Se tiene que dirigir a su entidad.',
		'9283'     => 'Se tiene que dirigir a su entidad.',
		'9284'     => 'No existe operacion sobre la que realizar el Pago Adicional',
		'9285'     => 'Tiene más de una operacion sobre la que realizar el Pago Adicional',
		'9286'     => 'La operación sobre la que se quiere hacer la operación adicional no esta Aceptada',
		'9287'     => 'la Operacion ha sobrepasado el importe para el Pago Adicional.',
		'9288'     => 'No se puede realizar otro pago Adicional. se ha superado el numero de pagos',
		'9289'     => 'El importe del pago Adicional supera el maximo días permitido.',
		'9290'     => 'Se tiene que dirigir a su entidad.',
		'9291'     => 'Se tiene que dirigir a su entidad.',
		'9292'     => 'Se tiene que dirigir a su entidad.',
		'9293'     => 'Se tiene que dirigir a su entidad.',
		'9294'     => 'La tarjeta no es privada.',
		'9295'     => 'duplicidad de operación. Se puede intentar de nuevo ( 1 minuto )',
		'9296'     => 'No se encuentra la operación Tarjeta en Archivo inicial',
		'9297'     => 'Número de operaciones sucesivas de Tarjeta en Archivo superado',
		'9298'     => 'No puede realizar este tipo de operativa. (Contacte con su entidad)',
		'9299'     => 'Error en pago con PayPal',
		'9300'     => 'Error en pago con PayPal',
		'9301'     => 'Error en pago con PayPal',
		'9302'     => 'Moneda no válida para pago con PayPal',
		'9304'     => 'No se permite pago fraccionado si la tarjeta no es de FINCONSUM',
		'9305'     => 'Revisar la moneda de la operación',
		'9306'     => 'Valor de Ds_Merchant_PrepaidCard no válido',
		'9307'     => 'Que consulte con su entidad. Operativa de tarjeta regalo no permitida',
		'9308'     => 'Tiempo límite para recarga de tarjeta regalo superado',
		'9309'     => 'Faltan datos adicionales para realizar la recarga de tarjeta prepago',
		'9310'     => 'Valor de Ds_Merchant_Prepaid_Expiry no válido',
		'9311'     => 'Error genérico',
		'9319'     => 'El comercio no pertenece al grupo especificado en Ds_Merchant_Group',
		'9320'     => 'Error generando la referencia',
		'9321'     => 'El identificador no está asociado al comercio',
		'9322'     => 'Que revise el formato del grupo',
		'9323'     => 'Para el tipo de operación F( pago en dos fases) es necesario enviar uno de estos campos. Ds_Merchant_Customer_Mobile o Ds_Merchant_Customer_Mail',
		'9324'     => 'Imposible enviar el link al cliente( Que revise la dirección mail)',
		'9326'     => 'Se han enviado datos de tarjeta en fase primera de un pago con dos fases',
		'9327'     => 'No se ha enviado ni móvil ni email en fase primera de un pago con dos fases',
		'9328'     => 'Token de pago en dos fases inválido',
		'9329'     => 'No se puede recuperar el Token de pago en dos fases.',
		'9330'     => 'Fechas incorrectas de pago dos fases',
		'9331'     => 'La operación no tiene un estado válido o no existe.',
		'9332'     => 'El importe de la operación original y de la devolución debe ser idéntico',
		'9333'     => 'Error en una petición a MasterPass Wallet',
		'9334'     => 'Bloqueo por control de Seguridad',
		'9335'     => 'El valor del campo Ds_Merchant_Recharge_Commission no es válido',
		'9336'     => 'Error genérico. Consulte con Redsys',
		'9337'     => 'Error genérico. Consulte con Redsys',
		'9338'     => 'No se encuentra la operación iUPAY',
		'9339'     => 'El comercio no dispone de pago iUPAY',
		'9340'     => 'Respuesta recibida desde iUPAY no válida',
		'9341'     => 'Error genérico. Consulte con Redsys',
		'9342'     => 'El comercio no permite realizar operaciones de pago de tributos',
		'9343'     => 'Falta o es incorrecto el parámetro Ds_Merchant_Tax_Reference',
		'9344'     => 'No se han aceptado las condiciones de las cuotas',
		'9345'     => 'Se ha elegido un número de plazos incorrecto',
		'9346'     => 'Error en el formato del campo DS_MERCHANT_PAY_TYPE',
		'9347'     => 'El comercio no está configurado para realizar la consulta de BIN.',
		'9348'     => 'El BIN indicado en la consulta no se reconoce',
		'9349'     => 'Los datos de importe y DCC enviados no coinciden con los registrados en SIS',
		'9350'     => 'No hay datos DCC registrados en SIS para este número de pedido',
		'9351'     => 'Autenticación prepago incorrecta',
		'9352'     => 'El tipo de firma del comercio no permite esta operativa',
		'9353'     => 'El comercio no tiene definida una clave 3DES válida',
		'9354'     => 'Error descifrando petición',
		'9355'     => 'El comercio-terminal enviado en los datos cifrados no coincide con el enviado en la petición',
		'9356'     => 'Existen datos de entrada para control de fraude y el comercio no tiene activo control de fraude',
		'9357'     => 'El comercio tiene activo control de fraude y no existe campo ds_merchant_merchantscf',
		'9358'     => 'La entidad no dispone de pago iUPAY',
		'9370'     => 'Error en formato Scf_Merchant_Nif. Longitud máxima 16',
		'9371'     => 'Error en formato Scf_Merchant_Name. Longitud máxima 30',
		'9372'     => 'Error en formato Scf_Merchant_First_Name. Longitud máxima 30',
		'9373'     => 'Error en formato Scf_Merchant_Last_Name. Longitud máxima 30',
		'9374'     => 'Error en formato Scf_Merchant_User. Longitud máxima 45',
		'9375'     => 'Error en formato Scf_Affinity_Card. Valores posibles "S" o "N". Longitud máxima 1',
		'9376'     => 'Error en formato Scf_Payment_Financed. Valores posibles "S" o "N". Longitud máxima 1',
		'9377'     => 'Error en formato Scf_Ticket_Departure_Point. Longitud máxima 30',
		'9378'     => 'Error en formato Scf_Ticket_Destination. Longitud máxima 30',
		'9379'     => 'Error en formato Scf_Ticket_Departure_Date. Debe tener formato yyyyMMddHHmmss.',
		'9380'     => 'Error en formato Scf_Ticket_Num_Passengers. Longitud máxima 1.',
		'9381'     => 'Error en formato Scf_Passenger_Dni. Longitud máxima 16.',
		'9382'     => 'Error en formato Scf_Passenger_Name. Longitud máxima 30.',
		'9283'     => 'Se tiene que dirigir a su entidad.',
		'9335'     => 'El valor del campo Ds_Merchant_Recharge_Commission no es válido',
		'9336'     => 'Error genérico',
		'9337'     => 'Error interno (iUPAY)',
		'9338'     => 'No se encuentra la operación iUPAY',
		'9339'     => 'El comercio no dispone de pago iUPAY ( Consulte a su entidad)',
		'9340'     => 'Respuesta recibida desde iUPAY no válida',
		'9341'     => 'Error interno (iUPAY)',
		'9342'     => 'El comercio no permite realizar operaciones de pago de tributos',
		'9343'     => 'Falta o es incorrecto el parámetro Ds_Merchant_Tax_Reference',
		'9344'     => 'El usuario ha elegido aplazar el pago, pero no ha aceptado las condiciones de las cuotas',
		'9345'     => 'Revisar el número de plazos que está enviando.',
		'9346'     => 'Revisar formato en parámetro DS_MERCHANT_PAY_TYPE',
		'9347'     => 'El comercio no está configurado para realizar la consulta de BIN.',
		'9348'     => 'El BIN indicado en la consulta no se reconoce',
		'9349'     => 'Los datos de importe y DCC enviados no coinciden con los registrados en SIS',
		'9350'     => 'No hay datos DCC registrados en SIS para este número de pedido',
		'9351'     => 'Autenticación prepago incorrecta',
		'9352'     => 'El tipo de firma no permite esta operativa',
		'9353'     => 'Clave no válida',
		'9354'     => 'Error descifrando petición al SIS',
		'9355'     => 'El comercio-terminal enviado en los datos cifrados no coincide con el enviado en la petición',
		'9356'     => 'El comercio no tiene activo control de fraude ( Consulte con su entidad',
		'9357'     => 'El comercio tiene activo control de fraude y no existe campo ds_merchant_merchantscf',
		'9358'     => 'No dispone de pago iUPAY',
		'9359'     => 'El comercio solamente permite pago de tributos y no se está informando el campo Ds_Merchant_TaxReference',
		'9370'     => 'Error en formato Scf_Merchant_Nif. Longitud máxima 16',
		'9371'     => 'Error en formato Scf_Merchant_Name. Longitud máxima 30',
		'9372'     => 'Error en formato Scf_Merchant_First_Name. Longitud máxima 30',
		'9373'     => 'Error en formato Scf_Merchant_Last_Name. Longitud máxima 30',
		'9374'     => 'Error en formato Scf_Merchant_User. Longitud máxima 45',
		'9375'     => 'Error en formato Scf_Affinity_Card. Valores posibles "S" o "N". Longitud máxima 1',
		'9376'     => 'Error en formato Scf_Payment_Financed. Valores posibles "S" o "N". Longitud máxima 1',
		'9377'     => 'Error en formato Scf_Ticket_Departure_Point. Longitud máxima 30',
		'9378'     => 'Error en formato Scf_Ticket_Destination. Longitud máxima 30',
		'9379'     => 'Error en formato Scf_Ticket_Departure_Date. Debe tener formato yyyyMMddHHmmss.',
		'9380'     => 'Error en formato Scf_Ticket_Num_Passengers. Longitud máxima 1.',
		'9381'     => 'Error en formato Scf_Passenger_Dni. Longitud máxima 16.',
		'9382'     => 'Error en formato Scf_Passenger_Name. Longitud máxima 30.',
		'9383'     => 'Error en formato Scf_Passenger_First_Name. Longitud máxima 30.',
		'9384'     => 'Error en formato Scf_Passenger_Last_Name. Longitud máxima 30.',
		'9385'     => 'Error en formato Scf_Passenger_Check_Luggage. Valores posibles "S" o "N". Longitud máxima 1.',
		'9386'     => 'Error en formato Scf_Passenger_Special_luggage. Valores posibles "S" o "N". Longitud máxima 1.',
		'9387'     => 'Error en formato Scf_Passenger_Insurance_Trip. Valores posibles "S" o "N". Longitud máxima 1.',
		'9388'     => 'Error en formato Scf_Passenger_Type_Trip. Valores posibles "N" o "I". Longitud máxima 1.',
		'9389'     => 'Error en formato Scf_Passenger_Pet. Valores posibles "S" o "N". Longitud máxima 1.',
		'9390'     => 'Error en formato Scf_Order_Channel. Valores posibles "M"(móvil), "P"(PC) o "T"(Tablet)',
		'9391'     => 'Error en formato Scf_Order_Total_Products. Debe tener formato numérico y longitud máxima de 3.',
		'9392'     => 'Error en formato Scf_Order_Different_Products. Debe tener formato numérico y longitud máxima de 3.',
		'9393'     => 'Error en formato Scf_Order_Amount. Debe tener formato numérico y longitud máxima de 19.',
		'9394'     => 'Error en formato Scf_Order_Max_Amount. Debe tener formato numérico y longitud máxima de 19.',
		'9395'     => 'Error en formato Scf_Order_Coupon. Valores posibles "S" o "N"',
		'9396'     => 'Error en formato Scf_Order_Show_Type. Debe longitud máxima de 30.',
		'9397'     => 'Error en formato Scf_Wallet_Identifier',
		'9398'     => 'Error en formato Scf_Wallet_Client_Identifier',
		'9399'     => 'Error en formato Scf_Merchant_Ip_Address',
		'9400'     => 'Error en formato Scf_Merchant_Proxy',
		'9401'     => 'Error en formato Ds_Merchant_Mail_Phone_Number. Debe ser numérico y de longitud máxima 19',
		'9402'     => 'Error en llamada a SafetyPay para solicitar token url',
		'9403'     => 'Error en proceso de solicitud de token url a SafetyPay',
		'9404'     => 'Error en una petición a SafetyPay',
		'9405'     => 'Solicitud de token url denegada SAFETYPAY',
		'9406'     => 'Se tiene que poner en contacto con su entidad para que revisen la configuración del sector de actividad de su comercio',
		'9407'     => 'El importe de la operación supera el máximo permitido para realizar un pago de premio de apuesta(Gambling)',
		'9408'     => 'La tarjeta debe de haber operado durante el último año para poder realizar un pago de premio de apuesta (Gambling)',
		'9409'     => 'La tarjeta debe ser una Visa o MasterCard nacional para realizar un pago de premio de apuesta (Gambling)',
		'9410'     => 'Denegada por el emisor',
		'9411'     => 'Error en la configuración del comercio (Remitir a su entidad)',
		'9412'     => 'La firma no es correcta',
		'9413'     => 'Denegada, consulte con su entidad.',
		'9414'     => 'El plan de ventas no es correcto',
		'9415'     => 'El tipo de producto no es correcto',
		'9416'     => 'Importe no permitido en devolucion',
		'9417'     => 'Fecha de devolucion no permitida',
		'9418'     => 'No existe plan de ventas vigente',
		'9419'     => 'Tipo de cuenta no permitida',
		'9420'     => 'El comercio no dispone de formas de pago para esta operación',
		'9421'     => 'Tarjeta no permitida. No es producto Agro',
		'9422'     => 'Faltan datos para operacion Agro',
		'9423'     => 'CNPJ del comecio incorrecto',
		'9424'     => 'No se ha encontrado el establecimiento',
		'9425'     => 'No se ha encontrado la tarjeta',
		'9426'     => 'Enrutamiento no valido para el comercio',
		'9427'     => 'La conexion con CECA no ha sido posible',
		'9428'     => 'Operacion debito no segura',
		'9429'     => 'Error en la versión enviada por el comercio (Ds_SignatureVersion)',
		'9430'     => 'Error al decodificar el parámetro Ds_MerchantParameters',
		'9431'     => 'Error del objeto JSON que se envía codificado en el parámetro Ds_MerchantParameters',
		'9432'     => 'Error FUC del comercio erróneo',
		'9433'     => 'Error Terminal del comercio erróneo',
		'9434'     => 'Error ausencia de número de pedido en la op. del comercio',
		'9435'     => 'Error en el cálculo de la firma',
		'9436'     => 'Error en la construcción del elemento padre',
		'9437'     => 'Error en la construcción del elemento',
		'9438'     => 'Error en la construcción del elemento',
		'9439'     => 'Error en la construcción del elemento',
		'9440'     => 'Error genérico',
		'9441'     => 'Error no tenemos bancos para Mybank',
		'9442'     => 'Error genérico',
		'9443'     => 'No se permite pago con esta tarjeta',
		'9444'     => 'Se está intentando acceder usando firmas antiguas y el comercio está configurado como HMAC SHA256',
		'9445'     => 'Error genérico',
		'9446'     => 'Es obligatorio indicar la forma de pago',
		'9447'     => 'Error, se está utilizando una referencia que se generó con un adquirente distinto al adquirente que la utiliza.',
		'9448'     => 'El comercio no tiene el método de pago "Pago DINERS"',
		'9449'     => 'Tipo de pago de la operación no permitido para este tipo de tarjeta',
		'9450'     => 'Tipo de pago de la operación no permitido para este tipo de tarjeta',
		'9451'     => 'Tipo de pago de la operación no permitido para este tipo de tarjeta',
		'9453'     => 'No se permiten pagos con ese tipo de tarjeta',
		'9454'     => 'No se permiten pagos con ese tipo de tarjeta',
		'9455'     => 'No se permiten pagos con ese tipo de tarjeta',
		'9456'     => 'No tiene método de pago configurado (Consulte a su entidad)',
		'9457'     => 'Error, se aplica el método de pago "MasterCard SecureCode" con Respuesta [VEReq, VERes] = N con tarjeta MasterCard Comercial y el comercio no tiene el método de pago "MasterCard Comercial"',
		'9458'     => 'Error, se aplica el método de pago "MasterCard SecureCode" con Respuesta [VEReq, VERes] = U con tarjeta MasterCard Comercial y el comercio no tiene el método de pago "MasterCard Comercial"',
		'9459'     => 'No tiene método de pago configurado (Consulte a su entidad)',
		'9460'     => 'No tiene método de pago configurado (Consulte a su entidad)',
		'9461'     => 'No tiene método de pago configurado (Consulte a su entidad)',
		'9462'     => 'Metodo de pago no disponible para conexión HOST to HOST',
		'9463'     => 'Metodo de pago no permitido',
		'9464'     => 'El comercio no tiene el método de pago "MasterCard Comercial"',
		'9465'     => 'No tiene método de pago configurado (Consulte a su entidad)',
		'9466'     => 'La referencia que se está utilizando no existe.',
		'9467'     => 'La referencia que se está utilizando está dada de baja',
		'9468'     => 'Se está utilizando una referencia que se generó con un adquirente distinto al adquirente que la utiliza.',
		'9469'     => 'Error, no se ha superado el proceso de fraude MR',
		'9470'     => 'Error la solicitud del primer factor ha fallado.',
		'9471'     => 'Error en la URL de redirección de solicitud del primer factor.',
		'9472'     => 'Error al montar la petición de Autenticación de PPII.',
		'9473'     => 'Error la respuesta de la petición de Autenticación de PPII es nula.',
		'9474'     => 'Error el statusCode de la respuesta de la petición de Autenticación de PPII es nulo',
		'9475'     => 'Error el idOperación de la respuesta de la petición de Autenticación de PPII es nulo',
		'9476'     => 'Error tratando la respuesta de la Autenticación de PPII',
		'9477'     => 'Error se ha superado el tiempo definido entre el paso 1 y 2 de PPI',
		'9478'     => 'Error tratando la respuesta de la Autorización de PPII',
		'9479'     => 'Error la respuesta de la petición de Autorización de PPII es nula',
		'9480'     => 'Error el statusCode de la respuesta de la petición de Autorización de PPII es nulo.',
		'9481'     => 'Error, el comercio no es Payment Facilitator',
		'9482'     => 'Error el idOperación de la respuesta de una Autorización OK es nulo o no coincide con el idOp. de la Auth.',
		'9483'     => 'Error la respuesta de la petición de devolución de PPII es nula.',
		'9484'     => 'Error el statusCode o el idPetición de la respuesta de la petición de Devolución de PPII es nulo.',
		'9485'     => 'Error producido por la denegación de la devolución.',
		'9486'     => 'Error la respuesta de la petición de consulta de PPII es nula.',
		'9487'     => 'El comercio terminal no tiene habilitado el método de pago Paygold.',
		'9488'     => 'El comercio no tiene el método de pago "Pago MOTO/Manual" y la operación viene marcada como pago MOTO.',
		'9489'     => 'Error de datos. Operacion MPI Externo no permitida',
		'9490'     => 'Error de datos. Se reciben parametros MPI Redsys en operacion MPI Externo',
		'9491'     => 'Error de datos. SecLevel no permitido en operacion MPI Externo',
		'9492'     => 'Error de datos. Se reciben parametros MPI Externo en operacion MPI Redsys',
		'9493'     => 'Error de datos. Se reciben parametros de MPI en operacion no segura',
		'9494'     => 'FIRMA OBSOLETA',
		'9495'     => 'Configuración incorrecta ApplePay o AndroidPay',
		'9496'     => 'No tiene dado de alta el método de pago AndroidPay',
		'9497'     => 'No tiene dado de alta el método de pago ApplePay',
		'9498'     => 'moneda / importe de la operación de ApplePay no coinciden',
		'9499'     => 'Error obteniendo claves del comercio en Android/Apple Pay',
		'9500'     => 'Error en el DCC Dinámico, se ha modificado la tarjeta.',
		'9501'     => 'Error en La validación de datos enviados para genera el Id operación',
		'9502'     => 'Error al validar Id Oper',
		'9503'     => 'Error al validar el pedido',
		'9504'     => 'Error al validar tipo de transacción',
		'9505'     => 'Error al validar moneda',
		'9506'     => 'Error al validar el importe',
		'9507'     => 'Id Oper no tiene vigencia',
		'9508'     => 'Error al validar Id Oper',
		'9510'     => 'No se permite el envío de datos de tarjeta si se envía ID de operación',
		'9511'     => 'Error en la respuesta de consulta de BINES',
		'9515'     => 'El comercio tiene activado pago Amex en Perfil.',
		'9516'     => 'Error al montar el mensaje de China Union Pay',
		'9517'     => 'Error al establecer la clave para China Union Pay',
		'9518'     => 'Error al grabar los datos para pago China Union Pay',
		'9519'     => 'Mensaje de autenticación erróneo',
		'9520'     => 'El mensaje SecurePlus de sesión está vacío',
		'9521'     => 'El xml de respuesta viene vacío',
		'9522'     => 'No se han recibido parametros en datosentrada',
		'9523'     => 'La firma calculada no coincide con la recibida en la respuesta',
		'9524'     => 'el resultado de la autenticación 3DSecure MasterCard es PARes="A" o VERes="N" y no recibimos CAVV del emisor',
		'9525'     => 'No se puede utilizar la tarjeta privada en este comercio',
		'9526'     => 'La tarjeta no es china',
		'9527'     => 'Falta el parametro obligatorio DS_MERCHANT_BUYERID',
		'9528'     => 'Formato erróneo del parametro DS_MERCHANT_BUYERID en operación Sodexo Brasil',
		'9529'     => 'No se permite operación recurrente en pagos con tarjeta Voucher',
		'9530'     => 'La fecha de Anulación no puede superar en mas de 7 dias a la de Preautorización.',
		'9531'     => 'La fecha de Anulación no puede superar en mas de 72 horas a la de Preautorización diferida',
		'9532'     => 'La moneda de la petición no coincide con la devuelta',
		'9533'     => 'El importe de la petición no coincide con el devuelto',
		'9534'     => 'No se recibe recaudación emisora o referencia del recibo',
		'9535'     => 'Pago de tributo fuera de plazo',
		'9536'     => 'Tributo ya pagado',
		'9537'     => 'Pago de tributo denegado',
		'9538'     => 'Rechazo en el pago de tributo',
		'9539'     => 'Error en el envío de SMS',
		'9540'     => 'El móvil enviado es demasiado largo (más de 12 posiciones)',
		'9541'     => 'La referencia enviada es demasiada larga (más de 40 posiciones)',
		'9542'     => 'Error genérico. Consulte con Redsys',
		'9543'     => 'Error, la tarjeta de la operación es DINERS y el comercio no tiene el método de pago "Pago DINERS" o "Pago Discover No Seguro"',
		'9544'     => 'Error, la tarjeta de la operación es DINERS y el comercio no tiene el método de pago "Pago Discover No Seguro"',
		'9545'     => 'Error DISCOVER',
		'9546'     => 'Error DISCOVER',
		'9547'     => 'Error DISCOVER',
		'9548'     => 'Error DISCOVER',
		'9549'     => 'Error DISCOVER',
		'9550'     => 'ERROR en el gestor de envío de los SMS. Consulte con Redsys',
		'9551'     => 'ERROR en el proceso de autenticación.',
		'9552'     => 'ERROR el resultado de la autenticacion PARes = "U"',
		'9553'     => 'ERROR se ha intentado hacer un pago con el método de pago UPI y la tarjeta no es china',
		'9554'     => 'ERROR el resultado de la autenticacion para UPI es PARes = "U" y el comercio no tiene métodos de pago no seguros UPI EXPRESSPAY',
		'9555'     => 'ERROR la IP de conexión del módulo de administración no esta entre las permitidas.',
		'9556'     => 'Se envía pago Tradicional y el comercio no tiene pago Tradicional mundial ni Tradicional UE.',
		'9557'     => 'Se envía pago Tarjeta en Archivo y el comercio no tiene pago Tradicional mundial ni Tradicional UE.',
		'9558'     => 'ERROR, el formato de la fecha dsMerchantP2FExpiryDate es incorrecto',
		'9559'     => 'ERROR el id Operacion de la respuesta en la autenticación PPII es nulo o no se ha obtenido de la autenticación final',
		'9560'     => 'ERROR al enviar la notificacion de autenticacion al comercio',
		'9561'     => 'ERROR el idOperación de la respuesta de una confirmacion separada OK es nulo o no coincide con el idOp. de la Confirmacion.',
		'9562'     => 'ERROR la respuesta de la petición de confirmacion separada de PPII es nula.',
		'9563'     => 'ERROR tratando la respuesta de la confirmacion separada de PPII.',
		'9564'     => 'ERROR chequeando los importes de DCC antes del envío de la operación a Stratus.',
		'9565'     => 'Formato del importe del campo Ds_Merchant_Amount excede del límite permitido.',
		'9566'     => 'Error de acceso al nuevo Servidor Criptográfico.',
		'9567'     => 'ERROR se ha intentado hacer un pago con una tarjeta china UPI y el comercio no tiene método de pago UPI',
		'9568'     => 'Operacion de consulta de tarjeta rechazada, tipo de transacción erróneo',
		'9569'     => 'Operacion de consulta de tarjeta rechazada, no se ha informado la tarjeta',
		'9570'     => 'Operacion de consulta de tarjeta rechazada, se ha enviado tarjeta y referencia',
		'9571'     => 'Operacion de autenticacion rechazada, protocolVersion no indicado',
		'9572'     => 'Operacion de autenticacion rechazada, protocolVersion no reconocido',
		'9573'     => 'Operacion de autenticacion rechazada, browserAcceptHeader no indicado',
		'9574'     => 'Operacion de autenticacion rechazada, browserUserAgent no indicado',
		'9575'     => 'Operacion de autenticacion rechazada, browserJavaEnabled no indicado',
		'9576'     => 'Operacion de autenticacion rechazada, browserLanguage no indicado',
		'9577'     => 'Operacion de autenticacion rechazada, browserColorDepth no indicado',
		'9578'     => 'Operacion de autenticacion rechazada, browserScreenHeight no indicado',
		'9579'     => 'Operacion de autenticacion rechazada, browserScreenWidth no indicado',
		'9580'     => 'Operacion de autenticacion rechazada, browserTZ no indicado',
		'9581'     => 'Operacion de autenticacion rechazada, datos DS_MERCHANT_EMV3DS no está indicado o es demasiado grande y no se puede convertir en JSON',
		'9582'     => 'Operacion de autenticacion rechazada, threeDSServerTransID no indicado',
		'9583'     => 'Operacion de autenticacion rechazada, threeDSCompInd no indicado',
		'9584'     => 'Operacion de autenticacion rechazada, notificationURL no indicado',
		'9585'     => 'Operacion de autenticacion EMV3DS rechazada, no existen datos en la BBDD',
		'9586'     => 'Operacion de autenticacion rechazada, PARes no indicado',
		'9587'     => 'Operacion de autenticacion rechazada, MD no indicado',
		'9588'     => 'Operacion de autenticacion rechazada, la versión no coincide entre los mensajes AuthenticationData y ChallengeResponse',
		'9589'     => 'Operacion de autenticacion rechazada, respuesta sin CRes',
		'9590'     => 'Operacion de autenticacion rechazada, error al desmontar la respuesta CRes',
		'9591'     => 'Operacion de autenticacion rechazada, error la respuesta CRes viene sin threeDSServerTransID',
		'9592'     => 'Operacion de autenticacion rechazada, error el transStatus del CRes no coincide con el transStatus de la consulta final de la operación',
		'9593'     => 'Operacion de autenticacion rechazada, error el transStatus de la consulta final de la operación no está definido',
		'9594'     => 'Operacion de autenticacion rechazada, CRes no indicado',
		'9595'     => 'El comercio indicado no tiene métodos de pago seguros permitidos en 3DSecure V2',
		'9596'     => 'Operacion de consulta de tarjeta rechazada,moneda errónea',
		'9597'     => 'Operacion de consulta de tarjeta rechazada,importe erróneo',
		'9598'     => 'Autenticación 3DSecure v2 errónea, y no se permite hacer fallback a 3DSecure v1',
		'9599'     => 'Error en el proceso de autenticación 3DSecure v2',
		'9600'     => 'Error en el proceso de autenticación 3DSecure v2 - Respuesta Areq N',
		'9601'     => 'Error en el proceso de autenticación 3DSecure v2 - Respuesta Areq R',
		'9602'     => 'Error en el proceso de autenticación 3DSecure v2 - Respuesta Areq U y el comercio no tiene método de pago U',
		'9603'     => 'Error en el parámetro DS_MERCHANT_DCC de DCC enviado en operacion H2H (REST y SOAP)',
		'9604'     => 'Error en los datos de DCC enviados en el parámetro DS_MERCHANT_DCC en operacion H2H (REST y SOAP)',
		'9605'     => 'Error en el parámetro DS_MERCHANT_MPIEXTERNAL enviado en operacion H2H (REST y SOAP)',
		'9606'     => 'Error en los datos de MPI enviados en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP)',
		'9607'     => 'Error del parámetro TXID de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'9608'     => 'Error del parámetro CAVV de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'9609'     => 'Error del parámetro ECI de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'9610'     => 'Error del parámetro threeDSServerTransID de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'9611'     => 'Error del parámetro dsTransID de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'9612'     => 'Error del parámetro authenticacionValue de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'9613'     => 'Error del parámetro protocolVersion de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'9614'     => 'Error del parámetro Eci de MPI enviado en el parámetro DS_MERCHANT_MPIEXTERNAL en operacion H2H (REST y SOAP) es erróneo',
		'9615'     => 'Error en MPI Externo, marca de tarjeta no permitida en SIS para MPI Externo',
		'9616'     => 'Error del parámetro DS_MERCHANT_EXCEP_SCA tiene un valor erróneo',
		'9617'     => 'Error del parámetro DS_MERCHANT_EXCEP_SCA es de tipo MIT y no vienen datos de COF o de pago por referencia',
		'9618'     => 'Error la exención enviada no está permitida y el comercio no está preparado para autenticar',
		'9619'     => 'Se recibe orderReferenceId de Amazon y no está el método de pago configurado',
		'9620'     => 'Error la operación de DCC tiene asociado un markUp más alto del permitido, se borran los datos de DCC',
		'9621'     => 'El amazonOrderReferenceId no es válido',
		'9622'     => 'Error la operación original se hizo sin marca de Nuevo modelo DCC y el comercio está configurado como Nuevo Modelo DCC',
		'9623'     => 'Error la operación original se hizo con marca de Nuevo modelo DCC y el comercio no está configurado como Nuevo Modelo DCC',
		'9624'     => 'Error la operación original se hizo con marca de Nuevo modelo DCC pero su valor difiere del modelo configurado en el comercio',
		'9625'     => 'Error en la anulación del pago, porque ya existe una devolución asociada a ese pago',
		'9626'     => 'Error en la devolución del pago, ya existe una anulación de la operación que se desea devolver',
		'9627'     => 'El número de referencia o solicitud enviada por CRTM no válida.',
		'9628'     => 'Error la operación de viene con datos de 3DSecure y viene por la entrada SERMEPA',
		'9629'     => 'Error no existe la operación de confirmación separada sobre la que realizar la anulación',
		'9630'     => 'Error en la anulación de confirmación separada, ya existe una devolución asociada a la confirmación separada',
		'9631'     => 'Error en la anulación de confirmación separada, ya existe una anulación asociada a la confirmación separada',
		'9632'     => 'Error la confirmacion separada sobre la que se desea anular no está autorizada',
		'9633'     => 'La fecha de Anulación no puede superar en los días configurados a la confirmacion separada.',
		'9634'     => 'Error no existe la operación de pago sobre la que realizar la anulación',
		'9635'     => 'Error en la anulación del pago, ya existe una anulación asociada al pago',
		'9636'     => 'Error el pago que se desea anular no está autorizado',
		'9637'     => 'La fecha de Anulación no puede superar en los días configurados al pago.',
		'9638'     => 'Error existe más de una devolución que se quiere anular y no se ha especificado cual.',
		'9639'     => 'Error no existe la operación de devolución sobre la que realizar la anulación',
		'9640'     => 'Error la confirmacion separada sobre la que se desea anular no está autorizada o ya está anulada',
		'9641'     => 'La fecha de Anulación no puede superar en los días configurados a la devolución.',
		'9642'     => 'La fecha de la preautorización que se desea reemplazar no puede superar los 30 días de antigüedad',
		'9643'     => 'Error al obtener la personalización del comercio',
		'9644'     => 'Error en el proceso de autenticación 3DSecure v2 - Se envían datos de la entrada IniciaPetición a la entrada TrataPetición',
		'9645'     => 'Unknown',
		'9646'     => 'Unknown',
		'9647'     => 'Unknown',
		'9648'     => 'Unknown',
		'9649'     => 'Unknown',
		'9650'     => 'Error, la MAC no es correcta en la mensajeria de pago de tributos',
		'9651'     => 'Error la exención exige SCA y el comercio no está preparado para autenticar',
		'9652'     => 'Error la exención y la configuración del comercio exigen no SCA y el comercio no está configurado para autorizar con dicha marca de tarjeta',
		'9653'     => 'Operacion de autenticacion rechazada, browserJavascriptEnabled no indicado',
		'9654'     => 'Error, se indican datos de 3RI en Inicia Petición y la versión que se envía en el trataPetición no es 2.2',
		'9655'     => 'Error, se indican un valor de Ds_Merchant_3RI_Ind no permitido',
		'9656'     => 'Error, se indican un valor Ds_Merchant_3RI_Ind diferentes en el Inicia Petición y en el trataPetición',
		'9657'     => 'Error, se indican datos de 3RI pero están incompletos',
		'9658'     => 'Error, el parámetro threeRITrasactionID es erróneo o no se encuentran datos de operación original',
		'9659'     => 'Error, los datos de FUC y Terminal obtenidos del threeRITrasactionID no corresponden al comercio que envía la operación',
		'9660'     => '3RI',
		'9661'     => '3RI',
		'9662'     => 'Error, el comercio no está entre los permitidos para realizar confirmaciones parciales.',
		'9663'     => 'No existe datos de Inicia Petición que concuerden con los enviados por el comercio en el mensaje Trata Petición',
		'9664'     => 'No se envía el elemento Id Transaccion 3DS Server en el mensaje Trata Petición y dicho elemento existe en el mensaje Inicia Petición',
		'9665'     => 'La moneda indicada por el comercio en el mensaje Trata Petición no corresponde con la enviada en el mensaje Inicia Petición',
		'9666'     => 'El importe indicado por el comercio en el mensaje Trata Petición no corresponde con el enviado en el mensaje Inicia Petición',
		'9667'     => 'El tipo de operación indicado por el comercio en el mensaje Trata Petición no corresponde con el enviado en el mensaje Inicia Petición',
		'9668'     => 'La referencia indicada por el comercio en el mensaje Trata Petición no corresponde con la enviada en el mensaje Inicia Petición',
		'9669'     => 'El Id Oper Insite indicado por el comercio en el mensaje Trata Petición no corresponde con el enviado en el mensaje Inicia Petición',
		'9670'     => 'La tarjeta indicada por el comercio en el mensaje Trata Petición no corresponde con la enviada en el mensaje Inicia Petición',
		'9671'     => 'Denegación por TRA Lynx',
		'9672'     => 'Bizum. Fallo en la autenticación. Bloqueo tras tres intentos.',
		'9673'     => 'Bizum. Operación cancelada. El usuario no desea seguir.',
		'9674'     => 'Bizum. Abono rechazado por beneficiario.',
		'9675'     => 'Bizum. Cargo rechazado por ordenante.',
		'9676'     => 'Bizum. El procesador rechaza la operación.',
		'9677'     => 'Bizum. Saldo disponible insuficiente.',
		'9678'     => 'La versión de 3DSecure indicada en el Trata Petición es errónea o es superior a la devuelva en el inicia petición',
		'9681'     => 'Error al insertar los datos de autenticación en una operación con MPI Externo',
		'9682'     => 'Error la operación es de tipo Consulta de TRA y el parámetro Ds_Merchant_TRA_Data es erróneo',
		'9683'     => 'Error la operación es de tipo Consulta de TRA Fase 1 y falta el parámetro Ds_Merchant_TRA_Type',
		'9684'     => 'Error la operación es de tipo Consulta de TRA Fase 1 y el parámetro Ds_Merchant_TRA_Type tiene un valor no permitido',
		'9685'     => 'Error la operación es de tipo Consulta de TRA Fase 1 y el perfil del comercio no le permite exención TRA',
		'9686'     => 'Error la operación es de tipo Consulta de TRA Fase 1 y la confifguración del comercio no le permite usar el TRA de Redsys',
		'9687'     => 'Error la operación es de tipo Consulta de TRA Fase 2 y falta el parámetro Ds_Merchant_TRA_Result o tiene un valor no permitido',
		'9688'     => 'Error la operación es de tipo Consulta de TRA Fase 2 y falta el parámetro Ds_Merchant_TRA_Method o tiene un valor erróneo',
		'9689'     => 'Error la operación es de tipo Consulta de TRA Fase 2, no existe una operación concreta de Fase 1',
		'9690'     => 'Error la operación es de tipo Consulta de TRA Fase 2 y obtenemos un error en la respuesta de Lynx',
		'9691'     => 'Se envían datos SamsungPay y el comercio no tiene dado de alta el método de pago SamsungPay',
		'9692'     => 'Se envía petición con firma de PSP y el comercio no tiene asociado un PSP.',
		'9693'     => 'No se han obtenido correctamente los datos enviados por SamsungPay.',
		'9694'     => 'No ha podido realizarse el pago con SamsungPay',
		'9700'     => 'PayPal a devuelto un KO',
		'9801'     => 'Denegada por iUPAY',
		'9899'     => 'No están correctamente firmados los datos que nos envían en el Ds_Merchant_Data.',
		'9900'     => 'SafetyPay ha devuelto un KO',
		'9909'     => 'Error interno',
		'9912'     => 'Emisor no disponible',
		'9913'     => 'Excepción en el envío SOAP de la notificacion',
		'9914'     => 'Respuesta KO en el envío SOAP de la notificacion',
		'9915'     => 'Cancelado por el titular',
		'9928'     => 'El titular ha cancelado la preautorización',
		'9929'     => 'El titular ha cancelado la operación',
		'9930'     => 'La transferencia está pendiente',
		'9931'     => 'Consulte con su entidad',
		'9932'     => 'Denegada por Fraude (LINX)',
		'9933'     => 'Denegada por Fraude (LINX)',
		'9934'     => 'Denegada ( Consulte con su entidad)',
		'9935'     => 'Denegada ( Consulte con su entidad)',
		'9966'     => 'BIZUM ha devuelto un KO en la autorización',
		'9992'     => 'Solicitud de PAE',
		'9994'     => 'No ha seleccionado ninguna tarjeta de la cartera.',
		'9995'     => 'Recarga de prepago denegada',
		'9996'     => 'No permite la recarga de tarjeta prepago',
		'9997'     => 'Con una misma tarjeta hay varios pagos en "vuelo" en el momento que se finaliza uno el resto se deniegan con este código. Esta restricción se realiza por seguridad.',
		'9998'     => 'Operación en proceso de solicitud de datos de tarjeta',
		'9999'     => 'Operación que ha sido redirigida al emisor a autenticar',
		'101'      => 'Tarjeta caducada',
		'106'      => 'Tarjeta bloqueada, exceso de pin erróneo',
		'129'      => 'Código de seguridad CVV incorrecto.',
		'180'      => 'Denegación emisor',
		'184'      => 'el cliente de la operación no se ha autenticado',
		'190'      => 'Denegación emisor',
		'904'      => 'Problema con la configuración de su comercio. Dirigirse a la entidad.',
		'915'      => 'El titular ha cancelado la operación de pago.',
		'BIZ00000' => 'Operación realizada correctamente.',
		'BIZ00001' => 'Parámetro de entrada obligatorio no completado.',
		'BIZ00002' => 'El formato de algún parámetro es incorrecto.',
		'BIZ00003' => 'No se encontró el elemento.',
		'BIZ00005' => 'Error interno del sistema.',
		'BIZ00006' => 'Error de seguridad 3DES o MAC X9.19',
		'BIZ00007' => 'Operación no permitida.',
		'BIZ00008' => 'Beneficiario no encontrado.',
		'BIZ00009' => 'Ordenante no encontrado.',
		'BIZ00202' => 'Funcionalidad aún no implementada.',
		'BIZ00213' => 'Error de autenticación en la petición recibida. Fallo en secuencia de seguridad.',
		'BIZ00224' => 'La respuesta de la entidad a la autenticación por RTP es KO.',
		'BIZ00225' => 'La autenticación por request to pay no ha finalizado con éxito.',
	);
}
