<?php
/*
 * Plugin Name: WooCommerce Sage Payments USA Gateway
 * Plugin URI: http://woothemes.com/woocommerce
 * Description: Extends WooCommerce. Provides Sage Payment Solutions API payment gateway.
 * Version: 3.1.0
 * Author: Andrew Benbow
 * Author URI: http://www.chromeorange.co.uk
 * Developer: Andrew Benbow
 * Developer URI: http://www.chromeorange.co.uk
 * Text Domain: woocommerce-spusa
 * Domain Path: /languages
 * WC requires at least: 2.6.0
 * WC tested up to: 3.3.0
 * Woo: 201957:6b04e48d7f0d2dc52abce05a118af09d
 *
 * Copyright: © 2017 Andrew Benbow (email : support@chromeorange.co.uk)
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

/*  
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 3, as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

    /**
     * Required functions
     */
    if ( ! function_exists( 'woothemes_queue_update' ) )
        require_once( 'woo-includes/woo-functions.php' );

    /**
     * Plugin updates
     */
    woothemes_queue_update( plugin_basename( __FILE__ ), '6b04e48d7f0d2dc52abce05a118af09d', '201957' );

    /**
     * Localization
     */
	load_plugin_textdomain( 'SPUSALANGUAGE', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

	/**
     * Defines
     */
	define( 'SPUSAVERSION' 		, '3.1.0' );
    define( 'SPUSASETTINGS'     , admin_url( 'admin.php?page=wc-settings&tab=checkout&section=wc_gateway_sagepaymentusa_api' ) );
	define( 'SPUSALANGUAGE'		, 'woocommerce-spusa' );
	define( 'SPUSASUPPORTURL' 	, 'http://support.woothemes.com/' );
	define( 'SPUSADOCSURL' 		, 'http://docs.woothemes.com/document/sage-payments-usa/');
    define( 'SPUSAPLUGINPATH'   , plugin_dir_path( __FILE__ ) );
    define( 'SPUSAPLUGINURL'    , plugin_dir_url( __FILE__ ) );

	/**
	 * Init Sage Payment Solutions after WooCommerce has loaded
	 */
	add_action( 'plugins_loaded', 'init_sagepaymentusa_gateway', 0 );

	function init_sagepaymentusa_gateway() {

    if ( ! class_exists( 'WC_Payment_Gateway' ) )
    	return;

        /**
         * Load Admin Class
         * Used for plugin links.
         */
        class WC_Gateway_SageUSA_admin {

            public function __construct() {

                add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), array( $this,'plugin_links' ) );

                // Enqueue Admin Scripts and CSS
                add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ), 99 );

            }

            /**
             * Plugin page links
             */
            function plugin_links( $links ) {

                $plugin_links = array(
                    '<a href="' . SPUSASETTINGS . '">' . __( 'Settings', 'woocommerce-spusa' ) . '</a>',
                    '<a href="' . SPUSASUPPORTURL . '">' . __( 'Support', 'woocommerce-spusa' ) . '</a>',
                    '<a href="' . SPUSADOCSURL . '">' . __( 'Docs', 'woocommerce-spusa' ) . '</a>',
                );

                return array_merge( $plugin_links, $links );
            }

            /**
             * Load admin CSS
             * @param  [type] $hook [description]
             * @return void
             */
            function admin_scripts( $hook ) {
                wp_enqueue_style( 'sagepayments-admin-wp', SPUSAPLUGINURL . 'assets/css/admin-css.css' , array(), SPUSAVERSION );
            }

        }

		if ( is_admin() ) :
			$GLOBALS['WC_Gateway_SageUSA_admin'] = new WC_Gateway_SageUSA_admin();
		endif;

		/**
		 * Include the gateway classes
		 */
		 include('classes/sagepaymentsapi.php');
         include('classes/sagepaymentsapi-addons.php');

    	/**
    	 * add_sagepaymentsapi_gateway function.
    	 *
    	 * @access public
    	 * @param mixed $methods
    	 * @return void
    	 */
    	function add_sagepaymentsapi_gateway($methods) {
            if ( class_exists( 'WC_Subscriptions_Order' ) ) {
                $methods[] = 'WC_Gateway_SagePaymentUSA_API_AddOns';
            } else {
                $methods[] = 'WC_Gateway_SagePaymentUSA_API';
            }
            return $methods;
    	}

    	add_filter( 'woocommerce_payment_gateways', 'add_sagepaymentsapi_gateway' );

        // Add 'Capture Authorised Payment' to WooCommerce Order Actions
        add_filter( 'woocommerce_order_actions', 'sagepayments_woocommerce_order_actions' );

        /**
         * [sagepayments_woocommerce_order_actions description]
         * Add Capture option to the Order Actions dropdown.
         */
        function sagepayments_woocommerce_order_actions( $orderactions ) {
            global $post;
            $id     = $post->ID;
            $order  = new WC_Order( $id );

            // $payment_status = get_post_meta( $id, '_SagePaymentsPaymentStatus', TRUE );

            // if( isset($payment_status) && ( $payment_status === 'AUTHENTICATED' || $payment_status === 'REGISTERED' ) ) {
            // wp_mail( 'andrew@chromeorange.co.uk', 'Order Status ' . $order->get_status(), 'hello' );
            if ( $order->get_status() === 'authorized' ) {
                $orderactions['sage_process_payment'] = 'Capture Authorised Payment';
            }

            return $orderactions;
        }

        add_action( 'init', 'sagepayments_register_order_status' );
        /**
         * New order status for WooCommerce 2.2 or later
         *
         * @return void
         */
        function sagepayments_register_order_status() {
            register_post_status( 'wc-authorized', array(
                'label'                     => _x( 'Authorized Payments', 'Order status', 'woocommerce-spusa' ),
                'public'                    => true,
                'exclude_from_search'       => false,
                'show_in_admin_all_list'    => true,
                'show_in_admin_status_list' => true,
                'label_count'               => _n_noop( 'Authorized, not captured <span class="count">(%s)</span>', 'Authorized, not captured <span class="count">(%s)</span>', 'woocommerce-spusa' )
            ) );
        }

        add_filter( 'wc_order_statuses', 'sagepayments_order_statuses' );
        /**
         * Set wc-authorized in WooCommerce order statuses.
         *
         * @param  array $order_statuses
         * @return array
         */
        function sagepayments_order_statuses( $order_statuses ) {
            $order_statuses['wc-authorized'] = _x( 'Authorized', 'Order status', 'woocommerce-spusa' );

            return $order_statuses;
        }

        add_action( 'woocommerce_email_customer_details', 'sage_woocommerce_email_customer_details', 99, 2 );

        function sage_woocommerce_email_customer_details ( $order, $sent_to_admin = false ) {

            // WC 3.0 compatibility
            $payment_method = is_callable( array( $order, 'get_payment_method' ) ) ? $order->get_payment_method() : $order->payment_method;

            // Get settings
            $woocommerce_sagepaymentsusaapi_settings = get_option( 'woocommerce_sagepaymentsusaapi_settings' );

            // sagepaytransinfo
            $sagepaytransinfo   =  'no';
            if( isset($woocommerce_sagepaymentsusaapi_settings['sagepaymenttransinfo']) ) {
                $sagepaytransinfo   = $woocommerce_sagepaymentsusaapi_settings['sagepaymenttransinfo'];
            }

            if ( $payment_method === 'sagepaymentsusaapi' && $sagepaytransinfo === 'yes' ) {

                $sageresult = version_compare( WC_VERSION, '3.0', '<' ) ? get_post_meta( $order->id, '_sageresult' ) : $order->get_meta( '_sageresult', true );

                $sageresult_output = '';

                if( isset( $sageresult ) && $sageresult !== '' && $sent_to_admin ) {

                    $sageresult_output = '<h3>Sage Transaction Details</h3>';

                    foreach ( $sageresult as $key => $value ) {
                        $sageresult_output .= $key . ' : ' . $value . "\r\n" . "<br />";
                    }

                    echo $sageresult_output;

                }

            }

        }

	} // EOF init_sagepaymentusa_gateway