<?php
/**
 * WooCommerce USA ePay Gateway
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@skyverge.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade WooCommerce USA ePay Gateway to newer
 * versions in the future. If you wish to customize WooCommerce USA ePay Gateway for your
 * needs please refer to http://docs.woocommerce.com/document/usa-epay/
 *
 * @author    SkyVerge
 * @copyright Copyright (c) 2014-2020, SkyVerge, Inc. (info@skyverge.com)
 * @license   http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 */

namespace SkyVerge\WooCommerce\USAePay\API;

use SkyVerge\WooCommerce\PluginFramework\v5_10_2 as Framework;

defined( 'ABSPATH' ) or exit;

/**
 * The USA ePay API message helper class.
 *
 * @since 2.0.0
 */
class Message_Helper extends Framework\SV_WC_Payment_Gateway_API_Response_Message_Helper {


	/** @var array known message IDs */
	protected $message_ids = array(

		// card number
		'card_number_invalid' => array( '11', '12', '13', '14', '89406' ),

		// CSC & AVS
		'csc_invalid'  => array( '10116', '10282', '64697' ),
		'csc_mismatch' => array( '10297' ),
		'avs_mismatch' => array( '34', '2034' ),

		// expiration
		'card_expired'        => array( '17' ),
		'card_expiry_invalid' => array( '15', '16', '85', '10005', '40452', '65205', '89154' ),

		// general declines
		'card_type_not_accepted' => array( '91', '92', '10003', '10004', '10006', '30001', '30003', '30004', '70013' ),
		'insufficient_funds'     => array( '203', '303', '10151', '10251', '50051', '57852', '78852' ),
		'card_declined'          => array( '10127', '10139', '15000', '15100', '50127', '64702', '64757', '65200' ),
	);


	/**
	 * Gets the message from a response error code.
	 *
	 * @since 2.0.0
	 *
	 * @param string $error_code a response error code
	 * @return string customer-friendly message
	 */
	public function get_message( $error_code ) {

		$message_id = 'error';

		foreach( $this->message_ids as $error_id => $statuses ) {

			if ( in_array( (string) $error_code, $statuses, true ) ) {

				$message_id = $error_id;
				break;
			}
		}

		return $this->get_user_message( $message_id );
	}


}
