<?php
/**
 * Internationalization: States
 *
 * Taken from simple-pay: https://raw.githubusercontent.com/woocommerce/woocommerce/trunk/plugins/woocommerce/i18n/states.php
 *
 * @package SimplePay\Core
 * @copyright Copyright (c) 2022, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 4.6.0
 */

namespace SimplePay\Core\i18n;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

return array(
	'AF' => array(),
	'AL' => array( // Albanian states.
		'AL-01' => __( 'Berat', 'simple-pay' ),
		'AL-09' => __( 'Dibër', 'simple-pay' ),
		'AL-02' => __( 'Durrës', 'simple-pay' ),
		'AL-03' => __( 'Elbasan', 'simple-pay' ),
		'AL-04' => __( 'Fier', 'simple-pay' ),
		'AL-05' => __( 'Gjirokastër', 'simple-pay' ),
		'AL-06' => __( 'Korçë', 'simple-pay' ),
		'AL-07' => __( 'Kukës', 'simple-pay' ),
		'AL-08' => __( 'Lezhë', 'simple-pay' ),
		'AL-10' => __( 'Shkodër', 'simple-pay' ),
		'AL-11' => __( 'Tirana', 'simple-pay' ),
		'AL-12' => __( 'Vlorë', 'simple-pay' ),
	),
	'AO' => array( // Angolan states.
		'BGO' => __( 'Bengo', 'simple-pay' ),
		'BLU' => __( 'Benguela', 'simple-pay' ),
		'BIE' => __( 'Bié', 'simple-pay' ),
		'CAB' => __( 'Cabinda', 'simple-pay' ),
		'CNN' => __( 'Cunene', 'simple-pay' ),
		'HUA' => __( 'Huambo', 'simple-pay' ),
		'HUI' => __( 'Huíla', 'simple-pay' ),
		'CCU' => __( 'Kuando Kubango', 'simple-pay' ),
		'CNO' => __( 'Kwanza-Norte', 'simple-pay' ),
		'CUS' => __( 'Kwanza-Sul', 'simple-pay' ),
		'LUA' => __( 'Luanda', 'simple-pay' ),
		'LNO' => __( 'Lunda-Norte', 'simple-pay' ),
		'LSU' => __( 'Lunda-Sul', 'simple-pay' ),
		'MAL' => __( 'Malanje', 'simple-pay' ),
		'MOX' => __( 'Moxico', 'simple-pay' ),
		'NAM' => __( 'Namibe', 'simple-pay' ),
		'UIG' => __( 'Uíge', 'simple-pay' ),
		'ZAI' => __( 'Zaire', 'simple-pay' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'simple-pay' ),
		'B' => __( 'Buenos Aires', 'simple-pay' ),
		'K' => __( 'Catamarca', 'simple-pay' ),
		'H' => __( 'Chaco', 'simple-pay' ),
		'U' => __( 'Chubut', 'simple-pay' ),
		'X' => __( 'Córdoba', 'simple-pay' ),
		'W' => __( 'Corrientes', 'simple-pay' ),
		'E' => __( 'Entre Ríos', 'simple-pay' ),
		'P' => __( 'Formosa', 'simple-pay' ),
		'Y' => __( 'Jujuy', 'simple-pay' ),
		'L' => __( 'La Pampa', 'simple-pay' ),
		'F' => __( 'La Rioja', 'simple-pay' ),
		'M' => __( 'Mendoza', 'simple-pay' ),
		'N' => __( 'Misiones', 'simple-pay' ),
		'Q' => __( 'Neuquén', 'simple-pay' ),
		'R' => __( 'Río Negro', 'simple-pay' ),
		'A' => __( 'Salta', 'simple-pay' ),
		'J' => __( 'San Juan', 'simple-pay' ),
		'D' => __( 'San Luis', 'simple-pay' ),
		'Z' => __( 'Santa Cruz', 'simple-pay' ),
		'S' => __( 'Santa Fe', 'simple-pay' ),
		'G' => __( 'Santiago del Estero', 'simple-pay' ),
		'V' => __( 'Tierra del Fuego', 'simple-pay' ),
		'T' => __( 'Tucumán', 'simple-pay' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'simple-pay' ),
		'NSW' => __( 'New South Wales', 'simple-pay' ),
		'NT'  => __( 'Northern Territory', 'simple-pay' ),
		'QLD' => __( 'Queensland', 'simple-pay' ),
		'SA'  => __( 'South Australia', 'simple-pay' ),
		'TAS' => __( 'Tasmania', 'simple-pay' ),
		'VIC' => __( 'Victoria', 'simple-pay' ),
		'WA'  => __( 'Western Australia', 'simple-pay' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi districts.
		'BD-05' => __( 'Bagerhat', 'simple-pay' ),
		'BD-01' => __( 'Bandarban', 'simple-pay' ),
		'BD-02' => __( 'Barguna', 'simple-pay' ),
		'BD-06' => __( 'Barishal', 'simple-pay' ),
		'BD-07' => __( 'Bhola', 'simple-pay' ),
		'BD-03' => __( 'Bogura', 'simple-pay' ),
		'BD-04' => __( 'Brahmanbaria', 'simple-pay' ),
		'BD-09' => __( 'Chandpur', 'simple-pay' ),
		'BD-10' => __( 'Chattogram', 'simple-pay' ),
		'BD-12' => __( 'Chuadanga', 'simple-pay' ),
		'BD-11' => __( "Cox's Bazar", 'simple-pay' ),
		'BD-08' => __( 'Cumilla', 'simple-pay' ),
		'BD-13' => __( 'Dhaka', 'simple-pay' ),
		'BD-14' => __( 'Dinajpur', 'simple-pay' ),
		'BD-15' => __( 'Faridpur ', 'simple-pay' ),
		'BD-16' => __( 'Feni', 'simple-pay' ),
		'BD-19' => __( 'Gaibandha', 'simple-pay' ),
		'BD-18' => __( 'Gazipur', 'simple-pay' ),
		'BD-17' => __( 'Gopalganj', 'simple-pay' ),
		'BD-20' => __( 'Habiganj', 'simple-pay' ),
		'BD-21' => __( 'Jamalpur', 'simple-pay' ),
		'BD-22' => __( 'Jashore', 'simple-pay' ),
		'BD-25' => __( 'Jhalokati', 'simple-pay' ),
		'BD-23' => __( 'Jhenaidah', 'simple-pay' ),
		'BD-24' => __( 'Joypurhat', 'simple-pay' ),
		'BD-29' => __( 'Khagrachhari', 'simple-pay' ),
		'BD-27' => __( 'Khulna', 'simple-pay' ),
		'BD-26' => __( 'Kishoreganj', 'simple-pay' ),
		'BD-28' => __( 'Kurigram', 'simple-pay' ),
		'BD-30' => __( 'Kushtia', 'simple-pay' ),
		'BD-31' => __( 'Lakshmipur', 'simple-pay' ),
		'BD-32' => __( 'Lalmonirhat', 'simple-pay' ),
		'BD-36' => __( 'Madaripur', 'simple-pay' ),
		'BD-37' => __( 'Magura', 'simple-pay' ),
		'BD-33' => __( 'Manikganj ', 'simple-pay' ),
		'BD-39' => __( 'Meherpur', 'simple-pay' ),
		'BD-38' => __( 'Moulvibazar', 'simple-pay' ),
		'BD-35' => __( 'Munshiganj', 'simple-pay' ),
		'BD-34' => __( 'Mymensingh', 'simple-pay' ),
		'BD-48' => __( 'Naogaon', 'simple-pay' ),
		'BD-43' => __( 'Narail', 'simple-pay' ),
		'BD-40' => __( 'Narayanganj', 'simple-pay' ),
		'BD-42' => __( 'Narsingdi', 'simple-pay' ),
		'BD-44' => __( 'Natore', 'simple-pay' ),
		'BD-45' => __( 'Nawabganj', 'simple-pay' ),
		'BD-41' => __( 'Netrakona', 'simple-pay' ),
		'BD-46' => __( 'Nilphamari', 'simple-pay' ),
		'BD-47' => __( 'Noakhali', 'simple-pay' ),
		'BD-49' => __( 'Pabna', 'simple-pay' ),
		'BD-52' => __( 'Panchagarh', 'simple-pay' ),
		'BD-51' => __( 'Patuakhali', 'simple-pay' ),
		'BD-50' => __( 'Pirojpur', 'simple-pay' ),
		'BD-53' => __( 'Rajbari', 'simple-pay' ),
		'BD-54' => __( 'Rajshahi', 'simple-pay' ),
		'BD-56' => __( 'Rangamati', 'simple-pay' ),
		'BD-55' => __( 'Rangpur', 'simple-pay' ),
		'BD-58' => __( 'Satkhira', 'simple-pay' ),
		'BD-62' => __( 'Shariatpur', 'simple-pay' ),
		'BD-57' => __( 'Sherpur', 'simple-pay' ),
		'BD-59' => __( 'Sirajganj', 'simple-pay' ),
		'BD-61' => __( 'Sunamganj', 'simple-pay' ),
		'BD-60' => __( 'Sylhet', 'simple-pay' ),
		'BD-63' => __( 'Tangail', 'simple-pay' ),
		'BD-64' => __( 'Thakurgaon', 'simple-pay' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'simple-pay' ),
		'BG-02' => __( 'Burgas', 'simple-pay' ),
		'BG-08' => __( 'Dobrich', 'simple-pay' ),
		'BG-07' => __( 'Gabrovo', 'simple-pay' ),
		'BG-26' => __( 'Haskovo', 'simple-pay' ),
		'BG-09' => __( 'Kardzhali', 'simple-pay' ),
		'BG-10' => __( 'Kyustendil', 'simple-pay' ),
		'BG-11' => __( 'Lovech', 'simple-pay' ),
		'BG-12' => __( 'Montana', 'simple-pay' ),
		'BG-13' => __( 'Pazardzhik', 'simple-pay' ),
		'BG-14' => __( 'Pernik', 'simple-pay' ),
		'BG-15' => __( 'Pleven', 'simple-pay' ),
		'BG-16' => __( 'Plovdiv', 'simple-pay' ),
		'BG-17' => __( 'Razgrad', 'simple-pay' ),
		'BG-18' => __( 'Ruse', 'simple-pay' ),
		'BG-27' => __( 'Shumen', 'simple-pay' ),
		'BG-19' => __( 'Silistra', 'simple-pay' ),
		'BG-20' => __( 'Sliven', 'simple-pay' ),
		'BG-21' => __( 'Smolyan', 'simple-pay' ),
		'BG-23' => __( 'Sofia District', 'simple-pay' ),
		'BG-22' => __( 'Sofia', 'simple-pay' ),
		'BG-24' => __( 'Stara Zagora', 'simple-pay' ),
		'BG-25' => __( 'Targovishte', 'simple-pay' ),
		'BG-03' => __( 'Varna', 'simple-pay' ),
		'BG-04' => __( 'Veliko Tarnovo', 'simple-pay' ),
		'BG-05' => __( 'Vidin', 'simple-pay' ),
		'BG-06' => __( 'Vratsa', 'simple-pay' ),
		'BG-28' => __( 'Yambol', 'simple-pay' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Beninese states.
		'AL' => __( 'Alibori', 'simple-pay' ),
		'AK' => __( 'Atakora', 'simple-pay' ),
		'AQ' => __( 'Atlantique', 'simple-pay' ),
		'BO' => __( 'Borgou', 'simple-pay' ),
		'CO' => __( 'Collines', 'simple-pay' ),
		'KO' => __( 'Kouffo', 'simple-pay' ),
		'DO' => __( 'Donga', 'simple-pay' ),
		'LI' => __( 'Littoral', 'simple-pay' ),
		'MO' => __( 'Mono', 'simple-pay' ),
		'OU' => __( 'Ouémé', 'simple-pay' ),
		'PL' => __( 'Plateau', 'simple-pay' ),
		'ZO' => __( 'Zou', 'simple-pay' ),
	),
	'BO' => array( // Bolivian states.
		'BO-B' => __( 'Beni', 'simple-pay' ),
		'BO-H' => __( 'Chuquisaca', 'simple-pay' ),
		'BO-C' => __( 'Cochabamba', 'simple-pay' ),
		'BO-L' => __( 'La Paz', 'simple-pay' ),
		'BO-O' => __( 'Oruro', 'simple-pay' ),
		'BO-N' => __( 'Pando', 'simple-pay' ),
		'BO-P' => __( 'Potosí', 'simple-pay' ),
		'BO-S' => __( 'Santa Cruz', 'simple-pay' ),
		'BO-T' => __( 'Tarija', 'simple-pay' ),
	),
	'BR' => array( // Brazilian states.
		'AC' => __( 'Acre', 'simple-pay' ),
		'AL' => __( 'Alagoas', 'simple-pay' ),
		'AP' => __( 'Amapá', 'simple-pay' ),
		'AM' => __( 'Amazonas', 'simple-pay' ),
		'BA' => __( 'Bahia', 'simple-pay' ),
		'CE' => __( 'Ceará', 'simple-pay' ),
		'DF' => __( 'Distrito Federal', 'simple-pay' ),
		'ES' => __( 'Espírito Santo', 'simple-pay' ),
		'GO' => __( 'Goiás', 'simple-pay' ),
		'MA' => __( 'Maranhão', 'simple-pay' ),
		'MT' => __( 'Mato Grosso', 'simple-pay' ),
		'MS' => __( 'Mato Grosso do Sul', 'simple-pay' ),
		'MG' => __( 'Minas Gerais', 'simple-pay' ),
		'PA' => __( 'Pará', 'simple-pay' ),
		'PB' => __( 'Paraíba', 'simple-pay' ),
		'PR' => __( 'Paraná', 'simple-pay' ),
		'PE' => __( 'Pernambuco', 'simple-pay' ),
		'PI' => __( 'Piauí', 'simple-pay' ),
		'RJ' => __( 'Rio de Janeiro', 'simple-pay' ),
		'RN' => __( 'Rio Grande do Norte', 'simple-pay' ),
		'RS' => __( 'Rio Grande do Sul', 'simple-pay' ),
		'RO' => __( 'Rondônia', 'simple-pay' ),
		'RR' => __( 'Roraima', 'simple-pay' ),
		'SC' => __( 'Santa Catarina', 'simple-pay' ),
		'SP' => __( 'São Paulo', 'simple-pay' ),
		'SE' => __( 'Sergipe', 'simple-pay' ),
		'TO' => __( 'Tocantins', 'simple-pay' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'simple-pay' ),
		'BC' => __( 'British Columbia', 'simple-pay' ),
		'MB' => __( 'Manitoba', 'simple-pay' ),
		'NB' => __( 'New Brunswick', 'simple-pay' ),
		'NL' => __( 'Newfoundland and Labrador', 'simple-pay' ),
		'NT' => __( 'Northwest Territories', 'simple-pay' ),
		'NS' => __( 'Nova Scotia', 'simple-pay' ),
		'NU' => __( 'Nunavut', 'simple-pay' ),
		'ON' => __( 'Ontario', 'simple-pay' ),
		'PE' => __( 'Prince Edward Island', 'simple-pay' ),
		'QC' => __( 'Quebec', 'simple-pay' ),
		'SK' => __( 'Saskatchewan', 'simple-pay' ),
		'YT' => __( 'Yukon Territory', 'simple-pay' ),
	),
	'CH' => array( // Swiss cantons.
		'AG' => __( 'Aargau', 'simple-pay' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'simple-pay' ),
		'AI' => __( 'Appenzell Innerrhoden', 'simple-pay' ),
		'BL' => __( 'Basel-Landschaft', 'simple-pay' ),
		'BS' => __( 'Basel-Stadt', 'simple-pay' ),
		'BE' => __( 'Bern', 'simple-pay' ),
		'FR' => __( 'Fribourg', 'simple-pay' ),
		'GE' => __( 'Geneva', 'simple-pay' ),
		'GL' => __( 'Glarus', 'simple-pay' ),
		'GR' => __( 'Graubünden', 'simple-pay' ),
		'JU' => __( 'Jura', 'simple-pay' ),
		'LU' => __( 'Luzern', 'simple-pay' ),
		'NE' => __( 'Neuchâtel', 'simple-pay' ),
		'NW' => __( 'Nidwalden', 'simple-pay' ),
		'OW' => __( 'Obwalden', 'simple-pay' ),
		'SH' => __( 'Schaffhausen', 'simple-pay' ),
		'SZ' => __( 'Schwyz', 'simple-pay' ),
		'SO' => __( 'Solothurn', 'simple-pay' ),
		'SG' => __( 'St. Gallen', 'simple-pay' ),
		'TG' => __( 'Thurgau', 'simple-pay' ),
		'TI' => __( 'Ticino', 'simple-pay' ),
		'UR' => __( 'Uri', 'simple-pay' ),
		'VS' => __( 'Valais', 'simple-pay' ),
		'VD' => __( 'Vaud', 'simple-pay' ),
		'ZG' => __( 'Zug', 'simple-pay' ),
		'ZH' => __( 'Zürich', 'simple-pay' ),
	),
	'CL' => array( // Chilean states.
		'CL-AI' => __( 'Aisén del General Carlos Ibañez del Campo', 'simple-pay' ),
		'CL-AN' => __( 'Antofagasta', 'simple-pay' ),
		'CL-AP' => __( 'Arica y Parinacota', 'simple-pay' ),
		'CL-AR' => __( 'La Araucanía', 'simple-pay' ),
		'CL-AT' => __( 'Atacama', 'simple-pay' ),
		'CL-BI' => __( 'Biobío', 'simple-pay' ),
		'CL-CO' => __( 'Coquimbo', 'simple-pay' ),
		'CL-LI' => __( 'Libertador General Bernardo O\'Higgins', 'simple-pay' ),
		'CL-LL' => __( 'Los Lagos', 'simple-pay' ),
		'CL-LR' => __( 'Los Ríos', 'simple-pay' ),
		'CL-MA' => __( 'Magallanes', 'simple-pay' ),
		'CL-ML' => __( 'Maule', 'simple-pay' ),
		'CL-NB' => __( 'Ñuble', 'simple-pay' ),
		'CL-RM' => __( 'Región Metropolitana de Santiago', 'simple-pay' ),
		'CL-TA' => __( 'Tarapacá', 'simple-pay' ),
		'CL-VS' => __( 'Valparaíso', 'simple-pay' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'simple-pay' ),
		'CN2'  => __( 'Beijing / 北京', 'simple-pay' ),
		'CN3'  => __( 'Tianjin / 天津', 'simple-pay' ),
		'CN4'  => __( 'Hebei / 河北', 'simple-pay' ),
		'CN5'  => __( 'Shanxi / 山西', 'simple-pay' ),
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'simple-pay' ),
		'CN7'  => __( 'Liaoning / 辽宁', 'simple-pay' ),
		'CN8'  => __( 'Jilin / 吉林', 'simple-pay' ),
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'simple-pay' ),
		'CN10' => __( 'Shanghai / 上海', 'simple-pay' ),
		'CN11' => __( 'Jiangsu / 江苏', 'simple-pay' ),
		'CN12' => __( 'Zhejiang / 浙江', 'simple-pay' ),
		'CN13' => __( 'Anhui / 安徽', 'simple-pay' ),
		'CN14' => __( 'Fujian / 福建', 'simple-pay' ),
		'CN15' => __( 'Jiangxi / 江西', 'simple-pay' ),
		'CN16' => __( 'Shandong / 山东', 'simple-pay' ),
		'CN17' => __( 'Henan / 河南', 'simple-pay' ),
		'CN18' => __( 'Hubei / 湖北', 'simple-pay' ),
		'CN19' => __( 'Hunan / 湖南', 'simple-pay' ),
		'CN20' => __( 'Guangdong / 广东', 'simple-pay' ),
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'simple-pay' ),
		'CN22' => __( 'Hainan / 海南', 'simple-pay' ),
		'CN23' => __( 'Chongqing / 重庆', 'simple-pay' ),
		'CN24' => __( 'Sichuan / 四川', 'simple-pay' ),
		'CN25' => __( 'Guizhou / 贵州', 'simple-pay' ),
		'CN26' => __( 'Shaanxi / 陕西', 'simple-pay' ),
		'CN27' => __( 'Gansu / 甘肃', 'simple-pay' ),
		'CN28' => __( 'Qinghai / 青海', 'simple-pay' ),
		'CN29' => __( 'Ningxia Hui / 宁夏', 'simple-pay' ),
		'CN30' => __( 'Macao / 澳门', 'simple-pay' ),
		'CN31' => __( 'Tibet / 西藏', 'simple-pay' ),
		'CN32' => __( 'Xinjiang / 新疆', 'simple-pay' ),
	),
	'CO' => array( // Colombian states.
		'CO-AMA' => __( 'Amazonas', 'simple-pay' ),
		'CO-ANT' => __( 'Antioquia', 'simple-pay' ),
		'CO-ARA' => __( 'Arauca', 'simple-pay' ),
		'CO-ATL' => __( 'Atlántico', 'simple-pay' ),
		'CO-BOL' => __( 'Bolívar', 'simple-pay' ),
		'CO-BOY' => __( 'Boyacá', 'simple-pay' ),
		'CO-CAL' => __( 'Caldas', 'simple-pay' ),
		'CO-CAQ' => __( 'Caquetá', 'simple-pay' ),
		'CO-CAS' => __( 'Casanare', 'simple-pay' ),
		'CO-CAU' => __( 'Cauca', 'simple-pay' ),
		'CO-CES' => __( 'Cesar', 'simple-pay' ),
		'CO-CHO' => __( 'Chocó', 'simple-pay' ),
		'CO-COR' => __( 'Córdoba', 'simple-pay' ),
		'CO-CUN' => __( 'Cundinamarca', 'simple-pay' ),
		'CO-DC'  => __( 'Capital District', 'simple-pay' ),
		'CO-GUA' => __( 'Guainía', 'simple-pay' ),
		'CO-GUV' => __( 'Guaviare', 'simple-pay' ),
		'CO-HUI' => __( 'Huila', 'simple-pay' ),
		'CO-LAG' => __( 'La Guajira', 'simple-pay' ),
		'CO-MAG' => __( 'Magdalena', 'simple-pay' ),
		'CO-MET' => __( 'Meta', 'simple-pay' ),
		'CO-NAR' => __( 'Nariño', 'simple-pay' ),
		'CO-NSA' => __( 'Norte de Santander', 'simple-pay' ),
		'CO-PUT' => __( 'Putumayo', 'simple-pay' ),
		'CO-QUI' => __( 'Quindío', 'simple-pay' ),
		'CO-RIS' => __( 'Risaralda', 'simple-pay' ),
		'CO-SAN' => __( 'Santander', 'simple-pay' ),
		'CO-SAP' => __( 'San Andrés & Providencia', 'simple-pay' ),
		'CO-SUC' => __( 'Sucre', 'simple-pay' ),
		'CO-TOL' => __( 'Tolima', 'simple-pay' ),
		'CO-VAC' => __( 'Valle del Cauca', 'simple-pay' ),
		'CO-VAU' => __( 'Vaupés', 'simple-pay' ),
		'CO-VID' => __( 'Vichada', 'simple-pay' ),
	),
	'CR' => array( // Costa Rican states.
		'CR-A'  => __( 'Alajuela', 'simple-pay' ),
		'CR-C'  => __( 'Cartago', 'simple-pay' ),
		'CR-G'  => __( 'Guanacaste', 'simple-pay' ),
		'CR-H'  => __( 'Heredia', 'simple-pay' ),
		'CR-L'  => __( 'Limón', 'simple-pay' ),
		'CR-P'  => __( 'Puntarenas', 'simple-pay' ),
		'CR-SJ' => __( 'San José', 'simple-pay' ),
	),
	'CZ' => array(),
	'DE' => array( // German states.
		'DE-BW' => __( 'Baden-Württemberg', 'simple-pay' ),
		'DE-BY' => __( 'Bavaria', 'simple-pay' ),
		'DE-BE' => __( 'Berlin', 'simple-pay' ),
		'DE-BB' => __( 'Brandenburg', 'simple-pay' ),
		'DE-HB' => __( 'Bremen', 'simple-pay' ),
		'DE-HH' => __( 'Hamburg', 'simple-pay' ),
		'DE-HE' => __( 'Hesse', 'simple-pay' ),
		'DE-MV' => __( 'Mecklenburg-Vorpommern', 'simple-pay' ),
		'DE-NI' => __( 'Lower Saxony', 'simple-pay' ),
		'DE-NW' => __( 'North Rhine-Westphalia', 'simple-pay' ),
		'DE-RP' => __( 'Rhineland-Palatinate', 'simple-pay' ),
		'DE-SL' => __( 'Saarland', 'simple-pay' ),
		'DE-SN' => __( 'Saxony', 'simple-pay' ),
		'DE-ST' => __( 'Saxony-Anhalt', 'simple-pay' ),
		'DE-SH' => __( 'Schleswig-Holstein', 'simple-pay' ),
		'DE-TH' => __( 'Thuringia', 'simple-pay' ),
	),
	'DK' => array(),
	'DO' => array( // Dominican states.
		'DO-01' => __( 'Distrito Nacional', 'simple-pay' ),
		'DO-02' => __( 'Azua', 'simple-pay' ),
		'DO-03' => __( 'Baoruco', 'simple-pay' ),
		'DO-04' => __( 'Barahona', 'simple-pay' ),
		'DO-33' => __( 'Cibao Nordeste', 'simple-pay' ),
		'DO-34' => __( 'Cibao Noroeste', 'simple-pay' ),
		'DO-35' => __( 'Cibao Norte', 'simple-pay' ),
		'DO-36' => __( 'Cibao Sur', 'simple-pay' ),
		'DO-05' => __( 'Dajabón', 'simple-pay' ),
		'DO-06' => __( 'Duarte', 'simple-pay' ),
		'DO-08' => __( 'El Seibo', 'simple-pay' ),
		'DO-37' => __( 'El Valle', 'simple-pay' ),
		'DO-07' => __( 'Elías Piña', 'simple-pay' ),
		'DO-38' => __( 'Enriquillo', 'simple-pay' ),
		'DO-09' => __( 'Espaillat', 'simple-pay' ),
		'DO-30' => __( 'Hato Mayor', 'simple-pay' ),
		'DO-19' => __( 'Hermanas Mirabal', 'simple-pay' ),
		'DO-39' => __( 'Higüamo', 'simple-pay' ),
		'DO-10' => __( 'Independencia', 'simple-pay' ),
		'DO-11' => __( 'La Altagracia', 'simple-pay' ),
		'DO-12' => __( 'La Romana', 'simple-pay' ),
		'DO-13' => __( 'La Vega', 'simple-pay' ),
		'DO-14' => __( 'María Trinidad Sánchez', 'simple-pay' ),
		'DO-28' => __( 'Monseñor Nouel', 'simple-pay' ),
		'DO-15' => __( 'Monte Cristi', 'simple-pay' ),
		'DO-29' => __( 'Monte Plata', 'simple-pay' ),
		'DO-40' => __( 'Ozama', 'simple-pay' ),
		'DO-16' => __( 'Pedernales', 'simple-pay' ),
		'DO-17' => __( 'Peravia', 'simple-pay' ),
		'DO-18' => __( 'Puerto Plata', 'simple-pay' ),
		'DO-20' => __( 'Samaná', 'simple-pay' ),
		'DO-21' => __( 'San Cristóbal', 'simple-pay' ),
		'DO-31' => __( 'San José de Ocoa', 'simple-pay' ),
		'DO-22' => __( 'San Juan', 'simple-pay' ),
		'DO-23' => __( 'San Pedro de Macorís', 'simple-pay' ),
		'DO-24' => __( 'Sánchez Ramírez', 'simple-pay' ),
		'DO-25' => __( 'Santiago', 'simple-pay' ),
		'DO-26' => __( 'Santiago Rodríguez', 'simple-pay' ),
		'DO-32' => __( 'Santo Domingo', 'simple-pay' ),
		'DO-41' => __( 'Valdesia', 'simple-pay' ),
		'DO-27' => __( 'Valverde', 'simple-pay' ),
		'DO-42' => __( 'Yuma', 'simple-pay' ),
	),
	'DZ' => array( // Algerian states.
		'DZ-01' => __( 'Adrar', 'simple-pay' ),
		'DZ-02' => __( 'Chlef', 'simple-pay' ),
		'DZ-03' => __( 'Laghouat', 'simple-pay' ),
		'DZ-04' => __( 'Oum El Bouaghi', 'simple-pay' ),
		'DZ-05' => __( 'Batna', 'simple-pay' ),
		'DZ-06' => __( 'Béjaïa', 'simple-pay' ),
		'DZ-07' => __( 'Biskra', 'simple-pay' ),
		'DZ-08' => __( 'Béchar', 'simple-pay' ),
		'DZ-09' => __( 'Blida', 'simple-pay' ),
		'DZ-10' => __( 'Bouira', 'simple-pay' ),
		'DZ-11' => __( 'Tamanghasset', 'simple-pay' ),
		'DZ-12' => __( 'Tébessa', 'simple-pay' ),
		'DZ-13' => __( 'Tlemcen', 'simple-pay' ),
		'DZ-14' => __( 'Tiaret', 'simple-pay' ),
		'DZ-15' => __( 'Tizi Ouzou', 'simple-pay' ),
		'DZ-16' => __( 'Algiers', 'simple-pay' ),
		'DZ-17' => __( 'Djelfa', 'simple-pay' ),
		'DZ-18' => __( 'Jijel', 'simple-pay' ),
		'DZ-19' => __( 'Sétif', 'simple-pay' ),
		'DZ-20' => __( 'Saïda', 'simple-pay' ),
		'DZ-21' => __( 'Skikda', 'simple-pay' ),
		'DZ-22' => __( 'Sidi Bel Abbès', 'simple-pay' ),
		'DZ-23' => __( 'Annaba', 'simple-pay' ),
		'DZ-24' => __( 'Guelma', 'simple-pay' ),
		'DZ-25' => __( 'Constantine', 'simple-pay' ),
		'DZ-26' => __( 'Médéa', 'simple-pay' ),
		'DZ-27' => __( 'Mostaganem', 'simple-pay' ),
		'DZ-28' => __( 'M’Sila', 'simple-pay' ),
		'DZ-29' => __( 'Mascara', 'simple-pay' ),
		'DZ-30' => __( 'Ouargla', 'simple-pay' ),
		'DZ-31' => __( 'Oran', 'simple-pay' ),
		'DZ-32' => __( 'El Bayadh', 'simple-pay' ),
		'DZ-33' => __( 'Illizi', 'simple-pay' ),
		'DZ-34' => __( 'Bordj Bou Arréridj', 'simple-pay' ),
		'DZ-35' => __( 'Boumerdès', 'simple-pay' ),
		'DZ-36' => __( 'El Tarf', 'simple-pay' ),
		'DZ-37' => __( 'Tindouf', 'simple-pay' ),
		'DZ-38' => __( 'Tissemsilt', 'simple-pay' ),
		'DZ-39' => __( 'El Oued', 'simple-pay' ),
		'DZ-40' => __( 'Khenchela', 'simple-pay' ),
		'DZ-41' => __( 'Souk Ahras', 'simple-pay' ),
		'DZ-42' => __( 'Tipasa', 'simple-pay' ),
		'DZ-43' => __( 'Mila', 'simple-pay' ),
		'DZ-44' => __( 'Aïn Defla', 'simple-pay' ),
		'DZ-45' => __( 'Naama', 'simple-pay' ),
		'DZ-46' => __( 'Aïn Témouchent', 'simple-pay' ),
		'DZ-47' => __( 'Ghardaïa', 'simple-pay' ),
		'DZ-48' => __( 'Relizane', 'simple-pay' ),
	),
	'EE' => array(),
	'EC' => array( // Ecuadorian states.
		'EC-A'  => __( 'Azuay', 'simple-pay' ),
		'EC-B'  => __( 'Bolívar', 'simple-pay' ),
		'EC-F'  => __( 'Cañar', 'simple-pay' ),
		'EC-C'  => __( 'Carchi', 'simple-pay' ),
		'EC-H'  => __( 'Chimborazo', 'simple-pay' ),
		'EC-X'  => __( 'Cotopaxi', 'simple-pay' ),
		'EC-O'  => __( 'El Oro', 'simple-pay' ),
		'EC-E'  => __( 'Esmeraldas', 'simple-pay' ),
		'EC-W'  => __( 'Galápagos', 'simple-pay' ),
		'EC-G'  => __( 'Guayas', 'simple-pay' ),
		'EC-I'  => __( 'Imbabura', 'simple-pay' ),
		'EC-L'  => __( 'Loja', 'simple-pay' ),
		'EC-R'  => __( 'Los Ríos', 'simple-pay' ),
		'EC-M'  => __( 'Manabí', 'simple-pay' ),
		'EC-S'  => __( 'Morona-Santiago', 'simple-pay' ),
		'EC-N'  => __( 'Napo', 'simple-pay' ),
		'EC-D'  => __( 'Orellana', 'simple-pay' ),
		'EC-Y'  => __( 'Pastaza', 'simple-pay' ),
		'EC-P'  => __( 'Pichincha', 'simple-pay' ),
		'EC-SE' => __( 'Santa Elena', 'simple-pay' ),
		'EC-SD' => __( 'Santo Domingo de los Tsáchilas', 'simple-pay' ),
		'EC-U'  => __( 'Sucumbíos', 'simple-pay' ),
		'EC-T'  => __( 'Tungurahua', 'simple-pay' ),
		'EC-Z'  => __( 'Zamora-Chinchipe', 'simple-pay' ),
	),
	'EG' => array( // Egyptian states.
		'EGALX' => __( 'Alexandria', 'simple-pay' ),
		'EGASN' => __( 'Aswan', 'simple-pay' ),
		'EGAST' => __( 'Asyut', 'simple-pay' ),
		'EGBA'  => __( 'Red Sea', 'simple-pay' ),
		'EGBH'  => __( 'Beheira', 'simple-pay' ),
		'EGBNS' => __( 'Beni Suef', 'simple-pay' ),
		'EGC'   => __( 'Cairo', 'simple-pay' ),
		'EGDK'  => __( 'Dakahlia', 'simple-pay' ),
		'EGDT'  => __( 'Damietta', 'simple-pay' ),
		'EGFYM' => __( 'Faiyum', 'simple-pay' ),
		'EGGH'  => __( 'Gharbia', 'simple-pay' ),
		'EGGZ'  => __( 'Giza', 'simple-pay' ),
		'EGIS'  => __( 'Ismailia', 'simple-pay' ),
		'EGJS'  => __( 'South Sinai', 'simple-pay' ),
		'EGKB'  => __( 'Qalyubia', 'simple-pay' ),
		'EGKFS' => __( 'Kafr el-Sheikh', 'simple-pay' ),
		'EGKN'  => __( 'Qena', 'simple-pay' ),
		'EGLX'  => __( 'Luxor', 'simple-pay' ),
		'EGMN'  => __( 'Minya', 'simple-pay' ),
		'EGMNF' => __( 'Monufia', 'simple-pay' ),
		'EGMT'  => __( 'Matrouh', 'simple-pay' ),
		'EGPTS' => __( 'Port Said', 'simple-pay' ),
		'EGSHG' => __( 'Sohag', 'simple-pay' ),
		'EGSHR' => __( 'Al Sharqia', 'simple-pay' ),
		'EGSIN' => __( 'North Sinai', 'simple-pay' ),
		'EGSUZ' => __( 'Suez', 'simple-pay' ),
		'EGWAD' => __( 'New Valley', 'simple-pay' ),
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'simple-pay' ),
		'VI' => __( 'Araba/Álava', 'simple-pay' ),
		'AB' => __( 'Albacete', 'simple-pay' ),
		'A'  => __( 'Alicante', 'simple-pay' ),
		'AL' => __( 'Almería', 'simple-pay' ),
		'O'  => __( 'Asturias', 'simple-pay' ),
		'AV' => __( 'Ávila', 'simple-pay' ),
		'BA' => __( 'Badajoz', 'simple-pay' ),
		'PM' => __( 'Baleares', 'simple-pay' ),
		'B'  => __( 'Barcelona', 'simple-pay' ),
		'BU' => __( 'Burgos', 'simple-pay' ),
		'CC' => __( 'Cáceres', 'simple-pay' ),
		'CA' => __( 'Cádiz', 'simple-pay' ),
		'S'  => __( 'Cantabria', 'simple-pay' ),
		'CS' => __( 'Castellón', 'simple-pay' ),
		'CE' => __( 'Ceuta', 'simple-pay' ),
		'CR' => __( 'Ciudad Real', 'simple-pay' ),
		'CO' => __( 'Córdoba', 'simple-pay' ),
		'CU' => __( 'Cuenca', 'simple-pay' ),
		'GI' => __( 'Girona', 'simple-pay' ),
		'GR' => __( 'Granada', 'simple-pay' ),
		'GU' => __( 'Guadalajara', 'simple-pay' ),
		'SS' => __( 'Gipuzkoa', 'simple-pay' ),
		'H'  => __( 'Huelva', 'simple-pay' ),
		'HU' => __( 'Huesca', 'simple-pay' ),
		'J'  => __( 'Jaén', 'simple-pay' ),
		'LO' => __( 'La Rioja', 'simple-pay' ),
		'GC' => __( 'Las Palmas', 'simple-pay' ),
		'LE' => __( 'León', 'simple-pay' ),
		'L'  => __( 'Lleida', 'simple-pay' ),
		'LU' => __( 'Lugo', 'simple-pay' ),
		'M'  => __( 'Madrid', 'simple-pay' ),
		'MA' => __( 'Málaga', 'simple-pay' ),
		'ML' => __( 'Melilla', 'simple-pay' ),
		'MU' => __( 'Murcia', 'simple-pay' ),
		'NA' => __( 'Navarra', 'simple-pay' ),
		'OR' => __( 'Ourense', 'simple-pay' ),
		'P'  => __( 'Palencia', 'simple-pay' ),
		'PO' => __( 'Pontevedra', 'simple-pay' ),
		'SA' => __( 'Salamanca', 'simple-pay' ),
		'TF' => __( 'Santa Cruz de Tenerife', 'simple-pay' ),
		'SG' => __( 'Segovia', 'simple-pay' ),
		'SE' => __( 'Sevilla', 'simple-pay' ),
		'SO' => __( 'Soria', 'simple-pay' ),
		'T'  => __( 'Tarragona', 'simple-pay' ),
		'TE' => __( 'Teruel', 'simple-pay' ),
		'TO' => __( 'Toledo', 'simple-pay' ),
		'V'  => __( 'Valencia', 'simple-pay' ),
		'VA' => __( 'Valladolid', 'simple-pay' ),
		'BI' => __( 'Biscay', 'simple-pay' ),
		'ZA' => __( 'Zamora', 'simple-pay' ),
		'Z'  => __( 'Zaragoza', 'simple-pay' ),
	),
	'FI' => array(),
	'FR' => array(),
	'GF' => array(),
	'GH' => array( // Ghanaian regions.
		'AF' => __( 'Ahafo', 'simple-pay' ),
		'AH' => __( 'Ashanti', 'simple-pay' ),
		'BA' => __( 'Brong-Ahafo', 'simple-pay' ),
		'BO' => __( 'Bono', 'simple-pay' ),
		'BE' => __( 'Bono East', 'simple-pay' ),
		'CP' => __( 'Central', 'simple-pay' ),
		'EP' => __( 'Eastern', 'simple-pay' ),
		'AA' => __( 'Greater Accra', 'simple-pay' ),
		'NE' => __( 'North East', 'simple-pay' ),
		'NP' => __( 'Northern', 'simple-pay' ),
		'OT' => __( 'Oti', 'simple-pay' ),
		'SV' => __( 'Savannah', 'simple-pay' ),
		'UE' => __( 'Upper East', 'simple-pay' ),
		'UW' => __( 'Upper West', 'simple-pay' ),
		'TV' => __( 'Volta', 'simple-pay' ),
		'WP' => __( 'Western', 'simple-pay' ),
		'WN' => __( 'Western North', 'simple-pay' ),
	),
	'GP' => array(),
	'GR' => array( // Greek regions.
		'I' => __( 'Attica', 'simple-pay' ),
		'A' => __( 'East Macedonia and Thrace', 'simple-pay' ),
		'B' => __( 'Central Macedonia', 'simple-pay' ),
		'C' => __( 'West Macedonia', 'simple-pay' ),
		'D' => __( 'Epirus', 'simple-pay' ),
		'E' => __( 'Thessaly', 'simple-pay' ),
		'F' => __( 'Ionian Islands', 'simple-pay' ),
		'G' => __( 'West Greece', 'simple-pay' ),
		'H' => __( 'Central Greece', 'simple-pay' ),
		'J' => __( 'Peloponnese', 'simple-pay' ),
		'K' => __( 'North Aegean', 'simple-pay' ),
		'L' => __( 'South Aegean', 'simple-pay' ),
		'M' => __( 'Crete', 'simple-pay' ),
	),
	'GT' => array( // Guatemalan states.
		'GT-AV' => __( 'Alta Verapaz', 'simple-pay' ),
		'GT-BV' => __( 'Baja Verapaz', 'simple-pay' ),
		'GT-CM' => __( 'Chimaltenango', 'simple-pay' ),
		'GT-CQ' => __( 'Chiquimula', 'simple-pay' ),
		'GT-PR' => __( 'El Progreso', 'simple-pay' ),
		'GT-ES' => __( 'Escuintla', 'simple-pay' ),
		'GT-GU' => __( 'Guatemala', 'simple-pay' ),
		'GT-HU' => __( 'Huehuetenango', 'simple-pay' ),
		'GT-IZ' => __( 'Izabal', 'simple-pay' ),
		'GT-JA' => __( 'Jalapa', 'simple-pay' ),
		'GT-JU' => __( 'Jutiapa', 'simple-pay' ),
		'GT-PE' => __( 'Petén', 'simple-pay' ),
		'GT-QZ' => __( 'Quetzaltenango', 'simple-pay' ),
		'GT-QC' => __( 'Quiché', 'simple-pay' ),
		'GT-RE' => __( 'Retalhuleu', 'simple-pay' ),
		'GT-SA' => __( 'Sacatepéquez', 'simple-pay' ),
		'GT-SM' => __( 'San Marcos', 'simple-pay' ),
		'GT-SR' => __( 'Santa Rosa', 'simple-pay' ),
		'GT-SO' => __( 'Sololá', 'simple-pay' ),
		'GT-SU' => __( 'Suchitepéquez', 'simple-pay' ),
		'GT-TO' => __( 'Totonicapán', 'simple-pay' ),
		'GT-ZA' => __( 'Zacapa', 'simple-pay' ),
	),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'simple-pay' ),
		'KOWLOON'         => __( 'Kowloon', 'simple-pay' ),
		'NEW TERRITORIES' => __( 'New Territories', 'simple-pay' ),
	),
	'HN' => array( // Honduran states.
		'HN-AT' => __( 'Atlántida', 'simple-pay' ),
		'HN-IB' => __( 'Bay Islands', 'simple-pay' ),
		'HN-CH' => __( 'Choluteca', 'simple-pay' ),
		'HN-CL' => __( 'Colón', 'simple-pay' ),
		'HN-CM' => __( 'Comayagua', 'simple-pay' ),
		'HN-CP' => __( 'Copán', 'simple-pay' ),
		'HN-CR' => __( 'Cortés', 'simple-pay' ),
		'HN-EP' => __( 'El Paraíso', 'simple-pay' ),
		'HN-FM' => __( 'Francisco Morazán', 'simple-pay' ),
		'HN-GD' => __( 'Gracias a Dios', 'simple-pay' ),
		'HN-IN' => __( 'Intibucá', 'simple-pay' ),
		'HN-LE' => __( 'Lempira', 'simple-pay' ),
		'HN-LP' => __( 'La Paz', 'simple-pay' ),
		'HN-OC' => __( 'Ocotepeque', 'simple-pay' ),
		'HN-OL' => __( 'Olancho', 'simple-pay' ),
		'HN-SB' => __( 'Santa Bárbara', 'simple-pay' ),
		'HN-VA' => __( 'Valle', 'simple-pay' ),
		'HN-YO' => __( 'Yoro', 'simple-pay' ),
	),
	'HU' => array( // Hungarian states.
		'BK' => __( 'Bács-Kiskun', 'simple-pay' ),
		'BE' => __( 'Békés', 'simple-pay' ),
		'BA' => __( 'Baranya', 'simple-pay' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'simple-pay' ),
		'BU' => __( 'Budapest', 'simple-pay' ),
		'CS' => __( 'Csongrád-Csanád', 'simple-pay' ),
		'FE' => __( 'Fejér', 'simple-pay' ),
		'GS' => __( 'Győr-Moson-Sopron', 'simple-pay' ),
		'HB' => __( 'Hajdú-Bihar', 'simple-pay' ),
		'HE' => __( 'Heves', 'simple-pay' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'simple-pay' ),
		'KE' => __( 'Komárom-Esztergom', 'simple-pay' ),
		'NO' => __( 'Nógrád', 'simple-pay' ),
		'PE' => __( 'Pest', 'simple-pay' ),
		'SO' => __( 'Somogy', 'simple-pay' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'simple-pay' ),
		'TO' => __( 'Tolna', 'simple-pay' ),
		'VA' => __( 'Vas', 'simple-pay' ),
		'VE' => __( 'Veszprém', 'simple-pay' ),
		'ZA' => __( 'Zala', 'simple-pay' ),
	),
	'ID' => array( // Indonesian provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'simple-pay' ),
		'SU' => __( 'Sumatera Utara', 'simple-pay' ),
		'SB' => __( 'Sumatera Barat', 'simple-pay' ),
		'RI' => __( 'Riau', 'simple-pay' ),
		'KR' => __( 'Kepulauan Riau', 'simple-pay' ),
		'JA' => __( 'Jambi', 'simple-pay' ),
		'SS' => __( 'Sumatera Selatan', 'simple-pay' ),
		'BB' => __( 'Bangka Belitung', 'simple-pay' ),
		'BE' => __( 'Bengkulu', 'simple-pay' ),
		'LA' => __( 'Lampung', 'simple-pay' ),
		'JK' => __( 'DKI Jakarta', 'simple-pay' ),
		'JB' => __( 'Jawa Barat', 'simple-pay' ),
		'BT' => __( 'Banten', 'simple-pay' ),
		'JT' => __( 'Jawa Tengah', 'simple-pay' ),
		'JI' => __( 'Jawa Timur', 'simple-pay' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'simple-pay' ),
		'BA' => __( 'Bali', 'simple-pay' ),
		'NB' => __( 'Nusa Tenggara Barat', 'simple-pay' ),
		'NT' => __( 'Nusa Tenggara Timur', 'simple-pay' ),
		'KB' => __( 'Kalimantan Barat', 'simple-pay' ),
		'KT' => __( 'Kalimantan Tengah', 'simple-pay' ),
		'KI' => __( 'Kalimantan Timur', 'simple-pay' ),
		'KS' => __( 'Kalimantan Selatan', 'simple-pay' ),
		'KU' => __( 'Kalimantan Utara', 'simple-pay' ),
		'SA' => __( 'Sulawesi Utara', 'simple-pay' ),
		'ST' => __( 'Sulawesi Tengah', 'simple-pay' ),
		'SG' => __( 'Sulawesi Tenggara', 'simple-pay' ),
		'SR' => __( 'Sulawesi Barat', 'simple-pay' ),
		'SN' => __( 'Sulawesi Selatan', 'simple-pay' ),
		'GO' => __( 'Gorontalo', 'simple-pay' ),
		'MA' => __( 'Maluku', 'simple-pay' ),
		'MU' => __( 'Maluku Utara', 'simple-pay' ),
		'PA' => __( 'Papua', 'simple-pay' ),
		'PB' => __( 'Papua Barat', 'simple-pay' ),
	),
	'IE' => array( // Irish states.
		'CW' => __( 'Carlow', 'simple-pay' ),
		'CN' => __( 'Cavan', 'simple-pay' ),
		'CE' => __( 'Clare', 'simple-pay' ),
		'CO' => __( 'Cork', 'simple-pay' ),
		'DL' => __( 'Donegal', 'simple-pay' ),
		'D'  => __( 'Dublin', 'simple-pay' ),
		'G'  => __( 'Galway', 'simple-pay' ),
		'KY' => __( 'Kerry', 'simple-pay' ),
		'KE' => __( 'Kildare', 'simple-pay' ),
		'KK' => __( 'Kilkenny', 'simple-pay' ),
		'LS' => __( 'Laois', 'simple-pay' ),
		'LM' => __( 'Leitrim', 'simple-pay' ),
		'LK' => __( 'Limerick', 'simple-pay' ),
		'LD' => __( 'Longford', 'simple-pay' ),
		'LH' => __( 'Louth', 'simple-pay' ),
		'MO' => __( 'Mayo', 'simple-pay' ),
		'MH' => __( 'Meath', 'simple-pay' ),
		'MN' => __( 'Monaghan', 'simple-pay' ),
		'OY' => __( 'Offaly', 'simple-pay' ),
		'RN' => __( 'Roscommon', 'simple-pay' ),
		'SO' => __( 'Sligo', 'simple-pay' ),
		'TA' => __( 'Tipperary', 'simple-pay' ),
		'WD' => __( 'Waterford', 'simple-pay' ),
		'WH' => __( 'Westmeath', 'simple-pay' ),
		'WX' => __( 'Wexford', 'simple-pay' ),
		'WW' => __( 'Wicklow', 'simple-pay' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'simple-pay' ),
		'AR' => __( 'Arunachal Pradesh', 'simple-pay' ),
		'AS' => __( 'Assam', 'simple-pay' ),
		'BR' => __( 'Bihar', 'simple-pay' ),
		'CT' => __( 'Chhattisgarh', 'simple-pay' ),
		'GA' => __( 'Goa', 'simple-pay' ),
		'GJ' => __( 'Gujarat', 'simple-pay' ),
		'HR' => __( 'Haryana', 'simple-pay' ),
		'HP' => __( 'Himachal Pradesh', 'simple-pay' ),
		'JK' => __( 'Jammu and Kashmir', 'simple-pay' ),
		'JH' => __( 'Jharkhand', 'simple-pay' ),
		'KA' => __( 'Karnataka', 'simple-pay' ),
		'KL' => __( 'Kerala', 'simple-pay' ),
		'LA' => __( 'Ladakh', 'simple-pay' ),
		'MP' => __( 'Madhya Pradesh', 'simple-pay' ),
		'MH' => __( 'Maharashtra', 'simple-pay' ),
		'MN' => __( 'Manipur', 'simple-pay' ),
		'ML' => __( 'Meghalaya', 'simple-pay' ),
		'MZ' => __( 'Mizoram', 'simple-pay' ),
		'NL' => __( 'Nagaland', 'simple-pay' ),
		'OR' => __( 'Odisha', 'simple-pay' ),
		'PB' => __( 'Punjab', 'simple-pay' ),
		'RJ' => __( 'Rajasthan', 'simple-pay' ),
		'SK' => __( 'Sikkim', 'simple-pay' ),
		'TN' => __( 'Tamil Nadu', 'simple-pay' ),
		'TS' => __( 'Telangana', 'simple-pay' ),
		'TR' => __( 'Tripura', 'simple-pay' ),
		'UK' => __( 'Uttarakhand', 'simple-pay' ),
		'UP' => __( 'Uttar Pradesh', 'simple-pay' ),
		'WB' => __( 'West Bengal', 'simple-pay' ),
		'AN' => __( 'Andaman and Nicobar Islands', 'simple-pay' ),
		'CH' => __( 'Chandigarh', 'simple-pay' ),
		'DN' => __( 'Dadra and Nagar Haveli', 'simple-pay' ),
		'DD' => __( 'Daman and Diu', 'simple-pay' ),
		'DL' => __( 'Delhi', 'simple-pay' ),
		'LD' => __( 'Lakshadeep', 'simple-pay' ),
		'PY' => __( 'Pondicherry (Puducherry)', 'simple-pay' ),
	),
	'IR' => array( // Irania states.
		'KHZ' => __( 'Khuzestan (خوزستان)', 'simple-pay' ),
		'THR' => __( 'Tehran (تهران)', 'simple-pay' ),
		'ILM' => __( 'Ilaam (ایلام)', 'simple-pay' ),
		'BHR' => __( 'Bushehr (بوشهر)', 'simple-pay' ),
		'ADL' => __( 'Ardabil (اردبیل)', 'simple-pay' ),
		'ESF' => __( 'Isfahan (اصفهان)', 'simple-pay' ),
		'YZD' => __( 'Yazd (یزد)', 'simple-pay' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'simple-pay' ),
		'KRN' => __( 'Kerman (کرمان)', 'simple-pay' ),
		'HDN' => __( 'Hamadan (همدان)', 'simple-pay' ),
		'GZN' => __( 'Ghazvin (قزوین)', 'simple-pay' ),
		'ZJN' => __( 'Zanjan (زنجان)', 'simple-pay' ),
		'LRS' => __( 'Luristan (لرستان)', 'simple-pay' ),
		'ABZ' => __( 'Alborz (البرز)', 'simple-pay' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'simple-pay' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'simple-pay' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'simple-pay' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'simple-pay' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'simple-pay' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'simple-pay' ),
		'SMN' => __( 'Semnan (سمنان)', 'simple-pay' ),
		'FRS' => __( 'Fars (فارس)', 'simple-pay' ),
		'QHM' => __( 'Qom (قم)', 'simple-pay' ),
		'KRD' => __( 'Kurdistan / کردستان)', 'simple-pay' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'simple-pay' ),
		'GLS' => __( 'Golestan (گلستان)', 'simple-pay' ),
		'GIL' => __( 'Gilan (گیلان)', 'simple-pay' ),
		'MZN' => __( 'Mazandaran (مازندران)', 'simple-pay' ),
		'MKZ' => __( 'Markazi (مرکزی)', 'simple-pay' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'simple-pay' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'simple-pay' ),
	),
	'IS' => array(),
	'IT' => array( // Italian provinces.
		'AG' => __( 'Agrigento', 'simple-pay' ),
		'AL' => __( 'Alessandria', 'simple-pay' ),
		'AN' => __( 'Ancona', 'simple-pay' ),
		'AO' => __( 'Aosta', 'simple-pay' ),
		'AR' => __( 'Arezzo', 'simple-pay' ),
		'AP' => __( 'Ascoli Piceno', 'simple-pay' ),
		'AT' => __( 'Asti', 'simple-pay' ),
		'AV' => __( 'Avellino', 'simple-pay' ),
		'BA' => __( 'Bari', 'simple-pay' ),
		'BT' => __( 'Barletta-Andria-Trani', 'simple-pay' ),
		'BL' => __( 'Belluno', 'simple-pay' ),
		'BN' => __( 'Benevento', 'simple-pay' ),
		'BG' => __( 'Bergamo', 'simple-pay' ),
		'BI' => __( 'Biella', 'simple-pay' ),
		'BO' => __( 'Bologna', 'simple-pay' ),
		'BZ' => __( 'Bolzano', 'simple-pay' ),
		'BS' => __( 'Brescia', 'simple-pay' ),
		'BR' => __( 'Brindisi', 'simple-pay' ),
		'CA' => __( 'Cagliari', 'simple-pay' ),
		'CL' => __( 'Caltanissetta', 'simple-pay' ),
		'CB' => __( 'Campobasso', 'simple-pay' ),
		'CE' => __( 'Caserta', 'simple-pay' ),
		'CT' => __( 'Catania', 'simple-pay' ),
		'CZ' => __( 'Catanzaro', 'simple-pay' ),
		'CH' => __( 'Chieti', 'simple-pay' ),
		'CO' => __( 'Como', 'simple-pay' ),
		'CS' => __( 'Cosenza', 'simple-pay' ),
		'CR' => __( 'Cremona', 'simple-pay' ),
		'KR' => __( 'Crotone', 'simple-pay' ),
		'CN' => __( 'Cuneo', 'simple-pay' ),
		'EN' => __( 'Enna', 'simple-pay' ),
		'FM' => __( 'Fermo', 'simple-pay' ),
		'FE' => __( 'Ferrara', 'simple-pay' ),
		'FI' => __( 'Firenze', 'simple-pay' ),
		'FG' => __( 'Foggia', 'simple-pay' ),
		'FC' => __( 'Forlì-Cesena', 'simple-pay' ),
		'FR' => __( 'Frosinone', 'simple-pay' ),
		'GE' => __( 'Genova', 'simple-pay' ),
		'GO' => __( 'Gorizia', 'simple-pay' ),
		'GR' => __( 'Grosseto', 'simple-pay' ),
		'IM' => __( 'Imperia', 'simple-pay' ),
		'IS' => __( 'Isernia', 'simple-pay' ),
		'SP' => __( 'La Spezia', 'simple-pay' ),
		'AQ' => __( "L'Aquila", 'simple-pay' ),
		'LT' => __( 'Latina', 'simple-pay' ),
		'LE' => __( 'Lecce', 'simple-pay' ),
		'LC' => __( 'Lecco', 'simple-pay' ),
		'LI' => __( 'Livorno', 'simple-pay' ),
		'LO' => __( 'Lodi', 'simple-pay' ),
		'LU' => __( 'Lucca', 'simple-pay' ),
		'MC' => __( 'Macerata', 'simple-pay' ),
		'MN' => __( 'Mantova', 'simple-pay' ),
		'MS' => __( 'Massa-Carrara', 'simple-pay' ),
		'MT' => __( 'Matera', 'simple-pay' ),
		'ME' => __( 'Messina', 'simple-pay' ),
		'MI' => __( 'Milano', 'simple-pay' ),
		'MO' => __( 'Modena', 'simple-pay' ),
		'MB' => __( 'Monza e della Brianza', 'simple-pay' ),
		'NA' => __( 'Napoli', 'simple-pay' ),
		'NO' => __( 'Novara', 'simple-pay' ),
		'NU' => __( 'Nuoro', 'simple-pay' ),
		'OR' => __( 'Oristano', 'simple-pay' ),
		'PD' => __( 'Padova', 'simple-pay' ),
		'PA' => __( 'Palermo', 'simple-pay' ),
		'PR' => __( 'Parma', 'simple-pay' ),
		'PV' => __( 'Pavia', 'simple-pay' ),
		'PG' => __( 'Perugia', 'simple-pay' ),
		'PU' => __( 'Pesaro e Urbino', 'simple-pay' ),
		'PE' => __( 'Pescara', 'simple-pay' ),
		'PC' => __( 'Piacenza', 'simple-pay' ),
		'PI' => __( 'Pisa', 'simple-pay' ),
		'PT' => __( 'Pistoia', 'simple-pay' ),
		'PN' => __( 'Pordenone', 'simple-pay' ),
		'PZ' => __( 'Potenza', 'simple-pay' ),
		'PO' => __( 'Prato', 'simple-pay' ),
		'RG' => __( 'Ragusa', 'simple-pay' ),
		'RA' => __( 'Ravenna', 'simple-pay' ),
		'RC' => __( 'Reggio Calabria', 'simple-pay' ),
		'RE' => __( 'Reggio Emilia', 'simple-pay' ),
		'RI' => __( 'Rieti', 'simple-pay' ),
		'RN' => __( 'Rimini', 'simple-pay' ),
		'RM' => __( 'Roma', 'simple-pay' ),
		'RO' => __( 'Rovigo', 'simple-pay' ),
		'SA' => __( 'Salerno', 'simple-pay' ),
		'SS' => __( 'Sassari', 'simple-pay' ),
		'SV' => __( 'Savona', 'simple-pay' ),
		'SI' => __( 'Siena', 'simple-pay' ),
		'SR' => __( 'Siracusa', 'simple-pay' ),
		'SO' => __( 'Sondrio', 'simple-pay' ),
		'SU' => __( 'Sud Sardegna', 'simple-pay' ),
		'TA' => __( 'Taranto', 'simple-pay' ),
		'TE' => __( 'Teramo', 'simple-pay' ),
		'TR' => __( 'Terni', 'simple-pay' ),
		'TO' => __( 'Torino', 'simple-pay' ),
		'TP' => __( 'Trapani', 'simple-pay' ),
		'TN' => __( 'Trento', 'simple-pay' ),
		'TV' => __( 'Treviso', 'simple-pay' ),
		'TS' => __( 'Trieste', 'simple-pay' ),
		'UD' => __( 'Udine', 'simple-pay' ),
		'VA' => __( 'Varese', 'simple-pay' ),
		'VE' => __( 'Venezia', 'simple-pay' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'simple-pay' ),
		'VC' => __( 'Vercelli', 'simple-pay' ),
		'VR' => __( 'Verona', 'simple-pay' ),
		'VV' => __( 'Vibo Valentia', 'simple-pay' ),
		'VI' => __( 'Vicenza', 'simple-pay' ),
		'VT' => __( 'Viterbo', 'simple-pay' ),
	),
	'IL' => array(),
	'IM' => array(),
	'JM' => array( // Jamaican parishes.
		'JM-01' => __( 'Kingston', 'simple-pay' ),
		'JM-02' => __( 'Saint Andrew', 'simple-pay' ),
		'JM-03' => __( 'Saint Thomas', 'simple-pay' ),
		'JM-04' => __( 'Portland', 'simple-pay' ),
		'JM-05' => __( 'Saint Mary', 'simple-pay' ),
		'JM-06' => __( 'Saint Ann', 'simple-pay' ),
		'JM-07' => __( 'Trelawny', 'simple-pay' ),
		'JM-08' => __( 'Saint James', 'simple-pay' ),
		'JM-09' => __( 'Hanover', 'simple-pay' ),
		'JM-10' => __( 'Westmoreland', 'simple-pay' ),
		'JM-11' => __( 'Saint Elizabeth', 'simple-pay' ),
		'JM-12' => __( 'Manchester', 'simple-pay' ),
		'JM-13' => __( 'Clarendon', 'simple-pay' ),
		'JM-14' => __( 'Saint Catherine', 'simple-pay' ),
	),

	/**
	 * Japanese states.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'simple-pay' ),
		'JP02' => __( 'Aomori', 'simple-pay' ),
		'JP03' => __( 'Iwate', 'simple-pay' ),
		'JP04' => __( 'Miyagi', 'simple-pay' ),
		'JP05' => __( 'Akita', 'simple-pay' ),
		'JP06' => __( 'Yamagata', 'simple-pay' ),
		'JP07' => __( 'Fukushima', 'simple-pay' ),
		'JP08' => __( 'Ibaraki', 'simple-pay' ),
		'JP09' => __( 'Tochigi', 'simple-pay' ),
		'JP10' => __( 'Gunma', 'simple-pay' ),
		'JP11' => __( 'Saitama', 'simple-pay' ),
		'JP12' => __( 'Chiba', 'simple-pay' ),
		'JP13' => __( 'Tokyo', 'simple-pay' ),
		'JP14' => __( 'Kanagawa', 'simple-pay' ),
		'JP15' => __( 'Niigata', 'simple-pay' ),
		'JP16' => __( 'Toyama', 'simple-pay' ),
		'JP17' => __( 'Ishikawa', 'simple-pay' ),
		'JP18' => __( 'Fukui', 'simple-pay' ),
		'JP19' => __( 'Yamanashi', 'simple-pay' ),
		'JP20' => __( 'Nagano', 'simple-pay' ),
		'JP21' => __( 'Gifu', 'simple-pay' ),
		'JP22' => __( 'Shizuoka', 'simple-pay' ),
		'JP23' => __( 'Aichi', 'simple-pay' ),
		'JP24' => __( 'Mie', 'simple-pay' ),
		'JP25' => __( 'Shiga', 'simple-pay' ),
		'JP26' => __( 'Kyoto', 'simple-pay' ),
		'JP27' => __( 'Osaka', 'simple-pay' ),
		'JP28' => __( 'Hyogo', 'simple-pay' ),
		'JP29' => __( 'Nara', 'simple-pay' ),
		'JP30' => __( 'Wakayama', 'simple-pay' ),
		'JP31' => __( 'Tottori', 'simple-pay' ),
		'JP32' => __( 'Shimane', 'simple-pay' ),
		'JP33' => __( 'Okayama', 'simple-pay' ),
		'JP34' => __( 'Hiroshima', 'simple-pay' ),
		'JP35' => __( 'Yamaguchi', 'simple-pay' ),
		'JP36' => __( 'Tokushima', 'simple-pay' ),
		'JP37' => __( 'Kagawa', 'simple-pay' ),
		'JP38' => __( 'Ehime', 'simple-pay' ),
		'JP39' => __( 'Kochi', 'simple-pay' ),
		'JP40' => __( 'Fukuoka', 'simple-pay' ),
		'JP41' => __( 'Saga', 'simple-pay' ),
		'JP42' => __( 'Nagasaki', 'simple-pay' ),
		'JP43' => __( 'Kumamoto', 'simple-pay' ),
		'JP44' => __( 'Oita', 'simple-pay' ),
		'JP45' => __( 'Miyazaki', 'simple-pay' ),
		'JP46' => __( 'Kagoshima', 'simple-pay' ),
		'JP47' => __( 'Okinawa', 'simple-pay' ),
	),
	'KE' => array( // Kenyan counties.
		'KE01' => __( 'Baringo', 'simple-pay' ),
		'KE02' => __( 'Bomet', 'simple-pay' ),
		'KE03' => __( 'Bungoma', 'simple-pay' ),
		'KE04' => __( 'Busia', 'simple-pay' ),
		'KE05' => __( 'Elgeyo-Marakwet', 'simple-pay' ),
		'KE06' => __( 'Embu', 'simple-pay' ),
		'KE07' => __( 'Garissa', 'simple-pay' ),
		'KE08' => __( 'Homa Bay', 'simple-pay' ),
		'KE09' => __( 'Isiolo', 'simple-pay' ),
		'KE10' => __( 'Kajiado', 'simple-pay' ),
		'KE11' => __( 'Kakamega', 'simple-pay' ),
		'KE12' => __( 'Kericho', 'simple-pay' ),
		'KE13' => __( 'Kiambu', 'simple-pay' ),
		'KE14' => __( 'Kilifi', 'simple-pay' ),
		'KE15' => __( 'Kirinyaga', 'simple-pay' ),
		'KE16' => __( 'Kisii', 'simple-pay' ),
		'KE17' => __( 'Kisumu', 'simple-pay' ),
		'KE18' => __( 'Kitui', 'simple-pay' ),
		'KE19' => __( 'Kwale', 'simple-pay' ),
		'KE20' => __( 'Laikipia', 'simple-pay' ),
		'KE21' => __( 'Lamu', 'simple-pay' ),
		'KE22' => __( 'Machakos', 'simple-pay' ),
		'KE23' => __( 'Makueni', 'simple-pay' ),
		'KE24' => __( 'Mandera', 'simple-pay' ),
		'KE25' => __( 'Marsabit', 'simple-pay' ),
		'KE26' => __( 'Meru', 'simple-pay' ),
		'KE27' => __( 'Migori', 'simple-pay' ),
		'KE28' => __( 'Mombasa', 'simple-pay' ),
		'KE29' => __( 'Murang’a', 'simple-pay' ),
		'KE30' => __( 'Nairobi County', 'simple-pay' ),
		'KE31' => __( 'Nakuru', 'simple-pay' ),
		'KE32' => __( 'Nandi', 'simple-pay' ),
		'KE33' => __( 'Narok', 'simple-pay' ),
		'KE34' => __( 'Nyamira', 'simple-pay' ),
		'KE35' => __( 'Nyandarua', 'simple-pay' ),
		'KE36' => __( 'Nyeri', 'simple-pay' ),
		'KE37' => __( 'Samburu', 'simple-pay' ),
		'KE38' => __( 'Siaya', 'simple-pay' ),
		'KE39' => __( 'Taita-Taveta', 'simple-pay' ),
		'KE40' => __( 'Tana River', 'simple-pay' ),
		'KE41' => __( 'Tharaka-Nithi', 'simple-pay' ),
		'KE42' => __( 'Trans Nzoia', 'simple-pay' ),
		'KE43' => __( 'Turkana', 'simple-pay' ),
		'KE44' => __( 'Uasin Gishu', 'simple-pay' ),
		'KE45' => __( 'Vihiga', 'simple-pay' ),
		'KE46' => __( 'Wajir', 'simple-pay' ),
		'KE47' => __( 'West Pokot', 'simple-pay' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array( // Laotian provinces.
		'AT' => __( 'Attapeu', 'simple-pay' ),
		'BK' => __( 'Bokeo', 'simple-pay' ),
		'BL' => __( 'Bolikhamsai', 'simple-pay' ),
		'CH' => __( 'Champasak', 'simple-pay' ),
		'HO' => __( 'Houaphanh', 'simple-pay' ),
		'KH' => __( 'Khammouane', 'simple-pay' ),
		'LM' => __( 'Luang Namtha', 'simple-pay' ),
		'LP' => __( 'Luang Prabang', 'simple-pay' ),
		'OU' => __( 'Oudomxay', 'simple-pay' ),
		'PH' => __( 'Phongsaly', 'simple-pay' ),
		'SL' => __( 'Salavan', 'simple-pay' ),
		'SV' => __( 'Savannakhet', 'simple-pay' ),
		'VI' => __( 'Vientiane Province', 'simple-pay' ),
		'VT' => __( 'Vientiane', 'simple-pay' ),
		'XA' => __( 'Sainyabuli', 'simple-pay' ),
		'XE' => __( 'Sekong', 'simple-pay' ),
		'XI' => __( 'Xiangkhouang', 'simple-pay' ),
		'XS' => __( 'Xaisomboun', 'simple-pay' ),
	),
	'LB' => array(),
	'LI' => array(),
	'LR' => array( // Liberian provinces.
		'BM' => __( 'Bomi', 'simple-pay' ),
		'BN' => __( 'Bong', 'simple-pay' ),
		'GA' => __( 'Gbarpolu', 'simple-pay' ),
		'GB' => __( 'Grand Bassa', 'simple-pay' ),
		'GC' => __( 'Grand Cape Mount', 'simple-pay' ),
		'GG' => __( 'Grand Gedeh', 'simple-pay' ),
		'GK' => __( 'Grand Kru', 'simple-pay' ),
		'LO' => __( 'Lofa', 'simple-pay' ),
		'MA' => __( 'Margibi', 'simple-pay' ),
		'MY' => __( 'Maryland', 'simple-pay' ),
		'MO' => __( 'Montserrado', 'simple-pay' ),
		'NM' => __( 'Nimba', 'simple-pay' ),
		'RV' => __( 'Rivercess', 'simple-pay' ),
		'RG' => __( 'River Gee', 'simple-pay' ),
		'SN' => __( 'Sinoe', 'simple-pay' ),
	),
	'LU' => array(),
	'MD' => array( // Moldovan states.
		'C'  => __( 'Chișinău', 'simple-pay' ),
		'BL' => __( 'Bălți', 'simple-pay' ),
		'AN' => __( 'Anenii Noi', 'simple-pay' ),
		'BS' => __( 'Basarabeasca', 'simple-pay' ),
		'BR' => __( 'Briceni', 'simple-pay' ),
		'CH' => __( 'Cahul', 'simple-pay' ),
		'CT' => __( 'Cantemir', 'simple-pay' ),
		'CL' => __( 'Călărași', 'simple-pay' ),
		'CS' => __( 'Căușeni', 'simple-pay' ),
		'CM' => __( 'Cimișlia', 'simple-pay' ),
		'CR' => __( 'Criuleni', 'simple-pay' ),
		'DN' => __( 'Dondușeni', 'simple-pay' ),
		'DR' => __( 'Drochia', 'simple-pay' ),
		'DB' => __( 'Dubăsari', 'simple-pay' ),
		'ED' => __( 'Edineț', 'simple-pay' ),
		'FL' => __( 'Fălești', 'simple-pay' ),
		'FR' => __( 'Florești', 'simple-pay' ),
		'GE' => __( 'UTA Găgăuzia', 'simple-pay' ),
		'GL' => __( 'Glodeni', 'simple-pay' ),
		'HN' => __( 'Hîncești', 'simple-pay' ),
		'IL' => __( 'Ialoveni', 'simple-pay' ),
		'LV' => __( 'Leova', 'simple-pay' ),
		'NS' => __( 'Nisporeni', 'simple-pay' ),
		'OC' => __( 'Ocnița', 'simple-pay' ),
		'OR' => __( 'Orhei', 'simple-pay' ),
		'RZ' => __( 'Rezina', 'simple-pay' ),
		'RS' => __( 'Rîșcani', 'simple-pay' ),
		'SG' => __( 'Sîngerei', 'simple-pay' ),
		'SR' => __( 'Soroca', 'simple-pay' ),
		'ST' => __( 'Strășeni', 'simple-pay' ),
		'SD' => __( 'Șoldănești', 'simple-pay' ),
		'SV' => __( 'Ștefan Vodă', 'simple-pay' ),
		'TR' => __( 'Taraclia', 'simple-pay' ),
		'TL' => __( 'Telenești', 'simple-pay' ),
		'UN' => __( 'Ungheni', 'simple-pay' ),
	),
	'MF' => array(),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexican states.
		'DF' => __( 'Ciudad de México', 'simple-pay' ),
		'JA' => __( 'Jalisco', 'simple-pay' ),
		'NL' => __( 'Nuevo León', 'simple-pay' ),
		'AG' => __( 'Aguascalientes', 'simple-pay' ),
		'BC' => __( 'Baja California', 'simple-pay' ),
		'BS' => __( 'Baja California Sur', 'simple-pay' ),
		'CM' => __( 'Campeche', 'simple-pay' ),
		'CS' => __( 'Chiapas', 'simple-pay' ),
		'CH' => __( 'Chihuahua', 'simple-pay' ),
		'CO' => __( 'Coahuila', 'simple-pay' ),
		'CL' => __( 'Colima', 'simple-pay' ),
		'DG' => __( 'Durango', 'simple-pay' ),
		'GT' => __( 'Guanajuato', 'simple-pay' ),
		'GR' => __( 'Guerrero', 'simple-pay' ),
		'HG' => __( 'Hidalgo', 'simple-pay' ),
		'MX' => __( 'Estado de México', 'simple-pay' ),
		'MI' => __( 'Michoacán', 'simple-pay' ),
		'MO' => __( 'Morelos', 'simple-pay' ),
		'NA' => __( 'Nayarit', 'simple-pay' ),
		'OA' => __( 'Oaxaca', 'simple-pay' ),
		'PU' => __( 'Puebla', 'simple-pay' ),
		'QT' => __( 'Querétaro', 'simple-pay' ),
		'QR' => __( 'Quintana Roo', 'simple-pay' ),
		'SL' => __( 'San Luis Potosí', 'simple-pay' ),
		'SI' => __( 'Sinaloa', 'simple-pay' ),
		'SO' => __( 'Sonora', 'simple-pay' ),
		'TB' => __( 'Tabasco', 'simple-pay' ),
		'TM' => __( 'Tamaulipas', 'simple-pay' ),
		'TL' => __( 'Tlaxcala', 'simple-pay' ),
		'VE' => __( 'Veracruz', 'simple-pay' ),
		'YU' => __( 'Yucatán', 'simple-pay' ),
		'ZA' => __( 'Zacatecas', 'simple-pay' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'simple-pay' ),
		'KDH' => __( 'Kedah', 'simple-pay' ),
		'KTN' => __( 'Kelantan', 'simple-pay' ),
		'LBN' => __( 'Labuan', 'simple-pay' ),
		'MLK' => __( 'Malacca (Melaka)', 'simple-pay' ),
		'NSN' => __( 'Negeri Sembilan', 'simple-pay' ),
		'PHG' => __( 'Pahang', 'simple-pay' ),
		'PNG' => __( 'Penang (Pulau Pinang)', 'simple-pay' ),
		'PRK' => __( 'Perak', 'simple-pay' ),
		'PLS' => __( 'Perlis', 'simple-pay' ),
		'SBH' => __( 'Sabah', 'simple-pay' ),
		'SWK' => __( 'Sarawak', 'simple-pay' ),
		'SGR' => __( 'Selangor', 'simple-pay' ),
		'TRG' => __( 'Terengganu', 'simple-pay' ),
		'PJY' => __( 'Putrajaya', 'simple-pay' ),
		'KUL' => __( 'Kuala Lumpur', 'simple-pay' ),
	),
	'MZ' => array( // Mozambican provinces.
		'MZP'   => __( 'Cabo Delgado', 'simple-pay' ),
		'MZG'   => __( 'Gaza', 'simple-pay' ),
		'MZI'   => __( 'Inhambane', 'simple-pay' ),
		'MZB'   => __( 'Manica', 'simple-pay' ),
		'MZL'   => __( 'Maputo Province', 'simple-pay' ),
		'MZMPM' => __( 'Maputo', 'simple-pay' ),
		'MZN'   => __( 'Nampula', 'simple-pay' ),
		'MZA'   => __( 'Niassa', 'simple-pay' ),
		'MZS'   => __( 'Sofala', 'simple-pay' ),
		'MZT'   => __( 'Tete', 'simple-pay' ),
		'MZQ'   => __( 'Zambézia', 'simple-pay' ),
	),
	'NA' => array( // Namibian regions.
		'ER' => __( 'Erongo', 'simple-pay' ),
		'HA' => __( 'Hardap', 'simple-pay' ),
		'KA' => __( 'Karas', 'simple-pay' ),
		'KE' => __( 'Kavango East', 'simple-pay' ),
		'KW' => __( 'Kavango West', 'simple-pay' ),
		'KH' => __( 'Khomas', 'simple-pay' ),
		'KU' => __( 'Kunene', 'simple-pay' ),
		'OW' => __( 'Ohangwena', 'simple-pay' ),
		'OH' => __( 'Omaheke', 'simple-pay' ),
		'OS' => __( 'Omusati', 'simple-pay' ),
		'ON' => __( 'Oshana', 'simple-pay' ),
		'OT' => __( 'Oshikoto', 'simple-pay' ),
		'OD' => __( 'Otjozondjupa', 'simple-pay' ),
		'CA' => __( 'Zambezi', 'simple-pay' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'simple-pay' ),
		'FC' => __( 'Abuja', 'simple-pay' ),
		'AD' => __( 'Adamawa', 'simple-pay' ),
		'AK' => __( 'Akwa Ibom', 'simple-pay' ),
		'AN' => __( 'Anambra', 'simple-pay' ),
		'BA' => __( 'Bauchi', 'simple-pay' ),
		'BY' => __( 'Bayelsa', 'simple-pay' ),
		'BE' => __( 'Benue', 'simple-pay' ),
		'BO' => __( 'Borno', 'simple-pay' ),
		'CR' => __( 'Cross River', 'simple-pay' ),
		'DE' => __( 'Delta', 'simple-pay' ),
		'EB' => __( 'Ebonyi', 'simple-pay' ),
		'ED' => __( 'Edo', 'simple-pay' ),
		'EK' => __( 'Ekiti', 'simple-pay' ),
		'EN' => __( 'Enugu', 'simple-pay' ),
		'GO' => __( 'Gombe', 'simple-pay' ),
		'IM' => __( 'Imo', 'simple-pay' ),
		'JI' => __( 'Jigawa', 'simple-pay' ),
		'KD' => __( 'Kaduna', 'simple-pay' ),
		'KN' => __( 'Kano', 'simple-pay' ),
		'KT' => __( 'Katsina', 'simple-pay' ),
		'KE' => __( 'Kebbi', 'simple-pay' ),
		'KO' => __( 'Kogi', 'simple-pay' ),
		'KW' => __( 'Kwara', 'simple-pay' ),
		'LA' => __( 'Lagos', 'simple-pay' ),
		'NA' => __( 'Nasarawa', 'simple-pay' ),
		'NI' => __( 'Niger', 'simple-pay' ),
		'OG' => __( 'Ogun', 'simple-pay' ),
		'ON' => __( 'Ondo', 'simple-pay' ),
		'OS' => __( 'Osun', 'simple-pay' ),
		'OY' => __( 'Oyo', 'simple-pay' ),
		'PL' => __( 'Plateau', 'simple-pay' ),
		'RI' => __( 'Rivers', 'simple-pay' ),
		'SO' => __( 'Sokoto', 'simple-pay' ),
		'TA' => __( 'Taraba', 'simple-pay' ),
		'YO' => __( 'Yobe', 'simple-pay' ),
		'ZA' => __( 'Zamfara', 'simple-pay' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepalese zones.
		'BAG' => __( 'Bagmati', 'simple-pay' ),
		'BHE' => __( 'Bheri', 'simple-pay' ),
		'DHA' => __( 'Dhaulagiri', 'simple-pay' ),
		'GAN' => __( 'Gandaki', 'simple-pay' ),
		'JAN' => __( 'Janakpur', 'simple-pay' ),
		'KAR' => __( 'Karnali', 'simple-pay' ),
		'KOS' => __( 'Koshi', 'simple-pay' ),
		'LUM' => __( 'Lumbini', 'simple-pay' ),
		'MAH' => __( 'Mahakali', 'simple-pay' ),
		'MEC' => __( 'Mechi', 'simple-pay' ),
		'NAR' => __( 'Narayani', 'simple-pay' ),
		'RAP' => __( 'Rapti', 'simple-pay' ),
		'SAG' => __( 'Sagarmatha', 'simple-pay' ),
		'SET' => __( 'Seti', 'simple-pay' ),
	),
	'NI' => array( // Nicaraguan states.
		'NI-AN' => __( 'Atlántico Norte', 'simple-pay' ),
		'NI-AS' => __( 'Atlántico Sur', 'simple-pay' ),
		'NI-BO' => __( 'Boaco', 'simple-pay' ),
		'NI-CA' => __( 'Carazo', 'simple-pay' ),
		'NI-CI' => __( 'Chinandega', 'simple-pay' ),
		'NI-CO' => __( 'Chontales', 'simple-pay' ),
		'NI-ES' => __( 'Estelí', 'simple-pay' ),
		'NI-GR' => __( 'Granada', 'simple-pay' ),
		'NI-JI' => __( 'Jinotega', 'simple-pay' ),
		'NI-LE' => __( 'León', 'simple-pay' ),
		'NI-MD' => __( 'Madriz', 'simple-pay' ),
		'NI-MN' => __( 'Managua', 'simple-pay' ),
		'NI-MS' => __( 'Masaya', 'simple-pay' ),
		'NI-MT' => __( 'Matagalpa', 'simple-pay' ),
		'NI-NS' => __( 'Nueva Segovia', 'simple-pay' ),
		'NI-RI' => __( 'Rivas', 'simple-pay' ),
		'NI-SJ' => __( 'Río San Juan', 'simple-pay' ),
	),
	'NZ' => array( // New Zealand states.
		'NL' => __( 'Northland', 'simple-pay' ),
		'AK' => __( 'Auckland', 'simple-pay' ),
		'WA' => __( 'Waikato', 'simple-pay' ),
		'BP' => __( 'Bay of Plenty', 'simple-pay' ),
		'TK' => __( 'Taranaki', 'simple-pay' ),
		'GI' => __( 'Gisborne', 'simple-pay' ),
		'HB' => __( 'Hawke’s Bay', 'simple-pay' ),
		'MW' => __( 'Manawatu-Wanganui', 'simple-pay' ),
		'WE' => __( 'Wellington', 'simple-pay' ),
		'NS' => __( 'Nelson', 'simple-pay' ),
		'MB' => __( 'Marlborough', 'simple-pay' ),
		'TM' => __( 'Tasman', 'simple-pay' ),
		'WC' => __( 'West Coast', 'simple-pay' ),
		'CT' => __( 'Canterbury', 'simple-pay' ),
		'OT' => __( 'Otago', 'simple-pay' ),
		'SL' => __( 'Southland', 'simple-pay' ),
	),
	'PA' => array( // Panamanian states.
		'PA-1'  => __( 'Bocas del Toro', 'simple-pay' ),
		'PA-2'  => __( 'Coclé', 'simple-pay' ),
		'PA-3'  => __( 'Colón', 'simple-pay' ),
		'PA-4'  => __( 'Chiriquí', 'simple-pay' ),
		'PA-5'  => __( 'Darién', 'simple-pay' ),
		'PA-6'  => __( 'Herrera', 'simple-pay' ),
		'PA-7'  => __( 'Los Santos', 'simple-pay' ),
		'PA-8'  => __( 'Panamá', 'simple-pay' ),
		'PA-9'  => __( 'Veraguas', 'simple-pay' ),
		'PA-10' => __( 'West Panamá', 'simple-pay' ),
		'PA-EM' => __( 'Emberá', 'simple-pay' ),
		'PA-KY' => __( 'Guna Yala', 'simple-pay' ),
		'PA-NB' => __( 'Ngöbe-Buglé', 'simple-pay' ),
	),
	'PE' => array( // Peruvian states.
		'CAL' => __( 'El Callao', 'simple-pay' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'simple-pay' ),
		'AMA' => __( 'Amazonas', 'simple-pay' ),
		'ANC' => __( 'Ancash', 'simple-pay' ),
		'APU' => __( 'Apurímac', 'simple-pay' ),
		'ARE' => __( 'Arequipa', 'simple-pay' ),
		'AYA' => __( 'Ayacucho', 'simple-pay' ),
		'CAJ' => __( 'Cajamarca', 'simple-pay' ),
		'CUS' => __( 'Cusco', 'simple-pay' ),
		'HUV' => __( 'Huancavelica', 'simple-pay' ),
		'HUC' => __( 'Huánuco', 'simple-pay' ),
		'ICA' => __( 'Ica', 'simple-pay' ),
		'JUN' => __( 'Junín', 'simple-pay' ),
		'LAL' => __( 'La Libertad', 'simple-pay' ),
		'LAM' => __( 'Lambayeque', 'simple-pay' ),
		'LIM' => __( 'Lima', 'simple-pay' ),
		'LOR' => __( 'Loreto', 'simple-pay' ),
		'MDD' => __( 'Madre de Dios', 'simple-pay' ),
		'MOQ' => __( 'Moquegua', 'simple-pay' ),
		'PAS' => __( 'Pasco', 'simple-pay' ),
		'PIU' => __( 'Piura', 'simple-pay' ),
		'PUN' => __( 'Puno', 'simple-pay' ),
		'SAM' => __( 'San Martín', 'simple-pay' ),
		'TAC' => __( 'Tacna', 'simple-pay' ),
		'TUM' => __( 'Tumbes', 'simple-pay' ),
		'UCA' => __( 'Ucayali', 'simple-pay' ),
	),
	'PH' => array( // Philippine provinces.
		'ABR' => __( 'Abra', 'simple-pay' ),
		'AGN' => __( 'Agusan del Norte', 'simple-pay' ),
		'AGS' => __( 'Agusan del Sur', 'simple-pay' ),
		'AKL' => __( 'Aklan', 'simple-pay' ),
		'ALB' => __( 'Albay', 'simple-pay' ),
		'ANT' => __( 'Antique', 'simple-pay' ),
		'APA' => __( 'Apayao', 'simple-pay' ),
		'AUR' => __( 'Aurora', 'simple-pay' ),
		'BAS' => __( 'Basilan', 'simple-pay' ),
		'BAN' => __( 'Bataan', 'simple-pay' ),
		'BTN' => __( 'Batanes', 'simple-pay' ),
		'BTG' => __( 'Batangas', 'simple-pay' ),
		'BEN' => __( 'Benguet', 'simple-pay' ),
		'BIL' => __( 'Biliran', 'simple-pay' ),
		'BOH' => __( 'Bohol', 'simple-pay' ),
		'BUK' => __( 'Bukidnon', 'simple-pay' ),
		'BUL' => __( 'Bulacan', 'simple-pay' ),
		'CAG' => __( 'Cagayan', 'simple-pay' ),
		'CAN' => __( 'Camarines Norte', 'simple-pay' ),
		'CAS' => __( 'Camarines Sur', 'simple-pay' ),
		'CAM' => __( 'Camiguin', 'simple-pay' ),
		'CAP' => __( 'Capiz', 'simple-pay' ),
		'CAT' => __( 'Catanduanes', 'simple-pay' ),
		'CAV' => __( 'Cavite', 'simple-pay' ),
		'CEB' => __( 'Cebu', 'simple-pay' ),
		'COM' => __( 'Compostela Valley', 'simple-pay' ),
		'NCO' => __( 'Cotabato', 'simple-pay' ),
		'DAV' => __( 'Davao del Norte', 'simple-pay' ),
		'DAS' => __( 'Davao del Sur', 'simple-pay' ),
		'DAC' => __( 'Davao Occidental', 'simple-pay' ),
		'DAO' => __( 'Davao Oriental', 'simple-pay' ),
		'DIN' => __( 'Dinagat Islands', 'simple-pay' ),
		'EAS' => __( 'Eastern Samar', 'simple-pay' ),
		'GUI' => __( 'Guimaras', 'simple-pay' ),
		'IFU' => __( 'Ifugao', 'simple-pay' ),
		'ILN' => __( 'Ilocos Norte', 'simple-pay' ),
		'ILS' => __( 'Ilocos Sur', 'simple-pay' ),
		'ILI' => __( 'Iloilo', 'simple-pay' ),
		'ISA' => __( 'Isabela', 'simple-pay' ),
		'KAL' => __( 'Kalinga', 'simple-pay' ),
		'LUN' => __( 'La Union', 'simple-pay' ),
		'LAG' => __( 'Laguna', 'simple-pay' ),
		'LAN' => __( 'Lanao del Norte', 'simple-pay' ),
		'LAS' => __( 'Lanao del Sur', 'simple-pay' ),
		'LEY' => __( 'Leyte', 'simple-pay' ),
		'MAG' => __( 'Maguindanao', 'simple-pay' ),
		'MAD' => __( 'Marinduque', 'simple-pay' ),
		'MAS' => __( 'Masbate', 'simple-pay' ),
		'MSC' => __( 'Misamis Occidental', 'simple-pay' ),
		'MSR' => __( 'Misamis Oriental', 'simple-pay' ),
		'MOU' => __( 'Mountain Province', 'simple-pay' ),
		'NEC' => __( 'Negros Occidental', 'simple-pay' ),
		'NER' => __( 'Negros Oriental', 'simple-pay' ),
		'NSA' => __( 'Northern Samar', 'simple-pay' ),
		'NUE' => __( 'Nueva Ecija', 'simple-pay' ),
		'NUV' => __( 'Nueva Vizcaya', 'simple-pay' ),
		'MDC' => __( 'Occidental Mindoro', 'simple-pay' ),
		'MDR' => __( 'Oriental Mindoro', 'simple-pay' ),
		'PLW' => __( 'Palawan', 'simple-pay' ),
		'PAM' => __( 'Pampanga', 'simple-pay' ),
		'PAN' => __( 'Pangasinan', 'simple-pay' ),
		'QUE' => __( 'Quezon', 'simple-pay' ),
		'QUI' => __( 'Quirino', 'simple-pay' ),
		'RIZ' => __( 'Rizal', 'simple-pay' ),
		'ROM' => __( 'Romblon', 'simple-pay' ),
		'WSA' => __( 'Samar', 'simple-pay' ),
		'SAR' => __( 'Sarangani', 'simple-pay' ),
		'SIQ' => __( 'Siquijor', 'simple-pay' ),
		'SOR' => __( 'Sorsogon', 'simple-pay' ),
		'SCO' => __( 'South Cotabato', 'simple-pay' ),
		'SLE' => __( 'Southern Leyte', 'simple-pay' ),
		'SUK' => __( 'Sultan Kudarat', 'simple-pay' ),
		'SLU' => __( 'Sulu', 'simple-pay' ),
		'SUN' => __( 'Surigao del Norte', 'simple-pay' ),
		'SUR' => __( 'Surigao del Sur', 'simple-pay' ),
		'TAR' => __( 'Tarlac', 'simple-pay' ),
		'TAW' => __( 'Tawi-Tawi', 'simple-pay' ),
		'ZMB' => __( 'Zambales', 'simple-pay' ),
		'ZAN' => __( 'Zamboanga del Norte', 'simple-pay' ),
		'ZAS' => __( 'Zamboanga del Sur', 'simple-pay' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'simple-pay' ),
		'00'  => __( 'Metro Manila', 'simple-pay' ),
	),
	'PK' => array( // Pakistani states.
		'JK' => __( 'Azad Kashmir', 'simple-pay' ),
		'BA' => __( 'Balochistan', 'simple-pay' ),
		'TA' => __( 'FATA', 'simple-pay' ),
		'GB' => __( 'Gilgit Baltistan', 'simple-pay' ),
		'IS' => __( 'Islamabad Capital Territory', 'simple-pay' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'simple-pay' ),
		'PB' => __( 'Punjab', 'simple-pay' ),
		'SD' => __( 'Sindh', 'simple-pay' ),
	),
	'PL' => array(),
	'PR' => array(),
	'PT' => array(),
	'PY' => array( // Paraguayan states.
		'PY-ASU' => __( 'Asunción', 'simple-pay' ),
		'PY-1'   => __( 'Concepción', 'simple-pay' ),
		'PY-2'   => __( 'San Pedro', 'simple-pay' ),
		'PY-3'   => __( 'Cordillera', 'simple-pay' ),
		'PY-4'   => __( 'Guairá', 'simple-pay' ),
		'PY-5'   => __( 'Caaguazú', 'simple-pay' ),
		'PY-6'   => __( 'Caazapá', 'simple-pay' ),
		'PY-7'   => __( 'Itapúa', 'simple-pay' ),
		'PY-8'   => __( 'Misiones', 'simple-pay' ),
		'PY-9'   => __( 'Paraguarí', 'simple-pay' ),
		'PY-10'  => __( 'Alto Paraná', 'simple-pay' ),
		'PY-11'  => __( 'Central', 'simple-pay' ),
		'PY-12'  => __( 'Ñeembucú', 'simple-pay' ),
		'PY-13'  => __( 'Amambay', 'simple-pay' ),
		'PY-14'  => __( 'Canindeyú', 'simple-pay' ),
		'PY-15'  => __( 'Presidente Hayes', 'simple-pay' ),
		'PY-16'  => __( 'Alto Paraguay', 'simple-pay' ),
		'PY-17'  => __( 'Boquerón', 'simple-pay' ),
	),
	'RE' => array(),
	'RO' => array( // Romanian states.
		'AB' => __( 'Alba', 'simple-pay' ),
		'AR' => __( 'Arad', 'simple-pay' ),
		'AG' => __( 'Argeș', 'simple-pay' ),
		'BC' => __( 'Bacău', 'simple-pay' ),
		'BH' => __( 'Bihor', 'simple-pay' ),
		'BN' => __( 'Bistrița-Năsăud', 'simple-pay' ),
		'BT' => __( 'Botoșani', 'simple-pay' ),
		'BR' => __( 'Brăila', 'simple-pay' ),
		'BV' => __( 'Brașov', 'simple-pay' ),
		'B'  => __( 'București', 'simple-pay' ),
		'BZ' => __( 'Buzău', 'simple-pay' ),
		'CL' => __( 'Călărași', 'simple-pay' ),
		'CS' => __( 'Caraș-Severin', 'simple-pay' ),
		'CJ' => __( 'Cluj', 'simple-pay' ),
		'CT' => __( 'Constanța', 'simple-pay' ),
		'CV' => __( 'Covasna', 'simple-pay' ),
		'DB' => __( 'Dâmbovița', 'simple-pay' ),
		'DJ' => __( 'Dolj', 'simple-pay' ),
		'GL' => __( 'Galați', 'simple-pay' ),
		'GR' => __( 'Giurgiu', 'simple-pay' ),
		'GJ' => __( 'Gorj', 'simple-pay' ),
		'HR' => __( 'Harghita', 'simple-pay' ),
		'HD' => __( 'Hunedoara', 'simple-pay' ),
		'IL' => __( 'Ialomița', 'simple-pay' ),
		'IS' => __( 'Iași', 'simple-pay' ),
		'IF' => __( 'Ilfov', 'simple-pay' ),
		'MM' => __( 'Maramureș', 'simple-pay' ),
		'MH' => __( 'Mehedinți', 'simple-pay' ),
		'MS' => __( 'Mureș', 'simple-pay' ),
		'NT' => __( 'Neamț', 'simple-pay' ),
		'OT' => __( 'Olt', 'simple-pay' ),
		'PH' => __( 'Prahova', 'simple-pay' ),
		'SJ' => __( 'Sălaj', 'simple-pay' ),
		'SM' => __( 'Satu Mare', 'simple-pay' ),
		'SB' => __( 'Sibiu', 'simple-pay' ),
		'SV' => __( 'Suceava', 'simple-pay' ),
		'TR' => __( 'Teleorman', 'simple-pay' ),
		'TM' => __( 'Timiș', 'simple-pay' ),
		'TL' => __( 'Tulcea', 'simple-pay' ),
		'VL' => __( 'Vâlcea', 'simple-pay' ),
		'VS' => __( 'Vaslui', 'simple-pay' ),
		'VN' => __( 'Vrancea', 'simple-pay' ),
	),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'SV' => array( // Salvadoran states.
		'SV-AH' => __( 'Ahuachapán', 'simple-pay' ),
		'SV-CA' => __( 'Cabañas', 'simple-pay' ),
		'SV-CH' => __( 'Chalatenango', 'simple-pay' ),
		'SV-CU' => __( 'Cuscatlán', 'simple-pay' ),
		'SV-LI' => __( 'La Libertad', 'simple-pay' ),
		'SV-MO' => __( 'Morazán', 'simple-pay' ),
		'SV-PA' => __( 'La Paz', 'simple-pay' ),
		'SV-SA' => __( 'Santa Ana', 'simple-pay' ),
		'SV-SM' => __( 'San Miguel', 'simple-pay' ),
		'SV-SO' => __( 'Sonsonate', 'simple-pay' ),
		'SV-SS' => __( 'San Salvador', 'simple-pay' ),
		'SV-SV' => __( 'San Vicente', 'simple-pay' ),
		'SV-UN' => __( 'La Unión', 'simple-pay' ),
		'SV-US' => __( 'Usulután', 'simple-pay' ),
	),
	'TH' => array( // Thai states.
		'TH-37' => __( 'Amnat Charoen', 'simple-pay' ),
		'TH-15' => __( 'Ang Thong', 'simple-pay' ),
		'TH-14' => __( 'Ayutthaya', 'simple-pay' ),
		'TH-10' => __( 'Bangkok', 'simple-pay' ),
		'TH-38' => __( 'Bueng Kan', 'simple-pay' ),
		'TH-31' => __( 'Buri Ram', 'simple-pay' ),
		'TH-24' => __( 'Chachoengsao', 'simple-pay' ),
		'TH-18' => __( 'Chai Nat', 'simple-pay' ),
		'TH-36' => __( 'Chaiyaphum', 'simple-pay' ),
		'TH-22' => __( 'Chanthaburi', 'simple-pay' ),
		'TH-50' => __( 'Chiang Mai', 'simple-pay' ),
		'TH-57' => __( 'Chiang Rai', 'simple-pay' ),
		'TH-20' => __( 'Chonburi', 'simple-pay' ),
		'TH-86' => __( 'Chumphon', 'simple-pay' ),
		'TH-46' => __( 'Kalasin', 'simple-pay' ),
		'TH-62' => __( 'Kamphaeng Phet', 'simple-pay' ),
		'TH-71' => __( 'Kanchanaburi', 'simple-pay' ),
		'TH-40' => __( 'Khon Kaen', 'simple-pay' ),
		'TH-81' => __( 'Krabi', 'simple-pay' ),
		'TH-52' => __( 'Lampang', 'simple-pay' ),
		'TH-51' => __( 'Lamphun', 'simple-pay' ),
		'TH-42' => __( 'Loei', 'simple-pay' ),
		'TH-16' => __( 'Lopburi', 'simple-pay' ),
		'TH-58' => __( 'Mae Hong Son', 'simple-pay' ),
		'TH-44' => __( 'Maha Sarakham', 'simple-pay' ),
		'TH-49' => __( 'Mukdahan', 'simple-pay' ),
		'TH-26' => __( 'Nakhon Nayok', 'simple-pay' ),
		'TH-73' => __( 'Nakhon Pathom', 'simple-pay' ),
		'TH-48' => __( 'Nakhon Phanom', 'simple-pay' ),
		'TH-30' => __( 'Nakhon Ratchasima', 'simple-pay' ),
		'TH-60' => __( 'Nakhon Sawan', 'simple-pay' ),
		'TH-80' => __( 'Nakhon Si Thammarat', 'simple-pay' ),
		'TH-55' => __( 'Nan', 'simple-pay' ),
		'TH-96' => __( 'Narathiwat', 'simple-pay' ),
		'TH-39' => __( 'Nong Bua Lam Phu', 'simple-pay' ),
		'TH-43' => __( 'Nong Khai', 'simple-pay' ),
		'TH-12' => __( 'Nonthaburi', 'simple-pay' ),
		'TH-13' => __( 'Pathum Thani', 'simple-pay' ),
		'TH-94' => __( 'Pattani', 'simple-pay' ),
		'TH-82' => __( 'Phang Nga', 'simple-pay' ),
		'TH-93' => __( 'Phatthalung', 'simple-pay' ),
		'TH-56' => __( 'Phayao', 'simple-pay' ),
		'TH-67' => __( 'Phetchabun', 'simple-pay' ),
		'TH-76' => __( 'Phetchaburi', 'simple-pay' ),
		'TH-66' => __( 'Phichit', 'simple-pay' ),
		'TH-65' => __( 'Phitsanulok', 'simple-pay' ),
		'TH-54' => __( 'Phrae', 'simple-pay' ),
		'TH-83' => __( 'Phuket', 'simple-pay' ),
		'TH-25' => __( 'Prachin Buri', 'simple-pay' ),
		'TH-77' => __( 'Prachuap Khiri Khan', 'simple-pay' ),
		'TH-85' => __( 'Ranong', 'simple-pay' ),
		'TH-70' => __( 'Ratchaburi', 'simple-pay' ),
		'TH-21' => __( 'Rayong', 'simple-pay' ),
		'TH-45' => __( 'Roi Et', 'simple-pay' ),
		'TH-27' => __( 'Sa Kaeo', 'simple-pay' ),
		'TH-47' => __( 'Sakon Nakhon', 'simple-pay' ),
		'TH-11' => __( 'Samut Prakan', 'simple-pay' ),
		'TH-74' => __( 'Samut Sakhon', 'simple-pay' ),
		'TH-75' => __( 'Samut Songkhram', 'simple-pay' ),
		'TH-19' => __( 'Saraburi', 'simple-pay' ),
		'TH-91' => __( 'Satun', 'simple-pay' ),
		'TH-17' => __( 'Sing Buri', 'simple-pay' ),
		'TH-33' => __( 'Sisaket', 'simple-pay' ),
		'TH-90' => __( 'Songkhla', 'simple-pay' ),
		'TH-64' => __( 'Sukhothai', 'simple-pay' ),
		'TH-72' => __( 'Suphan Buri', 'simple-pay' ),
		'TH-84' => __( 'Surat Thani', 'simple-pay' ),
		'TH-32' => __( 'Surin', 'simple-pay' ),
		'TH-63' => __( 'Tak', 'simple-pay' ),
		'TH-92' => __( 'Trang', 'simple-pay' ),
		'TH-23' => __( 'Trat', 'simple-pay' ),
		'TH-34' => __( 'Ubon Ratchathani', 'simple-pay' ),
		'TH-41' => __( 'Udon Thani', 'simple-pay' ),
		'TH-61' => __( 'Uthai Thani', 'simple-pay' ),
		'TH-53' => __( 'Uttaradit', 'simple-pay' ),
		'TH-95' => __( 'Yala', 'simple-pay' ),
		'TH-35' => __( 'Yasothon', 'simple-pay' ),
	),
	'TR' => array( // Turkish states.
		'TR01' => __( 'Adana', 'simple-pay' ),
		'TR02' => __( 'Adıyaman', 'simple-pay' ),
		'TR03' => __( 'Afyon', 'simple-pay' ),
		'TR04' => __( 'Ağrı', 'simple-pay' ),
		'TR05' => __( 'Amasya', 'simple-pay' ),
		'TR06' => __( 'Ankara', 'simple-pay' ),
		'TR07' => __( 'Antalya', 'simple-pay' ),
		'TR08' => __( 'Artvin', 'simple-pay' ),
		'TR09' => __( 'Aydın', 'simple-pay' ),
		'TR10' => __( 'Balıkesir', 'simple-pay' ),
		'TR11' => __( 'Bilecik', 'simple-pay' ),
		'TR12' => __( 'Bingöl', 'simple-pay' ),
		'TR13' => __( 'Bitlis', 'simple-pay' ),
		'TR14' => __( 'Bolu', 'simple-pay' ),
		'TR15' => __( 'Burdur', 'simple-pay' ),
		'TR16' => __( 'Bursa', 'simple-pay' ),
		'TR17' => __( 'Çanakkale', 'simple-pay' ),
		'TR18' => __( 'Çankırı', 'simple-pay' ),
		'TR19' => __( 'Çorum', 'simple-pay' ),
		'TR20' => __( 'Denizli', 'simple-pay' ),
		'TR21' => __( 'Diyarbakır', 'simple-pay' ),
		'TR22' => __( 'Edirne', 'simple-pay' ),
		'TR23' => __( 'Elazığ', 'simple-pay' ),
		'TR24' => __( 'Erzincan', 'simple-pay' ),
		'TR25' => __( 'Erzurum', 'simple-pay' ),
		'TR26' => __( 'Eskişehir', 'simple-pay' ),
		'TR27' => __( 'Gaziantep', 'simple-pay' ),
		'TR28' => __( 'Giresun', 'simple-pay' ),
		'TR29' => __( 'Gümüşhane', 'simple-pay' ),
		'TR30' => __( 'Hakkari', 'simple-pay' ),
		'TR31' => __( 'Hatay', 'simple-pay' ),
		'TR32' => __( 'Isparta', 'simple-pay' ),
		'TR33' => __( 'İçel', 'simple-pay' ),
		'TR34' => __( 'İstanbul', 'simple-pay' ),
		'TR35' => __( 'İzmir', 'simple-pay' ),
		'TR36' => __( 'Kars', 'simple-pay' ),
		'TR37' => __( 'Kastamonu', 'simple-pay' ),
		'TR38' => __( 'Kayseri', 'simple-pay' ),
		'TR39' => __( 'Kırklareli', 'simple-pay' ),
		'TR40' => __( 'Kırşehir', 'simple-pay' ),
		'TR41' => __( 'Kocaeli', 'simple-pay' ),
		'TR42' => __( 'Konya', 'simple-pay' ),
		'TR43' => __( 'Kütahya', 'simple-pay' ),
		'TR44' => __( 'Malatya', 'simple-pay' ),
		'TR45' => __( 'Manisa', 'simple-pay' ),
		'TR46' => __( 'Kahramanmaraş', 'simple-pay' ),
		'TR47' => __( 'Mardin', 'simple-pay' ),
		'TR48' => __( 'Muğla', 'simple-pay' ),
		'TR49' => __( 'Muş', 'simple-pay' ),
		'TR50' => __( 'Nevşehir', 'simple-pay' ),
		'TR51' => __( 'Niğde', 'simple-pay' ),
		'TR52' => __( 'Ordu', 'simple-pay' ),
		'TR53' => __( 'Rize', 'simple-pay' ),
		'TR54' => __( 'Sakarya', 'simple-pay' ),
		'TR55' => __( 'Samsun', 'simple-pay' ),
		'TR56' => __( 'Siirt', 'simple-pay' ),
		'TR57' => __( 'Sinop', 'simple-pay' ),
		'TR58' => __( 'Sivas', 'simple-pay' ),
		'TR59' => __( 'Tekirdağ', 'simple-pay' ),
		'TR60' => __( 'Tokat', 'simple-pay' ),
		'TR61' => __( 'Trabzon', 'simple-pay' ),
		'TR62' => __( 'Tunceli', 'simple-pay' ),
		'TR63' => __( 'Şanlıurfa', 'simple-pay' ),
		'TR64' => __( 'Uşak', 'simple-pay' ),
		'TR65' => __( 'Van', 'simple-pay' ),
		'TR66' => __( 'Yozgat', 'simple-pay' ),
		'TR67' => __( 'Zonguldak', 'simple-pay' ),
		'TR68' => __( 'Aksaray', 'simple-pay' ),
		'TR69' => __( 'Bayburt', 'simple-pay' ),
		'TR70' => __( 'Karaman', 'simple-pay' ),
		'TR71' => __( 'Kırıkkale', 'simple-pay' ),
		'TR72' => __( 'Batman', 'simple-pay' ),
		'TR73' => __( 'Şırnak', 'simple-pay' ),
		'TR74' => __( 'Bartın', 'simple-pay' ),
		'TR75' => __( 'Ardahan', 'simple-pay' ),
		'TR76' => __( 'Iğdır', 'simple-pay' ),
		'TR77' => __( 'Yalova', 'simple-pay' ),
		'TR78' => __( 'Karabük', 'simple-pay' ),
		'TR79' => __( 'Kilis', 'simple-pay' ),
		'TR80' => __( 'Osmaniye', 'simple-pay' ),
		'TR81' => __( 'Düzce', 'simple-pay' ),
	),
	'TZ' => array( // Tanzanian states.
		'TZ01' => __( 'Arusha', 'simple-pay' ),
		'TZ02' => __( 'Dar es Salaam', 'simple-pay' ),
		'TZ03' => __( 'Dodoma', 'simple-pay' ),
		'TZ04' => __( 'Iringa', 'simple-pay' ),
		'TZ05' => __( 'Kagera', 'simple-pay' ),
		'TZ06' => __( 'Pemba North', 'simple-pay' ),
		'TZ07' => __( 'Zanzibar North', 'simple-pay' ),
		'TZ08' => __( 'Kigoma', 'simple-pay' ),
		'TZ09' => __( 'Kilimanjaro', 'simple-pay' ),
		'TZ10' => __( 'Pemba South', 'simple-pay' ),
		'TZ11' => __( 'Zanzibar South', 'simple-pay' ),
		'TZ12' => __( 'Lindi', 'simple-pay' ),
		'TZ13' => __( 'Mara', 'simple-pay' ),
		'TZ14' => __( 'Mbeya', 'simple-pay' ),
		'TZ15' => __( 'Zanzibar West', 'simple-pay' ),
		'TZ16' => __( 'Morogoro', 'simple-pay' ),
		'TZ17' => __( 'Mtwara', 'simple-pay' ),
		'TZ18' => __( 'Mwanza', 'simple-pay' ),
		'TZ19' => __( 'Coast', 'simple-pay' ),
		'TZ20' => __( 'Rukwa', 'simple-pay' ),
		'TZ21' => __( 'Ruvuma', 'simple-pay' ),
		'TZ22' => __( 'Shinyanga', 'simple-pay' ),
		'TZ23' => __( 'Singida', 'simple-pay' ),
		'TZ24' => __( 'Tabora', 'simple-pay' ),
		'TZ25' => __( 'Tanga', 'simple-pay' ),
		'TZ26' => __( 'Manyara', 'simple-pay' ),
		'TZ27' => __( 'Geita', 'simple-pay' ),
		'TZ28' => __( 'Katavi', 'simple-pay' ),
		'TZ29' => __( 'Njombe', 'simple-pay' ),
		'TZ30' => __( 'Simiyu', 'simple-pay' ),
	),
	'LK' => array(),
	'RS' => array( // Serbian districts.
		'RS00' => _x( 'Belgrade', 'district', 'simple-pay' ),
		'RS14' => _x( 'Bor', 'district', 'simple-pay' ),
		'RS11' => _x( 'Braničevo', 'district', 'simple-pay' ),
		'RS02' => _x( 'Central Banat', 'district', 'simple-pay' ),
		'RS10' => _x( 'Danube', 'district', 'simple-pay' ),
		'RS23' => _x( 'Jablanica', 'district', 'simple-pay' ),
		'RS09' => _x( 'Kolubara', 'district', 'simple-pay' ),
		'RS08' => _x( 'Mačva', 'district', 'simple-pay' ),
		'RS17' => _x( 'Morava', 'district', 'simple-pay' ),
		'RS20' => _x( 'Nišava', 'district', 'simple-pay' ),
		'RS01' => _x( 'North Bačka', 'district', 'simple-pay' ),
		'RS03' => _x( 'North Banat', 'district', 'simple-pay' ),
		'RS24' => _x( 'Pčinja', 'district', 'simple-pay' ),
		'RS22' => _x( 'Pirot', 'district', 'simple-pay' ),
		'RS13' => _x( 'Pomoravlje', 'district', 'simple-pay' ),
		'RS19' => _x( 'Rasina', 'district', 'simple-pay' ),
		'RS18' => _x( 'Raška', 'district', 'simple-pay' ),
		'RS06' => _x( 'South Bačka', 'district', 'simple-pay' ),
		'RS04' => _x( 'South Banat', 'district', 'simple-pay' ),
		'RS07' => _x( 'Srem', 'district', 'simple-pay' ),
		'RS12' => _x( 'Šumadija', 'district', 'simple-pay' ),
		'RS21' => _x( 'Toplica', 'district', 'simple-pay' ),
		'RS05' => _x( 'West Bačka', 'district', 'simple-pay' ),
		'RS15' => _x( 'Zaječar', 'district', 'simple-pay' ),
		'RS16' => _x( 'Zlatibor', 'district', 'simple-pay' ),
		'RS25' => _x( 'Kosovo', 'district', 'simple-pay' ),
		'RS26' => _x( 'Peć', 'district', 'simple-pay' ),
		'RS27' => _x( 'Prizren', 'district', 'simple-pay' ),
		'RS28' => _x( 'Kosovska Mitrovica', 'district', 'simple-pay' ),
		'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'simple-pay' ),
		'RSKM' => _x( 'Kosovo-Metohija', 'district', 'simple-pay' ),
		'RSVO' => _x( 'Vojvodina', 'district', 'simple-pay' ),
	),
	'SE' => array(),
	'UA' => array( // Ukrainian oblasts.
		'VN' => __( 'Vinnytsia Oblast', 'simple-pay' ),
		'VL' => __( 'Volyn Oblast', 'simple-pay' ),
		'DP' => __( 'Dnipropetrovsk Oblast', 'simple-pay' ),
		'DT' => __( 'Donetsk Oblast', 'simple-pay' ),
		'ZT' => __( 'Zhytomyr Oblast', 'simple-pay' ),
		'ZK' => __( 'Zakarpattia Oblast', 'simple-pay' ),
		'ZP' => __( 'Zaporizhzhia Oblast', 'simple-pay' ),
		'IF' => __( 'Ivano-Frankivsk Oblast', 'simple-pay' ),
		'KV' => __( 'Kyiv Oblast', 'simple-pay' ),
		'KH' => __( 'Kirovohrad Oblast', 'simple-pay' ),
		'LH' => __( 'Luhansk Oblast', 'simple-pay' ),
		'LV' => __( 'Lviv Oblast', 'simple-pay' ),
		'MY' => __( 'Mykolaiv Oblast', 'simple-pay' ),
		'OD' => __( 'Odessa Oblast', 'simple-pay' ),
		'PL' => __( 'Poltava Oblast', 'simple-pay' ),
		'RV' => __( 'Rivne Oblast', 'simple-pay' ),
		'SM' => __( 'Sumy Oblast', 'simple-pay' ),
		'TP' => __( 'Ternopil Oblast', 'simple-pay' ),
		'KK' => __( 'Kharkiv Oblast', 'simple-pay' ),
		'KS' => __( 'Kherson Oblast', 'simple-pay' ),
		'KM' => __( 'Khmelnytskyi Oblast', 'simple-pay' ),
		'CK' => __( 'Cherkasy Oblast', 'simple-pay' ),
		'CH' => __( 'Chernihiv Oblast', 'simple-pay' ),
		'CV' => __( 'Chernivtsi Oblast', 'simple-pay' ),
	),
	'UG' => array( // Ugandan districts.
		'UG314' => __( 'Abim', 'simple-pay' ),
		'UG301' => __( 'Adjumani', 'simple-pay' ),
		'UG322' => __( 'Agago', 'simple-pay' ),
		'UG323' => __( 'Alebtong', 'simple-pay' ),
		'UG315' => __( 'Amolatar', 'simple-pay' ),
		'UG324' => __( 'Amudat', 'simple-pay' ),
		'UG216' => __( 'Amuria', 'simple-pay' ),
		'UG316' => __( 'Amuru', 'simple-pay' ),
		'UG302' => __( 'Apac', 'simple-pay' ),
		'UG303' => __( 'Arua', 'simple-pay' ),
		'UG217' => __( 'Budaka', 'simple-pay' ),
		'UG218' => __( 'Bududa', 'simple-pay' ),
		'UG201' => __( 'Bugiri', 'simple-pay' ),
		'UG235' => __( 'Bugweri', 'simple-pay' ),
		'UG420' => __( 'Buhweju', 'simple-pay' ),
		'UG117' => __( 'Buikwe', 'simple-pay' ),
		'UG219' => __( 'Bukedea', 'simple-pay' ),
		'UG118' => __( 'Bukomansimbi', 'simple-pay' ),
		'UG220' => __( 'Bukwa', 'simple-pay' ),
		'UG225' => __( 'Bulambuli', 'simple-pay' ),
		'UG416' => __( 'Buliisa', 'simple-pay' ),
		'UG401' => __( 'Bundibugyo', 'simple-pay' ),
		'UG430' => __( 'Bunyangabu', 'simple-pay' ),
		'UG402' => __( 'Bushenyi', 'simple-pay' ),
		'UG202' => __( 'Busia', 'simple-pay' ),
		'UG221' => __( 'Butaleja', 'simple-pay' ),
		'UG119' => __( 'Butambala', 'simple-pay' ),
		'UG233' => __( 'Butebo', 'simple-pay' ),
		'UG120' => __( 'Buvuma', 'simple-pay' ),
		'UG226' => __( 'Buyende', 'simple-pay' ),
		'UG317' => __( 'Dokolo', 'simple-pay' ),
		'UG121' => __( 'Gomba', 'simple-pay' ),
		'UG304' => __( 'Gulu', 'simple-pay' ),
		'UG403' => __( 'Hoima', 'simple-pay' ),
		'UG417' => __( 'Ibanda', 'simple-pay' ),
		'UG203' => __( 'Iganga', 'simple-pay' ),
		'UG418' => __( 'Isingiro', 'simple-pay' ),
		'UG204' => __( 'Jinja', 'simple-pay' ),
		'UG318' => __( 'Kaabong', 'simple-pay' ),
		'UG404' => __( 'Kabale', 'simple-pay' ),
		'UG405' => __( 'Kabarole', 'simple-pay' ),
		'UG213' => __( 'Kaberamaido', 'simple-pay' ),
		'UG427' => __( 'Kagadi', 'simple-pay' ),
		'UG428' => __( 'Kakumiro', 'simple-pay' ),
		'UG101' => __( 'Kalangala', 'simple-pay' ),
		'UG222' => __( 'Kaliro', 'simple-pay' ),
		'UG122' => __( 'Kalungu', 'simple-pay' ),
		'UG102' => __( 'Kampala', 'simple-pay' ),
		'UG205' => __( 'Kamuli', 'simple-pay' ),
		'UG413' => __( 'Kamwenge', 'simple-pay' ),
		'UG414' => __( 'Kanungu', 'simple-pay' ),
		'UG206' => __( 'Kapchorwa', 'simple-pay' ),
		'UG236' => __( 'Kapelebyong', 'simple-pay' ),
		'UG126' => __( 'Kasanda', 'simple-pay' ),
		'UG406' => __( 'Kasese', 'simple-pay' ),
		'UG207' => __( 'Katakwi', 'simple-pay' ),
		'UG112' => __( 'Kayunga', 'simple-pay' ),
		'UG407' => __( 'Kibaale', 'simple-pay' ),
		'UG103' => __( 'Kiboga', 'simple-pay' ),
		'UG227' => __( 'Kibuku', 'simple-pay' ),
		'UG432' => __( 'Kikuube', 'simple-pay' ),
		'UG419' => __( 'Kiruhura', 'simple-pay' ),
		'UG421' => __( 'Kiryandongo', 'simple-pay' ),
		'UG408' => __( 'Kisoro', 'simple-pay' ),
		'UG305' => __( 'Kitgum', 'simple-pay' ),
		'UG319' => __( 'Koboko', 'simple-pay' ),
		'UG325' => __( 'Kole', 'simple-pay' ),
		'UG306' => __( 'Kotido', 'simple-pay' ),
		'UG208' => __( 'Kumi', 'simple-pay' ),
		'UG333' => __( 'Kwania', 'simple-pay' ),
		'UG228' => __( 'Kween', 'simple-pay' ),
		'UG123' => __( 'Kyankwanzi', 'simple-pay' ),
		'UG422' => __( 'Kyegegwa', 'simple-pay' ),
		'UG415' => __( 'Kyenjojo', 'simple-pay' ),
		'UG125' => __( 'Kyotera', 'simple-pay' ),
		'UG326' => __( 'Lamwo', 'simple-pay' ),
		'UG307' => __( 'Lira', 'simple-pay' ),
		'UG229' => __( 'Luuka', 'simple-pay' ),
		'UG104' => __( 'Luwero', 'simple-pay' ),
		'UG124' => __( 'Lwengo', 'simple-pay' ),
		'UG114' => __( 'Lyantonde', 'simple-pay' ),
		'UG223' => __( 'Manafwa', 'simple-pay' ),
		'UG320' => __( 'Maracha', 'simple-pay' ),
		'UG105' => __( 'Masaka', 'simple-pay' ),
		'UG409' => __( 'Masindi', 'simple-pay' ),
		'UG214' => __( 'Mayuge', 'simple-pay' ),
		'UG209' => __( 'Mbale', 'simple-pay' ),
		'UG410' => __( 'Mbarara', 'simple-pay' ),
		'UG423' => __( 'Mitooma', 'simple-pay' ),
		'UG115' => __( 'Mityana', 'simple-pay' ),
		'UG308' => __( 'Moroto', 'simple-pay' ),
		'UG309' => __( 'Moyo', 'simple-pay' ),
		'UG106' => __( 'Mpigi', 'simple-pay' ),
		'UG107' => __( 'Mubende', 'simple-pay' ),
		'UG108' => __( 'Mukono', 'simple-pay' ),
		'UG334' => __( 'Nabilatuk', 'simple-pay' ),
		'UG311' => __( 'Nakapiripirit', 'simple-pay' ),
		'UG116' => __( 'Nakaseke', 'simple-pay' ),
		'UG109' => __( 'Nakasongola', 'simple-pay' ),
		'UG230' => __( 'Namayingo', 'simple-pay' ),
		'UG234' => __( 'Namisindwa', 'simple-pay' ),
		'UG224' => __( 'Namutumba', 'simple-pay' ),
		'UG327' => __( 'Napak', 'simple-pay' ),
		'UG310' => __( 'Nebbi', 'simple-pay' ),
		'UG231' => __( 'Ngora', 'simple-pay' ),
		'UG424' => __( 'Ntoroko', 'simple-pay' ),
		'UG411' => __( 'Ntungamo', 'simple-pay' ),
		'UG328' => __( 'Nwoya', 'simple-pay' ),
		'UG331' => __( 'Omoro', 'simple-pay' ),
		'UG329' => __( 'Otuke', 'simple-pay' ),
		'UG321' => __( 'Oyam', 'simple-pay' ),
		'UG312' => __( 'Pader', 'simple-pay' ),
		'UG332' => __( 'Pakwach', 'simple-pay' ),
		'UG210' => __( 'Pallisa', 'simple-pay' ),
		'UG110' => __( 'Rakai', 'simple-pay' ),
		'UG429' => __( 'Rubanda', 'simple-pay' ),
		'UG425' => __( 'Rubirizi', 'simple-pay' ),
		'UG431' => __( 'Rukiga', 'simple-pay' ),
		'UG412' => __( 'Rukungiri', 'simple-pay' ),
		'UG111' => __( 'Sembabule', 'simple-pay' ),
		'UG232' => __( 'Serere', 'simple-pay' ),
		'UG426' => __( 'Sheema', 'simple-pay' ),
		'UG215' => __( 'Sironko', 'simple-pay' ),
		'UG211' => __( 'Soroti', 'simple-pay' ),
		'UG212' => __( 'Tororo', 'simple-pay' ),
		'UG113' => __( 'Wakiso', 'simple-pay' ),
		'UG313' => __( 'Yumbe', 'simple-pay' ),
		'UG330' => __( 'Zombo', 'simple-pay' ),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'simple-pay' ),
		'84' => __( 'Howland Island', 'simple-pay' ),
		'86' => __( 'Jarvis Island', 'simple-pay' ),
		'67' => __( 'Johnston Atoll', 'simple-pay' ),
		'89' => __( 'Kingman Reef', 'simple-pay' ),
		'71' => __( 'Midway Atoll', 'simple-pay' ),
		'76' => __( 'Navassa Island', 'simple-pay' ),
		'95' => __( 'Palmyra Atoll', 'simple-pay' ),
		'79' => __( 'Wake Island', 'simple-pay' ),
	),
	'US' => array( // U.S. states.
		'AL' => __( 'Alabama', 'simple-pay' ),
		'AK' => __( 'Alaska', 'simple-pay' ),
		'AZ' => __( 'Arizona', 'simple-pay' ),
		'AR' => __( 'Arkansas', 'simple-pay' ),
		'CA' => __( 'California', 'simple-pay' ),
		'CO' => __( 'Colorado', 'simple-pay' ),
		'CT' => __( 'Connecticut', 'simple-pay' ),
		'DE' => __( 'Delaware', 'simple-pay' ),
		'DC' => __( 'District Of Columbia', 'simple-pay' ),
		'FL' => __( 'Florida', 'simple-pay' ),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'simple-pay' ),
		'HI' => __( 'Hawaii', 'simple-pay' ),
		'ID' => __( 'Idaho', 'simple-pay' ),
		'IL' => __( 'Illinois', 'simple-pay' ),
		'IN' => __( 'Indiana', 'simple-pay' ),
		'IA' => __( 'Iowa', 'simple-pay' ),
		'KS' => __( 'Kansas', 'simple-pay' ),
		'KY' => __( 'Kentucky', 'simple-pay' ),
		'LA' => __( 'Louisiana', 'simple-pay' ),
		'ME' => __( 'Maine', 'simple-pay' ),
		'MD' => __( 'Maryland', 'simple-pay' ),
		'MA' => __( 'Massachusetts', 'simple-pay' ),
		'MI' => __( 'Michigan', 'simple-pay' ),
		'MN' => __( 'Minnesota', 'simple-pay' ),
		'MS' => __( 'Mississippi', 'simple-pay' ),
		'MO' => __( 'Missouri', 'simple-pay' ),
		'MT' => __( 'Montana', 'simple-pay' ),
		'NE' => __( 'Nebraska', 'simple-pay' ),
		'NV' => __( 'Nevada', 'simple-pay' ),
		'NH' => __( 'New Hampshire', 'simple-pay' ),
		'NJ' => __( 'New Jersey', 'simple-pay' ),
		'NM' => __( 'New Mexico', 'simple-pay' ),
		'NY' => __( 'New York', 'simple-pay' ),
		'NC' => __( 'North Carolina', 'simple-pay' ),
		'ND' => __( 'North Dakota', 'simple-pay' ),
		'OH' => __( 'Ohio', 'simple-pay' ),
		'OK' => __( 'Oklahoma', 'simple-pay' ),
		'OR' => __( 'Oregon', 'simple-pay' ),
		'PA' => __( 'Pennsylvania', 'simple-pay' ),
		'RI' => __( 'Rhode Island', 'simple-pay' ),
		'SC' => __( 'South Carolina', 'simple-pay' ),
		'SD' => __( 'South Dakota', 'simple-pay' ),
		'TN' => __( 'Tennessee', 'simple-pay' ),
		'TX' => __( 'Texas', 'simple-pay' ),
		'UT' => __( 'Utah', 'simple-pay' ),
		'VT' => __( 'Vermont', 'simple-pay' ),
		'VA' => __( 'Virginia', 'simple-pay' ),
		'WA' => __( 'Washington', 'simple-pay' ),
		'WV' => __( 'West Virginia', 'simple-pay' ),
		'WI' => __( 'Wisconsin', 'simple-pay' ),
		'WY' => __( 'Wyoming', 'simple-pay' ),
		'AA' => __( 'Armed Forces (AA)', 'simple-pay' ),
		'AE' => __( 'Armed Forces (AE)', 'simple-pay' ),
		'AP' => __( 'Armed Forces (AP)', 'simple-pay' ),
	),
	'UY' => array( // Uruguayan states.
		'UY-AR' => __( 'Artigas', 'simple-pay' ),
		'UY-CA' => __( 'Canelones', 'simple-pay' ),
		'UY-CL' => __( 'Cerro Largo', 'simple-pay' ),
		'UY-CO' => __( 'Colonia', 'simple-pay' ),
		'UY-DU' => __( 'Durazno', 'simple-pay' ),
		'UY-FS' => __( 'Flores', 'simple-pay' ),
		'UY-FD' => __( 'Florida', 'simple-pay' ),
		'UY-LA' => __( 'Lavalleja', 'simple-pay' ),
		'UY-MA' => __( 'Maldonado', 'simple-pay' ),
		'UY-MO' => __( 'Montevideo', 'simple-pay' ),
		'UY-PA' => __( 'Paysandú', 'simple-pay' ),
		'UY-RN' => __( 'Río Negro', 'simple-pay' ),
		'UY-RV' => __( 'Rivera', 'simple-pay' ),
		'UY-RO' => __( 'Rocha', 'simple-pay' ),
		'UY-SA' => __( 'Salto', 'simple-pay' ),
		'UY-SJ' => __( 'San José', 'simple-pay' ),
		'UY-SO' => __( 'Soriano', 'simple-pay' ),
		'UY-TA' => __( 'Tacuarembó', 'simple-pay' ),
		'UY-TT' => __( 'Treinta y Tres', 'simple-pay' ),
	),
	'VE' => array( // Venezuelan states.
		'VE-A' => __( 'Capital', 'simple-pay' ),
		'VE-B' => __( 'Anzoátegui', 'simple-pay' ),
		'VE-C' => __( 'Apure', 'simple-pay' ),
		'VE-D' => __( 'Aragua', 'simple-pay' ),
		'VE-E' => __( 'Barinas', 'simple-pay' ),
		'VE-F' => __( 'Bolívar', 'simple-pay' ),
		'VE-G' => __( 'Carabobo', 'simple-pay' ),
		'VE-H' => __( 'Cojedes', 'simple-pay' ),
		'VE-I' => __( 'Falcón', 'simple-pay' ),
		'VE-J' => __( 'Guárico', 'simple-pay' ),
		'VE-K' => __( 'Lara', 'simple-pay' ),
		'VE-L' => __( 'Mérida', 'simple-pay' ),
		'VE-M' => __( 'Miranda', 'simple-pay' ),
		'VE-N' => __( 'Monagas', 'simple-pay' ),
		'VE-O' => __( 'Nueva Esparta', 'simple-pay' ),
		'VE-P' => __( 'Portuguesa', 'simple-pay' ),
		'VE-R' => __( 'Sucre', 'simple-pay' ),
		'VE-S' => __( 'Táchira', 'simple-pay' ),
		'VE-T' => __( 'Trujillo', 'simple-pay' ),
		'VE-U' => __( 'Yaracuy', 'simple-pay' ),
		'VE-V' => __( 'Zulia', 'simple-pay' ),
		'VE-W' => __( 'Federal Dependencies', 'simple-pay' ),
		'VE-X' => __( 'La Guaira (Vargas)', 'simple-pay' ),
		'VE-Y' => __( 'Delta Amacuro', 'simple-pay' ),
		'VE-Z' => __( 'Amazonas', 'simple-pay' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'simple-pay' ),
		'FS'  => __( 'Free State', 'simple-pay' ),
		'GP'  => __( 'Gauteng', 'simple-pay' ),
		'KZN' => __( 'KwaZulu-Natal', 'simple-pay' ),
		'LP'  => __( 'Limpopo', 'simple-pay' ),
		'MP'  => __( 'Mpumalanga', 'simple-pay' ),
		'NC'  => __( 'Northern Cape', 'simple-pay' ),
		'NW'  => __( 'North West', 'simple-pay' ),
		'WC'  => __( 'Western Cape', 'simple-pay' ),
	),
	'ZM' => array( // Zambian provinces.
		'ZM-01' => __( 'Western', 'simple-pay' ),
		'ZM-02' => __( 'Central', 'simple-pay' ),
		'ZM-03' => __( 'Eastern', 'simple-pay' ),
		'ZM-04' => __( 'Luapula', 'simple-pay' ),
		'ZM-05' => __( 'Northern', 'simple-pay' ),
		'ZM-06' => __( 'North-Western', 'simple-pay' ),
		'ZM-07' => __( 'Southern', 'simple-pay' ),
		'ZM-08' => __( 'Copperbelt', 'simple-pay' ),
		'ZM-09' => __( 'Lusaka', 'simple-pay' ),
		'ZM-10' => __( 'Muchinga', 'simple-pay' ),
	),
);
