<?php
/**
 * Custom Field: Telephone
 *
 * @package SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form\Custom_Fields
 * @copyright Copyright (c) 2022, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.9.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use SimplePay\Core\i18n;

$counter = absint( $counter );

/**
 * Allow output of extra settings before the defaults.
 *
 * @since 3.5.0
 */
do_action( 'simpay_admin_before_custom_field_telephone' );
?>

<tr class="simpay-panel-field">
	<th>
		<label for="<?php echo 'simpay-telephone-label-' . $counter; ?>"><?php esc_html_e( 'Label', 'simple-pay' ); ?></label>
	</th>
	<td>
		<?php

		simpay_print_field(
			array(
				'type'        => 'standard',
				'subtype'     => 'text',
				'name'        => '_simpay_custom_field[telephone][' . $counter . '][label]',
				'id'          => 'simpay-telephone-label-' . $counter,
				'value'       => isset( $field['label'] ) ? $field['label'] : esc_html( 'Phone', 'simple-pay' ),
				'class'       => array(
					'simpay-field-text',
					'simpay-label-input',
				),
				'attributes'  => array(
					'data-field-key' => $counter,
				),
				'description' => simpay_form_field_label_description(),
			)
		);

		?>
	</td>
</tr>

<?php if ( simpay_is_upe() ) : ?>

	<tr class="simpay-panel-field">
		<th>
			<label for="<?php echo 'simpay-telephone-smart-' . $counter; ?>">
				<?php esc_html_e( 'Offer Smart Phone Number Validation', 'simple-pay' ); ?>
			</label>
		</th>
		<td>
			<?php
			$is_smart = (
				// Explicitly enabled.
				(
					isset( $field['smart'] ) &&
					'yes' === $field['smart']
				) ||
				// Added to the form for the first time.
				! isset( $field['id'] ) ||
				// Form is new.
				'auto-draft' === get_post( $post_id )->post_status
			);

			simpay_print_field(
				array(
					'type'        => 'checkbox',
					'name'        => '_simpay_custom_field[telephone][' . $counter . '][smart]',
					'id'          => 'simpay-telephone-smart-' . $counter,
					'class'       => array(
						'simpay-phone-smart-enabled',
					),
					'value'       => $is_smart ? 'yes' : 'no',
				)
			);
			?>

			<div
				class="simpay-panel-field simpay-show-if"
				data-if=".simpay-phone-smart-enabled"
				data-is="yes"
				style="margin-top: 12px;"
			>
				<label
					for="<?php echo 'simpay-telephone-smart-default-country' . $counter; ?>"
					style="font-weight: bold;"
				>
					<?php esc_html_e( 'Default Country', 'simple-pay' ); ?>
				</label>

				<div>
					<?php
					simpay_print_field(
						array(
							'type'        => 'select',
							'name'        => '_simpay_custom_field[telephone][' . $counter . '][country]',
							'id'          => 'simpay-default-country-' . $counter,
							'value'       => isset( $field['country'] ) ? $field['country'] : 'US',
							'options'     => i18n\get_countries(),

							'attributes'  => array(
								'data-field-key' => $counter,
							),
							'description' => '',
						)
					);
					?>
				</div>
			</div>
		</td>
	</tr>

<?php endif; ?>

<tr class="simpay-panel-field">
	<?php
	simpay_print_field(
		array(
			'type'  => 'default-value',
			'label' => esc_html__( 'Default Value', 'simple-pay' ),
			'id'    => 'simpay-telephone-default-' . $counter,
			'name'  => '_simpay_custom_field[telephone][' . $counter . '][default]',
			'value' => isset( $field['default'] ) ? $field['default'] : '',
		)
	);
	?>
</tr>

<tr class="simpay-panel-field
	<?php if ( simpay_is_upe() ) : ?> simpay-show-if"
	data-if=".simpay-phone-smart-enabled"
	data-is="no"
	<?php else : ?>
		style="display: block !important;"
	<?php endif; ?>
>
	<th>
		<label for="<?php echo 'simpay-telephone-placeholder-' . $counter; ?>"><?php esc_html_e( 'Placeholder', 'simple-pay' ); ?></label>
	</th>
	<td>
		<?php

		simpay_print_field(
			array(
				'type'        => 'standard',
				'subtype'     => 'text',
				'name'        => '_simpay_custom_field[telephone][' . $counter . '][placeholder]',
				'id'          => 'simpay-telephone-placeholder-' . $counter,
				'value'       => isset( $field['placeholder'] ) ? $field['placeholder'] : '',
				'class'       => array(
					'simpay-field-text',
				),
				'attributes'  => array(
					'data-field-key' => $counter,
				),
				'description' => simpay_placeholder_description(),
			)
		);

		?>
	</td>
</tr>

<tr class="simpay-panel-field">
	<th>
		<label for="<?php echo 'simpay-telephone-required-' . $counter; ?>"><?php esc_html_e( 'Required', 'simple-pay' ); ?></label>
	</th>
	<td>
		<?php

		simpay_print_field(
			array(
				'type'        => 'checkbox',
				'name'        => '_simpay_custom_field[telephone][' . $counter . '][required]',
				'id'          => 'simpay-telephone-required-' . $counter,
				'value'       => isset( $field['required'] ) ? $field['required'] : '',
				'attributes'  => array(
					'data-field-key' => $counter,
				),
				'description' => simpay_required_field_description(),
			)
		);

		?>
	</td>
</tr>

<?php
/**
 * Allow output of extra settings after the defaults.
 *
 * @since 3.5.0
 */
do_action( 'simpay_admin_after_custom_field_telephone' );
