<?php
/**
 * Plugin Name:       WPForms PayPal Standard
 * Plugin URI:        https://wpforms.com
 * Description:       PayPal Standard integration with WPForms.
 * Requires at least: 5.5
 * Requires PHP:      7.0
 * Author:            WPForms
 * Author URI:        https://wpforms.com
 * Version:           1.10.0
 * Text Domain:       wpforms-paypal-standard
 * Domain Path:       languages
 *
 * WPForms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * WPForms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WPForms. If not, see <https://www.gnu.org/licenses/>.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use WPFormsPaypalStandard\Admin;
use WPFormsPaypalStandard\Plugin;

/**
 * Plugin version.
 *
 * @since 1.0.0
 */
const WPFORMS_PAYPAL_STANDARD_VERSION = '1.10.0';

/**
 * Plugin file.
 *
 * @since 1.0.0
 */
const WPFORMS_PAYPAL_STANDARD_FILE = __FILE__;

/**
 * Plugin path.
 *
 * @since 1.0.0
 */
define( 'WPFORMS_PAYPAL_STANDARD_PATH', plugin_dir_path( WPFORMS_PAYPAL_STANDARD_FILE ) );

/**
 * Plugin URL.
 *
 * @since 1.0.0
 */
define( 'WPFORMS_PAYPAL_STANDARD_URL', plugin_dir_url( WPFORMS_PAYPAL_STANDARD_FILE ) );

/**
 * Check addon requirements.
 *
 * @since 1.4.0
 * @since 1.8.0 Uses requirements feature.
 */
function wpforms_paypal_standard_load() {

	$requirements = [
		'file'    => WPFORMS_PAYPAL_STANDARD_FILE,
		'wpforms' => '1.8.7',
	];

	if ( ! function_exists( 'wpforms_requirements' ) || ! wpforms_requirements( $requirements ) ) {
		return;
	}

	wpforms_paypal_standard();
}

add_action( 'wpforms_loaded', 'wpforms_paypal_standard_load' );

/**
 * Get the instance of the addon main class.
 *
 * @since 1.0.0
 *
 * @return Plugin
 */
function wpforms_paypal_standard() {

	require_once WPFORMS_PAYPAL_STANDARD_PATH . 'vendor/autoload.php';

	if ( wpforms_is_admin_page( 'payments' ) ) {
		// Initialize class for extending the Payments functionality.
		( new Admin\Payments() )->hooks();
	}

	return Plugin::get_instance();
}
