jQuery(document).ready(function($) {

  var doing_license_registration_ajax = false;
  var admin_url = ajaxurl.replace( '/admin-ajax.php', '' ), spinner_url = admin_url + '/images/spinner';

  if ( 2 < window.devicePixelRatio ) {
    spinner_url += '-2x';
  }
  spinner_url += '.gif';

  var ajax_spinner = '<img src="' + spinner_url + '" alt="" class="ajax-spinner general-spinner" />';

  $( document ).on( 'click', "#analytify_goals_license_activate", function(e) {

    e.preventDefault();

    if ( doing_license_registration_ajax ) {
      return;
    }

    $( '#goals-license-status' ).removeClass( 'notification-message error-notice' );

    var license_key = $.trim( $( "#analytify_goals_license_key" ).val() );

    if ( '' === license_key ) {
      $( '#goals-license-status' ).addClass( 'notification-message error-notice' );
      $( '#goals-license-status' ).html( wpanalytify_strings.enter_license_key );
      return;
    }

    $( '#goals-license-status' ).empty().removeClass( 'success-notice' );
    doing_license_registration_ajax = true;
    $( '#analytify_goals_license_activate' ).after( '<img src="' + spinner_url + '" alt="" class="register-license-ajax-spinner general-spinner" />' );

    $.ajax( {
      url: ajaxurl,
      type: 'POST',
      dataType: 'JSON',
      cache: false,
      data: {
        action: 'wpanalytify_goals_activate_license',
        goals_license_key: license_key,
        nonce: wpanalytify_data.nonces.activate_license,
        context: 'license'
      },
      error: function( jqXHR, textStatus, errorThrown ) {
        doing_license_registration_ajax = false;
        $( '.register-license-ajax-spinner' ).remove();
        $( '#goals-license-status' ).html( wpanalytify_strings.register_license_problem );
      },
      success: function( data ) {
        doing_license_registration_ajax = false;
        $( '.register-license-ajax-spinner' ).remove();


        if ( 'undefined' !== typeof data.error ) {

          $( '#goals-license-status' ).addClass( 'notification-message error-notice' );
          $( '#goals-license-status' ).html( data.error );

        } else if ( data == '0' ){

          $( '#goals-license-status' ).addClass( 'notification-message error-notice' );
          $( '#goals-license-status' ).html( wpanalytify_strings.register_license_problem );
        }else {
          $( '#goals-license-status' ).html( wpanalytify_strings.license_registered ).delay( 5000 ).fadeOut( 1000 );
          $( '#goals-license-status' ).addClass( 'notification-message success-notice' );
          $( '#analytify_goals_license_key, #analytify_goals_license_activate' ).remove();
          $( '.goals-license-row' ).prepend( data.masked_license );

        }
      }
    } );
  });
});
