<?php


class WP_Analytify_Goals extends WP_Analytify_Pro_Base {

	function __construct() {
		parent::__construct();
		$this->hooks();
		$this->setup_constants();
	}

	/**
	 * hooks used to run the plugin
	 *
	 * @since 1.0.0
	 */
	function hooks() {

		add_action( 'analytify_add_submenu', array( $this, 'add_submenu' ), 40 );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
		add_action( 'admin_init', array( $this, 'wp_analytify_goals_register_option' ) );
		add_action( 'admin_init', array( $this, '_plugin_updater' ), 0 );

		add_action( 'analytify_dashboad_dropdown_option' , array( $this, 'dashboad_dropdown_option' ), 8 );

		add_action( 'wp_analytify_goals_license_key', array( $this, 'display_license_form' ), 11 );
		add_action( 'wp_ajax_wpanalytify_goals_activate_license', array( $this, 'ajax_activate_license' ) );

		// for modifing the meta links
		add_action( 'plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 2 );

	}

	/**
	 * Plugin row meta links
	 * 
	 * @param array  $input already defined meta links
	 * @param string $file plugin file path and name being processed
	 * @return array $input
	 */
	function plugin_row_meta( $input, $file ) {

		// exit if its other plugins
		if ( 'wp-analytify-goals/wp-analytify-goals.php' !== $file ) { return $input; }

		// remove the 'view details' org link
		unset( $input[2] );

		// add the plugin site link
		$input[] = '<a target="_blank" href="https://analytify.io/add-ons/google-analytics-goals-wordpress/">Visit plugin site</a>';

		return $input;

	}

	/**
	 * Define constant if not already set
	 *
	 * @param  string      $name
	 * @param  string|bool $value
	 */
	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}

	/**
	 * Setup plugin constants
	 *
	 * @access      private
	 * @since       1.0.0
	 * @return      void
	 */
	private function setup_constants() {

		// Setting Global Values
		$this->define( 'GOALS_ANALYTIFY_PLUGIN_FILE', __FILE__ );
		$this->define( 'GOALS_ANALYTIFY_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		$this->define( 'GOALS_ANALYTIFY_PLUGIN_DIR', dirname( __FILE__ ) );
		$this->define( 'GOALS_ANALYTIFY_PRODUCT_NAME', 'Analytify - Goals Addon' );
		$this->define( 'GOALS_ANALYTIFY_PRODUCT_ID', 14243 );
		$this->define( 'GOALS_ANALYTIFY_STORE_URL', 'https://analytify.io' );
	}

	/**
	 * Load Admin Scripts
	 *
	 * @since 1.0
	 */
	function admin_scripts( $page ) {
		if ( 'analytify_page_analytify-settings' == $page ) {
			wp_enqueue_script( 'analytify_goals_main_js', plugins_url( 'assets/js/main.js', __FILE__ ), array( 'jquery' ), ANALYTIFY_GOALS_VERSION );
		}
	}

	/**
	 * Create Submenu under Analytify
	 *
	 * @since 1.0
	 */
	function add_submenu() {
		add_submenu_page( 'analytify-dashboard', ANALYTIFY_NICK . esc_html__( 'Goals', 'wp-analytify-goals' ), esc_html__( 'Goals', 'wp-analytify-goals' ), 'manage_options', 'analytify-goals', array( $this, 'pa_page_file_path' ), 30 );
	}

	/**
	 * Analytify Goal Page callback.
	 *
	 * @since 1.0
	 */
	function pa_page_file_path() {

		if ( method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ) {
			if ( isset( $_GET['goal_id'] ) && ! empty( $_GET['goal_id'] ) ) {
				include_once ANALYTIFY_GOALS_ROOT_PATH . 'includes/analytify-goals-detail-view.php';
			} else {
				include_once ANALYTIFY_GOALS_ROOT_PATH . 'includes/analytify-goals-view.php';
			}
		} else {
			if ( isset( $_GET['goal_id'] ) && ! empty( $_GET['goal_id'] ) ) {
				include_once ANALYTIFY_GOALS_ROOT_PATH . 'includes/analytify-goals-detail-view-deprecated.php';
			} else {
				include_once ANALYTIFY_GOALS_ROOT_PATH . 'includes/analytify-goals-view-deprecated.php';
			}
		}
	}

	/**
	* Add dropdown option for goals dashboard.
	*
	*/
	function dashboad_dropdown_option() {
		echo  '<li><a href="'. admin_url( 'admin.php?page=analytify-goals' ) .'">' . __( 'Goals', 'wp-analytify-goals') . '</a></li>';
	}

	/**
	 * Output Analytify for Goals license activation key fields/inputs
	 *
	 * @since 1.0.0
	 */
	function display_license_form() {

		$license_goals = get_option( 'analytify_goals_license_key' );
		$status_goals  = get_option( 'analytify_goals_license_status' );
		// var_dump( delete_option( 'analytify_goals_license_status' ) );
		// var_dump($status_goals);
		?>

		<tr valign="top">
		<th scope="row" valign="top">
			<?php esc_html_e( 'Goals Tracking:', 'wp-analytify-goals' ); ?>
		</th>

		<?php if ( 'valid' === $status_goals ) : ?>

		<td class="goals-license-row">

		<?php echo $this->get_formatted_masked_goals_license( $license_goals ); ?>

		</td>

		<?php else : ?>

		  <td class="goals-license-row">
			<input id="analytify_goals_license_key" name="analytify_goals_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license_goals ); ?>" />

			  <input type="submit" class="button-secondary" id="analytify_goals_license_activate" name="analytify_license_activate" value="<?php esc_html_e( 'Activate License', 'wp-analytify-goals' ); ?>"/>

			<br /><p id="goals-license-status">
			<?php
			if ( $status_goals ) {
				echo $status_goals; 
			}
			?>
			</p>
		</td>

		<?php
		  endif;
			?>
		  </tr>

		<?php
	}

	function wp_analytify_goals_register_option() {
		// creates our settings in the options table
		register_setting( 'analytify-settings', 'analytify_goals_license_key', array( $this, 'analytify_goals_sanitize_license' ) );
	}

	function analytify_goals_sanitize_license( $new ) {

		$old = get_option( 'analytify_goals_license_key' );

		if ( $old && $old != $new ) {

			delete_option( 'analytify_goals_license_status' ); // new license has been entered, so must reactivate

		}
		  return $new;
	}

	/**
	 *
	 * To autoupdate addon.
	 *
	 * @since 1.0.0
	 */
	function _plugin_updater() {

		// retrieve our license key from the DB
		$wpa_license_key = trim( get_option( 'analytify_goals_license_key' ) );

		// setup the updater
		if ( class_exists( 'ANALYTIFY_SL_Plugin_Updater' ) ) {
			$edd_updater = new ANALYTIFY_SL_Plugin_Updater(
				GOALS_ANALYTIFY_STORE_URL, 'wp-analytify-goals/wp-analytify-goals.php', array(
					'version' => ANALYTIFY_GOALS_VERSION, // current version number
					'license' => $wpa_license_key, // license key (used get_option above to retrieve from DB)
					'item_id' => GOALS_ANALYTIFY_PRODUCT_ID, // name of this plugin
					'author'  => 'Muhammad Adnan', // author of this plugin
				)
			);
		}
	}

	/**
	 *
	 * Send Ajax on Active license.
	 *
	 * @since 1.0.0
	 */
	public function ajax_activate_license() {

		$this->check_ajax_referer( 'activate-license' );

		$key_rules = array(
			'action'            => 'key',
			'goals_license_key' => 'string',
			'context'           => 'key',
			'nonce'             => 'key',
		);
		$this->set_post_data( $key_rules );

		$api_params = array(
			'edd_action' => 'activate_license',
			'license'    => $this->state_data['goals_license_key'],
			'item_id'    => GOALS_ANALYTIFY_PRODUCT_ID, // the name of our product in EDD
			'url'        => home_url(),
		);

		$response = wp_remote_get(
			esc_url_raw( add_query_arg( $api_params, GOALS_ANALYTIFY_STORE_URL ) ), array(
				'timeout'   => 15,
				'sslverify' => false,
			)
		);

		// make sure the response came back okay
		if ( is_wp_error( $response ) ) {
			// var_dump($response);
			// wp_die();
			return false;
		}

		$license_response = json_decode( wp_remote_retrieve_body( $response ) );

		if ( 'valid' === $license_response->license ) {
			$this->set_goals_license_key( $this->state_data['goals_license_key'] );
			$license_response->masked_license = $this->get_formatted_masked_goals_license( $this->state_data['goals_license_key'] );
		} else {

			if ( 'invalid' === $license_response->license ) {
				// var_dump($license_response->license);
				// wp_die();
				set_site_transient( 'wpanalytify_goals_license_response', $license_response, $this->transient_timeout );
				$license_response->error = $this->get_goals_license_status_message( $license_response, $this->state_data['context'] );

			}
		}

		// $license_response->license will be either "valid" or "invalid"
		//var_dump($license_response->license);
		update_option( 'analytify_goals_license_status', $license_response->license );
		update_option( 'analytify_goals_license_key', $this->state_data['goals_license_key'] );

		$result = $this->end_ajax( json_encode( $license_response ) );

		return $result;
	}

}


new WP_Analytify_Goals();
