<?php

// redirect to goal page if start or end date not set.
if ( ! isset( $_GET['sd'] ) || ! isset( $_GET['ed'] ) ) {
	wp_redirect( admin_url( 'admin.php?page=analytify-goals' ) );
}

$acces_token = get_option( 'post_analytics_token' );

if ( ! $acces_token ) {
	return;
} else {
	if ( WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection( 'Analytify' ) ) {
		return;
  }
}

$wp_analytify         = $GLOBALS['WP_ANALYTIFY'];
$dashboard_profile_ID = $wp_analytify->settings->get_option( 'profile_for_dashboard', 'wp-analytify-profile' );
$start_date           = sanitize_text_field( wp_unslash( $_GET['sd'] ) );
$end_date             = sanitize_text_field( wp_unslash( $_GET['ed'] ) );
$goal_id              = sanitize_text_field( wp_unslash( $_GET['goal_id'] ) );
$fetch_fresh          = $wp_analytify->settings->get_option( 'delete_dashboard_cache', 'wp-analytify-dashboard' );
$version 			  = defined( 'ANALYTIFY_PRO_VERSION' ) ? ANALYTIFY_PRO_VERSION : ANALYTIFY_VERSION;


/*
* Check with roles assigned at dashboard settings.
*/
$is_access_level = $wp_analytify->settings->get_option( 'show_analytics_roles_dashboard', 'wp-analytify-dashboard' );

// Show dashboard to admin incase of empty access roles.
if ( empty( $is_access_level ) ) {
	$is_access_level = array( 'Administrator' ); }

if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {

	if ( $acces_token ) {
		// dequeue event calendar js
		wp_dequeue_script( 'tribe-common' );
		?>

		<div class="wpanalytify analytify-dashboard-nav">
			<div class="wpb_plugin_wraper">
				<div class="wpb_plugin_header_wraper">
					<div class="graph"></div>
						<div class="wpb_plugin_header">
							<div class="wpb_plugin_header_title"></div>
							<div class="wpb_plugin_header_info">
									<a href="https://analytify.io/changelog/" target="_blank" class="btn">View Changelog</a>
							</div>
							<div class="wpb_plugin_header_logo">
									<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/img/logo.svg'?>" alt="Analytify">
							</div>
						</div>
					</div>
						
					<div class="analytify-dashboard-body-container">
						<div class="wpb_plugin_body_wraper">
								<div class="wpb_plugin_body">
									<div class="wpa-tab-wrapper">
									
										<?php 
										if ( method_exists( $GLOBALS['WP_ANALYTIFY'], 'dashboard_navigation' ) ) {
											echo $GLOBALS['WP_ANALYTIFY']->dashboard_navigation();
										} ?>
									
									</div>
									<div class="wpb_plugin_tabs_content analytify-dashboard-content">

    <div class="analytify_wraper">
      <div class="analytify_main_title_section">
        <h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'Goals Detail Dashboard', 'wp-analytify-goals' ); ?></h1>
	  </div>

        <div class="analytify_general_status analytify_status_box_wraper">
          <div class="analytify_status_header">
            <h3><?php esc_html_e( 'Details of Source / Medium', 'wp-analytify-goals' ); ?></h3>
          </div>
          <div class="analytify_status_body ">
            <div class="analytify_top_pages_boxes_wraper">
              <table class="analytify_data_tables wp_analytify_paginated">
                <thead>
                  <tr>
                    <th class="analytify_num_row">#</th>
                    <th class="analytify_txt_left"><?php esc_html_e( 'Source / Medium', 'wp-analytify-goals' ); ?></th>
                    <th class="analytify_value_row"><?php esc_html_e( 'Total', 'wp-analytify-goals' ); ?></th>
                  </tr>
                </thead>
                <tbody>
                  <?php

									$detail_stats = $wp_analytify->pa_get_analytics_dashboard( $goal_id, $start_date, $end_date, 'ga:sourceMedium', '-' . $goal_id, $goal_id . '!=0', 50, 'show-goal-source-medium' );
                  ?>
									<?php if ( isset( $detail_stats['rows'] ) && $detail_stats['rows'] > 0 ) : ?>

                  <?php foreach ( $detail_stats['rows'] as $key => $stats ) : ?>
                    <tr>
                      <td class="analytify_txt_center"><?php echo $key + 1; ?></td>
                      <td><?php echo $stats[0]; ?></td>
                      <td class="analytify_txt_center analytify_value_row"><?php echo $stats[1]; ?></td>
                    </tr>
                  <?php endforeach; ?>
								<?php else: ?>
									<tr>
										<td class="analytify_td_error_msg" colspan="2">
											<?php $wp_analytify->no_records(); ?>
										</td>
									</tr>
								<?php endif ?>
                </tbody>
              </table>
            </div>

          </div>

        </div>

      </div>
		<?php
	} else {
		esc_html_e( 'You must be authenticated to see the Analytics Dashboard.', 'wp-analytify-goals' );
	}// End if().
} else {

	esc_html_e( 'You don\'t have access to Analytify Dashboard.', 'wp-analytify-goals' );
}// End if().
