<?php
/**
 * Analytify Dashboard file.
 *
 * @package WP_Analytify
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$wp_analytify = $GLOBALS['WP_ANALYTIFY'];

//Get the start date and end date from wpa-core-functions
if ( function_exists( 'analytify_datepicker_dates' ) ) {
	extract( analytify_datepicker_dates() );
} else {
	$start_date = wp_date( 'Y-m-d', strtotime( '-1 month' ) );
	$end_date   = wp_date( 'Y-m-d', strtotime( 'now' ) );
}

$date1 = date_create( $start_date );
$date2 = date_create( $end_date );
$diff  = date_diff( $date2, $date1 );

$compare_start_date = strtotime( $start_date . $diff->format( '%R%a days' ) );
$compare_start_date = date( 'Y-m-d', $compare_start_date );
$compare_end_date   = $start_date;

$dashboard_profile_ID = $wp_analytify->settings->get_option( 'profile_for_dashboard', 'wp-analytify-profile' );
$fetch_fresh          = $wp_analytify->settings->get_option( 'delete_dashboard_cache', 'wp-analytify-dashboard' );

$acces_token = get_option( 'post_analytics_token' );

if ( ! $acces_token ) {
	return;
} else {
	if ( WP_ANALYTIFY_FUNCTIONS::wpa_check_profile_selection( 'Analytify' ) ) {
		return; 
	}
}

/*
* Check with roles assigned at dashboard settings.
*/
$is_access_level = $wp_analytify->settings->get_option( 'show_analytics_roles_dashboard', 'wp-analytify-dashboard' );

// Show dashboard to admin incase of empty access roles.
if ( empty( $is_access_level ) ) {
	$is_access_level = array( 'Administrator' ); 
}

$version = defined( 'ANALYTIFY_PRO_VERSION' ) ? ANALYTIFY_PRO_VERSION : ANALYTIFY_VERSION;

if ( $wp_analytify->pa_check_roles( $is_access_level ) ) {
	// dequeue event calendar js
	wp_dequeue_script( 'tribe-common' ); ?>

	<div class="wpanalytify analytify-dashboard-nav">
		<div class="wpb_plugin_wraper">
			<div class="wpb_plugin_header_wraper">
				<div class="graph"></div>
				<div class="wpb_plugin_header">
					<div class="wpb_plugin_header_title"></div>
					<div class="wpb_plugin_header_info">
						<a href="https://analytify.io/changelog/" target="_blank" class="btn">Changelog - v<?php echo $version; ?></a>
					</div>
					<div class="wpb_plugin_header_logo">
						<img src="<?php echo ANALYTIFY_PLUGIN_URL . '/assets/img/logo.svg'?>" alt="Analytify">
					</div>
				</div>
			</div>
			<div class="analytify-dashboard-body-container">
				<div class="wpb_plugin_body_wraper">
					<div class="wpb_plugin_body">
						<div class="wpa-tab-wrapper">	
							<?php
								if ( method_exists( $GLOBALS['WP_ANALYTIFY'], 'dashboard_navigation' ) ) {
									echo $GLOBALS['WP_ANALYTIFY']->dashboard_navigation();
							} ?>
						</div>
						<div class="wpb_plugin_tabs_content analytify-dashboard-content">
							<div class="analytify_wraper">
								<div class="analytify_main_title_section">
									<div class="analytify_dashboard_title">
										<h1 class="analytify_pull_left analytify_main_title"><?php esc_html_e( 'Goals Dashboard', 'wp-analytify' ); ?></h1>

											<?php 
											if ( $acces_token && method_exists( 'WPANALYTIFY_Utils', 'dashboard_subtitle_section' ) ) {
												echo WPANALYTIFY_Utils::dashboard_subtitle_section();
											}
											?>

									</div>
									<div class="analytify_main_setting_bar">
										<div class="analytify_pull_right analytify_setting">
											<div class="analytify_select_date">

												<?php 
												if ( method_exists( 'WPANALYTIFY_Utils', 'date_form' )  ) {
													WPANALYTIFY_Utils::date_form( $start_date, $end_date );
												} ?>

											</div>
										</div>
									</div>
								</div>

								<div class="analytify_goals_wrapper">									
									<div class="analytify_author_dashboard analytify_status_box_wraper" data-endpoint-authors="main-dashboard">
										<div class="analytify_status_header analytify_header_adj">
											<h3>Goals<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="authors-dashboard" data-args="3">
											<span class="analytify_tooltiptext">Export Stats</span></a></h3>
										</div>
										<div class="analytify_status_body">
											<div class="stats-wrapper">
												<div class="analytify-email-promo-contianer">
													<div class="analytify-email-premium-overlay">
														<div class="analytify-email-premium-popup">
															<h3 class="analytify-promo-popup-heading" style="text-align:left;">Unable To Fetch Reports</h3>
															<p class="analytify-promo-popup-paragraph analytify-error-popup-paragraph">Goals are not available in GA4</p><p class="analytify-promo-popup-paragraph analytify-error-popup-paragraph"><a href="https://analytify.io/doc/get-started-with-custom-dimensions-addon/" target="_blank">Click here to read our guide on goals</a></p>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>	
	<?php
} else {

		esc_html_e( 'You don\'t have access to Analytify Dashboard.', 'wp-analytify' );
}

