<?php
/**
 * Plugin Name: Analytify Goals
 * Plugin URI: https://analytify.io/add-ons/google-analytics-goals-wordpress/
 * Description: This is a premium add-on to show you Goals results from Google Analytics.
 * Version: 5.0.2
* Author: Analytify
* Author URI: https://analytify.io/
 */

define( 'ANALYTIFY_GOALS_ROOT_PATH', dirname( __FILE__ ) . '/' );
define( 'ANALYTIFY_GOALS_VERSION', '5.0.2' );

function wpag_check_analytify_pro_notice() {
	$message = __( '<strong>Attention:</strong> Please Install Analytify Pro to use Analytify Goals addon.', 'wp-analytify-goals' );
	
	wpag_notice( $message, 'wp-analytify-danger' );
}

function wpag_email_active_analytify_pro() {
	$message = __( '<strong>Attention:</strong> Please active Analytify Pro to use Analytify Goals addon.', 'wp-analytify-goals' );
	
	wpag_notice( $message, 'wp-analytify-danger' );
}

add_action( 'plugins_loaded', 'load_analytify_goals', 20 );

function load_analytify_goals() {
	$prevent = false;

	// check for analytify
	if ( ! file_exists( WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php' ) ) {
		add_action( 'admin_notices' , 'wpag_check_analytify_pro_notice' );
		$prevent = true;
	} else if ( ! class_exists( 'WP_Analytify_Pro_Base' ) ) {
		add_action( 'admin_notices' ,  'wpag_email_active_analytify_pro' );
		$prevent = true;		
	}

	if ( $prevent ) {
		add_action( 'admin_enqueue_scripts', 'wpag_notices_scripts' );
		return;
	}

	include_once ANALYTIFY_GOALS_ROOT_PATH . 'class-wp-analytify-goals.php';
}

/**
 * Add custom admin notice
 * 
 * @param string $message Custom message
 * @param string $class wp-analytify-success,wp-analytify-danger
 */
function wpag_notice( $message, $class ) {
	echo '<div class="wp-analytify-notification '. $class .'">
	<a class="" href="#" aria-label="Dismiss the welcome panel"></a>
	<div class="wp-analytify-notice-logo">
	<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="analytify logo">
	</div>
	<div class="wp-analytify-notice-discription">
	<p>' . $message .'</p>
	</div>
	</div>';
}

/**
 * Admin notices scripts.
 */
function wpag_notices_scripts() {
	wp_enqueue_style( 'wpag-notices-css', plugins_url( 'assets/css/notices.css', __FILE__ ), '', ANALYTIFY_GOALS_VERSION );
}
